

#if !defined __BASIC_DT_H
#define __BASIC_DT_H


#ifndef NULL
#define NULL 0L
#endif

 
/* *******************************************************
******************************************************* */
class dbl_llist {

   public:
      dbl_llist *next, *back;
      
      dbl_llist() { next = back = NULL; }
      virtual ~dbl_llist() { dest(); }
      
      void dest() { if (next) delete next; next = back = NULL; }

      virtual void insert(dbl_llist *x);
      virtual void append(dbl_llist *x);
      virtual void remove();
};


/* *******************************************************
******************************************************* */
class dbl_llist_manager {

   public:
      dbl_llist *head, *tail;
      int count;
      
      dbl_llist_manager() { head = tail = NULL; count = 0; }
      virtual ~dbl_llist_manager() { dest(); }
      
      void dest();

      virtual dbl_llist *insert(dbl_llist *x, dbl_llist *target);
      virtual dbl_llist *append(dbl_llist *x, dbl_llist *target);
      virtual int remove(dbl_llist *x);
};


/* **************************************************************
************************************************************** */
class circular_dbl_llist : public dbl_llist {

   public:
      void insert(dbl_llist *x);
      void append(dbl_llist *x);
      void remove();

      virtual ~circular_dbl_llist() {}
};


/* **************************************************************
************************************************************** */
class circular_dbl_llist_manager {

   public:
      circular_dbl_llist *head;
      int count;

      circular_dbl_llist_manager() { head = NULL; count = 0; }
      virtual ~circular_dbl_llist_manager() { dest(); }

      void dest();

      void make_head(circular_dbl_llist *x) { head = x; }

      virtual circular_dbl_llist *append(circular_dbl_llist *x, circular_dbl_llist *target = NULL);
      virtual circular_dbl_llist *insert(circular_dbl_llist *x, circular_dbl_llist *target = NULL);
      virtual int remove(circular_dbl_llist *x);
};


/* **************************************************************
************************************************************** */
class binary_data {

   public:
      virtual ~binary_data() {}
      virtual int compare(binary_data *x) = 0;
};


/* **************************************************************
************************************************************** */
class binary_node {

   public:
      binary_data *key;
      binary_node *next, *back;

      binary_node() { key = NULL; next = back = NULL; }
      virtual ~binary_node();
      
      virtual binary_node *insert(binary_node *x);
      int remove(binary_node *x);
      virtual binary_node *find(binary_data *x);      
};


/* **************************************************************
************************************************************** */
class binary_tree {

   public:
      binary_node *head;
      
      void dest() { if (head) delete head; head = NULL; }
      
      binary_tree() { head = NULL; }
      virtual ~binary_tree() { dest(); }
      
      virtual binary_node *insert(binary_node *x);
      virtual int remove(binary_node *x);
      binary_node *find(binary_data *x);      
};


/* **************************************************************
************************************************************** */
class string_type : public dbl_llist {

   protected:
      int size, length;
      
   public:     
      char *string;

      string_type();
      string_type(char* src);
      virtual ~string_type();

      int  stringlen() { return length; }
      void stringsize(int len);
      int  recalc();
      void reset();
      char *stringcpy(char *src);
      char *stringncpy(char *src, int len);
      char *stringcpy(string_type *src);
      char *stringcat(char *src);
      char *stringcat(string_type *src);
      int  stringcmp(char *str);
      int  stringcmp(string_type *str);
};


/* **************************************************************
************************************************************** */
class buffer_type : public dbl_llist {

   protected:
      int size, length;
      
   public:     
      char *data;

      buffer_type();
      virtual ~buffer_type();

      int  bufferlen() { return length; }
      void bufferlen(int len);

      int buffersize() { return size; }
      void buffersize(int len);

      char *buffercpy(char *src, int len);
      char *buffercpy(buffer_type *buff);
};


/* **************************************************************
************************************************************** */
class string_binary_data : public binary_data {

   public:
      int compare(binary_data *x);

      string_type string;
      
      virtual ~string_binary_data() {}
};


#endif

