

#if !defined __BASE_H
#define __BASE_H


class engine;
class pc;

#include "camera.h"
#include "light.h"
#include "zbuffer.h"
#include "shader.h"
#include "mctype.h"
#include "linetype.h"
#include "global.h"

#define SORT_ASCENDING  0
#define SORT_DESCENDING 1

#define MINDIM  2
#define MINBBOX 1.5


/* *************************************************************
************************************************************* */
typedef struct {

   pc *ob;			// object
   float *surface;		// surface position
   float *normal;		// surface normal

   light *spot;			// beam light sources
   eye   *parm;			// camera

   texcolortype *texcolor;	// shade data
   float *tcolor;		// texture color
   shaderparamtype *sparam;     // 3D shader data
   int   i;			// 3D shader ID

   float *rcolor;		// output diffuse color
   float *acolor;		// output ambient color

   union {
      float *diffuse;		// precalculated color from main light source
      light *lmain;		// global light source
   };

} color_calc_data;


/* *************************************************************
************************************************************* */
class frame_data {

   public:
      camera *camdtr;
      light  *lightdtr;
      light  *beamdtr;
      pc     *transtr[MAXGROUND];
      pc     *invisotr[MAXGROUND];
      pc     *solidtr[MAXGROUND];

      void init();
      frame_data() { init(); }
      virtual ~frame_data();
};


/* *************************************************************
   This is the base class for objects to be rendered by the system
************************************************************* */
class pc : public frameclass {

   protected:
      vector4f rotate_buffer[4];          // default rotation matrix buffer

      virtual int clip(eye *parm, int maxx, int maxy) = 0;
      virtual void transform(eye *parm) = 0;
      virtual int bound_box(eye *parm) = 0;

   public:

      // superclass
      int  query_whatami() { return OBJECT_PC; }
      int  query_whatwasi(int type);
      int  query_category() { return CLASS_OBJECT; }
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      // pc
      shadetype     *base_color;
      shading_model mctype;         // shading
      shading_flag  mcinfo;         // flags

      shaderlisttype *shaderlist;
      shadelist *lob;

      vector4f  bbox[2];            // box in screen space

      int       bvalid_flag;
      float     bradius;            // object radius
      vector4f  bcenter;
      float     bwork;

      vector4f  center;             // object center in wc
      float     size;               // size change
      vector4f  *rotate;          // rotation matrix
      vector4f  world[4], iworld[4];

      vector4f  splane;             // shadow plane
      pc        *shadptr;           // shadow obj

      string_type texname3, colorname;

      char      sflag, renderflag, groundflag, pc_padd2;
      int       renderpriority;

      pc();
      virtual ~pc() {}
      
      void print_mctype(FILE *outfile);

      virtual void bound_sphere() = 0;
      virtual void begin_scan() {}
      virtual void end_scan()   {}
      virtual void datacopy()   { mctype.datacopy(); mcinfo.datacopy(); }

      virtual int beamscan(spotlight *spot, engine *proc) = 0;
      virtual int scan(camera *cparm, light *lmain, engine *proc) = 0;

      virtual void beamrender(spotlight *spot, engine *proc) = 0;
      virtual void render(camera *cparm, light *lmain, light *spot, engine *proc) = 0;
      virtual void prender(engine *proc) = 0;
};


typedef pc * ppc;
typedef pc ** pppc;


/* *************************************************************
   This is the base class for objects to be rendered by the system
************************************************************* */
class basenull: public pc {

   protected:

      // pc
      void transform(eye *parm);
      int clip(eye *parm, int maxx, int maxy);

   public:

      // superclass
      int  query_whatami() { return OBJECT_BASENULL; };
      int  query_whatwasi(int type);

      // pc
      int  bound_box(eye *parm);
      void bound_sphere() {};
      int  beamscan(spotlight *spot, engine *proc);
      int  scan(camera *cparm, light *lmain, engine *proc);

      void beamrender(spotlight *spot, engine *proc);
      void render(camera *cparm, light *lmain, light *spot, engine *proc);
      void prender(engine *proc);
};


/* *************************************************************
************************************************************* */
class engine {

   protected:
      frame_data frame;        // list of primitives to render

      virtual void cullnsort(eye *parm, pc *list, pc **start_list, pc **final_list, int direction = SORT_ASCENDING);
      virtual void cull(eye *parm, pc *list, pc **start_list, pc **final_list);

   public:
      int proc_id;			// processor id (for multiprocessing)
      linelist wireframe;               // pstring line object

      zbuffer zbuff;                    // zbuffer-screenbuffer
      mapul   adata;
      mapf    zdata;

      memman *control;                  // memory manager

      // system stats
      int countedge, countvertex, countface;
      
      engine() { proc_id = 0; control = NULL; }
      virtual ~engine() { if (control) delete control; frame.init(); }
      virtual void spawn(int frame_id, mapul *mapbuffer) = 0;

      // general purpose 3D engine
      virtual void engine_init();
      virtual void engine_submit(frameclass *ob);

      camera *query_camera() { return frame.camdtr; }
};


void calc_color(color_calc_data *shdmdl);
void calc_colorpc(color_calc_data *shdmdl);

void calc_color2(color_calc_data *shdmdl);
void calc_color2pc(color_calc_data *shdmdl);

void calc_color3(color_calc_data *shdmdl);
void calc_color3pc(color_calc_data *shdmdl);


#endif

