

#if !defined __ASHMEM_H
#define __ASHMEM_H

#ifdef WIN32
#include <winsock2.h>
#include <windows.h>
#endif

#define TOKEN_SHMEM_KEY   "-shmem_key"
#define TOKEN_SHMEM_SIZE  "-shmem_size"


/* ******************************************************************
****************************************************************** */
typedef struct {
    
   unsigned int block_size;   // size of this block
   unsigned int index;        // the starting index to shared memory that this block represents
} block_header_type;
    
    
/* ******************************************************************
   Header to a block of preallocated but unused memory
****************************************************************** */
typedef struct {
    
   block_header_type header;
   unsigned int next_index;   // index of the next block on the list
   unsigned int back_index;   // header to the previous block on the list
} dirty_block;
    
    
/* ******************************************************************
   Header to the shared memory - the first block in shared memory
****************************************************************** */
typedef struct {
    
   block_header_type header;         // size of this block
   union { char idkey[4]; int id; }; // identification/initiallization key
   unsigned int freespace_index;     // index to the freespace/unallocated memory
   unsigned int dirty_block_index;   // index to a double link list of allocated but unused memory - ShmemDirtyBlock
   unsigned int dirty_block_tail;    // index to the last element of the dirty block list - ShmemDirtyBlock
   unsigned int data_index;          // index to programmer defined header
   unsigned int padd;                // padd - evens out the byte count to 32 bytes
} master_block_type;
    
    
/* ******************************************************************
****************************************************************** */
class ashmem {

   protected:
      // size of the shared memory block
      int shmem_size;

      // shared memory key
      int shmem_key;
    
      int config_type;
      
      void insert_dirty_block(dirty_block *etr);
      void remove_dirty_block(dirty_block *dtr);

   public:
      // shared memory buffer
      union {
         char *shmem_buffer;
         master_block_type *master_block;
      };
      
      ashmem();
      virtual ~ashmem() {}

      int  get_buffer_size();

      int  allocate_block(int bytecount, int clean_flag = 0);
      int  remove_block(int delete_index);
      
      virtual int  reset();
      virtual int  init(int argc, char **argv, int type);
      virtual void dest() = 0;
};


#ifdef WIN32

/* ******************************************************************
****************************************************************** */
class ashmem_win : public ashmem {

   protected:
      // used by macroshaft to alloc/dealloc shared memory
      HANDLE hMap;

   public:
      int  init(int argc, char **argv, int type);
      void dest();

      virtual ~ashmem_win() { dest(); }
};


#else

/* ******************************************************************
****************************************************************** */
class ashmem_x : public ashmem {

   public:
      int  init(int argc, char **argv, int type);
      void dest();

      int shmem_id;
      
      virtual ~ashmem_x() { dest(); }
};


#endif

#endif
   
