

#if !defined __ANINEUTR_H
#define __ANINEUTR_H


#include "gamequrk.h"


#define GAME_NOZCHECK       0x01
#define GAME_NOZSET         0x02
#define GAME_TRANSPARENT    0x04
#define GAME_GOURAUD        0x08
#define GAME_BITMAP         0x10


/* ****************************************************************
**************************************************************** */
class antineutron : public gamequark {

   public:
      spheretype *colsphere;

      // superclass
      int  query_whatami() { return OBJECT_ANTINEUTRON; }
      int  query_whatwasi(int type);
      void preprocess(void *data);
      int  parse(FILE *infile, char *token);

      // quark
      void begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);

      // antineutron
      float duration;

      antineutron();
      virtual ~antineutron() {}
      int obj_vs_lineseg(float *start, float *end, float *midpt, float radius, float *pos, float *normal, int level);
      int obj_vs_line(float *pt, float *ray, float *pos, float *normal, int level);
};


/* ****************************************************************
**************************************************************** */
class antineutron_loader : public quark_loader {

   public:
      superclass *make_object() { return new antineutron; }
      antineutron_loader() {
         object_name = TOKEN_ANTINEUTRON_STR;
         alias_name = TOKEN_NEUTRON_STR;
      }

      virtual ~antineutron_loader() {}
};


/* ****************************************************************
**************************************************************** */
class antifxneutron : public antineutron {

   public:
      antifxneutron();
      virtual ~antifxneutron() {}
};


/* ****************************************************************
**************************************************************** */
class antiflat : public gamequark {

   public:
      // superclass
      int  query_whatami() { return OBJECT_ANTIFLAT; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);

      // quark
      void begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);

      // antiflat
      float duration;

      antiflat();
      virtual ~antiflat() {}
};


/* ****************************************************************
**************************************************************** */
class antiflat_loader : public quark_loader {

   public:
      superclass *make_object() { return new antiflat; }

      antiflat_loader() {
         object_name = TOKEN_ANTIFLAT_STR;
         alias_name = TOKEN_FLAT_STR;
      }

      virtual ~antiflat_loader() {}
};


/* ****************************************************************
**************************************************************** */
class antifxflat : public antiflat {

   public:
      // antifxflat
      antifxflat();
      virtual ~antifxflat() {}
};


#endif
