


#if !defined __ANICODE_H
#define __ANICODE_H


#include "neutron.h"


/* *************************************************************
   This is the class of 3D object children of a SPHERE
************************************************************* */
class buckey : public neutron {

   public:
      // superclass
      int query_whatami() { return OBJECT_BUCKEY; }
      int query_whatwasi(int type);

      // buckey
      buckey();
      virtual ~buckey() {}
};


/* *************************************************************
************************************************************* */
class buckey_loader : public quark_loader {

   public:
      superclass *make_object() { return new buckey; }
      
      buckey_loader() {
         object_name = TOKEN_BUCKEY_STR;
         alias_name = TOKEN_GEOSPHERE_STR;
      }
      
      virtual ~buckey_loader() {}
};


/* *************************************************************
   This is the class of 3D object children of a SPHERE
************************************************************* */
class tube : public neutron {

   public:
      // superclass
      int query_whatami() { return OBJECT_TUBE; }
      int query_whatwasi(int type);

      // tube
      tube();
      virtual ~tube() {}
};


/* *************************************************************
************************************************************* */
class tube_loader : public quark_loader {

   public:
      superclass *make_object() { return new tube; }

      tube_loader() {
         object_name = TOKEN_TUBE_STR;
         alias_name = TOKEN_GEOCYLINDER_STR;
      }

      virtual ~tube_loader() {}
};


/* *************************************************************
************************************************************* */
class shell : public neutron {

   public:
      // superclass
      int query_whatami() { return OBJECT_SHELL; }
      int query_whatwasi(int type);

      // shell
      shell();
      virtual ~shell() {}
};


/* *************************************************************
************************************************************* */
class shell_loader : public quark_loader {

   public:
      superclass *make_object() { return new shell; }

      shell_loader() {
         object_name = TOKEN_SHELL_STR;
         alias_name = TOKEN_SPATCH_STR;
      }

      virtual ~shell_loader() {}
};


/* *************************************************************
   This is sbfast class
************************************************************* */
class helix : public neutron {

   public:
      // superclass
      int query_whatami() { return OBJECT_HELIX; }
      int query_whatwasi(int type);

      // helix
      helix();
      virtual ~helix() {}
};


/* *************************************************************
************************************************************* */
class helix_loader : public quark_loader {

   public:
      superclass *make_object() { return new helix; }

      helix_loader() {
         object_name = TOKEN_HELIX_STR;
         alias_name = TOKEN_SBFAST_STR;
      }

      virtual ~helix_loader() {}
};


/* *************************************************************
   This is the class of 3D object children of a SPHERE
************************************************************* */
class funnel : public neutron {

   public:
      // superclass
      int query_whatami() { return OBJECT_FUNNEL; }
      int query_whatwasi(int type);

      // funnel
      funnel();
      virtual ~funnel() {}
};


/* *************************************************************
************************************************************* */
class funnel_loader : public quark_loader {

   public:
      superclass *make_object() { return new funnel; }
      funnel_loader() {
         object_name = TOKEN_FUNNEL_STR;
         alias_name = TOKEN_GEOCONE_STR;
      }
      
      virtual ~funnel_loader() {}
};


#endif

