

#if !defined __AMESSAGE_H
#define __AMESSAGE_H

#ifdef WIN32

#include <winsock2.h>

int inet_aton(char *in, struct in_addr *address);

#else

#include <netinet/in.h>

typedef int SOCKET;

#endif

#include "basic_dt.h"


#define CONFIG_TYPE_SERVER 0
#define CONFIG_TYPE_CLIENT 1

#define TOKEN_SOCKET_PORT     "-socket_port"
#define TOKEN_SOCKET_ADDRESS  "-socket_address"
#define TOKEN_SOCKET_BROADCAST "-socket_broadcast"

#define ASOCKET_FLAG_NULL              0x00
#define ASOCKET_FLAG_INIT              0x01
#define ASOCKET_FLAG_CONNECT           0x02
#define ASOCKET_FLAG_ACCEPT            0x04
#define ASOCKET_FLAG_UDP_CONNECT       0x08
#define ASOCKET_FLAG_BROADCAST         0x10

#define TOKEN_MSGQUEUE_KEY     "-msgqueue_key"

#define TOKEN_MSGWIN_NAME      "-msgwin_name"
#define TOKEN_MSGWIN_INSTANCE  "-msgwin_instance"
#define TOKEN_MSGWIN_TARGET    "-msgwin_target"


/* ******************************************************************
****************************************************************** */
class amessage {

   protected:
      int config_type;

   public:
      virtual ~amessage() {}

      virtual int init(int argc, char **argv, int type) = 0;
      virtual void dest() = 0;

      virtual int  query_message(buffer_type *buffer) = 0;
      virtual int  receive_message(buffer_type *buffer) = 0;
      virtual int  send_message(buffer_type *buffer) = 0;

      virtual int  query_message_raw(buffer_type *buffer, int len) = 0;
      virtual int  receive_message_raw(buffer_type *buffer, int len) = 0;
      virtual int  send_message_raw(buffer_type *buffer) = 0;
};


/* ******************************************************************
****************************************************************** */
class asocktcp : public amessage {

   protected:
      string_type socket_address;
      int port;
      SOCKET sock;
      struct sockaddr_in dest_sin;  // DESTination Socket INternet

      unsigned int decode(unsigned int i);
      unsigned int encode(unsigned int i);
      void error_handler(char *error_msg);

   public:
      // amessage
      int  init(int argc, char **argv, int type);
      void dest();

      int  query_message(buffer_type *buffer);
      int  receive_message(buffer_type *buffer);
      int  send_message(buffer_type *buffer);

      int  query_message_raw(buffer_type *buffer, int len);
      int  receive_message_raw(buffer_type *buffer, int len);
      int  send_message_raw(buffer_type *buffer);

      // asocktpc
      SOCKET accept_sock;
      int socket_flag;

      asocktcp();
      virtual ~asocktcp() { dest(); }

      int  query_port() { return port; }
      char *query_address() { return socket_address.string; }

      void set_socket(SOCKET s);

      virtual int  init_connection(float timeout = -1.0f);
};


/* ******************************************************************
NOTE: this currently only supports a P2P/1on1 connection - future work
for a real server and broadcast capabilities
****************************************************************** */
class asockudp : public asocktcp {

   public:
      // amessage
      int  init(int argc, char **argv, int type);

      int  query_message(buffer_type *buffer);
      int  receive_message(buffer_type *buffer);
      int  send_message(buffer_type *buffer);

      int  query_message_raw(buffer_type *buffer, int len);
      int  receive_message_raw(buffer_type *buffer, int len);
      int  send_message_raw(buffer_type *buffer);

      // asocktpc
      int  init_connection(float timeout = -1.0f);

      // asockudp
      virtual ~asockudp() {}

      int  receive_message(buffer_type *buffer, struct sockaddr *dest);
      int  send_message(buffer_type *buffer, struct sockaddr *dest);

      int  receive_message_raw(buffer_type *buffer, struct sockaddr *dest, int len);
      int  send_message_raw(buffer_type *buffer, struct sockaddr *dest);
};



#ifdef WIN32

/* ******************************************************************
****************************************************************** */
class amsg_win : public amessage {

   protected:
      HWND window;
      string_type name;
      dbl_llist_manager backlog_manager;
      HWND target_window;

   public:
      // amessage
      int init(int argc, char **argv, int type);
      void dest();

      int  query_message(buffer_type *buffer);
      int  receive_message(buffer_type *buffer);
      int  send_message(buffer_type *buffer);

      int  query_message_raw(buffer_type *buffer, int len);
      int  receive_message_raw(buffer_type *buffer, int len);
      int  send_message_raw(buffer_type *buffer);

      // amsg_win
      amsg_win();
      virtual ~amsg_win() { dest(); }
      
      unsigned int query_win_id() { return *(unsigned int *)&window; }

      int  init_connection(int tid, float timeout = -1.0f);
      void process_message(char *buffer, int len);
      int  send_message(buffer_type *buffer, unsigned int target);
};

#else

/* ******************************************************************
****************************************************************** */
class amsgqueue : public amessage {

   protected:
      int queue_key;
      int queue_id;

      buffer_type inbuffer, outbuffer;
      int rcv_flag;
      
   public:
      int init(int argc, char **argv, int type);
      void dest();

      int  query_message(buffer_type *buffer);
      int  receive_message(buffer_type *buffer);
      int  send_message(buffer_type *buffer);

      int  query_message_raw(buffer_type *buffer, int len);
      int  receive_message_raw(buffer_type *buffer, int len);
      int  send_message_raw(buffer_type *buffer);

      // amsgqueue
      amsgqueue();
      virtual ~amsgqueue() { dest(); }
};

#endif

#endif
