

#ifndef __AMAILBOX_H
#define __AMAILBOX_H


#include "amessage.h"


#define TOKEN_MAILBOX_ID "-mailbox_id"


/* ******************************************************************
****************************************************************** */
class message_type : public dbl_llist {

   public:
      buffer_type buffer;
      
      virtual ~message_type() {}
};


/* ******************************************************************
****************************************************************** */
typedef struct {
    
   // length = ((sizeof(mail_header_type) + 3) & 0xfffffffc) + sizof(message)
   int msg_length;
   int msg_type;
   int msg_to;
   int msg_from;
    
} mail_header_type;
  
  
/* ******************************************************************
****************************************************************** */
class mailbox_type : public dbl_llist {

   public:
      int address;
      amessage *mailslot;
      
      mailbox_type() { mailslot = NULL; }
      virtual ~mailbox_type() {}
};


/* ******************************************************************
****************************************************************** */
class post_office_type {

   protected:
      dbl_llist_manager message_list;
      int type;
      int address;
      
      virtual void update_mailboxes();
      
   public:
      dbl_llist_manager mailbox_list;

      post_office_type() { type = CONFIG_TYPE_CLIENT; address = 0; }
      virtual ~post_office_type() {}
      
      virtual int init(int argc, char **argv, int id);
       
      void new_address(amessage *src, int id);    
      amessage *delete_address(int id);    

      virtual int query_message(buffer_type *buffer);
      virtual int receive_message(buffer_type *buffer);

      virtual int find_message(int type, buffer_type *buffer);
      virtual int send_message(buffer_type *buffer);
};

#endif
