

#if !defined __WIN_XOS_H
#define __WIN_XOS_H


#include <X11/Xlib.h>
#include <GL/glx.h>

#include "WIN_VIRTUAL.h"


/************************************************************************
************************************************************************/
class XOSwindow : public OSwindow {

   protected:
      Display *mdisplay;
      GLXPbuffer pbuffer;
      GLXContext context;

      unsigned int *XOSnew_ogl_attrib_list(unsigned int *attribs);
      void XOSsetup_ogl();

   public:
      // VIRTUAL
      void VIRTUALgetdim(int *w, int *h);
      int  VIRTUALreset(int argc, char **argv, int maxx, int maxy, char *winname, void *attribs);
      void VIRTUALcancel();
      void VIRTUALswapbuffers();
      int  VIRTUALreparent(void *data) { return 0; }

      // OSwindow
      void OSset_context(); 
      int  OSquery_reset() { return mdisplay && pbuffer && context; }

      // XOSwindow
      XOSwindow() { mdisplay = NULL; context = NULL; pbuffer = 0; }
      virtual ~XOSwindow() {}
};

#endif
