

#if !defined __WIN_VIRTUAL_H
#define __WIN_VIRTUAL_H

#include "linetype.h"
#include "map.h"

#define OGLFLAG_NULL           0x0000
#define OGLFLAG_INIT           0x0001
#define OGLFLAG_ICONIFY        0x0002
#define OGLFLAG_DOUBLEBUFFER   0x0004
#define OGLFLAG_RGBA           0x0008
#define OGLFLAG_RED_SIZE       0x0010
#define OGLFLAG_GREEN_SIZE     0x0020
#define OGLFLAG_BLUE_SIZE      0x0040
#define OGLFLAG_DEPTH_SIZE     0x0080
#define OGLFLAG_BPP            0x0100
#define OGLFLAG_MAPBUFFER      0x0200
#define OGLFLAG_SHARE_CONTEXT  0x0400

#define FRAMESPERSEC      30

#ifndef sgn
#define sgn(x)   ( ((x)<0) ? -1 : ((x) ? 1:0) )
#endif

#define TOKEN_WINPARENT_STR "-winparent"

/* ***********************************************************************
  basic window
*********************************************************************** */
class VIRTUALwindow {

   protected:
      unsigned int flags;

   public:
      mapul mapbuffer;

      VIRTUALwindow() { flags = OGLFLAG_NULL; }
      virtual ~VIRTUALwindow() {}
      
      virtual int  VIRTUALreparent(void *data) = 0;
      virtual int  VIRTUALreset(int argc, char **argv, int maxx, int maxy, char *winname, void *attribs = NULL) = 0;
      virtual void VIRTUALswapbuffers() = 0;
      virtual void VIRTUALcancel() = 0;
      virtual void VIRTUALgetdim(int *w, int *h) = 0;
};


/* ***********************************************************************
  basic 2D window
*********************************************************************** */
class BLTwindow : public VIRTUALwindow{

   public:
      virtual void BLTbitblt(mapul *mcanvas) = 0;
      virtual void BLTbitblt(int framenum, linelist *mcanvas) = 0;

      virtual void BLTbitmap(mapul *mcanvas) = 0; 
      virtual void BLTbitmap(int framenum, linelist *mcanvas) = 0;

      virtual void BLTanimate(int numframes, mapul *mcanvas) = 0;
      virtual void BLTanimate(linelist *mcanvas) = 0;

      virtual ~BLTwindow() {}
};


/************************************************************************
************************************************************************/
class OSwindow : public VIRTUALwindow {

   public:
      virtual ~OSwindow() {}

      virtual void OSset_context() = 0;
      virtual int  OSquery_reset() = 0;
};

#endif

