

#if !defined __3DS_LOAD_H
#define __3DS_LOAD_H


#include "polytype.h"
#include "shading.h"


typedef struct {
   unsigned int id;
   unsigned int length;
} sd3_block_header;
   

/* *******************************************************************
******************************************************************* */
typedef struct {

   vector3f v;
   vector2f uv;
} vertex3ds;


/* *******************************************************************
******************************************************************* */
class face3ds {

   public:
      int edgelist[3];
      int ilm;
      
      face3ds() { ilm = -1; }
};


/* *******************************************************************
******************************************************************* */
class ilm3ds : public dbl_llist {

   public:
      string_type name;

      vector4uc   ambient;
      vector4uc   diffuse;
      vector4uc   specular;

      string_type texname;
      texbase     *tob;
      vector2f    uvscale;
      vector2f    uvoffset;
      vector2f    angle;
      vector2f    diff;
      
      int         facecount;
      
      ilm3ds();
      virtual ~ilm3ds() {}

      void convert(float *in, float *out);
};


/* *******************************************************************
******************************************************************* */
class object3ds : public dbl_llist {

   public:
      int countvertex, countobject;
      vertex3ds *vertex;
      face3ds *face;

      object3ds() { vertex = NULL; face = NULL; }      
      virtual ~object3ds() { if (vertex) delete [] vertex; if (face) delete [] face; }
};


/* *******************************************************************
******************************************************************* */
class sd3_loader : public file_loader {

   protected:
      sd3_block_header master_block;
      polytype *ob;
      resource_type *current;

      dbl_llist_manager o_manager;
      dbl_llist_manager i_manager;
      
      void scan_string(string_type *string);

      int  extract_face_block(int length);
      int  extract_mesh_block(int length);
      int  extract_object_block(int length);

      int  extract_texture_block(int length);
      int  extract_color_block(int length, unsigned char *color);
      int  extract_amount_block(int length);
      int  extract_material_block(int length);

      int  extract_edit_block(int length);
      int  extract_master_block(int length);

      int  extract_uv();
      void extract_shade(ilm3ds *itr, shadetype *ilm);
      int  extract_material();
      int  extract_object();

   public:
      // basic_loader
      void cleanup();
      basic_loader *find_loader(sfile *data);

      // file_loader
      int read_data();
      void *extract(unsigned int type, char *altname, int level = 0);

      // sd3
      sd3_loader() { master_block.id = 0; }
      virtual ~sd3_loader() {}
};

#endif

