

#include "imgman.h"


/* ****************************************************************************
**************************************************************************** */
void imgman_resize_length(mapul *source, mapul *out, int new_length) {

   int i, j;
   float stretch, x;
   int *buffer;
   unsigned int *sdata;
   unsigned int *odata;

   buffer = new int[new_length];

   out->init_map(new_length, source->maxy, source->data - source->alloc_data);

   sdata = source->data;
   odata = out->data;

   stretch = ((float)source->maxx)/new_length;

   for (j=0, x=0; j<new_length; j++, x += stretch)
      buffer[j] = (int)x;

   for (i=0; i<(int)source->maxy; i++, sdata += source->maxx, odata += new_length)
      for (j=0; j<new_length; j++)
         odata[j] = sdata[buffer[j]];

   delete [] buffer;
}


/* ****************************************************************************
**************************************************************************** */
void imgman_resize_height(mapul *source, mapul *out, int new_height) {

   int i, j;
   float stretch, y;
   unsigned int *sdata;
   unsigned int *odata;

   out->init_map(source->maxx, new_height, source->data - source->alloc_data);

   odata = out->data;

   stretch = ((float)source->maxy)/new_height;

   for (i=0, y=0; i<new_height; i++, y+=stretch, odata+=out->maxx) {
      sdata = source->pdata[(int)y];
      for (j=0; j<(int)source->maxx; j++)
         odata[j] = sdata[j];
   }

}


/* ****************************************************************************
**************************************************************************** */
void imgman_resize(mapul *source, mapul *out, int new_length, int new_height) {

   int i, j;
   float hstretch, lstretch, f;
   int *buffer;
   unsigned int *sdata;
   unsigned int *odata;

   buffer = new int[new_length];

   out->init_map(new_length, new_height, source->data - source->alloc_data);

   odata = out->data;

   hstretch = ((float)source->maxy)/new_height;
   lstretch = ((float)source->maxx)/new_length;

   for (j=0, f=0; j<new_length; j++, f += lstretch)
      buffer[j] = (int)f;

   for (i=0, f=0; i<new_height; i++, f+=hstretch, odata+=out->maxx) {
      sdata = source->pdata[(int)f];
      for (j=0; j<(int)new_length; j++)
         odata[j] = sdata[buffer[j]];
   }

   delete [] buffer;
}


/* ****************************************************************************
**************************************************************************** */
void imgman_resize_length(mapuc *source, mapuc *out, int new_length) {

   int i, j;
   float stretch, x;
   int *buffer;
   unsigned char *sdata;
   unsigned char *odata;

   buffer = new int[new_length];

   out->init_map(new_length, source->maxy, source->data - source->alloc_data);

   sdata = source->data;
   odata = out->data;

   stretch = ((float)source->maxx)/new_length;

   for (j=0, x=0; j<new_length; j++, x += stretch)
      buffer[j] = (int)x;

   for (i=0; i<(int)source->maxy; i++, sdata += source->maxx, odata += new_length)
      for (j=0; j<new_length; j++)
         odata[j] = sdata[buffer[j]];

   delete [] buffer;
}


/* ****************************************************************************
**************************************************************************** */
void imgman_resize_height(mapuc *source, mapuc *out, int new_height) {

   int i, j;
   float stretch, y;
   unsigned char *sdata;
   unsigned char *odata;

   out->init_map(source->maxx, new_height, source->data - source->alloc_data);

   odata = out->data;

   stretch = ((float)source->maxy)/new_height;

   for (i=0, y=0; i<new_height; i++, y+=stretch, odata+=out->maxx) {
      sdata = source->pdata[(int)y];
      for (j=0; j<(int)source->maxx; j++)
         odata[j] = sdata[j];
   }

}


/* ****************************************************************************
**************************************************************************** */
void imgman_resize(mapuc *source, mapuc *out, int new_length, int new_height) {

   int i, j;
   float hstretch, lstretch, f;
   int *buffer;
   unsigned char *sdata;
   unsigned char *odata;

   buffer = new int[new_length];

   out->init_map(new_length, new_height, source->data - source->alloc_data);

   odata = out->data;

   hstretch = ((float)source->maxy)/new_height;
   lstretch = ((float)source->maxx)/new_length;

   for (j=0, f=0; j<new_length; j++, f += lstretch)
      buffer[j] = (int)f;

   for (i=0, f=0; i<new_height; i++, f+=hstretch, odata+=out->maxx) {
      sdata = source->pdata[(int)f];
      for (j=0; j<(int)new_length; j++)
         odata[j] = sdata[buffer[j]];
   }

   delete [] buffer;
}

