

#include "imgman.h"
#include "matrix.h"


vector4f RGB2LSM[4] = { { 0.381102f, 0.578327f, 0.040219f, 0.0f },
                        { 0.196697f, 0.724380f, 0.078176f, 0.0f },
                        { 0.024100f, 0.128800f, 0.844400f, 0.0f },
                        { 0.0f,    0.0f,    0.0f,    1.0f } };

vector4f LOG10LSM2LAB[4] = { { 0.577350f,  0.577350f,  0.577350f, 0.0f },
                             { 0.408248f,  0.408248f, -0.816497f, 0.0f },
                             { 0.707107f, -0.707107f,  0.000000f, 0.0f },
                             { 0.0f,       0.0f,       0.0f,      1.0f } };

vector4f LAB2LOG10LSM[4] = { { 0.577350f,  0.408248f,  0.707107f, 0.0f },
                             { 0.577350f,  0.408248f, -0.707107f, 0.0f },
                             { 0.577350f, -0.816497f,  0.000000f, 0.0f },
                             { 0.0f,       0.0f,       0.0f,      1.0f } };

vector4f LSM2RGB[4] = { {  4.4679f, -3.5873f,  0.1193f, 0.0f },
                        { -1.2186f,  2.3809f, -0.1624f, 0.0f },
                        {  0.0497f, -0.2439f,  1.2045f, 0.0f },
                        {  0.0f,     0.0f,     0.0f,    1.0f } };


/* *******************************************************
******************************************************* */
void char2float(mapul *image, mapf *out, int type) {

   int i, j;
   vector4uc ccolor;

   out->init_map(image->maxx*3, image->maxy);
   
   for (i=0; i < (int)image->maxy; i++)
      for (j=0; j < (int)image->maxx; j++) {
         imgman_external2internal((unsigned char *)&image->pdata[i][j], ccolor, type);
         out->pdata[i][j*3]   = ccolor[0] ? CONVERT_0_255_0_1(ccolor[0]) : (float)CORRECT;
         out->pdata[i][j*3+1] = ccolor[1] ? CONVERT_0_255_0_1(ccolor[1]) : (float)CORRECT;
         out->pdata[i][j*3+2] = ccolor[2] ? CONVERT_0_255_0_1(ccolor[2]) : (float)CORRECT;
      }

}


/* *******************************************************
******************************************************* */
void float2char(mapf *image, mapul *out, int type) {

   int i, j, k;
   vector4uc ccolor;

   out->init_map(image->maxx/3, image->maxy);
   
   for (i=0; i < (int)out->maxy; i++)
      for (j=0; j < (int)out->maxx; j++) {
         for (k=0; k<3; k++)
            if (image->pdata[i][j*3+k] < 0)
               ccolor[k] = 0;
            else if (image->pdata[i][j*3+k] > 1.0f)
               ccolor[k] = (unsigned char)255;
            else
               ccolor[k] = CONVERT_0_1_0_255(image->pdata[i][j*3+k]);

          ccolor[3] = (ccolor[0] | ccolor[1] | ccolor[2]) ? 255 : 0;
          imgman_internal2external(ccolor, (unsigned char *)&out->pdata[i][j], type);
      }

}


/* *******************************************************
******************************************************* */
void calc_stddev(mapf *image, double *mean, int axis, double *out) {

   int i, j;
   double trow, total, tdiff;
      
   for (i=0, total = 0; i < (int)image->maxy; i++) {
      for (j=axis, trow = 0; j < (int)image->maxx; j+=3) {
         tdiff = image->pdata[i][j] - *mean;
         trow += tdiff*tdiff;
      }

      total += trow;
   }

   total = (total*3.0)/(image->maxx*image->maxy);
   *out = total < CORRECT*CORRECT ? 0.0 : sqrt(total);
}


/* *******************************************************
******************************************************* */
void calc_mean(mapf *image, int axis, double *out) {

   int i, j;
   double trow, total;
      
   for (i=0, total = 0; i < (int)image->maxy; i++) {
      for (j=axis, trow = 0; j < (int)image->maxx; j+=3)
         trow += image->pdata[i][j];
      total += trow;
      
   }

   *out = (total*3.0)/(image->maxx*image->maxy);
}


/* **************************************************
************************************************** */
void rgb2lab(mapf *image) {

   int i, j;
   float *v;
   
   for (i=0; i < (int)image->maxy; i++)
      for (j=0, v = image->pdata[i]; j < (int)image->maxx; j+=3, v+=3) {
         matvecmultv(RGB2LSM, v);
         v[0] = (float)log10(v[0]);
         v[1] = (float)log10(v[1]);
         v[2] = (float)log10(v[2]);
         matvecmultv(LOG10LSM2LAB, v);
      }

}


/* **************************************************
************************************************** */
void lab2rgb(mapf *image) {

   int i, j;
   float *v;
   
   for (i=0; i < (int)image->maxy; i++)
      for (j=0, v = image->pdata[i]; j < (int)image->maxx; j+=3, v+=3) {
         matvecmultv(LAB2LOG10LSM, v);
         v[0] = (float)pow(10.0, v[0]);
         v[1] = (float)pow(10.0, v[1]);
         v[2] = (float)pow(10.0, v[2]);
         matvecmultv(LSM2RGB, v);
      }

}


/* **************************************************
************************************************** */
void preprocess_map(mapul *tob, mapf *tex, double *mean, double *stddev, int type) {

   char2float(tob, tex, type);
   rgb2lab(tex);

   calc_mean(tex, 0, &mean[0]);
   calc_mean(tex, 1, &mean[1]);
   calc_mean(tex, 2, &mean[2]);

   calc_stddev(tex, &mean[0], 0, &stddev[0]);
   calc_stddev(tex, &mean[1], 1, &stddev[1]);
   calc_stddev(tex, &mean[2], 2, &stddev[2]);
}


/* **************************************************
************************************************** */
void imgman_swap_palettes(mapul *source, mapul *palette, mapul *out, int type) {

   mapf tex_palette;
   vector3d mean_palette;
   vector3d stddev_palette;
   
   mapf tex_target;
   vector3d mean_target;
   vector3d stddev_target;
   
   vector3d offset;
   vector3d weight;
   int i, j;
   float *v;

   preprocess_map(source, &tex_target, mean_target, stddev_target, type);
   preprocess_map(palette, &tex_palette, mean_palette, stddev_palette, type);

   weight[0] = stddev_target[0] ? stddev_palette[0]/stddev_target[0] : 1.0;   
   weight[1] = stddev_target[1] ? stddev_palette[1]/stddev_target[1] : 1.0;   
   weight[2] = stddev_target[2] ? stddev_palette[2]/stddev_target[2] : 1.0;   

   offset[0] = -mean_target[0]*weight[0] + mean_palette[0];
   offset[1] = -mean_target[1]*weight[1] + mean_palette[1];
   offset[2] = -mean_target[2]*weight[2] + mean_palette[2];

   for (i=0; i < (int)tex_target.maxy; i++)
      for (j=0, v = tex_target.pdata[i]; j < (int)tex_target.maxx; j+=3, v+=3) {
         v[0] = (float)(v[0]*weight[0] + offset[0]);
         v[1] = (float)(v[1]*weight[1] + offset[1]);
         v[2] = (float)(v[2]*weight[2] + offset[2]);
      }

   lab2rgb(&tex_target);
   float2char(&tex_target, out, type);
}

