

#include "imgman.h"
#include "matrix.h"


/* *******************************************************************************
   uses a 3x3 cone filter
******************************************************************************* */
void imgman_build_mipmap(mapul *source, mapul *out, int repeat, int type) {

   vector3f value;
   int alpha;
   float weight;
   int maxx, maxy;
   int i, j;
   int x, y;
   int a, b;
   int row, col;
   union { unsigned int *odata; unsigned char *cdata; };
   union { unsigned int *idata; unsigned char *cidata; };
   mapul tob;
   vector4uc color;

   tob.init_map(source->maxx, source->maxy);

   odata = tob.data;
   idata = source->data;
   j = source->maxx*source->maxy;

   for (i=0; i < j; i++, odata++, idata++)
      imgman_external2internal(cidata, cdata, type);

   maxx = source->maxx > 1 ? (source->maxx>>1) : 1;
   maxy = source->maxy > 1 ? (source->maxy>>1) : 1;
   out->init_map(maxx, maxy);
   odata = out->data;

   for (i=a=0; i<out->maxy; i++, a+=2)
      for (j=b=0; j<out->maxx; j++, b+=2, odata++) {

         weight = 0;
         alpha = 0;
         value[0] = value[1] = value[2] = 0;

         // edge of filter
         for (y=a-1; y < a+2; y++) {
            if (y < 0) {
               if (!repeat)
                  continue;
               row = tob.maxy - 1;
            }

            else if (y == tob.maxy) {
               if (!repeat)
                  continue;
               row = 0;
            }

            else
               row = y;

            for (x=b-1; x < b+2; x++) {
               if (y == a && x == b)
                  continue;
 
               if (x < 0) {
                  if (!repeat)
                     continue;
                  col = tob.maxx - 1;
               }

               else if (x == tob.maxx) {
                  if (!repeat)
                     continue;
                  col = 0;
               }

               else
                  col = x;

               weight += 0.05;
   
               value[0] += ((unsigned char *)&tob.pdata[row][col])[0];
               value[1] += ((unsigned char *)&tob.pdata[row][col])[1];
               value[2] += ((unsigned char *)&tob.pdata[row][col])[2];
               alpha |= ((unsigned char *)&tob.pdata[row][col])[3];
            }

         }

         // center of filter
         weight += 0.6;

         value[0] = 0.05*value[0] + 0.6*((unsigned char *)&tob.pdata[a][b])[0];
         value[1] = 0.05*value[1] + 0.6*((unsigned char *)&tob.pdata[a][b])[1];
         value[2] = 0.05*value[2] + 0.6*((unsigned char *)&tob.pdata[a][b])[2];
         alpha |= ((unsigned char *)&tob.pdata[a][b])[3];

         color[0] = (int)(value[0]/weight); 
         color[1] = (int)(value[1]/weight); 
         color[2] = (int)(value[2]/weight); 
         color[3] = alpha ? 255 : 0;
         imgman_internal2external(color, cdata, type);
      }

}

