

#include "datatype.h"


/* **************************************************
************************************************** */
void imgman_external2internal(unsigned char *external, unsigned char *internal, int type) {

   switch(type) {
      case CBYTE_ORDER_ABGR:
         internal[0] = external[3];
         internal[1] = external[2];
         internal[2] = external[1];
         internal[3] = external[0];
         return;

      case CBYTE_ORDER_ARGB:
         internal[0] = external[1];
         internal[1] = external[2];
         internal[2] = external[3];
         internal[3] = external[0];
         return;

      case CBYTE_ORDER_BGRA:
         internal[0] = external[2];
         internal[1] = external[1];
         internal[2] = external[0];
         internal[3] = external[3];
         return;

//      case CBYTE_ORDER_RGBA:
      default:
         internal[0] = external[0];
         internal[1] = external[1];
         internal[2] = external[2];
         internal[3] = external[3];
         return;
   }

}

/* **************************************************
************************************************** */
void imgman_internal2external(unsigned char *internal, unsigned char *external, int type) {

   switch(type) {
      case CBYTE_ORDER_ABGR:
         external[3] = internal[0];
         external[2] = internal[1];
         external[1] = internal[2];
         external[0] = internal[3];
         return;

      case CBYTE_ORDER_ARGB:
         external[1] = internal[0];
         external[2] = internal[1];
         external[3] = internal[2];
         external[0] = internal[3];
         return;

      case CBYTE_ORDER_BGRA:
         external[2] = internal[0];
         external[1] = internal[1];
         external[0] = internal[2];
         external[3] = internal[3];
         return;

//      case CBYTE_ORDER_RGBA:
      default:
         external[0] = internal[0];
         external[1] = internal[1];
         external[2] = internal[2];
         external[3] = internal[3];
         return;
   }

}


