

#include "imgman.h"
#include "matrix.h"


/* **************************************************
************************************************** */
void imgman_greyscale(mapul *source, mapul *out, int type) {

   union { unsigned int icolor; vector4uc ccolor; };
   union { unsigned int *pisource; unsigned char *pcsource; };
   union { unsigned int *piout; unsigned char *pcout; };
   unsigned int *piend;
   float r[256], g[256], b[256];
   int i;

   for (i=0; i<256; i++) {
      r[i] = i*0.30;
      g[i] = i*0.59;
      b[i] = i*0.11;
   }

   out->init_map(source->maxx, source->maxy);

   pisource = source->data;
   piend = out->data + out->maxx*out->maxy;

   for (piout=out->data; piout<piend; pisource++, piout++) {
      imgman_external2internal(pcsource, ccolor, type);
      ccolor[0] = ccolor[1] = ccolor[2] = BYTE_LUT((int)(r[ccolor[0]] + g[ccolor[1]] + b[ccolor[2]]));
      imgman_internal2external(ccolor, pcout, type);
   }

}

