

#include "colortre.h"
#include "imgman.h"


/* **************************************************
************************************************** */
int colordata::compare(binary_data *x) {

   if (icolor < ((colordata *)x)->icolor)
      return -1;
      
   return icolor > ((colordata *)x)->icolor;
}


/* **************************************************
************************************************** */
binary_node *colornode::insert(binary_node *x) {

   binary_node *ptr;
   int i;
   
   i = key->compare(x->key);
   
   if (i < 0)
      return next ? next->insert(x) : next = x;

   if (i > 0)
      return back ? back->insert(x) : back = x;
   
   count++;

   if (x->next) {
      x->remove(ptr = x->next);
      insert(ptr);
   }

   if (x->back) {
      x->remove(ptr = x->back);
      insert(ptr);
   }

   delete x;
   return this;
}


/* **************************************************
************************************************** */
void colornode::build_list(dbl_llist_manager *x) {

   color_llist *ptr;
   
   x->append(ptr = new color_llist, NULL);
   ptr->color = this;

   if (next)
      ((colornode *)next)->build_list(x);
      
   if (back)
      ((colornode *)back)->build_list(x);
}
      

/* **************************************************
************************************************** */
void colortree::build_list(dbl_llist_manager *x) {

   x->dest();
   
   if (head)
      ((colornode *)head)->build_list(x);
}
      

/* **************************************************
************************************************** */
binary_node *colortree::insert(binary_node *x) {

   binary_node *ptr;
   
   ptr = binary_tree::insert(x);
   
   if (ptr == x) {
      count++;
      pixel_count+=((colornode *)x)->count;
   }
   
   else    
      pixel_count++;
   
   return ptr;
}


/* **************************************************
************************************************** */
int colortree::remove(binary_node *x) {

   unsigned int ret = binary_tree::remove(x);

   if (ret) {
      count--;
      pixel_count -= ((colornode *)x)->count; 
   }
   
   return ret;
}


/* *******************************************************
******************************************************* */
void list_manager_type::calc_stddev(unsigned int flag) {

   int i;
   color_llist *ctr;
   
   double tdiff;
   
   calc_mean();
   
   stddev[0] = stddev[1] = stddev[2] = 0;

   if (!head)
      return;

   for (ctr = (color_llist *)head; ctr; ctr = (color_llist *)ctr->next)
      for (i=0; i<3; i++) {
         tdiff = CONVERT_0_255_0_1(ctr->color->key_color.ccolor[i]) - mean[i];
         stddev[i] += tdiff*tdiff*ctr->color->count;
      }

   if (flag == FILTER_STDDEV) 
      for (i=0; i<3; i++) {      
         stddev[i] /= total;
         stddev[i] = stddev[i] < CORRECT*CORRECT ? 0.0 : sqrt(stddev[i]);
      }
      
   // else FILTER_WEIGHTED_STDDEV
   else
      for (i=0; i<3; i++)
         stddev[i] = stddev[i] < CORRECT*CORRECT ? 0.0 : sqrt(stddev[i]);
}


/* *******************************************************
******************************************************* */
void list_manager_type::calc_mean() {

   int i;
   color_llist *ctr;

   total = 0;
   mean[0] = mean[1] = mean[2] = 0;

   if (!head)
      return;

   for (ctr = (color_llist *)head; ctr; ctr = (color_llist *)ctr->next) {
      for (i=0; i<3; i++)
         mean[i] += CONVERT_0_255_0_1(ctr->color->key_color.ccolor[i])*ctr->color->count;
      total += ctr->color->count;
   }

   for (i=0; i<3; i++)     
      mean[i] /= total;
}


/* **************************************************
************************************************** */
void list_manager_type::set_index(unsigned int x, char *buffer) {

   color_llist *ctr;

   for (ctr = (color_llist *)head; ctr; ctr = (color_llist *)ctr->next)
      buffer[color2index(ctr->color->key_color.ccolor)] = x;
}


/* **************************************************
************************************************** */
void colortree::append(mapul *tob, int type) {

   int i, j;
   colornode *ptr;
   
   for (i=0; i<(int)tob->maxy; i++)
      for (j=0; j<(int)tob->maxx; j++) {
         ptr = new colornode;

         imgman_external2internal((unsigned char *)&tob->pdata[i][j], ptr->key_color.ccolor, type);
         ptr->key_color.ccolor[3] = 0;
         ptr->count = 1;

         insert(ptr);
      }

}

