

#include "colortre.h"
#include "imgman.h"
#include "global.h"


/* **************************************************
************************************************** */
void split_tree(dbl_llist_manager *intree, dbl_llist_manager *outtree) {

   tree_llist *ttr;
   colordata black;
   colornode *cnode;
   int i, j; 
   color_llist *clist;
   dbl_llist_manager list_manager;
   manager_node *ltr, *mtr, *str;
   float work;
   vector4uc cwork;
    
   ttr = (tree_llist *)intree->head;
   outtree->dest();

   // split off black
   black.icolor = 0;
   cnode = (colornode *)ttr->tree->find(&black);
   if (cnode) {
      // take black out of tree
      ttr->tree->remove(cnode);
      outtree->insert(ltr = new manager_node, NULL);
      ltr->list.mean[0] = ltr->list.mean[1] = ltr->list.mean[2] = 0;
      ltr->list.insert(clist = new color_llist, NULL);
      clist->color = cnode;
   }

   list_manager.insert(ltr = new manager_node, NULL);
   
   // list of colors minus black
   ttr->tree->build_list(&ltr->list);

   // put back black into tree - remember "manager_node" points to tree node for info
   if (cnode)
      ttr->tree->insert(cnode);
        
   ltr->list.calc_stddev(FILTER_WEIGHTED_STDDEV);

   // split rest   
   while (outtree->count + list_manager.count < 256) {
   
      // 1) find channel w/ most stddev colors
      str = (manager_node *)list_manager.head;

      work = (float)str->list.stddev[j=0];

      if (work < str->list.stddev[1])
         work = (float)str->list.stddev[j=1];

      if (work < str->list.stddev[2])
         work = (float)str->list.stddev[j=2];

      for (ltr = (manager_node *)str->next; ltr; ltr = (manager_node *)ltr->next)
         for (i=0; i<3; i++)
            if (work < ltr->list.stddev[i]) {
               str = ltr;
               work = (float)ltr->list.stddev[j=i];
            }

      
      cwork[0] = CONVERT_0_1_0_255(str->list.mean[j]);
      
      list_manager.insert(ltr = new manager_node, NULL);
      list_manager.insert(mtr = new manager_node, NULL);
      
      while (str->list.head) {
         str->list.remove(clist = (color_llist *)str->list.head);

         if (clist->color->key_color.ccolor[j] < cwork[0])
            ltr->list.insert(clist, NULL);
         else
            mtr->list.insert(clist, NULL);
      }

      ltr->list.calc_stddev(FILTER_WEIGHTED_STDDEV);
      mtr->list.calc_stddev(FILTER_WEIGHTED_STDDEV);

      list_manager.remove(str);
      delete str;
   }

   while (list_manager.head) {
      list_manager.remove(str = (manager_node *)list_manager.head);
      outtree->insert(str, NULL);
   }

}


/* **************************************************
************************************************** */
void create_tree_palette(colortree *tree, unsigned int *palette, int type) {

   dbl_llist_manager manager;
   color_llist *ctr;
   int i;
   union { unsigned int itexel; vector4uc ctexel; };

   tree->build_list(&manager);      

   for (ctr = (color_llist *)manager.head, i=0; ctr; ctr = (color_llist *)ctr->next, i++) {
      itexel = ctr->color->key_color.icolor;
      ctexel[3] = (ctexel[0] | ctexel[1] | ctexel[2]) ? 255 : 0;
      imgman_internal2external(ctexel, (unsigned char *)&palette[i], type);
      ctr->color->index = i;
   }

}


/* **************************************************
   Note: this will delete the incoming tree...
************************************************** */
char *create_mean_tree_palette(colortree *tree, unsigned int *palette, int type) {

   dbl_llist_manager manager, outman;
   int i;
   vector4uc ccolor;
   manager_node *ltr;
   char *colortable;

   manager.insert(new tree_llist, NULL);
   ((tree_llist *)manager.head)->tree = tree;

   // apply color filtering....

   split_tree(&manager, &outman);

   // asdf possible opt: alloc/dealloc this table from memman
   colortable = new char[1<<24];
   
   // create palette
   for (i = 0, ltr = (manager_node *)outman.head; ltr; i++, ltr = (manager_node *)ltr->next) {
      ccolor[0] = CONVERT_0_1_0_255(ltr->list.mean[0]);
      ccolor[1] = CONVERT_0_1_0_255(ltr->list.mean[1]);
      ccolor[2] = CONVERT_0_1_0_255(ltr->list.mean[2]);
      ccolor[3] = (ccolor[0] | ccolor[1] | ccolor[2]) ? 255 : 0;
      imgman_internal2external(ccolor, (unsigned char *)&palette[i], type);
      ltr->list.set_index(i, colortable);
   }

   return colortable;
}


/* **************************************************
************************************************** */
void process_tree(colortree *tree, mapul *tob, mapuc *cob, int type) {

   int i, j;
   colornode *ptr;
   colordata key;

   cob->init_map(tob->maxx, tob->maxy);

   for (i=0; i<(int)cob->maxy; i++)
      for (j=0; j<(int)cob->maxx; j++) {
         imgman_external2internal((unsigned char *)&tob->pdata[i][j], key.ccolor, type);
         key.ccolor[3] = 0;
         ptr = (colornode *)tree->find(&key);
         if (ptr)
            cob->pdata[i][j] = ptr->index;
         else {
            pprintf("Reduction Error... cannot remap colors...\n");
            cob->pdata[i][j] = 0;
         }

      }
      
}


/* **************************************************
************************************************** */
void process_mean_tree(char *colortable, mapul *tob, mapuc *cob, int type) {

   int i, j;
   vector4uc ccolor;

   // remap to new palette   
   cob->init_map(tob->maxx, tob->maxy);
   
   for (i=0; i<(int)cob->maxy; i++)
      for (j=0; j<(int)cob->maxx; j++) {
         imgman_external2internal((unsigned char *)&tob->pdata[i][j], ccolor, type);
         cob->pdata[i][j] = colortable[color2index(ccolor)];
      }

}


/* **************************************************
************************************************** */
void imgman_convert_2428(mapul *source, unsigned int *out_palette, mapuc *out, int type) {

   colortree *tree;
   char *colortable;

   tree = new colortree;
   tree->append(source, type);

   if (tree->count < 257) {
      create_tree_palette(tree, out_palette, type);
      process_tree(tree, source, out, type);
      delete tree;
      return;
   }

   colortable = create_mean_tree_palette(tree, out_palette, type);
   process_mean_tree(colortable, source, out, type);

   delete [] colortable;
}


/* **************************************************
************************************************** */
void imgman_convert_multiple_2428(dbl_llist_manager *inout, unsigned int *out_palette, int type) {

   colortree *tree;
   char *colortable;
   imgman_i2c_type *ptr;

   if (!inout->head)
      return;

   tree = new colortree;

   for (ptr = (imgman_i2c_type *)inout->head; ptr; ptr = (imgman_i2c_type *)ptr->next)
      tree->append(ptr->itob, type);

   if (tree->count < 257) {
      create_tree_palette(tree, out_palette, type);

      for (ptr = (imgman_i2c_type *)inout->head; ptr; ptr = (imgman_i2c_type *)ptr->next)
         process_tree(tree, ptr->itob, ptr->ctob, type);

      delete tree;
      return;
   }

   colortable = create_mean_tree_palette(tree, out_palette, type);

   for (ptr = (imgman_i2c_type *)inout->head; ptr; ptr = (imgman_i2c_type *)ptr->next)
      process_mean_tree(colortable, ptr->itob, ptr->ctob, type);

   delete [] colortable;
}

