

#include "tiffio.h"

#include "pstring.h"
#include "image.h"
#include "global.h"


/* ***************************************************************
*************************************************************** */
basic_loader *tiff::find_loader(sfile *data) {

   TIFF *tif;

   sinfile = data;

   tif = TIFFOpen(sinfile->filename.string, "rb");

   if (tif) {
      TIFFClose(tif);
      return this;
   }

   sinfile = NULL;

   return next ? ((basic_loader *)next)->find_loader(data) : NULL;
}


/* *****************************************************
   asdf - bypassing "sfile" because of tiff lib
***************************************************** */
int tiff::scan_data(mapul *tob, int flip) {

   TIFF *tif;
   unsigned int x, y;
   int i;
   char *j, *ptr;
   int l, m;
   
   if (!(tif = TIFFOpen(sinfile->filename.string, "rb")))
      return 0;

   TIFFGetField(tif, TIFFTAG_IMAGELENGTH, &y);
   TIFFGetField(tif, TIFFTAG_IMAGEWIDTH, &x);

   if ((int)x*3 != TIFFScanlineSize(tif)) {
      TIFFClose(tif);
      return 0;
   }

   tob->init_map(x, y);

   for (m=0, i=y-1; m<(int)y; m++, i--) {
      TIFFReadScanline(tif, tob->pdata[i], m);

      for (l=0, j=(char *)tob->pdata[i] + 3*(x-1), ptr=(char *)&tob->pdata[i][x-1]; l<(int)x; l++, j-=3, ptr-=4)
         switch (flip) {
            case CBYTE_ORDER_ABGR:
               ptr[3] = j[0];
               ptr[2] = j[1];
               ptr[1] = j[2];
               ptr[0] = (j[0] | j[1] | j[2]) ? 255 : 0;
               break;

            case CBYTE_ORDER_ARGB:
               ptr[3] = j[2];
               ptr[2] = j[1];
               ptr[1] = j[1];
               ptr[0] = (j[0] | j[1] | j[2]) ? 255 : 0;
               break;

            case CBYTE_ORDER_BGRA:
               ptr[0] = j[2];
               ptr[1] = j[1];
               ptr[2] = j[0];
               ptr[3] = (j[0] | j[1] | j[2]) ? 255 : 0;
               break;

            default:  // CBYTE_ORDER_RGBA
               ptr[0] = j[0];
               ptr[1] = j[1];
               ptr[2] = j[2];
               ptr[3] = (j[0] | j[1] | j[2]) ? 255 : 0;
               break;
         }

   }

   TIFFClose(tif);
   return 1;
}

/* *****************************************************
   asdf - bypassing "sfile" because of tiff lib
***************************************************** */
int tiff::skim_data(int *maxx, int *maxy, int flip) {

   TIFF *tif;
   unsigned int y, x;
   
   if (!(tif = TIFFOpen(sinfile->filename.string, "rb")))
      return 0;

   TIFFGetField(tif, TIFFTAG_IMAGELENGTH, &y);
   TIFFGetField(tif, TIFFTAG_IMAGEWIDTH, &x);

   *maxx = (int)x;
   *maxy = (int)y;
   
   TIFFClose(tif);
   return 1;
}

