

#include <stdlib.h>
#include <string.h>

#include "pstring.h"
#include "image.h"
#include "global.h"


/* ***************************************************************
*************************************************************** */
basic_loader *ppm::find_loader(sfile *data) {

   char buffer[MAXSTRLEN];

   sinfile = data;
   sinfile->sseek(0);

   while (1) {
      sinfile->scan_token(buffer, MAXSTRLEN);

      if (buffer[0] == '#') {
         while (sinfile->scan_uchar() != '\n');
         continue;
      }

      if (!strcmp(buffer, "P6"))
         return this;

      break;
   }

   sinfile = NULL;

   return next ? ((basic_loader *)next)->find_loader(data) : NULL;
}


/* ***************************************************************
   P6 hor(x)(col)count ver(y)(row)count 255(1 byte) top to bottom
*************************************************************** */
int ppm::scan_data(mapul *tob, int flip) {

   char buffer[MAXSTRLEN];
   string_type magic;
   int  bsize;
   int  i, j;
   int flag = 0;
   int xsize, ysize;
   unsigned char *ptr;

   sinfile->sseek(0);

   while (flag < 4) {

      sinfile->scan_token(buffer, MAXSTRLEN);

      if (buffer[0] == '#') {
         while (sinfile->scan_uchar() != '\n');
         continue;
      }

      switch(flag) {

         case 0:
            magic.stringcpy(buffer);
            break;

         case 1:
            xsize = atoi(buffer);
            break;

         case 2:
            ysize = atoi(buffer);
            break;

         case 3:
            bsize = atoi(buffer);
            break;

         default:
            break;
      }

      flag++;
   }

   if (magic.stringcmp("P6") || bsize != 255)
      return 0;

   while (sinfile->scan_uchar() != '\n');

   tob->init_map(xsize, ysize);

   for (i=ysize-1; i>-1; i--)
      for (j=0, ptr = (unsigned char *)tob->pdata[i]; j < xsize; j++, ptr+=4) {

         switch (flip) {
            case CBYTE_ORDER_ABGR:
               ptr[3] = sinfile->scan_uchar();
               ptr[2] = sinfile->scan_uchar();
               ptr[1] = sinfile->scan_uchar();
               ptr[0] = (ptr[1] | ptr[2] | ptr[3]) ? 255 : 0;
               break;

            case CBYTE_ORDER_ARGB:
               ptr[1] = sinfile->scan_uchar();
               ptr[2] = sinfile->scan_uchar();
               ptr[3] = sinfile->scan_uchar();
               ptr[0] = (ptr[1] | ptr[2] | ptr[3]) ? 255 : 0;
               break;

            case CBYTE_ORDER_BGRA:
               ptr[2] = sinfile->scan_uchar();
               ptr[1] = sinfile->scan_uchar();
               ptr[0] = sinfile->scan_uchar();
               ptr[3] = (ptr[0] | ptr[1] | ptr[2]) ? 255 : 0;
               break;

            default:  // CBYTE_ORDER_RGBA
               ptr[0] = sinfile->scan_uchar();
               ptr[1] = sinfile->scan_uchar();
               ptr[2] = sinfile->scan_uchar();
               ptr[3] = (ptr[0] | ptr[1] | ptr[2]) ? 255 : 0;
               break;
         }

      }

   return 1;
}


/* ***************************************************************
*************************************************************** */
int ppm::skim_data(int *maxx, int *maxy, int flip) {

   char buffer[MAXSTRLEN];
   string_type magic;
   int  bsize;
   int flag = 0;

   sinfile->sseek(0);

   while (flag < 4) {

      sinfile->scan_token(buffer, MAXSTRLEN);

      if (buffer[0] == '#') {
         while (sinfile->scan_uchar() != '\n');
         continue;
      }

      switch(flag) {

         case 0:
            magic.stringcpy(buffer);
            break;

         case 1:
            *maxx = atoi(buffer);
            break;

         case 2:
            *maxy = atoi(buffer);
            break;

         case 3:
            bsize = atoi(buffer);
            break;

         default:
            break;
      }

      flag++;
   }

   return !magic.stringcmp("P6") && bsize == 255;
}


/* ***************************************************************
*************************************************************** */
int ppm::write_data(char *fname, mapul *tob, int flip) {

   FILE *outfile;
   int  i, j;
   unsigned char *ptr;

   if (!(outfile = fopen(fname,"wb")))
      return 0;

   fprintf(outfile, "P6 %d %d 255\n", tob->maxx, tob->maxy);

   switch (flip) {

      case CBYTE_ORDER_ABGR:
         for (i=tob->maxy-1; i>=0; i--)
            for (j=0, ptr = (unsigned char *)tob->pdata[i]; j < (int)tob->maxx; j++, ptr+=4) {
               fwrite(&ptr[3], 1, 1, outfile);
               fwrite(&ptr[2], 1, 1, outfile);
               fwrite(&ptr[1], 1, 1, outfile);
            }
	    
         break;
	 
      case CBYTE_ORDER_ARGB:
         for (i=tob->maxy-1; i>=0; i--)
            for (j=0, ptr = (unsigned char *)tob->pdata[i]; j < (int)tob->maxx; j++, ptr+=4) {
               fwrite(&ptr[1], 1, 1, outfile);
               fwrite(&ptr[2], 1, 1, outfile);
               fwrite(&ptr[3], 1, 1, outfile);
            }
	    
         break;
	 
      case CBYTE_ORDER_BGRA:
         for (i=tob->maxy-1; i>=0; i--)
            for (j=0, ptr = (unsigned char *)tob->pdata[i]; j < (int)tob->maxx; j++, ptr+=4) {
               fwrite(&ptr[2], 1, 1, outfile);
               fwrite(&ptr[1], 1, 1, outfile);
               fwrite(&ptr[0], 1, 1, outfile);
            }

            break;

      default: // CBYTE_ORDER_RGBA	    
         for (i=tob->maxy-1; i>=0; i--)
            for (j=0, ptr = (unsigned char *)tob->pdata[i]; j < (int)tob->maxx; j++, ptr+=4) {
               fwrite(&ptr[0], 1, 1, outfile);
               fwrite(&ptr[1], 1, 1, outfile);
               fwrite(&ptr[2], 1, 1, outfile);
            }

   }
   
   fclose(outfile);
   return 1;
}

