

/* **********************************************************************
    Updated for JPEG 6b libraries by Dave Bodenstab (imdave@mcs.net)
********************************************************************** */


#include "image.h"
#include "global.h"
#include "jpeglib.h"


/* ********************************************************
   bypass default jpeg error handler (exit the program)
******************************************************** */
static void catch_error_exit(j_common_ptr cinfo) {

//   pprintf("Warning: activating jpeg default error handler...\n");
}


/* ********************************************************
   bypass default jpeg message handler (exit the program)
******************************************************** */
static void catch_message(j_common_ptr cinfo, int msg_level) {

//   pprintf("Note: activating jpeg msg handler...\n");
}


/* ***************************************************************
*************************************************************** */
basic_loader *jpeg::find_loader(sfile *data) {

   struct jpeg_decompress_struct cinfo;
   struct jpeg_error_mgr jerr;
   FILE *infile;
   int i;

   sinfile = data;

   if (find_file(sinfile->filename.string, "rb", TEXTURE_PATH.string, (char)PLATFORM_SLASH, NULL, &infile)) {

      cinfo.err = jpeg_std_error(&jerr);
      jerr.error_exit = catch_error_exit;
      jerr.emit_message = catch_message;

      jpeg_create_decompress(&cinfo);
      jpeg_stdio_src(&cinfo, infile);

      i = jpeg_read_header(&cinfo,TRUE) == JPEG_HEADER_OK;
      jpeg_destroy_decompress(&cinfo);
      fclose(infile);

      if (i)
         return this;
   }

   sinfile = NULL;

   return next ? ((basic_loader *)next)->find_loader(data) : NULL;
}


/* ********************************************************
   asdf - bypassing "sinfile" because of jpeg lib
******************************************************** */
int jpeg::scan_data(mapul *tob, int flip) {

   // This struct contains the JPEG decompression parameters and pointers to
   // working space (which is allocated as needed by the JPEG library).
   struct jpeg_decompress_struct cinfo;

   // source file
   FILE *infile;

   struct jpeg_error_mgr jerr;
   int i;
   unsigned char *j, *k;
   int l;

   if (!find_file(sinfile->filename.string, "rb", TEXTURE_PATH.string, (char)PLATFORM_SLASH, NULL, &infile))
      return 0;

   // Step 1: allocate and initialize JPEG decompression object
   //         We set up the normal JPEG error routines
   cinfo.err = jpeg_std_error(&jerr);
   jerr.error_exit = catch_error_exit;
   jerr.emit_message = catch_message;

   // Now we can initialize the JPEG decompression object.
   jpeg_create_decompress(&cinfo);

   // Step 2: specify data source (eg, a file)
   jpeg_stdio_src(&cinfo, infile);

   if (jpeg_read_header(&cinfo,TRUE) != JPEG_HEADER_OK) {
      jpeg_destroy_decompress(&cinfo);
      fclose(infile);
      return 0;
   }

   jpeg_start_decompress(&cinfo);

   tob->init_map(cinfo.output_width, cinfo.output_height);

   // Step 6: while (scan lines remain to be read)
   //           jpeg_read_scanlines(...); 

   if (cinfo.out_color_space == JCS_GRAYSCALE) {
      for (i=cinfo.output_height-1; i > -1; i--) {
         jpeg_read_scanlines(&cinfo, (unsigned char **)(&tob->pdata[i]), 1);

         j=(unsigned char *)tob->pdata[i] + (cinfo.output_width-1);
         k=(unsigned char *)(&tob->pdata[i][cinfo.output_width-1]);
         for (l=0; l < cinfo.output_width; l++, j--, k-=4)
            switch (flip) {
               case CBYTE_ORDER_ABGR:
               case CBYTE_ORDER_ARGB:
                  k[3] = k[2] = k[1] = *j;
                  k[0] = *j ? 255 : 0;
                  break;

               // case CBYTE_ORDER_BGRA:
               default:  // CBYTE_ORDER_RGBA
                  k[0] = k[1] = k[2] = *j;
                  k[3] = *j ? 255 : 0;
                  break;
            }

      }

   }

   else {
      for (i=cinfo.output_height-1; i > -1; i--) {
         jpeg_read_scanlines(&cinfo, (unsigned char **)(&tob->pdata[i]), 1);

         j=(unsigned char *)tob->pdata[i] + 3*(cinfo.output_width-1);
         k=(unsigned char *)(&tob->pdata[i][cinfo.output_width-1]);
         for (l=0; l < cinfo.output_width; l++, j-=3, k-=4)
            switch (flip) {
               case CBYTE_ORDER_ABGR:
                  k[3] = j[0];
                  k[2] = j[1];
                  k[1] = j[2];
                  k[0] = (j[0] | j[1] | j[2]) ? 255 : 0;
                  break;

               case CBYTE_ORDER_ARGB:
                  k[3] = j[2];
                  k[2] = j[1];
                  k[1] = j[1];
                  k[0] = (j[0] | j[1] | j[2]) ? 255 : 0;
                  break;

               case CBYTE_ORDER_BGRA:
                  k[2] = j[0];
                  k[1] = j[1];
                  k[0] = j[2];
                  k[3] = (j[0] | j[1] | j[2]) ? 255 : 0;
                  break;

               default:  // CBYTE_ORDER_RGBA
                  k[0] = j[0];
                  k[1] = j[1];
                  k[2] = j[2];
                  k[3] = (j[0] | j[1] | j[2]) ? 255 : 0;
                  break;
            }

      }

   }

   jpeg_finish_decompress(&cinfo);
   jpeg_destroy_decompress(&cinfo);
   fclose(infile);
   return 1;
}


/* ********************************************************
   asdf - bypassing "sfile" because of jpeg lib
******************************************************** */
int jpeg::skim_data(int *maxx, int *maxy, int flip) {

   struct jpeg_decompress_struct cinfo;
   FILE *infile;
   struct jpeg_error_mgr jerr;

   if (!find_file(sinfile->filename.string, "rb", TEXTURE_PATH.string, (char)PLATFORM_SLASH, NULL, &infile))
      return 0;

   cinfo.err = jpeg_std_error(&jerr);
   jerr.error_exit = catch_error_exit;
   jerr.emit_message = catch_message;

   jpeg_create_decompress(&cinfo);
   jpeg_stdio_src(&cinfo, infile);

   if (jpeg_read_header(&cinfo,TRUE) != JPEG_HEADER_OK) {
      fclose(infile);
      return 0;
   }

   *maxx = cinfo.output_width;
   *maxy = cinfo.output_height;
                                                                                
   jpeg_destroy_decompress(&cinfo);
   fclose(infile);
   return 1;
}


/* ***************************************************************
*************************************************************** */
int jpeg::write_data(char *fname, mapul *tob, int flip) {

   struct jpeg_compress_struct cinfo;
   struct jpeg_error_mgr jerr;
   FILE * outfile;               // target file
   JSAMPROW row_pointer[1];      // pointer to JSAMPLE row[s]
   unsigned char *buffer, *ptr;
   int i, j;

   outfile = fopen(fname, "wb");
   if (!outfile) {
      sprintf(perror_buffer, "Error: Can't open %s...\n", fname);
      pprintf(perror_buffer);
      return 0;
   }

   // Step 1: allocate and initialize JPEG compression object
   cinfo.err = jpeg_std_error(&jerr);
   jerr.error_exit = catch_error_exit;
   jerr.emit_message = catch_message;

   // Now we can initialize the JPEG compression object.
   jpeg_create_compress(&cinfo);

   // Step 2: specify data destination (eg, a file)
   jpeg_stdio_dest(&cinfo, outfile);

   // Step 3: set parameters for compression
   // Four fields of the cinfo struct must be filled in:
   cinfo.image_width = tob->maxx;
   cinfo.image_height = tob->maxy;
   cinfo.input_components = 3;       // # of color components per pixel
   cinfo.in_color_space = JCS_RGB;   // colorspace of input image

   // Now use the library's routine to set default compression parameters.
   jpeg_set_defaults(&cinfo);

   // Now you can set any non-default parameters you wish to.
   // ex. the use of quality (quantization table) scaling
   // limit to baseline-JPEG values
   // quality 0 = low, 100 = highest
   jpeg_set_quality(&cinfo, 100, TRUE);

   // Step 4: Start compressor
   // TRUE ensures that we will write a complete interchange-JPEG file.
   // Pass TRUE unless you are very sure of what you're doing.
   jpeg_start_compress(&cinfo, TRUE);

   // Here we use the library's state variable cinfo.next_scanline as the
   // loop counter, so that we don't have to keep track ourselves.  To keep
   // things simple, we pass one scanline/call - you can pass more.

   row_pointer[0] = new unsigned char[tob->maxx*3];

   for (i=tob->maxy-1; i > -1; i--) {
      switch (flip) {

         case CBYTE_ORDER_ABGR:
            for (j=0, buffer = row_pointer[0], ptr = (unsigned char *)tob->pdata[i]; j < (int)tob->maxx; j++, ptr+=4, buffer+=3) {
               buffer[0] = ptr[3];
               buffer[1] = ptr[2];
               buffer[2] = ptr[1];
            }

            break;

         case CBYTE_ORDER_ARGB:
            for (j=0, buffer = row_pointer[0], ptr = (unsigned char *)tob->pdata[i]; j < (int)tob->maxx; j++, ptr+=4, buffer+=3) {
               buffer[0] = ptr[1];
               buffer[1] = ptr[2];
               buffer[2] = ptr[3];
            }

            break;

         case CBYTE_ORDER_BGRA:
            for (j=0, buffer = row_pointer[0], ptr = (unsigned char *)tob->pdata[i]; j < (int)tob->maxx; j++, ptr+=4, buffer+=3) {
               buffer[0] = ptr[2];
               buffer[1] = ptr[1];
               buffer[2] = ptr[0];
            }

            break;

         default: // CBYTE_ORDER_RGBA
            for (j=0, buffer = row_pointer[0], ptr = (unsigned char *)tob->pdata[i]; j < (int)tob->maxx; j++, ptr+=4, buffer+=3)
               copyarray3(buffer, ptr);
      }

      jpeg_write_scanlines(&cinfo, row_pointer, 1);
   }

   delete [] row_pointer[0];

   jpeg_finish_compress(&cinfo);
   jpeg_destroy_compress(&cinfo);
   fclose(outfile);
   return 1;
}

