

#include <stdlib.h>
#include <string.h>

#include "texture.h"
#include "pstring.h"


/* *****************************************************************************************
***************************************************************************************** */
void texvid::update(float current_time) {
}


/* *****************************************************************************************
***************************************************************************************** */
void *texvid::query_data() {

   return NULL;
}


/* *****************************************************************
***************************************************************** */
void texvid::replace_data(void *subresource) {

}


/* ************************************************************************
************************************************************************ */
int texvid::pre_process_texture() {

   // get nearest power of 2 dimentions
   for (bitx=0, maxx=1; maxx < oldx; bitx++, maxx+=maxx);
   for (bity=0, maxy=1; maxy < oldy; bity++, maxy+=maxy);

   maskx = maxx-1;
   masky = maxy-1;

   return 1;
}


/* ************************************************************************
************************************************************************ */
int texvid::read_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip) {

   char buffer[MAXSTRLEN], buffer2[MAXSTRLEN], buffer3[MAXSTRLEN];
   int i, j, k;

   sinfile->sseek(0);

   sinfile->scan_token(buffer, MAXSTRLEN);
   lower_case(buffer);

   if (strcmp(buffer, "asdf"))
      return 0;

   sinfile->scan_token(buffer, MAXSTRLEN);
   lower_case(buffer);

   vpflag = strcmp(buffer, "repeat") ? VIDONE : VIDREPEAT;

   sinfile->scan_token(buffer, MAXSTRLEN);
   count = atoi(buffer);

   if (!count)
      return 0;

   if (tob)
      delete [] tob;

   tob = new ptexbase[count];
   for (i=0; i<count; ) {
      sinfile->scan_token(buffer, MAXSTRLEN);
      lower_case(buffer);

      if (!strcmp(buffer, "series")) {
         sinfile->scan_token(buffer2, MAXSTRLEN);

         sinfile->scan_token(buffer, MAXSTRLEN);
         j = atoi(buffer);

         sinfile->scan_token(buffer, MAXSTRLEN);
         k = atoi(buffer);

         sinfile->scan_token(buffer3, MAXSTRLEN);

         if (j <= k)
            for (; j<=k; j++) {
               sprintf(buffer, "%s.%05d.%s", buffer2, j, buffer3);
	       tob[i] = (texbase *)((frame_manager *)global_resource_manager)->read_tex(buffer);

               if (!tob[i])
                  return 0;

               i++;
            }

         else
            for (; j>=k; j--) {
               sprintf(buffer, "%s.%05d.%s", buffer2, j, buffer3);
	       tob[i] = (texbase *)((frame_manager *)global_resource_manager)->read_tex(buffer);

               if (!tob[i])
                  return 0;

               i++;
            }

      }

      else {
         sinfile->scan_token(buffer, MAXSTRLEN);
         tob[i] = (texbase *)((frame_manager *)global_resource_manager)->read_tex(buffer);

         if (!tob[i])
            return 0;

         i++;
      }

   }

   if (global_resource_manager)
      global_resource_manager->register_resource_object(RESOURCE_TEXTURE, this);

   dataname.stringcpy(&sinfile->filename);
   oldx = maxx = tob[0]->maxx;
   oldy = maxy = tob[0]->maxy;

   return 1;
}


/* ************************************************************************
        Assumption - x, y w/in parameters...
************************************************************************ */
unsigned int texvid::query_texel(float x, float y, float *color, int frame, float d) {

   int i;

   if (!tob)
      return 0;

   if (frame >= count) {
      if (vpflag == VIDONE)
         return tob[count-1]->query_texel(x,y,color,count-1, d);

      i = frame % count;
      return tob[i]->query_texel(x,y,color,i,d);
   }

   return tob[frame]->query_texel(x,y,color,frame,d);
}


/* *****************************************************************************************
***************************************************************************************** */
int texvid::query_data(int type, void *key, void *response) {

   int i;

   switch (type) {
      case TEXTURE2D_QUERY_TEXTURE:
         if (!tob)
            return 0;

         if (*(int *)key >= count) {
            i = (vpflag == VIDONE) ? count - 1 : *(int *)key % count;
            return tob[i]->query_data(TEXTURE2D_QUERY_TEXTURE, &i, response);
         }

         return tob[*(int *)key]->query_data(TEXTURE2D_QUERY_TEXTURE, key, response);

      case TEXTURE2D_QUERY_FRAMECOUNT:
         *(int *)response = count;
         return 1;

      case TEXTURE2D_QUERY_UNIT_TEXTURE:
         if (!tob)
            return 0;

         i = (int)(*(float *)key * (count-1));

         if (i >= count) {
            i = (vpflag == VIDONE) ? count - 1 : i % count;
            return tob[i]->query_data(TEXTURE2D_QUERY_TEXTURE, &i, response);
         }

         return tob[i]->query_data(TEXTURE2D_QUERY_TEXTURE, &i, response);

      default:
         break;
   }

   return texbase::query_data(type, key, response);
}

