

#include <string.h>

#include "texture.h"
#include "global.h"
#include "imgman.h"


/* *****************************************************************************************
***************************************************************************************** */
void texture::update(float current_time) {

   if (!(statusflag & STATUSFLAG_LOADABLE) || !(statusflag & STATUSFLAG_LOADED))
      return;

   if (!(statusflag & STATUSFLAG_TIME_UPDATE)) {
      delete tblock;
      tblock = NULL;

      statusflag &= ~STATUSFLAG_LOADED;
      return;
   }

   global_statistic_texture_count++;
   access_time = current_time;
   statusflag &= ~STATUSFLAG_TIME_UPDATE;
}


/* *****************************************************************************************
***************************************************************************************** */
void *texture::query_data() {

   image_coder *ptr;
   unsigned int flip;
   sfile sinfile;
   int i;

   if (tblock) {
      statusflag |= STATUSFLAG_TIME_UPDATE;
      return tblock;
   }

   if (!(statusflag & STATUSFLAG_LOADABLE))
      return NULL;

   if (!sinfile.scan_data(dataname.string, TEXTURE_PATH.string, PLATFORM_SLASH))
      return NULL;

   ptr = (image_coder *)((dbl_llist_manager *)global_resource_manager->get_resource_object(RESOURCE_IMAGE_LOADER))->head;

   if (!ptr)
      return NULL;

   ptr = (image_coder *)ptr->find_loader(&sinfile);

   if (!ptr)
      return NULL;

   flip = ((frame_manager *)global_resource_manager)->query_color_byte_order();
   tblock = new texture_block;

   i = ptr->scan_data(&((texture_block *)tblock)->tob, flip);
   ptr->cleanup();

   if (!i) {
      delete tblock;
      return tblock = NULL;
   }

   maxx = ((texture_block *)tblock)->tob.maxx;
   maxy = ((texture_block *)tblock)->tob.maxy;
   statusflag |= STATUSFLAG_LOADED | STATUSFLAG_TIME_UPDATE;
   ((frame_manager *)global_resource_manager)->postprocessCBtexture(this);
   return tblock;
}


/* *****************************************************************
***************************************************************** */
void texture::replace_data(void *subresource) {

   if (tblock)
      delete tblock;

   tblock = (basic_texture_block *)subresource;
}


/* *****************************************************************************************
   converts texture to nearest power of 2
***************************************************************************************** */
int texture::pre_process_texture() {

   int length, width;
   int diff;
   mapul source;

   if (!tblock || !((texture_block *)tblock)->tob.data)
      return 0;

   // get nearest power of 2 dimentions
   for (bitx=0, length=1; length < (int)((texture_block *)tblock)->tob.maxx; bitx++, length+=length);
   for (bity=0, width=1; width < (int)((texture_block *)tblock)->tob.maxy; bity++, width+=width);

   diff = (length - ((texture_block *)tblock)->tob.maxx) ? 1 : 0;
   diff += (width - ((texture_block *)tblock)->tob.maxy) ? 2 : 0;

   if (diff) {
      source.alloc_data = ((texture_block *)tblock)->tob.alloc_data;
      source.data = ((texture_block *)tblock)->tob.data;
      source.pdata = ((texture_block *)tblock)->tob.pdata;
      source.maxx = ((texture_block *)tblock)->tob.maxx;
      source.maxy = ((texture_block *)tblock)->tob.maxy;
      ((texture_block *)tblock)->tob.alloc_data = NULL;
      ((texture_block *)tblock)->tob.data = NULL;
      ((texture_block *)tblock)->tob.pdata = NULL;
      ((texture_block *)tblock)->tob.maxx = ((texture_block *)tblock)->tob.maxy = 0;

      switch (diff) {

         // change only x
         case 1:
            imgman_resize_length(&source, &((texture_block *)tblock)->tob, length);
            break;

         // change only y
         case 2:
            imgman_resize_height(&source, &((texture_block *)tblock)->tob, width);
            break;

         // change x and y
         // case 3:
         default:
            imgman_resize(&source, &((texture_block *)tblock)->tob, length, width);
            break;
      }

   }

   maxx = length;
   maxy = width;

   maskx = length-1;
   masky = width-1;

   return 1;
}


/* *****************************************************************************************
   adds 1 row and column for bilinear filtering and created after mip maps
***************************************************************************************** */
int texture::post_process_texture() {

   unsigned int *adata, *pdata;
   unsigned int **ppdata;
   int i, j;

   if (!tblock || !((texture_block *)tblock)->tob.data)
      return 0;

   ((texture_block *)tblock)->tob.maxx++;
   ((texture_block *)tblock)->tob.maxy++;

   ppdata = ((texture_block *)tblock)->tob.pdata;
   ((texture_block *)tblock)->tob.pdata = new puint[((texture_block *)tblock)->tob.maxy];

   adata  = ((texture_block *)tblock)->tob.alloc_data;
   pdata  = ((texture_block *)tblock)->tob.data;
   ((texture_block *)tblock)->tob.alloc_data = new unsigned int[((texture_block *)tblock)->tob.maxx*((texture_block *)tblock)->tob.maxy+32];
   ((texture_block *)tblock)->tob.data = (unsigned int *)(((unsigned int)((texture_block *)tblock)->tob.alloc_data) + (((unsigned int)pdata) - ((unsigned int)adata)));

   for (i=j=0; i<(int)((texture_block *)tblock)->tob.maxy; i++, j += ((texture_block *)tblock)->tob.maxx)
      ((texture_block *)tblock)->tob.pdata[i] = &((texture_block *)tblock)->tob.data[j];

   // copy old texture and update right column
   for (i=0, j=((texture_block *)tblock)->tob.maxx-1; i<(int)((texture_block *)tblock)->tob.maxy-1; i++) {
      memcpy(((texture_block *)tblock)->tob.pdata[i], ppdata[i], j<<2);
      ((texture_block *)tblock)->tob.pdata[i][j] = ((texture_block *)tblock)->tob.pdata[i][0];
   }

   // bottom row
   memcpy(((texture_block *)tblock)->tob.pdata[((texture_block *)tblock)->tob.maxy-1], ppdata[0], (((texture_block *)tblock)->tob.maxx-1)<<2);

   // lower right corner
   ((texture_block *)tblock)->tob.pdata[((texture_block *)tblock)->tob.maxy-1][((texture_block *)tblock)->tob.maxx-1] = ((texture_block *)tblock)->tob.pdata[0][0];

   // garbage collection
   delete [] adata;
   delete [] ppdata;

   return 1;
}


/* *****************************************************************************************
   perform 3x3 cone filters for each successive mip map
   assumes texture is repeating (wraps)
***************************************************************************************** */
void texture::build_mipmaps(dbl_llist_manager *image_handler, int flip) {

   int temp2;
   int h, i;
   int compress;

   if (!tblock)
      return;
      
   i = (((texture_block *)tblock)->tob.maxx < ((texture_block *)tblock)->tob.maxy) ? ((texture_block *)tblock)->tob.maxx : ((texture_block *)tblock)->tob.maxy;

   for (((texture_block *)tblock)->mipmapcount=0, temp2=1; temp2<i; temp2+=temp2, ((texture_block *)tblock)->mipmapcount++);

   if (((texture_block *)tblock)->mipmap) {
      ((texture_block *)tblock)->mipmap[0].init();
      delete [] ((texture_block *)tblock)->mipmap;
      ((texture_block *)tblock)->mipmap = NULL;
   }

   if (!((texture_block *)tblock)->mipmapcount)
      return;

   ((texture_block *)tblock)->mipmapcount++;
   ((texture_block *)tblock)->mipmap = new mipmaptype[((texture_block *)tblock)->mipmapcount];

   ((texture_block *)tblock)->mipmap[0].tob = &((texture_block *)tblock)->tob;
   ((texture_block *)tblock)->mipmap[0].compression = 1.0f;
   compress = 1;
   ((texture_block *)tblock)->mipmap[0].idiff = 1.0f;

   ((texture_block *)tblock)->mipmap[0].compress_length = new int[((texture_block *)tblock)->tob.maxx];
   for (i=0; i<(int)((texture_block *)tblock)->tob.maxx; i++)
      ((texture_block *)tblock)->mipmap[0].compress_length[i] = i;

   ((texture_block *)tblock)->mipmap[0].compress_width = new int[((texture_block *)tblock)->tob.maxy];
   for (i=0; i<(int)((texture_block *)tblock)->tob.maxy; i++)
      ((texture_block *)tblock)->mipmap[0].compress_width[i] = i;

   for (h=0, temp2=1; temp2<((texture_block *)tblock)->mipmapcount; h++, temp2++) {

      ((texture_block *)tblock)->mipmap[temp2].tob = new mapul;

      ((texture_block *)tblock)->mipmap[temp2].idiff = 1.0f/compress;
      compress += compress;
      ((texture_block *)tblock)->mipmap[temp2].compression = (float)compress;

      ((texture_block *)tblock)->mipmap[temp2].compress_length = new int[((texture_block *)tblock)->tob.maxx];
      for (i=0; i<(int)((texture_block *)tblock)->tob.maxx; i++)
         ((texture_block *)tblock)->mipmap[temp2].compress_length[i] = i/compress;

      ((texture_block *)tblock)->mipmap[temp2].compress_width = new int[((texture_block *)tblock)->tob.maxy];
      for (i=0; i<(int)((texture_block *)tblock)->tob.maxy; i++)
         ((texture_block *)tblock)->mipmap[temp2].compress_width[i] = i/compress;

      imgman_build_mipmap(((texture_block *)tblock)->mipmap[h].tob, ((texture_block *)tblock)->mipmap[temp2].tob, IMGMAN_TEXTURE_REPEAT, ((frame_manager *)global_resource_manager)->query_color_byte_order());
   }

   post_process_texture();
}


/* *****************************************************************************************
***************************************************************************************** */
int texture::read_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip) {

   if (tblock) {
      delete tblock;
      tblock = NULL;
   }
   
   dataname.stringcpy(&sinfile->filename);
   statusflag = STATUSFLAG_VOID;
   
   tblock = new texture_block;
      
   if (!loader->scan_data(&((texture_block *)tblock)->tob, flip)) {
      delete tblock;
      tblock = NULL;
      return 0;
   }

   global_resource_manager->register_resource_object(RESOURCE_TEXTURE, this);

   oldx = maxx = ((texture_block *)tblock)->tob.maxx;
   oldy = maxy = ((texture_block *)tblock)->tob.maxy;
   statusflag |= STATUSFLAG_LOADED | STATUSFLAG_LOADABLE;
   ((frame_manager *)global_resource_manager)->postprocessCBtexture(this);
   return 1;
}


/* *****************************************************************************************
***************************************************************************************** */
int texture::skim_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip) {

   if (tblock) {
      delete tblock;
      tblock = NULL;
   }
   
   dataname.stringcpy(&sinfile->filename);
   statusflag = STATUSFLAG_VOID;
         
   if (!loader->skim_data(&maxx, &maxy, flip))
      return 0;

   global_resource_manager->register_resource_object(RESOURCE_TEXTURE, this);

   oldx = maxx;
   oldy = maxy;
   statusflag |= STATUSFLAG_LOADABLE;
   return 1;
}


/* *****************************************************************************************
***************************************************************************************** */
unsigned int texture::query_texel(float x, float y, float *color, int frame, float d) {

   unsigned char *p, *q;
   unsigned int temp;
   int i, j, k;
   float dx;
   int length, width;
   mipmaptype *map1, *map2;

   if (!tblock) {
      color[0] = color[1] = color[2] = 0;
      return 0;
   }
   
   // no antialiasing
   if (!((texture_block *)tblock)->mipmap) {
      i = (int)y;
      j = (int)x;

      p = ((unsigned char *)(((texture_block *)tblock)->tob.pdata[i]+j));
      color[0] = CONVERT_0_255_0_1(p[3]);
      color[1] = CONVERT_0_255_0_1(p[2]);
      color[2] = CONVERT_0_255_0_1(p[1]);

      return *(unsigned int *)p;
   }

   // bilinear filtered texture
   if (d <= 1.0 + CORRECT)
      return query_bifilter_texel(x, y, color);

   i = (int)y;
   j = (int)x;

   // last mip map
   if (d > ((texture_block *)tblock)->mipmap[((texture_block *)tblock)->mipmapcount-1].compression-CORRECT) {
      map1 = &((texture_block *)tblock)->mipmap[((texture_block *)tblock)->mipmapcount-1];

      length = map1->compress_length[j];
      width  = map1->compress_width[i];

      p = (unsigned char *)(map1->tob->pdata[width]+length);

      color[0] = CONVERT_0_255_0_1(p[3]);
      color[1] = CONVERT_0_255_0_1(p[2]);
      color[2] = CONVERT_0_255_0_1(p[1]);

      return *(unsigned int *)p;
   }

   // mipmap
   for (k=0; k<((texture_block *)tblock)->mipmapcount-2 && d>((texture_block *)tblock)->mipmap[k+1].compression; k++);

   map1 = &((texture_block *)tblock)->mipmap[k];
   map2 = &((texture_block *)tblock)->mipmap[k+1];

   length = map1->compress_length[j];
   width  = map1->compress_width[i];
   temp = *(map1->tob->pdata[width] + length);
   p = (unsigned char *)&temp;

   length = map2->compress_length[j];
   width  = map2->compress_width[i];
   q = (unsigned char *)(map2->tob->pdata[width]+length);

   dx = (d - map1->compression)*map2->idiff;

   p[1] = (unsigned char)(p[1] + (q[1] - p[1])*dx);
   p[2] = (unsigned char)(p[2] + (q[2] - p[2])*dx);
   p[3] = (unsigned char)(p[3] + (q[3] - p[3])*dx);

   color[0] = CONVERT_0_255_0_1(p[3]);
   color[1] = CONVERT_0_255_0_1(p[2]);
   color[2] = CONVERT_0_255_0_1(p[1]);

   return temp;
}


/* *****************************************************************************************
***************************************************************************************** */
unsigned int texture::query_bifilter_texel(float x, float y, float *color) {

   unsigned char *p, *q, *r, *s;
   unsigned int temp, temp2;
   int i, j, k, l;
   float dx, dy;

   if (!tblock) {
      color[0] = color[1] = color[2] = 0;
      return 0;
   }
   
   i = (int)y;
   j = (int)x;

   dy = y - i;
   dx = x - j;

   k = i+1;
   l = j+1;

   p = (unsigned char *)&temp;

   r = (unsigned char *)(((texture_block *)tblock)->tob.pdata[i]+j);
   s = (unsigned char *)(((texture_block *)tblock)->tob.pdata[k]+j);
   p[1] = (unsigned char)(r[1] + (s[1] - r[1])*dy);
   p[2] = (unsigned char)(r[2] + (s[2] - r[2])*dy);
   p[3] = (unsigned char)(r[3] + (s[3] - r[3])*dy);

   q = (unsigned char *)&temp2;

   r = (unsigned char *)(((texture_block *)tblock)->tob.pdata[i]+l);
   s = (unsigned char *)(((texture_block *)tblock)->tob.pdata[k]+l);
   q[1] = (unsigned char)(r[1] + (s[1] - r[1])*dy);
   q[2] = (unsigned char)(r[2] + (s[2] - r[2])*dy);
   q[3] = (unsigned char)(r[3] + (s[3] - r[3])*dy);

   p[1] = (unsigned char)(p[1] + (q[1] - p[1])*dx);
   p[2] = (unsigned char)(p[2] + (q[2] - p[2])*dx);
   p[3] = (unsigned char)(p[3] + (q[3] - p[3])*dx);

   color[0] = CONVERT_0_255_0_1(p[3]);
   color[1] = CONVERT_0_255_0_1(p[2]);
   color[2] = CONVERT_0_255_0_1(p[1]);

   return temp;
}


/* *****************************************************************************************
***************************************************************************************** */
int texture::query_data(int type, void *key, void *response) {

   switch (type) {

      case TEXTURE2D_QUERY_TEXTURE:
      case TEXTURE2D_QUERY_UNIT_TEXTURE:
         *(texbase **)response = this;
         return 1;

      default:
         break;
   }

   return texbase::query_data(type, key, response);
}

