

#include <string.h>

#include "texture.h"
#include "global.h"
#include "imgman.h"


/* *****************************************************************
***************************************************************** */
void texture256::update(float current_time) {

   if (!(statusflag & STATUSFLAG_LOADABLE) || !(statusflag & STATUSFLAG_LOADED))
      return;

   if (!(statusflag & STATUSFLAG_TIME_UPDATE)) {
      delete tblock;
      tblock = NULL;
      
      statusflag &= ~STATUSFLAG_LOADED;
      return;
   }

   global_statistic_texture_count++;
   access_time = current_time;
   statusflag &= ~STATUSFLAG_TIME_UPDATE;
}


/* *****************************************************************
***************************************************************** */
void *texture256::query_data() {

   image_coder *ptr;
   unsigned int flip;
   sfile sinfile;
   int i;
 
   if (tblock) {
      statusflag |= STATUSFLAG_TIME_UPDATE;   
      return tblock;
   }

   if (!(statusflag & STATUSFLAG_LOADABLE)||
       !sinfile.scan_data(dataname.string, TEXTURE_PATH.string, PLATFORM_SLASH))
      return NULL;

   ptr = (image_coder *)((dbl_llist_manager *)global_resource_manager->get_resource_object(RESOURCE_IMAGE_LOADER))->head;
   if (ptr)
      ptr = (image_coder *)ptr->find_loader(&sinfile);

   if (!ptr)
      return NULL;

   flip = ((frame_manager *)global_resource_manager)->query_color_byte_order();
   tblock = new texture_block256;

   i = ptr->scan_data256(&((texture_block256 *)tblock)->tob, ((texture_block256 *)tblock)->ipalette, flip);
   ptr->dest();

   if (!i) {
      delete tblock;
      return tblock = NULL;
   }

   maxx = ((texture_block256 *)tblock)->tob.maxx;
   maxy = ((texture_block256 *)tblock)->tob.maxy;
   statusflag |= STATUSFLAG_LOADED | STATUSFLAG_TIME_UPDATE;
   ((frame_manager *)global_resource_manager)->postprocessCBtexture(this);
   return tblock;   
}


/* *****************************************************************
***************************************************************** */
void texture256::replace_data(void *subresource) {

   if (tblock)
      delete tblock;
      
   tblock = (basic_texture_block *)subresource;
}


/* *****************************************************************
   converts texture to nearest power of 2
***************************************************************** */
int texture256::pre_process_texture() {

   int length, width;
   int diff;
   mapuc source;

   if (!tblock || !((texture_block256 *)tblock)->tob.data)
      return 0;

   // get nearest power of 2 dimentions
   for (bitx=0, length=1; length < (int)((texture_block256 *)tblock)->tob.maxx; bitx++, length+=length);
   for (bity=0, width=1; width < (int)((texture_block256 *)tblock)->tob.maxy; bity++, width+=width);

   diff = (length - ((texture_block256 *)tblock)->tob.maxx) ? 1 : 0;
   diff += (width - ((texture_block256 *)tblock)->tob.maxy) ? 2 : 0;

   if (diff) {
      source.alloc_data = ((texture_block256 *)tblock)->tob.alloc_data;
      source.data = ((texture_block256 *)tblock)->tob.data;
      source.pdata = ((texture_block256 *)tblock)->tob.pdata;
      source.maxx = ((texture_block256 *)tblock)->tob.maxx;
      source.maxy = ((texture_block256 *)tblock)->tob.maxy;
      ((texture_block256 *)tblock)->tob.alloc_data = NULL;
      ((texture_block256 *)tblock)->tob.data = NULL;
      ((texture_block256 *)tblock)->tob.pdata = NULL;
      ((texture_block256 *)tblock)->tob.maxx = ((texture_block256 *)tblock)->tob.maxy = 0;

      switch (diff) {

         // change only x
         case 1:
            imgman_resize_length(&source, &((texture_block256 *)tblock)->tob, length);
            break;

         // change only y
         case 2:
            imgman_resize_height(&source, &((texture_block256 *)tblock)->tob, width);
            break;

         // change x and y
         // case 3:
         default:
            imgman_resize(&source, &((texture_block256 *)tblock)->tob, length, width);
            break;
      }

   }

   maxx = length;
   maxy = width;

   maskx = length-1;
   masky = width-1;

   return 1;
}


/* *****************************************************************
   adds 1 row and column for bilinear filtering and created after mip maps
***************************************************************** */
int texture256::post_process_texture() {

   unsigned char *adata, *pdata;
   unsigned char **ppdata;
   int i, j;

   if (!tblock || !((texture_block256 *)tblock)->tob.data)
      return 0;

   ((texture_block256 *)tblock)->tob.maxx++;
   ((texture_block256 *)tblock)->tob.maxy++;

   ppdata = ((texture_block256 *)tblock)->tob.pdata;
   ((texture_block256 *)tblock)->tob.pdata = new puchar[((texture_block256 *)tblock)->tob.maxy];

   adata = ((texture_block256 *)tblock)->tob.alloc_data;
   pdata = ((texture_block256 *)tblock)->tob.data;
   ((texture_block256 *)tblock)->tob.alloc_data = new unsigned char[((texture_block256 *)tblock)->tob.maxx*((texture_block256 *)tblock)->tob.maxy+128];
   ((texture_block256 *)tblock)->tob.data = ((texture_block256 *)tblock)->tob.alloc_data + ((unsigned int)pdata) - ((unsigned int)adata);

   for (i=j=0; i<(int)((texture_block256 *)tblock)->tob.maxy; i++, j += ((texture_block256 *)tblock)->tob.maxx)
      ((texture_block256 *)tblock)->tob.pdata[i] = &((texture_block256 *)tblock)->tob.data[j];

   // copy old texture and update right column
   for (i=0, j=((texture_block256 *)tblock)->tob.maxx-1; i<(int)((texture_block256 *)tblock)->tob.maxy-1; i++) {
      memcpy(((texture_block256 *)tblock)->tob.pdata[i], ppdata[i], j);
      ((texture_block256 *)tblock)->tob.pdata[i][j] = ((texture_block256 *)tblock)->tob.pdata[i][0];
   }

   // bottom row
   memcpy(((texture_block256 *)tblock)->tob.pdata[((texture_block256 *)tblock)->tob.maxy-1], ppdata[0], ((texture_block256 *)tblock)->tob.maxx-1);

   // lower right corner
   ((texture_block256 *)tblock)->tob.pdata[((texture_block256 *)tblock)->tob.maxy-1][((texture_block256 *)tblock)->tob.maxx-1] = ((texture_block256 *)tblock)->tob.pdata[0][0];

   // garbage collection
   delete [] adata;
   delete [] ppdata;

   return 1;
}


/* *****************************************************************
   perform 3x3 cone filters for each successive mip map
***************************************************************** */
void texture256::build_mipmaps(dbl_llist_manager *image_handler, int flip) {

   int i;
   int compress;
   int temp2;
   mapul buffer[2];
   mapul *source, *out, *temp;
   unsigned int *x;
   unsigned char *c;

   if (!tblock)
      return;

   i = (((texture_block256 *)tblock)->tob.maxx < ((texture_block256 *)tblock)->tob.maxy) ? ((texture_block256 *)tblock)->tob.maxx : ((texture_block256 *)tblock)->tob.maxy;

   for (((texture_block256 *)tblock)->mipmapcount=0, temp2=1; temp2<i; temp2+=temp2, ((texture_block256 *)tblock)->mipmapcount++);
      
   if (((texture_block256 *)tblock)->mipmap) {
      ((texture_block256 *)tblock)->mipmap[0].init();
      delete [] ((texture_block256 *)tblock)->mipmap;
      ((texture_block256 *)tblock)->mipmap = NULL;
   }

   if (!((texture_block256 *)tblock)->mipmapcount)
      return;

   ((texture_block256 *)tblock)->mipmapcount++;
   ((texture_block256 *)tblock)->mipmap = new mipmaptype256[((texture_block256 *)tblock)->mipmapcount];

   ((texture_block256 *)tblock)->mipmap[0].tob = &((texture_block256 *)tblock)->tob;
   memcpy(((texture_block256 *)tblock)->mipmap[0].ipalette, ((texture_block256 *)tblock)->ipalette, 1024);
   ((texture_block256 *)tblock)->mipmap[0].compression = 1.0f;
   compress = 1;
   ((texture_block256 *)tblock)->mipmap[0].idiff = 1.0f;

   ((texture_block256 *)tblock)->mipmap[0].compress_length = new int[((texture_block256 *)tblock)->tob.maxx];
   for (i=0; i<(int)((texture_block256 *)tblock)->tob.maxx; i++)
      ((texture_block256 *)tblock)->mipmap[0].compress_length[i] = i;

   ((texture_block256 *)tblock)->mipmap[0].compress_width = new int[((texture_block256 *)tblock)->tob.maxy];
   for (i=0; i<(int)((texture_block256 *)tblock)->tob.maxy; i++)
      ((texture_block256 *)tblock)->mipmap[0].compress_width[i] = i;

   source = &buffer[0];
   out = &buffer[1];

   temp2 = ((texture_block256 *)tblock)->tob.maxy*((texture_block256 *)tblock)->tob.maxx;
   source->init_map(((texture_block256 *)tblock)->tob.maxx, ((texture_block256 *)tblock)->tob.maxy);
   x = source->data;
   c = ((texture_block256 *)tblock)->tob.data;

   for (i=0; i<temp2; i++, x++, c++)
      *x = ((texture_block256 *)tblock)->ipalette[*c];

   for (temp2=1; temp2<((texture_block256 *)tblock)->mipmapcount; temp2++) {

      ((texture_block256 *)tblock)->mipmap[temp2].tob = new mapuc;

      ((texture_block256 *)tblock)->mipmap[temp2].idiff = 1.0f/compress;
      compress += compress;
      ((texture_block256 *)tblock)->mipmap[temp2].compression = (float)compress;

      ((texture_block256 *)tblock)->mipmap[temp2].compress_length = new int[((texture_block256 *)tblock)->tob.maxx];
      for (i=0; i<(int)((texture_block256 *)tblock)->tob.maxx; i++)
         ((texture_block256 *)tblock)->mipmap[temp2].compress_length[i] = i/compress;

      ((texture_block256 *)tblock)->mipmap[temp2].compress_width = new int[((texture_block256 *)tblock)->tob.maxy];
      for (i=0; i<(int)((texture_block256 *)tblock)->tob.maxy; i++)
         ((texture_block256 *)tblock)->mipmap[temp2].compress_width[i] = i/compress;

      imgman_build_mipmap(source, out, IMGMAN_TEXTURE_REPEAT, ((frame_manager *)global_resource_manager)->query_color_byte_order());
      imgman_convert_2428(out, ((texture_block256 *)tblock)->mipmap[temp2].ipalette, ((texture_block256 *)tblock)->mipmap[temp2].tob, ((frame_manager *)global_resource_manager)->query_color_byte_order());

      temp = source;
      source = out;
      out = temp;
   }

   post_process_texture();
}


/* *****************************************************************
***************************************************************** */
int texture256::read_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip) {

   if (tblock) {
      delete tblock;
      tblock = NULL;
   }
   
   dataname.stringcpy(&sinfile->filename);
   statusflag = STATUSFLAG_VOID;
   
   tblock = new texture_block256;

   if (!loader->scan_data256(&((texture_block256 *)tblock)->tob, ((texture_block256 *)tblock)->ipalette, flip)) {
      delete tblock;
      tblock = NULL;
      return 0;
   }

   global_resource_manager->register_resource_object(RESOURCE_TEXTURE, this);

   oldx = maxx = ((texture_block256 *)tblock)->tob.maxx;
   oldy = maxy = ((texture_block256 *)tblock)->tob.maxy;
   statusflag |= STATUSFLAG_LOADED | STATUSFLAG_LOADABLE;
   ((frame_manager *)global_resource_manager)->postprocessCBtexture(this);
   return 1;
}


/* *****************************************************************
***************************************************************** */
int texture256::skim_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip) {

   if (tblock) {
      delete tblock;
      tblock = NULL;
   }
   
   dataname.stringcpy(&sinfile->filename);
   statusflag = STATUSFLAG_VOID;
     
   if (!loader->skim_data(&maxx, &maxy, flip))
      return 0;

   global_resource_manager->register_resource_object(RESOURCE_TEXTURE, this);

   oldx = maxx;
   oldy = maxy;
   statusflag |= STATUSFLAG_LOADABLE;
   return 1;
}


/* *****************************************************************
***************************************************************** */
unsigned int texture256::query_texel(float x, float y, float *color, int frame, float d) {

   unsigned char *q;
   int i, j, k;
   mipmaptype256 *map1, *map2;
   union { unsigned int temp; vector4uc p; };
   float dx;
   int length, width;
   
   if (!tblock) {
      color[0] = color[1] = color[2] = 0;
      return 0;
   }
   
   // no antialiasing
   if (!((texture_block256 *)tblock)->mipmap) {
      i = (int)y;
      j = (int)x;

      temp = ((texture_block256 *)tblock)->ipalette[*(((texture_block256 *)tblock)->tob.pdata[i]+j)];
      color[0] = CONVERT_0_255_0_1(p[3]);
      color[1] = CONVERT_0_255_0_1(p[2]);
      color[2] = CONVERT_0_255_0_1(p[1]);

      return temp;
   }

   // bilinear filtered texture
   if (d <= 1.0 + CORRECT)
      return query_bifilter_texel(x, y, color);

   i = (int)y;
   j = (int)x;

   // last mip map
   if (d > ((texture_block256 *)tblock)->mipmap[((texture_block256 *)tblock)->mipmapcount-1].compression-CORRECT) {
      map1 = &((texture_block256 *)tblock)->mipmap[((texture_block256 *)tblock)->mipmapcount-1];

      length = map1->compress_length[j];
      width  = map1->compress_width[i];

      temp = map1->ipalette[*(map1->tob->pdata[width]+length)];

      color[0] = CONVERT_0_255_0_1(p[3]);
      color[1] = CONVERT_0_255_0_1(p[2]);
      color[2] = CONVERT_0_255_0_1(p[1]);

      return temp;
   }

   // mipmap
   for (k=0; k<((texture_block256 *)tblock)->mipmapcount-2 && d>((texture_block256 *)tblock)->mipmap[k+1].compression; k++);

   map1 = &((texture_block256 *)tblock)->mipmap[k];
   map2 = &((texture_block256 *)tblock)->mipmap[k+1];

   length = map1->compress_length[j];
   width  = map1->compress_width[i];
   temp = map1->ipalette[*(map1->tob->pdata[width]+length)];

   length = map2->compress_length[j];
   width  = map2->compress_width[i];
   q = (unsigned char *)&map2->ipalette[*(map2->tob->pdata[width]+length)];

   dx = (d - map1->compression)*map2->idiff;

   p[1] = (unsigned char)(p[1] + (q[1] - p[1])*dx);
   p[2] = (unsigned char)(p[2] + (q[2] - p[2])*dx);
   p[3] = (unsigned char)(p[3] + (q[3] - p[3])*dx);

   color[0] = CONVERT_0_255_0_1(p[3]);
   color[1] = CONVERT_0_255_0_1(p[2]);
   color[2] = CONVERT_0_255_0_1(p[1]);

   return temp;
}


/* *****************************************************************
***************************************************************** */
unsigned int texture256::query_bifilter_texel(float x, float y, float *color) {

   unsigned char *p, *q, *r, *s;
   unsigned int temp, temp2;
   int i, j, k, l;
   float dx, dy;

   if (!tblock) {
      color[0] = color[1] = color[2] = 0;
      return 0;
   }

   i = (int)y;
   j = (int)x;

   dy = y - i;
   dx = x - j;

   k = i+1;
   l = j+1;

   p = (unsigned char *)&temp;

   r = (unsigned char *)&((texture_block256 *)tblock)->ipalette[*(((texture_block256 *)tblock)->tob.pdata[i]+j)];
   s = (unsigned char *)&((texture_block256 *)tblock)->ipalette[*(((texture_block256 *)tblock)->tob.pdata[k]+j)];
   p[1] = (unsigned char)(r[1] + (s[1] - r[1])*dy);
   p[2] = (unsigned char)(r[2] + (s[2] - r[2])*dy);
   p[3] = (unsigned char)(r[3] + (s[3] - r[3])*dy);

   q = (unsigned char *)&temp2;

   r = (unsigned char *)&((texture_block256 *)tblock)->ipalette[*(((texture_block256 *)tblock)->tob.pdata[i]+l)];
   s = (unsigned char *)&((texture_block256 *)tblock)->ipalette[*(((texture_block256 *)tblock)->tob.pdata[k]+l)];
   q[1] = (unsigned char)(r[1] + (s[1] - r[1])*dy);
   q[2] = (unsigned char)(r[2] + (s[2] - r[2])*dy);
   q[3] = (unsigned char)(r[3] + (s[3] - r[3])*dy);

   p[1] = (unsigned char)(p[1] + (q[1] - p[1])*dx);
   p[2] = (unsigned char)(p[2] + (q[2] - p[2])*dx);
   p[3] = (unsigned char)(p[3] + (q[3] - p[3])*dx);

   color[0] = CONVERT_0_255_0_1(p[3]);
   color[1] = CONVERT_0_255_0_1(p[2]);
   color[2] = CONVERT_0_255_0_1(p[1]);

   return temp;
}


/* *****************************************************************
***************************************************************** */
int texture256::query_data(int type, void *key, void *response) {

   switch (type) {
      case TEXTURE2D_QUERY_TEXTURE:
      case TEXTURE2D_QUERY_UNIT_TEXTURE:
         *(texbase **)response = this;
         return 1;

      default:
         break;
   }

   return texbase::query_data(type, key, response);
}

