

#include <string.h>

#include "polytype.h"
#include "global.h"
#include "pstring.h"


/* *****************************************************************
***************************************************************** */
texface::~texface() {

   if (uv)
      delete [] uv;
}


/* *****************************************************************
***************************************************************** */
texface::texface() {

   uv = NULL;
   ob = NULL;
   count = 0;
}


/* *****************************************************************
***************************************************************** */
void texface::setup(int i) {

   if (uv)
      delete [] uv;

   uv = new vector2f[i];
   count = i;
   ob = NULL;
}


/* *****************************************************************
    reminder - maxx*maxy included for polygons...
***************************************************************** */
void texface::calc_area() {

   int j;

   area = 0;

   for (j=0; j<count-1; j++)
      area += xproduct2(uv[j], uv[j+1]);

   area = (float)sqrt(0.5*fabs(area)*ob->maxx*ob->maxy);
}


/* *****************************************************************
***************************************************************** */
void texface::make_unit() {

   int j;
   float x, y;

   x = 1.0f/(ob->oldx - 1);
   y = 1.0f/(ob->oldy - 1);

   for (j=0; j<count; j++) {
      uv[j][0] *= x;
      uv[j][1] *= y;
   }

}


/* *****************************************************************
***************************************************************** */
int texface::write_coord(FILE *outfile) {

   int j;
   float x, y;

   x = (float)ob->oldx;
   y = (float)ob->oldy;

   for (j=0; j<count-1; j++)
      fprintf(outfile, "%f %f ", uv[j][0] * x, uv[j][1] * y);

   fprintf(outfile, "%s\n", ob->dataname.string);
   return 1;
}


/* *****************************************************************
***************************************************************** */
int texface::write_basis(FILE *outfile) {

   fprintf(outfile, "%f %f %f %f %f %f %s\n",
         uv[0][0], uv[0][1], uv[1][0], uv[1][1],
         uv[2][0], uv[2][1], ob->dataname.string);

   return 1;
}


/* *************************************************************
************************************************************* */
void *texpolygon::query_data() {

   file_loader *loader;

   if (!(statusflag & STATUSFLAG_LOADED)) {
      if (!(statusflag & STATUSFLAG_LOADABLE))
         return data;

      loader = (file_loader *)global_resource_manager->find_resource_object(RESOURCE_POLYGON_LOADER, dataname.string, NULL);

      if (!loader)
         return NULL;

      loader->read_data();
      loader->extract(FILETYPE_TEX, altname.string);
      loader->cleanup();
   }

   statusflag |= STATUSFLAG_TIME_UPDATE;
   return data;   
}


/* *************************************************************
asdf - future - can use accesstime to drop object based on time...
************************************************************* */
void texpolygon::update(float current_time) {

   if (!(statusflag & STATUSFLAG_LOADABLE) || !(statusflag & STATUSFLAG_LOADED))
      return;

   if (!(statusflag & STATUSFLAG_TIME_UPDATE)) {
      delete [] data;
      data = NULL;
      statusflag &= ~STATUSFLAG_LOADED;
      return;
   }

   global_statistic_uv_count++;
   access_time = current_time;
   statusflag &= ~STATUSFLAG_TIME_UPDATE;
}


/* *****************************************************************
***************************************************************** */
texpolygon::~texpolygon() {

   if (data)
      delete [] data;
}


/* *****************************************************************
***************************************************************** */
void texpolygon::setup(int i) {

   if (data)
      delete [] data;

   data = new texface[i];
   countobject = i;
}


/* *****************************************************************
   "countobject" is set externally
***************************************************************** */
void texpolygon::replace_data(void *subresource) {

   if (data)
      delete [] data;
      
   data = (texface *)subresource;
}


/* *****************************************************************
***************************************************************** */
unsigned int texpolygon::query_texel(int face, float x, float y, float *color, int frame, float d) {

   float a, b;

   a = (x - (int)x)*data[face].ob->maskx;
   if (a < 0)
      a += data[face].ob->maskx;

   b = (y - (int)y)*data[face].ob->masky;
   if (b < 0)
      b += data[face].ob->masky;

   return data[face].ob->query_texel(a, b, color, frame, d);
}


/* *****************************************************************
***************************************************************** */
void texpolygon::perim2Dmap(int face, int *corner, texbase *tob, polytype *dob) {

   int h, i, j, k;
   double delta[4][2];
   double coord[4][2];
   double perim;
   double *dist;
   face_type *flist;
   polygon_object_type *pot;
   
   pot = (polygon_object_type *)dob->query_data();
   flist = &pot->flist[face];

   if (data[face].uv)
      delete [] data[face].uv;

   data[face].setup(flist->polynum+1);
   data[face].ob = tob;

   dist = new double[data[face].count];

   j = 0;
   for (i=0, h = 1; i<3; i++, h++)
      if (corner[h] - corner[i] < 0)
         j--;
      else
         j++;

   if (j > 0) {
      coord[0][0] = 0;
      coord[0][1] = 0;
      coord[1][0] = 0;
      coord[1][1] = tob->oldy-1;
      coord[2][0] = tob->oldx-1;
      coord[2][1] = coord[1][1];
      coord[3][0] = coord[2][0];
      coord[3][1] = 0;

      delta[0][0] = 0;
      delta[0][1] = coord[1][1];
      delta[1][0] = coord[2][0];
      delta[1][1] = 0;
      delta[2][0] = 0;
      delta[2][1] = -coord[1][1];
      delta[3][0] = -coord[2][0];
      delta[3][1] = 0;
   }

   else {
      i = corner[0]; corner[0] = corner[3]; corner[3] = i;
      i = corner[1]; corner[1] = corner[2]; corner[2] = i;

      coord[3][0] = 0;
      coord[3][1] = 0;
      coord[2][0] = 0;
      coord[2][1] = tob->oldy-1;
      coord[1][0] = tob->oldx-1;
      coord[1][1] = coord[2][1];
      coord[0][0] = coord[1][0];
      coord[0][1] = 0;

      delta[3][0] = 0;
      delta[3][1] = coord[2][1];
      delta[2][0] = coord[1][0];
      delta[2][1] = 0;
      delta[1][0] = 0;
      delta[1][1] = -coord[2][1];
      delta[0][0] = -coord[1][0];
      delta[0][1] = 0;
   }

   for (j=0, k=1; j < flist->polynum; j++, k++, k = (k<flist->polynum) ? k:0)
      dist[j] = distance3(pot->vlist[flist->edgeptr[j]], pot->vlist[flist->edgeptr[k]]);

   for (i=0; i<4; i++) {
      h = (i == 3) ? 0 : (i+1);

      perim = 0;
      for (j=corner[i], k=j+1, k=(k<flist->polynum) ? k:0; j != corner[h]; j=k, k++, k = (k<flist->polynum) ? k:0)
         perim += dist[j];

      delta[i][0] /= perim;
      delta[i][1] /= perim;

      for (k=corner[i]; k!=corner[h]; k++, k= (k<flist->polynum) ? k:0) {
         copyarray2(data[face].uv[k], (float)coord[i]);
         coord[i][0] += delta[i][0] * dist[k];
         coord[i][1] += delta[i][1] * dist[k];
      }

   }

   copyarray2(data[face].uv[flist->polynum], data[face].uv[0]);

   delete [] dist;
   data[face].make_unit();
   data[face].calc_area();
}


/* *****************************************************************
***************************************************************** */
void texpolygon::affinemap(int face, vector2f *uv, texbase *tob, polytype *dob, int unitflag) {

   vector3f v1, mxu, mxv;
   float *base;
   int *sindex;
   int i;
   polygon_object_type *pot;
   face_type *flist;
   
   pot = (polygon_object_type *)dob->query_data();
   flist = &pot->flist[face];

   data[face].setup(flist->polynum+1);
   data[face].ob = tob;

   copyarray2(data[face].uv[0], uv[0]);
   copyarray2(data[face].uv[1], uv[1]);
   copyarray2(data[face].uv[2], uv[2]);

   if (flist->polynum > 3) {

      base = (float *)pot->vlist[*flist->edgeptr];
      sindex = flist->edgeptr;
 
      map_3D_2D(base, pot->vlist[sindex[1]],
                pot->vlist[sindex[2]], uv[0], uv[1], uv[2], mxu, mxv);

      for (i=3, sindex+=3; i<flist->polynum; i++, sindex++) {
         subeqarray3(v1, pot->vlist[*sindex], base);
         data[face].uv[i][0] = dotproduct3(v1, mxu) + uv[0][0];
         data[face].uv[i][1] = dotproduct3(v1, mxv) + uv[0][1];
      }

   }

   copyarray2(data[face].uv[flist->polynum], data[face].uv[0]);

   if (unitflag)
      data[face].make_unit();

   data[face].calc_area();
}


/* *****************************************************************
***************************************************************** */
void texpolygon::direct2Dmap(int face, vector2f *uv, texbase *tob, int vcount, int unitflag) {

   data[face].setup(vcount+1);
   data[face].ob = tob;
   memcpy(data[face].uv, uv, vcount<<3);
   copyarray2(data[face].uv[vcount], uv[0]);

   if (unitflag)
      data[face].make_unit();

   data[face].calc_area();
}


/* *****************************************************************
   for polygons only!
***************************************************************** */
int texpolygon::read_data(char *filename, polytype *dob) {

   FILE *infile;
   char tempstr[MAXSTRLEN];
   int corner[4];
   texbase *tmap;
   int count;
   int i, j, k;
   vector2f *uv;
   vector2f uv3[3];
   int coordflag;
   polygon_object_type *pot;
   
   pot = (polygon_object_type *)dob->query_data();
   
   if (!find_file(filename, "r", OBJECT_PATH.string, (char)PLATFORM_SLASH, NULL, &infile)) {
      sprintf(perror_buffer, "WARNING: cannot access \"%s\"...\n", filename);
      pprintf(perror_buffer);
      return 0;
   }

   setup(dob->countobject);

   fscanf(infile, "%s", tempstr);
   lower_case(tempstr);

   if (strcmp(tempstr, "mono")) {

      fscanf(infile, "%s", tempstr);
      lower_case(tempstr);

      fscanf(infile, "%d %d %d %d", &corner[0], &corner[1], &corner[2], &corner[3]);
      corner[0]--;
      corner[1]--;
      corner[2]--;
      corner[3]--;

      fscanf(infile, "%s", tempstr);               // texture name
      tmap = (texbase *)((frame_manager *)global_resource_manager)->read_tex(tempstr);

      if (tmap)
         for (j=0; j<dob->countobject; j++)
            perim2Dmap(j, corner, tmap, dob);
      else {
         sprintf(perror_buffer, "Warning: Cannot locate texture \"%s\"...\n", tempstr);
         pprintf(perror_buffer);
      }
      
   }

   fscanf(infile, "%d", &count);

   for (; count>0; count--) {
      fscanf(infile, "%d", &j);
      j--;

      fscanf(infile, "%s", tempstr);
      lower_case(tempstr);

      if (!strcmp(tempstr, "coord")) {
         coordflag = 1;
         i = pot->flist[j].polynum;
         uv = new vector2f[i];

         for (k=0; k<i; k++)
            fscanf(infile, "%f %f", &uv[k][0], &uv[k][1]);
      }

      else if (!strcmp(tempstr, "affine")) {
         coordflag = 2;

         fscanf(infile, "%f %f", &uv3[0][0], &uv3[0][1]);
         fscanf(infile, "%f %f", &uv3[1][0], &uv3[1][1]);
         fscanf(infile, "%f %f", &uv3[2][0], &uv3[2][1]);
      }

      else if (!strcmp(tempstr, "basis")) {
         coordflag = 3;

         fscanf(infile, "%f %f", &uv3[0][0], &uv3[0][1]);
         fscanf(infile, "%f %f", &uv3[1][0], &uv3[1][1]);
         fscanf(infile, "%f %f", &uv3[2][0], &uv3[2][1]);
      }

      else if (!strcmp(tempstr, "corner")) {

         coordflag = 0;
         fscanf(infile, "%d %d %d %d", &corner[0], &corner[1], &corner[2], &corner[3]);
         corner[0]--;
         corner[1]--;
         corner[2]--;
         corner[3]--;
      }

      else {
         sprintf(perror_buffer, "Warning: Invalid 2D texture method \"%s\"...\n", tempstr);
         pprintf(perror_buffer);
         break;
      }

      fscanf(infile, "%s", tempstr);               // texture name
      tmap = (texbase *)((frame_manager *)global_resource_manager)->read_tex(tempstr);

      if (tmap)
         switch (coordflag) {

            case 1:
               direct2Dmap(j, uv, tmap, pot->flist[j].polynum, 1);
               delete [] uv;
               break;

            case 2:
               affinemap(j, uv3, tmap, dob, 1);
               break;

            case 3:
               affinemap(j, uv3, tmap, dob, 0);
               break;

            default:
               perim2Dmap(j, corner, tmap, dob);
         }

      else {
         sprintf(perror_buffer, "Warning: Cannot locate texture \"%s\"...\n", tempstr);
         pprintf(perror_buffer);
      }
      
   }

   fclose(infile);

   statusflag |= STATUSFLAG_LOADABLE | STATUSFLAG_LOADED;
   return 1;
}


/* *****************************************************************
***************************************************************** */
int texpolygon::write_coord(char *filename) {

   FILE *outfile;
   int i, j;
   
   for (i=0, j=0; i<countobject; i++)
      if (data[i].ob)
         j++;

   if (!j)
      return 0;

   outfile = fopen(filename, "w");

   if (!outfile) {
      sprintf(perror_buffer, "WARNING: Cannot create \"%s\"...\n", filename);
      pprintf(perror_buffer);
      return 0;
   }

   fprintf(outfile, "mono %d\n\n", j);

   for (i=0; i<countobject; i++)
      if (data[i].ob) {
         fprintf(outfile, "%d coord ", i+1);
	 data[i].write_coord(outfile);
      }

   fclose(outfile);
   return 1;
}


/* *******************************************************************
******************************************************************* */
int texpolygon::write_basis(char *filename) {

   FILE *outfile;
   int i, j;
   
   for (i=0, j=0; i<countobject; i++)
      if (data[i].ob)
         j++;

   if (!j)
      return 0;
      
   outfile = fopen(filename, "w");
   
   if (!outfile) {
      sprintf(perror_buffer, "WARNING: Cannot create \"%s\"...\n", filename);
      pprintf(perror_buffer);
      return 0;
   }
   
   fprintf(outfile, "\nmono %d\n\n", j);

   for (i=0; i<countobject; i++)
      if (data[i].ob) {
         fprintf(outfile, "%d basis ", i+1);
	 data[i].write_basis(outfile);
      }		

   fclose(outfile);
   return 1;
}

