

#include <stdlib.h>
#include <string.h>

#include "superclass.h"
#include "global.h"
#include "pstring.h"


/* *******************************************************************
******************************************************************* */
void superclass::preprocess(void *data) {}


/* *******************************************************************
******************************************************************* */
int superclass::parse(FILE *infile, char *token) { return 0; }

/* *******************************************************************
******************************************************************* */
int superclass::query_whatwasi(int type) { return type == superclass::query_whatami(); }


/* *******************************************************************
******************************************************************* */
void frameclass::preprocess(void *data) { superclass::preprocess(data); }


/* *******************************************************************
******************************************************************* */
int frameclass::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_FRAME_STR)) {
      get_token(infile, token);
      frame = atoi(token) - 1;

      return 1;
   }

   return superclass::parse(infile, token);
}


/* *******************************************************************
******************************************************************* */
int frameclass::dump_frame(FILE *outfile) {

   fprintf(outfile, "%s %d\n", TOKEN_FRAME_STR, frame);
   return 1;
}


/* *******************************************************************
******************************************************************* */
superclass *loader::parse(FILE *infile, char *token) {

   superclass *ptr;
   
   if (strcmp(token, query_name()))
      return (next ? (superclass *)((loader *)next)->parse(infile, token) : (superclass *)NULL);

   ptr = make_object();

   do {
      if (!get_token(infile, token) || token[0] == '}')
         break;

      lower_case(token);

      if (!ptr->parse(infile, token)) {
         sprintf(perror_buffer, "Warning: Invalid data format for superclass - \"%s\".\n", token);
         pprintf(perror_buffer);
      }

   } while (1);

   return ptr;
}


/* *******************************************************************
******************************************************************* */
void doer::init() {

   if (!init_fcn)
      return;

   ((void (*)())init_fcn)();
   init_fcn = NULL;
}


/* *************************************************************************
************************************************************************* */
int doer::set(char *tmpstr, void *func_call, void *init_call) {

   string.stringcpy(tmpstr);
   fcn = func_call;
   init_fcn = init_call;

   return 1;
}


/***************************************************************************
****************************************************************************/
resource_manager::resource_manager() {

   resource_manager::local_init();
}


/***************************************************************************
****************************************************************************/
resource_manager::~resource_manager() {

   resource_manager::local_reset();       
}


/***************************************************************************
****************************************************************************/
void resource_manager::init(int x) {

   reset();
   resource_manager::local_init();
}


/* *******************************************************************
******************************************************************* */
void resource_manager::reset() {

   resource_manager::local_reset();
}


/* *******************************************************************
******************************************************************* */
void resource_manager::local_init() {

}


/* *******************************************************************
******************************************************************* */
void resource_manager::local_reset() {

   object_counter = 0;
}


/***************************************************************************
****************************************************************************/
void resource_manager::update(float current_time) {

}


/***************************************************************************
****************************************************************************/
void resource_manager::register_resource_object(int type, void *data) {

   sprintf(perror_buffer, "WARNING: Attempt to register unknown resource \"%d\"...\n", type);
   pprintf(perror_buffer);
}


/***************************************************************************
****************************************************************************/
void *resource_manager::find_resource_object(int type, char *id, char *alias) {

   sprintf(perror_buffer, "WARNING: Attempt to find unknown/invalid resource \"%d\"...\n", type);
   pprintf(perror_buffer);
   return NULL;
}


/***************************************************************************
****************************************************************************/
void *resource_manager::get_resource_object(int type) {

   sprintf(perror_buffer, "WARNING: Attempt to get unknown resource \"%d\"...\n", type);
   pprintf(perror_buffer);
   return NULL;
}


/* *************************************************************
************************************************************* */
resource_type::resource_type() {

   access_time = 0;
   statusflag = STATUSFLAG_VOID;
}




// parser tokens

char TOKEN_FRAME_STR[]          = "frame";
char TOKEN_LOCATION_STR[]       = "location";
char TOKEN_UP_STR[]             = "up";
char TOKEN_AMBIENT_STR[]        = "ambient";
char TOKEN_DIFFUSE_STR[]        = "diffuse";
char TOKEN_FATT_STR[]           = "fatt";
char TOKEN_DIRECTION_STR[]      = "direction";
char TOKEN_2D_TEXTURE_STR[]     = "2d_texture";
char TOKEN_3D_TEXTURE_STR[]     = "3d_texture";
char TOKEN_SHADE_STR[]          = "shade";
char TOKEN_DISTANCE2PLANE_STR[] = "distance2plane";
char TOKEN_LENGTH_STR[]         = "length";
char TOKEN_WIDTH_STR[]          = "width";
char TOKEN_COA_STR[]            = "coa";
char TOKEN_TYPE_STR[]           = "type";
char TOKEN_TOP_RADIUS_STR[]     = "top_radius";
char TOKEN_BOTTOM_RADIUS_STR[]  = "bottom_radius";
char TOKEN_LUMINATE_STR[]       = "luminate";
char TOKEN_RAYCAST_STR[]        = "raycast";
char TOKEN_ROTATE_X_STR[]       = "rotate_x";
char TOKEN_ROTATE_Y_STR[]       = "rotate_y";
char TOKEN_ROTATE_Z_STR[]       = "rotate_z";
char TOKEN_SCALE_STR[]          = "scale";
char TOKEN_SHADOW_STR[]         = "shadow";
char TOKEN_TR_MATRIX_STR[]      = "tr_matrix";
char TOKEN_TRANSLATE_STR[]      = "translate";
char TOKEN_TRANSPARENT_STR[]    = "transparent";
char TOKEN_RADIUS_STR[]         = "radius";
char TOKEN_AXIS_STR[]           = "axis";
char TOKEN_AXIS_X_STR[]         = "axis_x";
char TOKEN_AXIS_Y_STR[]         = "axis_y";
char TOKEN_AXIS_Z_STR[]         = "axis_z";
char TOKEN_BIPLANE_STR[]        = "biplane";
char TOKEN_FILE_STR[]           = "file";
char TOKEN_INVISO_STR[]         = "inviso";
char TOKEN_HOLLOW_STR[]         = "hollow";
char TOKEN_INNER_RADIUS_STR[]   = "inner_radius";
char TOKEN_OUTER_RADIUS_STR[]   = "outer_radius";
char TOKEN_BACK_STR[]           = "back";
char TOKEN_DITHER_STR[]         = "dither";
char TOKEN_DISPLACEMENT_STR[]   = "displacement";
char TOKEN_H_STR[]              = "h";
char TOKEN_LACUNARITY_STR[]     = "lacunarity";
char TOKEN_OCTAVES_STR[]        = "octaves";
char TOKEN_GHOST_STR[]          = "ghost";
char TOKEN_OVERWRITE_STR[]      = "overwrite";
char TOKEN_FOREGROUND_STR[]     = "foreground";
char TOKEN_MIDGROUND_STR[]      = "midground";
char TOKEN_BACKGROUND_STR[]     = "background";

char TOKEN_LIST_STR[]               = "list";                   // magic for .list files

char TOKEN_LIGHT_STR[]              = "light";
char TOKEN_POINT_STR[]              = "point";
char TOKEN_BEAM_FAR_STR[]           = "beam_far";
char TOKEN_BEAM_POINT_STR[]         = "beam_point";
char TOKEN_FAR_STR[]                = "far";
char TOKEN_SIMPLE_POINT_STR[]       = "simple_point";
char TOKEN_SIMPLE_BEAM_FAR_STR[]    = "simple_beam_far";
char TOKEN_SIMPLE_BEAM_POINT_STR[]  = "simple_beam_point";
char TOKEN_SIMPLE_FAR_STR[]         = "simple_far";

char TOKEN_CAMERA_STR[]             = "camera";

char TOKEN_GEOCONE_STR[]            = "geocone";
char TOKEN_GEOCYLINDER_STR[]        = "geocylinder";
char TOKEN_GEOSPHERE_STR[]          = "geosphere";
char TOKEN_LINE_STR[]               = "line";
char TOKEN_PARTICLE_STR[]           = "particle";
char TOKEN_POLYGON_STR[]            = "polygon";
char TOKEN_RADIANT_STR[]            = "radiant";
char TOKEN_SBFAST_STR[]             = "sbfast";
char TOKEN_SPATCH_STR[]             = "spatch";
                                                                // anitroll specific
char TOKEN_ORIGIN_STR[]             = "origin";
char TOKEN_BOUND_STR[]              = "bound";
char TOKEN_CHILDREN_STR[]           = "children";
char TOKEN_NAME_STR[]               = "name";
char TOKEN_PIVOT_STR[]              = "pivot";
char TOKEN_ROTATE_LOCAL_X_STR[]     = "rotate_local_x";
char TOKEN_ROTATE_LOCAL_Y_STR[]     = "rotate_local_y";
char TOKEN_ROTATE_LOCAL_Z_STR[]     = "rotate_local_z";
char TOKEN_TR_LOCAL_MATRIX_STR[]    = "tr_local_matrix";
char TOKEN_TRANSLATE_LOCAL_STR[]    = "translate_local";
char TOKEN_DEATH_STR[]              = "death";
char TOKEN_DECAY_STR[]              = "decay";
char TOKEN_INTENSITY_STR[]          = "intensity";
char TOKEN_END_POINT_STR[]          = "end_point";
char TOKEN_ORIENTATION_MX_STR[]     = "orientation_mx";
char TOKEN_LOCK_STR[]               = "lock";
char TOKEN_UNLOCK_STR[]             = "unlock";
char TOKEN_OFFSET_STR[]             = "offset";
char TOKEN_BOID_RANGE_STR[]         = "boid_range";
char TOKEN_COLLISION_LOSS_STR[]     = "collision_loss";
char TOKEN_FRICTION_PER_SEC_STR[]   = "friction_per_sec";
char TOKEN_GRAVITY_STR[]            = "gravity";
char TOKEN_LEADER_RANGE_STR[]       = "leader_range";
char TOKEN_MAX_TURN_RADIUS_STR[]    = "max_turn_radius";
char TOKEN_MAX_ACCELERATION_STR[]   = "max_acceleration";
char TOKEN_RED_ALERT_STR[]          = "red_alert";
char TOKEN_VELOCITY_STR[]           = "velocity";
char TOKEN_VELOCITY_RANGE_STR[]     = "velocity_range";
char TOKEN_YELLOW_ALERT_STR[]       = "yellow_alert";
char TOKEN_NULL_STR[]               = "null";

char TOKEN_ATOM_STR[]               = "atom";
char TOKEN_QUARK_STR[]              = "quark";
char TOKEN_FLIGHT_STR[]             = "flight";
char TOKEN_BOID_STR[]               = "boid";
char TOKEN_BOIDBAIT_STR[]           = "boidbait";
char TOKEN_NEUTRON_STR[]            = "neutron";
char TOKEN_ELECTRON_STR[]           = "electron";
char TOKEN_PHOTON_STR[]             = "photon";
char TOKEN_TACHYON_STR[]            = "tachyon";
char TOKEN_SHELL_STR[]              = "shell";
char TOKEN_ION_STR[]                = "ion";
char TOKEN_HELIX_STR[]              = "helix";
char TOKEN_TUBE_STR[]               = "tube";
char TOKEN_FUNNEL_STR[]             = "funnel";
char TOKEN_CHAIN_STR[]              = "chain";
char TOKEN_BUCKEY_STR[]             = "buckey";

resource_manager *global_resource_manager = NULL;

