

#include <stdlib.h>
#include <string.h>

#include "sphere.h"
#include "pstring.h"


#define U 10
#define DU 0.1f
#define V 16
#define DV 0.0625f
                                // (U+1-2) * V + 2
#define COUNTVERTEX   146
                                // U * V
#define COUNTOBJECT   160
                                // 4 * U * V
#define COUNTEDGE     640


/* *************************************************************
************************************************************* */
int sphere::query_whatwasi(int type) {

   return (sphere::query_whatami() == type) ? 1 : pc::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
int sphere::parse(FILE *infile, char *token) {

   switch (token[0]) {

      case 'a':
         if (!strcmp(token, TOKEN_AXIS_STR)) {
            get_token(infile, token);
            master_wscale[0] = (float)atof(token);
            get_token(infile, token);
            master_wscale[1] = (float)atof(token);
            get_token(infile, token);
            master_wscale[2] = (float)atof(token);

            return 1;
         }

         if (strlen(token) < 6)
            break;

         switch (token[5]) {

            case 'x':
               if (!strcmp(token, TOKEN_AXIS_X_STR)) {
                  get_token(infile, token);
                  master_wscale[0] = (float)atof(token);

                  return 1;
               }

               break;

            case 'y':
               if (!strcmp(token, TOKEN_AXIS_Y_STR)) {
                  get_token(infile, token);
                  master_wscale[1] = (float)atof(token);

                  return 1;
               }

               break;

            case 'z':
               if (!strcmp(token, TOKEN_AXIS_Z_STR)) {
                  get_token(infile, token);
                  master_wscale[2] = (float)atof(token);

                  return 1;
               }

               break;

            default:
               break;
         }

         break;

      case 'r':
         if (!strcmp(token, TOKEN_RADIUS_STR)) {
            get_token(infile, token);
            master_wscale[0] = master_wscale[1] = master_wscale[2] = (float)atof(token);

            return 1;
         }

         break;

      default:
         break;
   }

   return geo::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void sphere::preprocess(void *data) {

   geo::preprocess(data);

   smultarray3(master_wscale, size);

   rotate[0][3] += center[0];
   rotate[1][3] += center[1];
   rotate[2][3] += center[2];
}


/* *************************************************************
************************************************************* */
void sphere::bound_sphere() {

   float mag, temp;
   vector4f r[4];

   bcenter[0] = rotate[0][3];
   bcenter[1] = rotate[1][3];
   bcenter[2] = rotate[2][3];

   transpose(r, rotate);

   mag = dotproduct3(r[0], r[0]);

   temp = dotproduct3(r[1], r[1]);
   if (temp > mag)
      mag = temp;

   temp = dotproduct3(r[2], r[2]);
   if (temp > mag)
      mag = temp;

   bradius = (float)sqrt(mag * dotproduct3(master_wscale, master_wscale));

   bvalid_flag = 1;
}


/* *************************************************************
************************************************************* */
void sphere::datacopy() {

   mctype.datacopy();
   mcinfo.datacopy();

   if (lob)
      base_color = &lob->base;

   copyarray3(wscale, master_wscale);

   pob = NULL;
   plob = NULL;
}


/* *************************************************************
************************************************************* */
float sphere::calc_area() {

   float r = (float)(sphere_area(wscale[0]+wscale[1]+wscale[2])*0.33333333);
   return sphere_area(r);
}


/* *************************************************************
************************************************************* */
void sphere::pg(eye *parm, light *lmain, light *spot, zbuffer *zbuff) {

   int  i, j;
   vector4f surface, pzero, zero;
   float temp[2];
   vector4f normal;
   vector4f pt;
   float t;
   int   flag;
   vector3f rcolor, acolor, tcolor;
   int  flag2t = (mcinfo.info & CITEXTURE) == CITEXTURE;
   int  flag3t = (mcinfo.info & CI3DTEX) == CI3DTEX;
   int  flagtr = (mcinfo.info & CITRANSPARENT) == CITRANSPARENT;
   int  ghostflag = (mcinfo.info & CIGHOST) == CIGHOST;
   int  overwriteflag = (mcinfo.info & CIOVERWRITE) == CIOVERWRITE;
   int  inflag;
   int  index, scanxy;
   flt2int_type a0, a1, a2, d0, d1, d2;

   texcolortype texcolor;
   shaderparamtype sparam;
   color_calc_data colordata;
   void *shade_fcn;

   float piinverse = (float)(1.0/PI);
   float tx, ty;
   float di, dj, wi, wj, wt;
   float area;

   vector3f iwscale;
   vector4f mx[4], imx[4];

   colordata.ob = this;
   colordata.surface = surface;
   colordata.normal = normal;
   colordata.spot = (flagtr ? (light *)NULL : spot);
   colordata.parm = parm;
   colordata.texcolor = &texcolor;
   colordata.tcolor = tcolor;
   colordata.sparam = &sparam;
   colordata.i = 0;
   colordata.rcolor = rcolor;
   colordata.acolor = acolor;
   colordata.lmain = lmain;

   if (flag3t)
      shade_fcn = (void *)calc_color3;
   else if (flag2t)
      shade_fcn = (void *)calc_color2;
   else
      shade_fcn = (void *)calc_color;

   init_mx(mx);
   mx[0][0] = wscale[0];
   mx[1][1] = wscale[1];
   mx[2][2] = wscale[2];

   matmatmulto(world, mx);
   inversemx(mx, imx);

   iwscale[0] = (float)(1.0/wscale[0]);
   iwscale[1] = (float)(1.0/wscale[1]);
   iwscale[2] = (float)(1.0/wscale[2]);

   normal[3] = 0;

   if (flag3t) {
      t = iwscale[0];

      if (iwscale[1] > t)
         t = iwscale[1];
      if (wscale[2] > t)
         t = iwscale[2];

      sparam.setup(world, iworld, frame, parm, this, shaderlist->scale*t);
   }

   else if (flag2t) {
      area = parm->query_scale();
      area = (float)sqrt((tob->maxx*tob->maxy)/(calc_area()*area*area));
   }

   texcolor.set(base_color);

   if (lmain)
      lmain->set_ambient(texcolor.color.ka, texcolor.ambient, texcolor.color.lum);
   else
      copyarray3(texcolor.ambient, (float)texcolor.color.lum);

   pzero[0] = imx[0][3];
   pzero[1] = imx[1][3];
   pzero[2] = imx[2][3];
   pzero[3] = 1;
   
   zero[0] = zero[1] = zero[2] = 0;
   zero[3] = 1;

   surface[0] = (float)col[0];
   surface[1] = (float)row[0];
   surface[2] = -1;
   surface[3] = 1;
   parm->screen2map(surface);

   di = dj = (float)(1.0/parm->query_scale());

   wt = surface[0];
   wi = surface[1];

   scanxy = row[0] * zbuff->maxx;
   for (i=row[0]; i<=row[1]; i++, wi+=di, scanxy += zbuff->maxx) {

      for (j=col[0], index = col[0] + scanxy, wj=wt, inflag = 0; j<=col[1]; j++, wj+=dj, index++) {

         surface[0] = wj;
         surface[1] = wi;
         surface[2] = -1;

         matvecmultv(imx, surface, pt);

         flag = line_sphere_intersect(1.0, zero, pzero, pt, &t);

         if (!flag) {
            if (inflag)
               break;

            continue;
         }

         inflag = 1;

         if (overwriteflag || -t>zbuff->zdata[index]) {
            surface[0] *= t;
            surface[1] *= t;
            surface[2] = -t;

            normal[0] = pzero[0] + t*pt[0] - zero[0];
            normal[1] = pzero[1] + t*pt[1] - zero[1];
            normal[2] = pzero[2] + t*pt[2] - zero[2];

            if (flag2t) {
               ty = ACOS(-normal[1])*piinverse;

               temp[0] = normal[0];
               temp[1] = normal[2];
               normalize2(temp);

               tx = (float)(0.5 * ((temp[0] >= 0.0) ? (ACOS(temp[1])*piinverse) : (2-ACOS(temp[1])*piinverse)));

               query_texel(tx, ty, tcolor, area*(-surface[2]));

               if (lmain)
                  lmain->set_ambient(texcolor.color.ka, texcolor.ambient, texcolor.color.lum);
            }

            if (flag < 0) {
               normal[0] = -normal[0];
               normal[1] = -normal[1];
               normal[2] = -normal[2];
            }

            matvecmultv(world, normal);

            ((void (*)(color_calc_data *))shade_fcn)(&colordata);

            if (flagtr) {
               set_datatr(zbuff, index, acolor, rcolor, a0, a1, a2, d0, d1, d2);
            }

            else if (ghostflag) {
               set_nzbuff(zbuff, index, acolor, rcolor, a0, a1, a2, d0, d1, d2);
            }

            else {
               set_zdata(zbuff, index, surface[2], acolor, rcolor, a0, a1, a2, d0, d1, d2);
            }

         }

      }

   }

}


/* *************************************************************
************************************************************* */
void sphere::lt(spotlight *spot) {

   int i, j;
   vector4f surface, pzero, zero;
   float t;
   int   flag;
   float di, dj, wi, wj, wt;
   int  inflag;
   vector4f mx[4], imx[4];

   zero[0] = zero[1] = zero[2] = 0;
   zero[3] = 1;

   init_mx(mx);
   mx[0][0] = wscale[0];
   mx[1][1] = wscale[1];
   mx[2][2] = wscale[2];

   matmatmulto(world, mx);
   inversemx(mx, imx);

   surface[0] = (float)col[0];
   surface[1] = (float)row[0];
   surface[2] = -1;
   surface[3] = 1;
   copyarray3(pzero, surface);

   spot->screen2map(surface);

   pzero[0] += 1;
   pzero[1] += 1;
   pzero[3] = 0;
   spot->screen2map(pzero);

   dj = pzero[0] - surface[0];
   di = pzero[1] - surface[1];
   wt = surface[0];
   wi = surface[1];

   if (spot->query_whatami() == OBJECT_POINT) {
      pzero[0] = imx[0][3];
      pzero[1] = imx[1][3];
      pzero[2] = imx[2][3];
      pzero[3]   = 1;

      surface[3] = 0;
   }

   else {
      pzero[0] = -imx[0][2];
      pzero[1] = -imx[1][2];
      pzero[2] = -imx[2][2];
      pzero[3]   = 0;

      surface[3] = 1;
   }

   for (i=row[0]; i<=row[1]; i++, wi+=di)
      for (j=col[0], wj=wt, inflag = 0; j<=col[1]; j++, wj+=dj) {

         surface[0] = wj;
         surface[1] = wi;

         if (spot->query_whatami() == OBJECT_POINT) {
            surface[2] = -1;
            matvecmultv(imx, surface);
            flag = line_sphere_intersect(1.0, zero, pzero, surface, &t);
         }

         else {
            surface[2] = 0;
            matvecmulto(imx, surface);
            flag = line_sphere_intersect(1.0, zero, surface, pzero, &t);
         }

         if (!flag) {
            if (inflag)
               break;
         }

         else {
            inflag = 1;

            if (-t>spot->lbuff->lbuff.pdata[i][j].zdata) {
               spot->lbuff->lbuff.pdata[i][j].zdata = -t;
               spot->lbuff->lbuff.pdata[i][j].idbuff = id;
            }

         }

      }

}


/* *************************************************************
************************************************************* */
void sphere::transform(eye *parm) {

   int i, j;
   vector4f box[8];

   matmatmulto(parm->transform, rotate, world);
   world[3][0] = world[3][1] = world[3][2] = 0;
   world[3][3] = 1;
   
   wcenter[0] = world[0][3];
   wcenter[1] = world[1][3];
   wcenter[2] = world[2][3];
   wcenter[3] = 1;

   transpose(world);

   wscale[0] *= normalize3(world[0]);
   wscale[1] *= normalize3(world[1]);
   wscale[2] *= normalize3(world[2]);

   transpose(world);

   inversemx(world, iworld);

   bbox[0][0] = -wscale[0];
   bbox[0][1] = -wscale[1];
   bbox[0][2] = -wscale[2];
   bbox[0][3] = 1;

   bbox[1][0] = wscale[0];
   bbox[1][1] = wscale[1];
   bbox[1][2] = wscale[2];
   bbox[1][3] = 1;

   make_box(bbox, box);

   matvecmulto(world, box[0], bbox[0]);
   copyarray3(bbox[1], bbox[0]);

   for (i=1; i<8; i++) {
      matvecmulto(world, box[i]);

      for (j=0; j<3; j++)
         if (box[i][j] < bbox[0][j])
            bbox[0][j] = box[i][j];
         else if (box[i][j] > bbox[1][j])
            bbox[1][j] = box[i][j];
   }

}


/* *************************************************************
************************************************************* */
void sphere::geo2poly(texpolygon **ptob, shaderlisttype *slist) {

   unsigned int i, j, k, l;
   float fi, fdi, fj, fdj;
   float r;
   float tx, ty;
   vector4f mx[4], imx[4];
   vector2f uv[4];
   int      textureflag = (mcinfo.info & CITEXTURE) && ptob;
   polygon_object_type *pot;
   shade_block *sblock;
   
   pob = new polytype;
   pob->build(COUNTVERTEX, COUNTOBJECT, COUNTEDGE);
   pob->maxpolynum = 4;

   pot = (polygon_object_type *)pob->query_data();

   if (ptob) {
      if (textureflag) {
         *ptob = new texpolygon;
         (*ptob)->setup(COUNTOBJECT);
      }

      if (mctype.model > BW)
         plob = new shadelist(COUNTOBJECT);
   
      if (mcinfo.info & CI3DTEX) {
         slist->scount = COUNTOBJECT;
         slist->shade = new shadertype[COUNTOBJECT];
      }

   }
   
   init_mx(mx);
   mx[0][0] = wscale[0];
   mx[1][1] = wscale[1];
   mx[2][2] = wscale[2];

   matmatmulto(world, mx);
   inversemx(mx, imx);

   // optimization - do only 1/8 of below then calc the symetrical parts

   for (k=i=0, fdi = DU+DU, fi = -1 + fdi; i < U-1; i++, fi += fdi) {
      r = (float)(1.0 - fi*fi);

      r = (float)((r > CORRECT) ? sqrt(r) : 0);

      for (j=0, fj=-HALFPI, fdj = ((float)TWOPI*DV); j < V; j++, fj += fdj, k++) {
         pot->vlist[k][0] = COS(fj)*r;
         pot->vlist[k][1] = fi;
         pot->vlist[k][2] = -SIN(fj)*r;
         pot->vlist[k][3] = 1;

         matvecmultv(world, pot->vlist[k], pot->nlist[k]);
         matvecmulto(mx, pot->vlist[k]);
      }

   }

   pot->vlist[k][0] = 0;
   pot->vlist[k][1] = 1;
   pot->vlist[k][2] = 0;
   pot->vlist[k][3] = 1;
   matvecmultv(world, pot->vlist[k], pot->nlist[k]);
   matvecmulto(mx, pot->vlist[k]);

   k++;

   pot->vlist[k][0] = 0;
   pot->vlist[k][1] = -1;
   pot->vlist[k][2] = 0;
   pot->vlist[k][3] = 1;
   matvecmultv(world, pot->vlist[k], pot->nlist[k]);
   matvecmulto(mx, pot->vlist[k]);

   for (i=k=l=0, ty=fdi=DU*texcoord[2][1]; i < U-2; i++, ty+=fdi, k++) {
      for (j=0, tx=0, fdj=DV*texcoord[2][0]; j < V-1; j++, k++, tx+=fdj) {

         pot->flist[k].polynum = 4;
         pot->flist[k].edgeptr = &pot->vindex[l];

         pot->vindex[l] = k;
         l++;
         pot->vindex[l] = k+V;
         l++;
         pot->vindex[l] = k+V+1;
         l++;
         pot->vindex[l] = k+1;
         l++;

         if (textureflag) {
            uv[0][0] = tx;
            uv[0][1] = ty;
            uv[1][0] = tx;
            uv[1][1] = ty+fdi;
            uv[2][0] = tx+fdj;
            uv[2][1] = ty+fdi;
            uv[3][0] = tx+fdj;
            uv[3][1] = ty;
            (*ptob)->direct2Dmap(k, uv, tob, 4, 1);
         }

      }

      pot->flist[k].polynum = 4;
      pot->flist[k].edgeptr = &pot->vindex[l];

      pot->vindex[l] = k;
      l++;
      pot->vindex[l] = k+V;
      l++;
      pot->vindex[l] = k+1;
      l++;
      pot->vindex[l] = k+1-V;
      l++;

      if (textureflag) {
         uv[0][0] = tx;
         uv[0][1] = ty;
         uv[1][0] = tx;
         uv[1][1] = ty+fdi;
         uv[2][0] = texcoord[2][0];
         uv[2][1] = ty+fdi;
         uv[3][0] = texcoord[2][0];
         uv[3][1] = ty;
         (*ptob)->direct2Dmap(k, uv, tob, 4, 1);
      }

   }
                                // top patches
   for (j=0, tx=0, fdj=DV*texcoord[2][0], ty=texcoord[2][1]-fdi; j < V-1; j++, k++, tx+=fdj) {

      pot->flist[k].polynum = 4;
      pot->flist[k].edgeptr = &pot->vindex[l];

      pot->vindex[l] = k+1;
      l++;
      pot->vindex[l] = k;
      l++;
      pot->vindex[l] = COUNTVERTEX-2;
      l++;
      pot->vindex[l] = COUNTVERTEX-2;
      l++;

      if (textureflag) {
         uv[0][0] = tx+fdj;
         uv[0][1] = ty;
         uv[1][0] = tx;
         uv[1][1] = ty;
         uv[2][0] = tx;
         uv[2][1] = texcoord[2][1];
         uv[3][0] = tx+fdj;
         uv[3][1] = texcoord[2][1];
         (*ptob)->direct2Dmap(k, uv, tob, 4, 1);
      }

   }

   pot->flist[k].polynum = 4;
   pot->flist[k].edgeptr = &pot->vindex[l];

   pot->vindex[l] = k+1-V;
   l++;
   pot->vindex[l] = k;
   l++;
   pot->vindex[l] = COUNTVERTEX-2;
   l++;
   pot->vindex[l] = COUNTVERTEX-2;
   l++;

   if (textureflag) {
      uv[0][0] = texcoord[2][0];
      uv[0][1] = ty;
      uv[1][0] = tx;
      uv[1][1] = ty;
      uv[2][0] = tx;
      uv[2][1] = texcoord[2][1];
      uv[3][0] = texcoord[2][0];
      uv[3][1] = texcoord[2][1];
      (*ptob)->direct2Dmap(k, uv, tob, 4, 1);
   }

   k++;
                                        // bottom
   for (j=0, tx=0, fdj=DV*texcoord[2][0], ty=texcoord[2][1]-fdi; j < V-1; j++, k++, tx+=fdj) {

      pot->flist[k].polynum = 4;
      pot->flist[k].edgeptr = &pot->vindex[l];

      pot->vindex[l] = j;
      l++;
      pot->vindex[l] = j+1;
      l++;
      pot->vindex[l] = COUNTVERTEX-1;
      l++;
      pot->vindex[l] = COUNTVERTEX-1;
      l++;

      if (textureflag) {
         uv[0][0] = tx;
         uv[0][1] = fdi;
         uv[1][0] = tx+fdj;
         uv[1][1] = fdi;
         uv[2][0] = tx+fdj;
         uv[2][1] = 0.0;
         uv[3][0] = tx;
         uv[3][1] = 0.0;
         (*ptob)->direct2Dmap(k, uv, tob, 4, 1);
      }

   }

   pot->flist[k].polynum = 4;
   pot->flist[k].edgeptr = &pot->vindex[l];

   pot->vindex[l] = j;
   l++;
   pot->vindex[l] = 0;
   l++;
   pot->vindex[l] = COUNTVERTEX-1;
   l++;
   pot->vindex[l] = COUNTVERTEX-1;
   l++;

   if (textureflag) {
      uv[0][0] = tx;
      uv[0][1] = fdi;
      uv[1][0] = texcoord[2][0];
      uv[1][1] = fdi;
      uv[2][0] = texcoord[2][0];
      uv[2][1] = 0.0;
      uv[3][0] = tx;
      uv[3][1] = 0.0;
      (*ptob)->direct2Dmap(k, uv, tob, 4, 1);
   }

   if (ptob) {   // NULL signifies NO coloring
      if (mctype.model > BW) {
         sblock = (shade_block *)plob->query_data();
         for (i=0; i<COUNTOBJECT; i++)
            sblock->facelist[i] = base_color;
      }

      if (mcinfo.info & CI3DTEX) {
         slist->scale = shaderlist->scale;
         for (i=0; i<COUNTOBJECT; i++) {
            slist->shade[i].scount = shaderlist->shade[0].scount;
            slist->shade[i].s = shaderlist->shade[0].s;
            slist->shade[i].stype = shaderlist->shade[0].stype;
         }

      }

   }

}


/* *************************************************************
************************************************************* */
int sphere::dump_frame(FILE *outfile) {

   char token[4][MAXSTRLEN];
   int i, j;
   unsigned int master;

   master = mcinfo.query_master();

   fprintf(outfile, "%s {\n", TOKEN_GEOSPHERE_STR);

   sprintf(token[0], "\t%s ", TOKEN_SHADE_STR);
   sprintf(token[1], " %s\n", colorname.string);
   mctype.write_model(outfile, token[0], token[1]);

   float2char(master_wscale[0], token[0]);
   float2char(master_wscale[1], token[1]);
   float2char(master_wscale[2], token[2]);
   fprintf(outfile, "\t%s %s %s %s\n", TOKEN_AXIS_STR, token[0], token[1], token[2]);

   if (master & CITEXTURE)
      fprintf(outfile, "\t%s %s\n", TOKEN_2D_TEXTURE_STR, texname2.string);
   else if (master & CI3DTEX)
      fprintf(outfile, "\t%s %s\n", TOKEN_3D_TEXTURE_STR, texname3.string);

   if (master & CIRAYCAST)
      fprintf(outfile, "\t%s\n", TOKEN_RAYCAST_STR);

   if (master & CITRANSPARENT)
      fprintf(outfile, "\t%s\n", TOKEN_TRANSPARENT_STR);
   else if (sflag && !NOSHADOW) {
      float2char(splane[0], token[0]);
      float2char(splane[1], token[1]);
      float2char(splane[2], token[2]);
      float2char(splane[3], token[3]);
      fprintf(outfile, "\t%s %s %s %s %s\n", TOKEN_SHADOW_STR, token[0], token[1], token[2], token[3]);
   }

   fprintf(outfile, "\t%s ", TOKEN_TR_MATRIX_STR);
   for (i=0; i<4; i++)
      for (j=0; j<4; j++) {
         float2char(rotate[i][j], token[0]);
         fprintf(outfile, "%s ", token);
      }

   fprintf(outfile, "\n");

   fprintf(outfile, "\tframe %d\n", frame);
   fprintf(outfile, "}\n");

   return 1;
}
