

/* *************************************************************
   This function scans poligonal objects into a zbuffer
************************************************************* */

#include <string.h>

#include "polygon.h"


/* *************************************************************
************************************************************* */
void shadow::object2plane(camera *cparm, light *lparm) {

   int    i, j, k;
   int    flag;
   vector3f vector;
   float  t;
   char   *clip;
   int    xflag = 0;
   float  *v;
   face_type *flist;
   vector4f pt;
   
   clip = new char[ob->countvertex];

   if (lparm->query_whatami() == OBJECT_FAR) {
      vector[0] = -lparm->transvec[0];
      vector[1] = -lparm->transvec[1];
      vector[2] = -lparm->transvec[2];
   }

   for (i=0, v=(float *)pot->vlist; i<ob->countvertex; i++, v+=4) {
      if (lparm->query_whatami() == OBJECT_POINT) {
         subeqarray3(vector, v, lparm->transloc);
      }

      flag = line_plane_intersect(splane, v, vector, NULL, &t);

      clip[i] = !flag || t < 0;
      
      if (!clip[i]) {
         v[0] += t*vector[0];
         v[1] += t*vector[1];
         v[2] += t*vector[2];

         matvecmulto(cparm->transform, v, pt);

         if (xflag) {
            for (j=0; j<3; j++)
               if (pt[j] < bbox[0][j])
                  bbox[0][j] = pt[j];
               else if (pt[j] > bbox[1][j])
                  bbox[1][j] = pt[j];
         }

         else {
            xflag = 1;
            copyarray3(bbox[0], pt);
            copyarray3(bbox[1], pt);
	    bbox[0][3] = bbox[1][3] = 1.0f;
         }

      }

   }

   for (i=0, flist=pot->flist; i<ob->countobject; i++, flist++)
      for (k=0; k<flist->polynum; k++)
         if (clip[flist->edgeptr[k]]) {
            flist->polynum = 0;
            break;
         }

   delete [] clip;
   polyflag |= POLYFLAG_BOUNDBOX;
}


/* **************************************************
************************************************** */
void shadow::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   switch (mctype.model) {

      case SHADOW:
         shadct(cparm, spot, proc);
         break;

      case BW:
         polybw(cparm, spot, proc);
         break;

      default:
         polywfbw(spot, proc);
         break;
   }

}


/* **************************************************
************************************************** */
void shadow::shadct(eye *parm, light *spot, engine *proc) {

   COMMON;

   winx = zbuff->maxx;
   winy = zbuff->maxy;

#define SHADCT

   if (bitflags[FLAG_RAYCAST]) {
#include "polyplate.c"
   }

   else {
#define INTZ
#include "polyplate.c"
#undef INTZ
   }

#undef SHADCT
}


/* *************************************************************
   This procedure takes the basic object data, and creates a composite
   structure to be worked on.
************************************************************* */
int shadow::datacopy2(polygon *pob, camera *cparm, light *lparm) {

   face_type *flist, *fend, *dlist;
   int i;                             // looping variables
   float *v;
   int *olist;
   polygon_object_type *dot;
   vector4f mx[4];

   ob->build(pob->ob->countvertex, pob->ob->countobject, pob->ob->countedge);
   ob->maxpolynum = pob->ob->maxpolynum;

   pot = (polygon_object_type *)ob->query_data();
   dot = pob->pot;

   memcpy(pot->vlist, dot->vlist, ob->countvertex*sizeof(vector4f));
   memcpy(pot->vindex, dot->vindex, ob->countedge*sizeof(int));

   dlist = dot->flist;
   flist = pot->flist;
   fend = &flist[ob->countobject];
   olist = pot->vindex;

   for (; flist<fend; olist += flist->polynum, flist++, dlist++) {
      flist->edgeptr = olist;
      flist->polynum = dlist->polynum;
   }

   size = 1;
   init_mx(rotate);
   center[0] = center[1] = center[2] = 0;
   id = -pob->id;

   // apply source xformation to camera space
   // remove camera xform to get world space

   if (pob->polyflag & POLYFLAG_TRANSFORM) {
      copymx4x4(mx, cparm->Tinverse);
   }

   else
      matmatmulto(cparm->Tinverse, pob->world, mx);

   mx[3][0] = mx[3][1] = mx[3][2] = 0;
   mx[3][3] = 1;

   for (i=0, v=(float *)pot->vlist; i<ob->countvertex; i++, v+=4)
      matvecmulto(mx, v);

   copyarray4(splane, pob->splane);

   sflag = 0;

   mcinfo.info = pob->mcinfo.info & CIRAYCAST;

   polyflag = 0;

   if (mctype.model > WFBW)
      polyflag |= pob->polyflag & POLYFLAG_BACKFACE_CULL;

   mctype.model = (pob->mctype.model > BW) ? SHADOW : pob->mctype.model;

   object2plane(cparm, lparm);

   ob->calc_normal();

   return 1;
}
