



/* *************************************************************
   This function scans poligonal objects into a zbuffer
************************************************************* */


#include "particle.h"


/* *************************************************************
************************************************************* */
int shadowpt::point2plane(float psplane[], light *lparm) {

   float  vector[3];
   float  t;

   if (lparm->query_whatami() == OBJECT_POINT) {
      subeqarray3(vector, wwai, lparm->location);
   }

   else {
      vector[0] = -lparm->transvec[0];
      vector[1] = -lparm->transvec[1];
      vector[2] = -lparm->transvec[2];
   }

   line_plane_intersect(psplane, wwai, vector, NULL, &t);

   if (t <=0)
      return 0;

   wwai[0] += t*vector[0];
   wwai[1] += t*vector[1];
   wwai[2] += t*vector[2];

   return 1;
}


/* *************************************************************
   This procedure takes the basic object data, and creates a composite
   structure to be worked on.
************************************************************* */
int shadowpt::datacopy2(particle *pob, light *lparm) {

   copyarray4(wwai, pob->wwai);

   sflag  = 0;
   mctype.model = pob->mctype.model;
   id = -pob->id;

   return point2plane(pob->splane, lparm);
}


/* **************************************************
************************************************** */
void shadowpt::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   int    index;
   zbuffer *zbuff = &proc->zbuff;

   index = iwai[1];

   index = index*zbuff->maxx + iwai[0];

   if (wwai[2] > zbuff->zdata[index])
      zbuff->data[index] = (mctype.model == WFBW) ? 0xffffffff : zbuff->adata[index];
}

