

#include <string.h>

#include "pstring.h"
#include "shader.h"


/* *************************************************************************
************************************************************************* */
shaderparamtype::shaderparamtype() {

   params.H = params.lacunarity = params.octaves = 0;
   cam = (eye *)NULL;
   ob = (pc *)NULL;
   min = max = 0;
}


/* *************************************************************************
************************************************************************* */
void shaderparamtype::setup(vector4f *xf, vector4f *ixf, int f, eye *c, pc *o, float fscale) {

   float ifscale;

   copymx4x4o(ixform, ixf);
   smultarray4(ixform[0], fscale);
   smultarray4(ixform[1], fscale);
   smultarray4(ixform[2], fscale);
   smultarray3(ixform[3], fscale);

   ifscale = 1.0f/fscale;
   copymx4x4o(xform, xf);
   smultarray4(xform[0], ifscale);
   smultarray4(xform[1], ifscale);
   smultarray4(xform[2], ifscale);
   smultarray3(xform[3], ifscale);

   frame = f;

   cam = c;
   ob = o;
}


/* *************************************************************************
************************************************************************* */
void shaderparamtype::set_point(float *local, float *n) {

   copyarray4(normal, n);
   copyarray3(pt, local);
   matvecmulto(ixform, local, in);
}


/* *************************************************************************
************************************************************************* */
shadertype &shadertype::operator = (shadertype &x) {

   scount = x.scount;
   if (s != (shader **)NULL)
      delete [] s;
   if (stype != (shader_type *)NULL)
      delete [] stype;

   s = new pshader[scount];
   stype = new shader_type[scount];

   memcpy(stype, x.stype, sizeof(shader_type *)*scount);
   memcpy(s, x.s, sizeof(pshader)*scount);
   return x;
}


/* *************************************************************************
************************************************************************* */
void shadertype::read_data(FILE *infile, binary_tree *sptr) {

   char tmpstr[MAXSTRLEN], tmpstr2[MAXSTRLEN];
   int j;
   string_binary_data sbd;
   binary_node *btr;
   
   fscanf(infile, "%d", &scount);

   if (s != (pshader *)NULL)
      delete [] s;

   if (stype != (shader_type *)NULL)
      delete [] stype;

   s = new pshader[scount];
   stype = new shader_type[scount];

   for (j=0; j<scount; j++) {
      get_token(infile, tmpstr);
      get_token(infile, tmpstr2);

      if (tmpstr2[0] == 'A')
         stype[j] = ATMOSPHERE;
      else
         stype[j] = SURFACE;

      sbd.string.stringcpy(tmpstr);
      
      btr = sptr->find(&sbd);
      
      if (!btr) {
         sprintf(perror_buffer, "Can't find shader %s\n", tmpstr);
         pprintf(perror_buffer);
      }
      
      else {
         s[j] = (shader *)btr->key;
         s[j]->init();
      }
      
   }

}


/* *************************************************************************
************************************************************************* */
void shaderlisttype::update(float current_time) {

}


/* *************************************************************************
************************************************************************* */
void *shaderlisttype::query_data() {

   return NULL;
}


/* *************************************************************
************************************************************* */
void shaderlisttype::replace_data(void *subresource) {

}


/* *************************************************************************
************************************************************************* */
void shaderlisttype::init(int x) {

   if (shade)
      delete [] shade;

   shade = new shadertype[x];
   scount = x;
}

