

#include "sbfast.h"


/* *****************************************************************
***************************************************************** */
void sbmap::setup(vector4f *pt) {

   float size[2];

   if (ob == (texbase *)NULL)
      return;

   min[0] = max[0] = pt[0][0];

   if (pt[2][0] < min[0])
      min[0] = pt[2][0];
   else if (pt[2][0] > max[0])
      max[0] = pt[2][0];

   min[1] = max[1] = pt[0][1];

   if (pt[2][1] < min[1])
      min[1] = pt[2][1];
   else if (pt[2][1] > max[1])
      max[1] = pt[2][1];

   size[0] = max[0] - min[0];
   size[1] = max[1] - min[1];

   xscale = 1.0f/size[0];
   yscale = 1.0f/size[1];

   fxpxscale = FLOAT_TO_FIXED(xscale);
   fxpyscale = FLOAT_TO_FIXED(yscale);

   if ((flaginv = (fabs(pt[0][0] - pt[3][0]) > CORRECT))) {
      xsign = pt[2][0] - pt[0][0];
      ysign = pt[2][1] - pt[0][1];
   }

   else {
      ysign = pt[2][0] - pt[0][0];
      xsign = pt[2][1] - pt[0][1];
   }

   area = (float)sqrt((ob->maxx*ob->maxy)/(size[0]*size[1]));
}


/* *****************************************************************
***************************************************************** */
unsigned int sbmap::query_texel(float x, float y, float *c, int frame, float d) {

   float a, b, e;
   unsigned int z;

   if (repeatflag && (x < min[0] || x > max[0] || y < min[1] || y > max[1]))
      return 0;

   a = (x-min[0]) * xscale;
   b = (y-min[1]) * yscale;

   a -= (int)a;
   b -= (int)b;


   if (a < 0)           // bug in sgi  (int)(-x) = roundup(x)
      a += 1.0;
   if (b < 0)           // bug in sgi  (int)(-x) = roundup(x)
      b += 1.0;

   if (flaginv) {
      a = ob->maskx * ((xsign < 0) ? (1 - a) : a);
      b = ob->masky * ((ysign < 0) ? (1 - b) : b);
   }

   else {
      e = ob->maskx * ((xsign < 0) ? (1 - b) : b);
      b = ob->masky * ((ysign < 0) ? (1 - a) : a);

      a = e;
   }

   z = ob->query_texel(a, b, c, frame, d*area);

   return (z > 0) ? z : 1;
}


/* *************************************************************
************************************************************* */
void *texsbfast::query_data() {

//asdf   
return NULL;   
}


/* *************************************************************
asdf - future - can use accesstime to drop object based on time...
************************************************************* */
void texsbfast::update(float current_time) {

//asdf   
}


/* *****************************************************************
***************************************************************** */
void texsbfast::replace_data(void *subresource) {

}


/* *****************************************************************
***************************************************************** */
void texsbfast::setup(int x) {

   if (data)
      delete [] data;

   data = new sbmap[x];
}


/* *****************************************************************
***************************************************************** */
int texsbfast::query_texel(float x, float y, float *c, int frame, float d) {

   int i, j;

   for (i=j=0; i<countobject; i++)
      if (!data[i].repeatflag) {
         if (data[i].query_texel(x,y,c, frame, d))
            return 1;
      }

      else
         if (!j && data[i].query_texel(x,y,c, frame, d))
            j = 1;

   return j;
}
