

#include "sbfast.h"


#define SBCOMMON                \
   color_calc_data colordata;	\
   void *shade_fcn;		\
   shaderparamtype sparam;      \
   int  i, j, k;                \
   vector4f surface, normal;    \
   vector4f pzero, pray;        \
   vector3f rcolor, acolor, tcolor;     \
   int  flag3t = (mcinfo.info & CI3DTEX) == CI3DTEX;      \
   int  flag2t = (mcinfo.info & CITEXTURE) == CITEXTURE;    \
   int  flagtr = (mcinfo.info & CITRANSPARENT) == CITRANSPARENT;        \
   int  overwriteflag = (mcinfo.info & CIOVERWRITE) == CIOVERWRITE;        \
   int  ghostflag = (mcinfo.info & CIGHOST) == CIGHOST;        \
   float increment;             \
   texcolortype texcolor;       \
   vector4f isw[4];             \
   int index;                   \
   flt2int_type a0, a1, a2, d0, d1, d2;  \
                                \
   pzero[0] = iworld[0][3];     \
   pzero[1] = iworld[1][3];     \
   pzero[2] = iworld[2][3];     \
   pzero[3] = 1;                \
                                \
   normal[3] = pray[3] = 0;     \
   surface[3] = 1;              \
                                \
   if (flag3t)                  \
      sparam.setup(world, iworld, frame, parm, this, shaderlist->scale);        \
                                \
   copymx4x4o(isw, world);      \
   smultarray3(isw[0], isize);  \
   smultarray3(isw[1], isize);  \
   smultarray3(isw[2], isize);  \
   increment = (parm->vrc[1]+parm->vrc[1])*isize / (float)zbuff->maxx; \
                                \
   texcolor.set(base_color);    \
                                \
   if (lmain)                   \
      lmain->set_ambient(texcolor.color.ka, texcolor.ambient, texcolor.color.lum);      \
   else                         \
      copyarray3(texcolor.ambient, (float)texcolor.color.lum); \
				\
  if (flag3t)			\
     shade_fcn = (void *)calc_color3;	\
  else if (flag2t)		\
     shade_fcn = (void *)calc_color2;	\
  else				\
     shade_fcn = (void *)calc_color;	\
					\
   colordata.ob = this;			\
   colordata.surface = surface;		\
   colordata.normal = normal;		\
   colordata.spot = (flagtr ? (light *)NULL : spot);	\
   colordata.parm = parm;		\
   colordata.texcolor = &texcolor;	\
   colordata.tcolor = tcolor;		\
   colordata.sparam = &sparam;		\
   colordata.i = 0;			\
   colordata.rcolor = rcolor;		\
   colordata.acolor = acolor;		\
   colordata.lmain = lmain


/* **************************************************
************************************************** */
void sbfast::sbfastpg_llurh(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dy) {

   int  h;
   float row;
                                           // calculate the ray-creep increment
   SBCOMMON;

   for (h = 0; h < (int)zbuff->maxy; h++) {

      start_flag = 1;
      row = (float)h;

      if (!SILENT)
         printf("y1 %d\n", h);

      for (j=0; j<(int)zbuff->maxx && (i=(int)row)<(int)zbuff->maxy; j++, row += dy) {
#include "sbshade.c"
      }

      for (; j<(int)zbuff->maxx && (i=(int)row)<(int)zbuff->maxy; j++, row += dy)
         sbbuffer->pdata[i][j] = 2;
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_llurv(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dx) {

   int  h;
   float col;
                                           // calculate the ray-creep increment
   SBCOMMON;

   for (h=0; h<(int)zbuff->maxx; h++) {

      start_flag = 1;
      col = (float)h;

      if (!SILENT)
         printf("x2 %d\n", h);

      for (i=0; i<(int)zbuff->maxy && (j=(int)col)<(int)zbuff->maxx; i++, col += dx) {
#include "sbshade.c"
      }

      for (; i<(int)zbuff->maxy && (j=(int)col)<(int)zbuff->maxx; i++, col += dx)
         sbbuffer->pdata[i][j] = 2;
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_lrulh(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dy) {

   int  h;
   float row;
                                           // calculate the ray-creep increment
   SBCOMMON;

   for (h = 1; h<(int)zbuff->maxy; h++) {

      start_flag = 1;
      row = (float)h;

      if (!SILENT)
         printf("y3 %d\n", h);

      for (j=(int)zbuff->maxx-1; j>-1 && (i=(int)row)<(int)zbuff->maxy; j--, row -= dy) {  // dy is negative - go up
#include "sbshade.c"
      }

      for (; j>-1 && (i=(int)row)<(int)zbuff->maxy; j--, row -= dy)    // dy is negative - go up
         sbbuffer->pdata[i][j] = 2;
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_lrulv(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dx) {

   int  h;
   float col;
                                           // calculate the ray-creep increment
   SBCOMMON;

   for (h=0; h<(int)zbuff->maxx; h++) {

      start_flag = 1;
      col = (float)h;

      if (!SILENT)
         printf("x4 %d\n", h);

      for (i=0; i<(int)zbuff->maxy && (j=(int)col)>-1; i++, col += dx) {  // dx is negative, go left
#include "sbshade.c"
      }

      for (; i<(int)zbuff->maxy && (j=(int)col)>-1; i++, col += dx)    // dx is negative, go left
         sbbuffer->pdata[i][j] = 2;
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_negh(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dy, float *up, float *horizon) {

   int  g, h;
   float intersect[2];
   float row;
   float column[3];
   float incup;
   float delta[2], curr[2];
   float yaxis[3];
   float xzero[3] = {1,0,0};
   float op[4];
                                           // calculate the ray-creep increment
   SBCOMMON;

   yaxis[0] = 0;
   yaxis[1] = 1;
   yaxis[2] = 1.0f-zbuff->maxy;

   copyarray2(column, up);
   incup = -up[1];

   h = 1;

   column[2] = -(up[0]*(zbuff->maxx-1) + up[1]);

   line2d_line2d_intersect(column, horizon, curr);
   column[2] += incup;
   line2d_line2d_intersect(column, horizon, delta);
   subarray2(delta, curr);

   for (column[2] = -(up[0]*(zbuff->maxx-1)+up[1]); h<(int)zbuff->maxy; h++, column[2]+=incup) {

      if (!SILENT)
         printf("y5 %d \n", h);

      start_flag = 1;

      copyarray2(intersect, curr);

      if (intersect[0] >= zbuff->maxx-1) {
         intersect[0] = (float)(zbuff->maxx-1);
         intersect[1] = (float)h;
      }

      else {
         if (intersect[1] > zbuff->maxy-1)
            line2d_line2d_intersect(column, yaxis, intersect);

         if (intersect[0] < 0)
            line2d_line2d_intersect(column, xzero, intersect);
      }

      g = j = (int)intersect[0];
      i = (int)(intersect[1] = h - (zbuff->maxx-1-j)*dy);

      if (i > (float)(zbuff->maxy-1)) {
         j++;
         i = (int)(intersect[1] += dy);
      }

      do {
#include "sbshade.c"
      } while (0);

      copyarray4(op, old_pos);

      for (j++, row=intersect[1]+dy; j<(int)zbuff->maxx && (i=(int)row)>-1; j++, row+=dy) {
#include "sbshade.c"
      }

      for (; j<(int)zbuff->maxx && (i=(int)row)>-1; j++, row+=dy)
         sbbuffer->pdata[i][j] = 2;

      copyarray4(old_pos, op);

      for (j=g-1, row=intersect[1]-dy; j>-1 && (i=(int)row)<(int)zbuff->maxy; j--, row -= dy) {
#include "sbshade.c"
      }

      for (; j>-1 && (i=(int)row)<(int)zbuff->maxy; j--, row -= dy)
         sbbuffer->pdata[i][j] = 2;

      addarray2(curr, delta);
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_negv(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dx, float *up, float *horizon) {

   int  g, h;
   float intersect[2];
   float col;
   float column[3];
   float incup;
   float delta[2], curr[2];
   float yaxis[3];
   float xzero[3] = {1,0,0};
   float op[4];
                                           // calculate the ray-creep increment
   SBCOMMON;

   yaxis[0] = 0;
   yaxis[1] = 1;
   yaxis[2] = 1.0f-zbuff->maxy;

   copyarray2(column, up);
   incup = -up[0];

   h = 0;
   column[2] = 0;

   line2d_line2d_intersect(column, horizon, curr);
   column[2] += incup;
   line2d_line2d_intersect(column, horizon, delta);
   subarray2(delta, curr);

   for (column[2]=0; h<(int)zbuff->maxx; h++, column[2]+=incup) {
      if (!SILENT)
         printf("x6 %d\n", h);

      start_flag = 1;

      copyarray2(intersect, curr);

      if (intersect[1] <= 0) {
         intersect[0] = (float)h;
         intersect[1] = 0;
      }

      else {
         if (intersect[1] > zbuff->maxy-1)
            line2d_line2d_intersect(column, yaxis, intersect);

         if (intersect[0] < 0)
            line2d_line2d_intersect(column, xzero, intersect);
      }

      g = i = (int)intersect[1];
      j = (int)(intersect[0] = h + i*dx);

      if (j > (int)zbuff->maxx-1) {
         i++;
         j = (int)(intersect[0] += dx);
      }

      do {
#include "sbshade.c"
      } while (0);

      copyarray4(op, old_pos);

      for (i++, col=intersect[0]+dx; i<(int)zbuff->maxy && (j=(int)col)>-1; i++, col+=dx) {
#include "sbshade.c"
      }

      for (; i<(int)zbuff->maxy && (j=(int)col)>-1; i++, col+=dx)
         sbbuffer->pdata[i][j] = 2;

      copyarray4(old_pos, op);

      for (i=g-1, col=intersect[0]-dx; i>-1 && (j=(int)col)<(int)zbuff->maxx; i--, col -= dx) {
#include "sbshade.c"
      }

      for (; i>-1 && (j=(int)col)<(int)zbuff->maxx; i--, col -= dx)
         sbbuffer->pdata[i][j] = 2;

      addarray2(curr, delta);
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_posh(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dy, float *up, float *horizon) {

   int  g, h;
   float intersect[2];
   float row;
   float column[3];
   float incup;
   float delta[2], curr[2];
   float yaxis[3];
   float xaxis[3];
   float op[4];
                                           // calculate the ray-creep increment
   SBCOMMON;

   yaxis[0] = 0;
   yaxis[1] = 1;
   yaxis[2] = 1.0f-zbuff->maxy;

   xaxis[0] = 1;
   xaxis[1] = 0;
   xaxis[2] = 1.0f-zbuff->maxx;

   copyarray2(column, up);
   incup = -up[1];

   h = 1;

   column[2] = -up[1];

   line2d_line2d_intersect(column, horizon, curr);
   column[2] += incup;
   line2d_line2d_intersect(column, horizon, delta);
   subarray2(delta, curr);

   for (column[2] = -up[1]; h<(int)zbuff->maxy; h++, column[2]+=incup) {
      if (!SILENT)
         printf("y7 %d \n", h);

      start_flag = 1;

      copyarray2(intersect, curr);

      if (intersect[0] <= 0) {
         intersect[0] = 0;
         intersect[1] = (float)h;
      }

      else {
         if (intersect[1] > zbuff->maxy-1)
            line2d_line2d_intersect(column, yaxis, intersect);

         if (intersect[0] > zbuff->maxx-1)
            line2d_line2d_intersect(column, xaxis, intersect);
      }

      g = j = (int)intersect[0];
      i = (int)(intersect[1] = h+j*dy);

      do {
#include "sbshade.c"
      } while (0);

      copyarray4(op, old_pos);

      for (j++, row=intersect[1]+dy; j<(int)zbuff->maxx && (i=(int)row)<(int)zbuff->maxy; j++, row+=dy) {
#include "sbshade.c"
      }

      for (; j<(int)zbuff->maxx && (i=(int)row)<(int)zbuff->maxy; j++, row+=dy)
         sbbuffer->pdata[i][j] = 2;

      copyarray4(old_pos, op);

      for (j=g-1, row=intersect[1]-dy; j>-1 && (i=(int)row)>-1; j--, row -= dy) {
#include "sbshade.c"
      }

      for (; j>-1 && (i=(int)row)>-1; j--, row -= dy)
         sbbuffer->pdata[i][j] = 2;

      addarray2(curr, delta);
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_posv(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dx, float *up, float *horizon) {

   int  g, h;
   float intersect[2];
   float col;
   float column[3];
   float incup;
   float delta[2], curr[2];
   float yaxis[3];
   float xaxis[3];
   float op[4];
                                           // calculate the ray-creep increment
   SBCOMMON;

   yaxis[0] = 0;
   yaxis[1] = 1;
   yaxis[2] = 1.0f-zbuff->maxy;

   xaxis[0] = 1;
   xaxis[1] = 0;
   xaxis[2] = 1.0f-zbuff->maxx;

   copyarray2(column, up);
   incup = -up[0];

   h = 0;

   column[2] = 0;

   line2d_line2d_intersect(column, horizon, curr);
   column[2] += incup;
   line2d_line2d_intersect(column, horizon, delta);
   subarray2(delta, curr);

   for (column[2] = 0; h<(int)zbuff->maxx; h++, column[2]+=incup) {
      if (!SILENT)
         printf("x8 %d\n", h);

      start_flag = 1;

      copyarray2(intersect, curr);

      if (intersect[1] <= 0) {
         intersect[0] = (float)h;
         intersect[1] = 0;
      }

      else {
         if (intersect[1] > zbuff->maxy-1)
            line2d_line2d_intersect(column, yaxis, intersect);

         if (intersect[0] > zbuff->maxx-1)
            line2d_line2d_intersect(column, xaxis, intersect);
      }

      g = i = (int)intersect[1];
      j = (int)(intersect[0] = h + i*dx);

      do {
#include "sbshade.c"
      } while (0);

      copyarray4(op, old_pos);

      for (i++, col=intersect[0]+dx; i<(int)zbuff->maxy && (j=(int)col)<(int)zbuff->maxx; i++, col+=dx) {
#include "sbshade.c"
      }

      for (; i<(int)zbuff->maxy && (j=(int)col)<(int)zbuff->maxx; i++, col+=dx)
         sbbuffer->pdata[i][j] = 2;

      copyarray4(old_pos, op);

      for (i=g-1, col=intersect[0]-dx; i>-1 && (j=(int)col)>-1; i--, col -= dx) {
#include "sbshade.c"
      }

      for (; i>-1 && (j=(int)col)>-1; i--, col -= dx)
         sbbuffer->pdata[i][j] = 2;

      addarray2(curr, delta);
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_horizontal(eye *parm, light *lmain, light *spot, zbuffer *zbuff, int dflag) {

   int up, down, vinc;
                                           // calculate the ray-creep increment
   SBCOMMON;

   if (dflag) {
      up   = zbuff->maxx;
      down = 0;
      vinc = 1;
   }

   else {
      up = -1;
      down = zbuff->maxx-1;
      vinc = -1;
   }

   for (i=0; i<(int)zbuff->maxy; i++) {

      start_flag = 1;

      if (!SILENT)
         printf("y9 %d\n", i);

      for (j=down; j != up; j+=vinc) {
#include "sbshade.c"
      }

      for (; j != up; j+=vinc)
         sbbuffer->pdata[i][j] = 2;
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_vertical(eye *parm, light *lmain, light *spot, zbuffer *zbuff, int dflag) {

   int up, down, vinc;
                                           // calculate the ray-creep increment
   SBCOMMON;

   if (dflag) {
      up   = zbuff->maxy;
      down = 0;
      vinc = 1;
   }

   else {
      up = -1;
      down = zbuff->maxy-1;
      vinc = -1;
   }

   for (j=0; j<(int)zbuff->maxx; j++) {

      start_flag = 1;

      if (!SILENT)
         printf("xa %d\n", j);

      for (i=down; i != up; i+=vinc) {
#include "sbshade.c"
      }

      for (; i != up; i+=vinc)
         sbbuffer->pdata[i][j] = 2;
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_horizontald(eye *parm, light *lmain, light *spot, zbuffer *zbuff, int origin) {

   vector4f op;
                                           // calculate the ray-creep increment
   SBCOMMON;

   if (origin < 0)              // shouldnt do this, but in case of fp error...
      origin = 0;
   else
      if (origin >= (int)zbuff->maxx)
         origin = zbuff->maxx-1;

   for (i=0; i<(int)zbuff->maxy; i++) {

      if (!SILENT)
         printf("yb %d\n", i);

      start_flag = 1;

      j = origin;

do {
#include "sbshade.c"
} while (0);

      copyarray4(op, old_pos);

      for (j--; j > -1; j--) {
#include "sbshade.c"
      }

      for (; j > -1; j--)
         sbbuffer->pdata[i][j] = 2;

      copyarray4(old_pos, op);

      for (j=origin+1; j<(int)zbuff->maxx; j++) {
#include "sbshade.c"
      }

      for (; j<(int)zbuff->maxx; j++)
         sbbuffer->pdata[i][j] = 2;
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_verticald(eye *parm, light *lmain, light *spot, zbuffer *zbuff, int origin) {

   vector4f op;
                                           // calculate the ray-creep increment
   SBCOMMON;

   if (origin < 0)              // shouldnt do this, but in case of fp error...
      origin = 0;
   else if (origin >= (int)zbuff->maxy)
      origin = zbuff->maxy-1;

   for (j=0; j<(int)zbuff->maxx; j++) {

      if (!SILENT)
         printf("xc %d\n", j);

      start_flag = 1;

      i = origin;

do {
#include "sbshade.c"
} while (0);

      copyarray4(op, old_pos);

      for (i--; i > -1; i--) {
#include "sbshade.c"
      }

      for (; i > -1; i--)
         sbbuffer->pdata[i][j] = 2;

      copyarray4(old_pos, op);

      for (i=origin+1; i<(int)zbuff->maxy; i++) {
#include "sbshade.c"
      }

      for (; i<(int)zbuff->maxy; i++)
         sbbuffer->pdata[i][j] = 2;
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_ullrh(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dy) {

   int  h;
   float row;
                                           // calculate the ray-creep increment
   SBCOMMON;

   for (h=0; h<(int)zbuff->maxy; h++) {

      start_flag = 1;
      row = (float)h;

      if (!SILENT)
         printf("yd %d\n", h);

      for (j=0; j<(int)zbuff->maxx && (i=(int)row)>-1; j++, row += dy) {  // dy is negative - go down
#include "sbshade.c"
      }

      for (; j<(int)zbuff->maxx && (i=(int)row)>-1; j++, row += dy)    // dy is negative - go down
         sbbuffer->pdata[i][j] = 2;
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_ullrv(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dx) {

   int  h;
   float col;
                                           // calculate the ray-creep increment
   SBCOMMON;

   for (h=0; h<(int)zbuff->maxx; h++) {

      start_flag = 1;
      col = (float)h;

      if (!SILENT)
         printf("xe %d\n", h);

      for (i=((int)zbuff->maxy)-1; i>-1 && (j=(int)col)<(int)zbuff->maxx; i--, col -= dx) {  // dx is negative, go right
#include "sbshade.c"
      }

      for (; i>-1 && (j=(int)col)<(int)zbuff->maxx; i--, col -= dx)    // dx is negative, go right
         sbbuffer->pdata[i][j] = 2;
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_urllh(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dy) {

   int  h;
   float row;
                                           // calculate the ray-creep increment
   SBCOMMON;

   for (h=0; h<(float)zbuff->maxy; h++) {

      start_flag = 1;
      row = (float)h;

      if (!SILENT)
         printf("yf %d\n", h);

      for (j=zbuff->maxx-1; j>-1 && (i=(int)row)>-1; j--, row -= dy) {
#include "sbshade.c"
      }

      for (; j>-1 && (i=(int)row)>-1; j--, row -= dy)
         sbbuffer->pdata[i][j] = 2;
   }

}


/* **************************************************
************************************************** */
void sbfast::sbfastpg_urllv(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dx) {

   int  h;
   float col;
                                           // calculate the ray-creep increment
   SBCOMMON;

   for (h=0; h < (int)zbuff->maxx; h++) {

      start_flag = 1;
      col = (float)h;

      if (!SILENT)
         printf("xg %d\n", h);

      for (i=zbuff->maxy-1; i>-1 && (j=(int)col)>-1; i--, col -= dx) {
#include "sbshade.c"
      }

      for (; i>-1 && (j=(int)col)>-1; i--, col -= dx)
         sbbuffer->pdata[i][j] = 2;
   }

}


/* **************************************************
************************************************** */
void sbfast::dither(zbuffer *zbuff) {

   int i, j, k;
   int count;
   float icount;
   float z;
   vector3f acolor, dcolor;
   int flagtr = (mcinfo.info & CITRANSPARENT) == CITRANSPARENT;
   int overwriteflag = (mcinfo.info & CIOVERWRITE) == CIOVERWRITE;
   int ghostflag = (mcinfo.info & CIGHOST) == CIGHOST;
   int index;
   int pointer[4];
   flt2int_type a0, a1, a2, d0, d1, d2;
   float icount_lut[5] = {  0.0f, 1.0f, 0.5f, 0.3333f, 0.25f };

   if (!ditherflag)
      return;

   for (i=1; i < (int)(zbuff->maxy-1); i++)
      for (j=!(i & 0x01); j < (int)(zbuff->maxx-1); j+=2) {
         index = i*zbuff->maxx + j;

         if (sbbuffer->data[index] == 4) {

            pointer[0] = index-1;
            pointer[1] = pointer[0] + 2;
            pointer[2] = pointer[1] - (zbuff->maxx + 1);
            pointer[3] = pointer[2] + (zbuff->maxx<<1);

            acolor[0] = acolor[1] = acolor[2] = 0.0;
            dcolor[0] = dcolor[1] = dcolor[2] = 0.0;
            count = 0;
            z = 0.0;

            for (k=0; k<4; k++)
               if (sbbuffer->data[pointer[k]] == 1) {
                  count++;

                  addarray3(acolor, ((unsigned char *)&zbuff->adata[pointer[k]]));
                  addarray3(dcolor, ((unsigned char *)&zbuff->data[pointer[k]]));
                  z += zbuff->zdata[pointer[k]];
               }


            if (count) {
               icount = icount_lut[count];
               z *= icount;

               if (overwriteflag || z > zbuff->zdata[index]) {
                  F2I(a0, acolor[0]*icount);
                  F2I(a1, acolor[1]*icount);
                  F2I(a2, acolor[2]*icount);
                  F2I(d0, dcolor[0]*icount);
                  F2I(d1, dcolor[1]*icount);
                  F2I(d2, dcolor[2]*icount);

                  if (flagtr) {
                     if (a0.iflt2int[0] > ((unsigned char *)&zbuff->adata[index])[REDINDEX])
                        ((unsigned char *)&zbuff->adata[index])[REDINDEX] = BYTE_LUT(a0.iflt2int[0]);
                     if (a1.iflt2int[0] > ((unsigned char *)&zbuff->adata[index])[GREENINDEX])
                        ((unsigned char *)&zbuff->adata[index])[GREENINDEX] = BYTE_LUT(a1.iflt2int[0]);
                     if (a2.iflt2int[0] > ((unsigned char *)&zbuff->adata[index])[BLUEINDEX])
                        ((unsigned char *)&zbuff->adata[index])[BLUEINDEX] = BYTE_LUT(a2.iflt2int[0]);
                     if (d0.iflt2int[0] > ((unsigned char *)&zbuff->data[index])[REDINDEX])
                        ((unsigned char *)&zbuff->data[index])[REDINDEX] = BYTE_LUT(d0.iflt2int[0]);
                     if (d1.iflt2int[0] > ((unsigned char *)&zbuff->data[index])[GREENINDEX])
                        ((unsigned char *)&zbuff->data[index])[GREENINDEX] = BYTE_LUT(d1.iflt2int[0]);
                     if (d2.iflt2int[0] > ((unsigned char *)&zbuff->data[index])[BLUEINDEX])
                        ((unsigned char *)&zbuff->data[index])[BLUEINDEX] = BYTE_LUT(d2.iflt2int[0]);
                  }

                  else {
                     if (!ghostflag)
                        zbuff->zdata[index] = z;

                     ((unsigned char *)&zbuff->adata[index])[REDINDEX] = BYTE_LUT(a0.iflt2int[0]);
                     ((unsigned char *)&zbuff->adata[index])[GREENINDEX] = BYTE_LUT(a1.iflt2int[0]);
                     ((unsigned char *)&zbuff->adata[index])[BLUEINDEX] = BYTE_LUT(a2.iflt2int[0]);
                     ((unsigned char *)&zbuff->data[index])[REDINDEX] = BYTE_LUT(d0.iflt2int[0]);
                     ((unsigned char *)&zbuff->data[index])[GREENINDEX] = BYTE_LUT(d1.iflt2int[0]);
                     ((unsigned char *)&zbuff->data[index])[BLUEINDEX] = BYTE_LUT(d2.iflt2int[0]);
                  }

               }

            }

         }

      }

}
