

#include <stdlib.h>
#include <string.h>

#include "sbfast.h"
#include "pstring.h"


#define CLEANUP -1
#define DITHER  -2
#define SBRENDER 1


/* *************************************************************
************************************************************* */
int sbfast::query_whatwasi(int type) {

   return (sbfast::query_whatami() == type) ? 1 : pc::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
sbfast::sbfast() {

   back = 1000;
   params.octaves = 100;
   params.H = 0.9f;
   params.lacunarity = 2.1f;
   displacement = NULL;
//   SCALESB = 157.241;
   ditherflag = 0;
   shadername.stringcpy("default_alt");
}


/* *************************************************************
************************************************************* */
int sbfast::parse(FILE *infile, char *token) {

   switch (token[0]) {

      case '2':
         if (!strcmp(token, TOKEN_2D_TEXTURE_STR)) {
            get_token(infile, token);
            texname2.stringcpy(token);
            mcinfo.mask_or(CITEXTURE);
            return 1;
         }

         break;

      case 'b':
         if (!strcmp(token, TOKEN_BACK_STR)) {
            get_token(infile, token);
            master_back = (float)atof(token);
            return 1;
         }

         break;

      case 'd':
         if (!strcmp(token, TOKEN_DISPLACEMENT_STR)) {
            get_token(infile, token);
            shadername.stringcpy(token);
            return 1;
         }

         if (!strcmp(token, TOKEN_DITHER_STR)) {
            ditherflag = 1;
            return 1;
         }

         break;

      case 'h':
         if (!token[1]) {
            get_token(infile, token);
            params.H = (float)atof(token);
            return 1;
         }

         break;

      case 'l':
         if (!strcmp(token, "lacunarity")) {
            get_token(infile, token);
            params.lacunarity = (float)atof(token);

            return 1;
         }

         break;

      case 'o':
         if (!strcmp(token, "octaves")) {
            get_token(infile, token);
            params.octaves = (float)atof(token);

            return 1;
         }

         break;

      default:
         break;
   }

   return pc::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void sbfast::preprocess(void *data) {

   colortype ilm;

   pc::preprocess(data);

   rotate[3][0] = center[0];
   rotate[3][1] = center[1];
   rotate[3][2] = center[2];
   smultarray3(rotate[0], size);
   smultarray3(rotate[1], size);
   smultarray3(rotate[2], size);

   ilm = mctype.query_master();

   if (!((frame_manager *)global_resource_manager)->query_render())
      return;

   if (colorname.string[0])
      lob = (shadelist *)((frame_manager *)global_resource_manager)->read_ilm(colorname.string, 1);

   displacement = (shader *)global_resource_manager->find_resource_object(RESOURCE_SHADER, shadername.string, NULL);

   if ((ilm > BW && ilm <= PHONG) || ilm > PBW) {

      if (mcinfo.query_master() & CITEXTURE)
         read_tex(texname2.string);
      if (mcinfo.query_master() & CI3DTEX)
         read_3dtex(texname3.string);
   }

}


/* *************************************************************
************************************************************* */
void sbfast::bound_sphere() {

   bvalid_flag = 0;
}


/* *************************************************************
************************************************************* */
int sbfast::read_tex(char *filename) {

   FILE *infile;
   int  i, j;
   char token[MAXSTRLEN];
   vector4f pt[4];

   tob = (texsbfast *)global_resource_manager->find_resource_object(RESOURCE_UVCOORD, "__SBFAST__", filename);
   if (tob)
      return 1;
      
   if (!find_file(filename, "r", OBJECT_PATH.string, (char)PLATFORM_SLASH, NULL, &infile)) {
      mcinfo.mask_and(~CITEXTURE);
      return 0;
   }

   tob = new texsbfast;
   tob->altname.stringcpy(filename);
   tob->dataname.stringcpy("__SBFAST__");

   global_resource_manager->register_resource_object(RESOURCE_UVCOORD, tob);

   get_token(infile, token);
   tob->countobject = atoi(token);

   tob->setup(tob->countobject);

   for (i=0; i<tob->countobject; i++) {
      get_token(infile, token);
      lower_case(token);

      tob->data[i].repeatflag = !strcmp(token, "coord");

      // texture name
      get_token(infile, token);

      tob->data[i].ob = (texbase *)((frame_manager *)global_resource_manager)->read_tex(token);

      if (!tob) {
         mcinfo.mask_and(~CITEXTURE);
         fclose(infile);
         return 0;
      }

      for (j=0; j<4; j++) {
         get_token(infile, token);
         pt[j][0] = (float)atof(token);
         get_token(infile, token);
         pt[j][1] = (float)atof(token);
      }

      tob->data[i].setup(pt);
   }

   fclose(infile);
   return 1;
}


/* *************************************************************
************************************************************* */
int sbfast::read_3dtex(char *filename) {

   shaderlist = (shaderlisttype *)((frame_manager *)global_resource_manager)->read_tex3d(filename, "__SBFAST__", 1);

   if (!shaderlist) {
      mcinfo.mask_and(~CI3DTEX);
      return 0;
   }

   return 1;
}


/* **************************************************
************************************************** */
void sbfast::begin_scan() {

   params.init();

   dis.params.freq = NULL;
   sbbuffer = new mapuc;
}


/* **************************************************
************************************************** */
void sbfast::end_scan() {

   if (sbbuffer) {
      delete sbbuffer;
      sbbuffer = NULL;
   } 

   dis.params.freq = NULL;
}


/* **************************************************
************************************************** */
int sbfast::bound_box(eye *parm) {

//octaves = 5.5 - log2(dist);
//SCALESB*max(rmf2 with pos, h, lac, octaves, 1, 2, 0)-1

// to be done at a later date

   return 1;
}


/* **************************************************
************************************************** */
void sbfast::datacopy() {

   mctype.datacopy();
   mcinfo.datacopy();

   back = master_back;

   if (mctype.model == PFLAT)
      base_color = &lob->base;
}


/* **************************************************
 * Finds the intersection between line segment [a,b] and ray;
 * determines surface normal by constructing a plane.
 *
 * Note that this could be simplified by using a line/line intersection
 * test between line segment [a,b] and the ray.
************************************************** */
float sbfast::Intersect_Surface(float distance, float increment, float *cam,
                   float *ray, float *surface, float *normal) {

   vector3f vf,     // vector from p to pf
            vr;     // vector from p to pr
   float    d;      // ax + by + cz + d = 0
   float    t;

   // get two vectors in the surface plane; cross for surface normal

   dis.pt[0] = distance;

   copyarray2(dis.in, old_pos);
   dis.in[1] += increment;   // one pixel-width to front
   displacement->query_data((void *)&dis);
   vf[2] = dis.out[0] - old_pos[2];
   vf[1] = increment;
   vf[0] = 0;

   copyarray2(dis.in, old_pos);
   dis.in[0] += increment;   // one pixel-width to right
   displacement->query_data((void *)&dis);
   vr[2] = dis.out[0] - old_pos[2];
   vr[1] = 0;
   vr[0] = increment;

   xproduct(normal, vr, vf);
   normalize3(normal);

   d = dotproduct3(normal, old_pos);  // this is the "-D" distance from the origin to the plane

   t=dotproduct3(normal, ray);

   // assign the various hit data

   t = ((fabs(t) < CORRECT) ? distance :  (( d - dotproduct3(normal, cam) ) / t));

   surface[0] = cam[0] + t*ray[0];
   surface[1] = cam[1] + t*ray[1];
   surface[2] = cam[2] + t*ray[2];

   return t;
}


/* **************************************************
 * Procedurally ray-trace a terrain given by function Displacement().
 *
 * Algorithm and code by F. Kenton Musgrave, 3/95
 *
 * Brute-force method steps across terrain at pixel-sized steps
 * until an intersection is found.
 *
 * Assumptions:
 *  - bottom-to-top scan
 *  - error inherent in pixel-sized horizontal steps is acceptable
 *  - parameter camera.near_clip is close enough to ray origin
 *  - downward-sloping rays: currently no vertical bound test
 *  - only for eye rays -- shadow rays (for directional light sources)
 *      should use a constant step size: the pixel size at ray origin
 *
 * Possible mods:
 *  - optimize based on prev col calc iff no horizontal jittering
 *  - use derivatives of terrain func to get greater step stride
 *  - add vertical bound test (only for upward-sloping rays)
 *  - modify for shadow rays with constant step size
************************************************** */
int sbfast::Intersect_Terrain(float increment, float *cam, float *ray, float *surface,
                      float *normal) {

   float   t;                 // ray parameter, equal to distance travelled
   float   acceleration, iacceleration;
   float   position[3];       // current position along ray
   float   start;

   copyarray3(position, ray);

   start = t = normalize3(ray);         // get magnitude, then normalize
   acceleration = increment/t;

   if (start_flag) {
      start_flag = 0;
      addarray3(position, cam);
   }

   else {
      t = old_pos[3];

      increment = t*acceleration;

      position[0] = cam[0] + t*ray[0];
      position[1] = cam[1] + t*ray[1];
      position[2] = cam[2] + t*ray[2];
   }

   copyarray2(dis.in, position);
   dis.pt[0] = t;
   displacement->query_data((void *)&dis);

   acceleration += 1;   // (1)
   iacceleration = 1.0f/acceleration;

   if (position[2] < dis.out[0]) {
        //  we have "cave/cliff" artifacts

      do {
         increment *= iacceleration;    // (1)
         t -= increment;

         position[0] -= increment*ray[0];
         position[1] -= increment*ray[1];
         position[2] -= increment*ray[2];

         copyarray2(dis.in, position);
         dis.pt[0] = t;
         displacement->query_data((void *)&dis);
     } while (t > start && position[2] < dis.out[0]);   // go back til no intersect...

      copyarray2(old_pos, position);
      old_pos[2] = dis.out[0];
      old_pos[3] = t;

      Intersect_Surface(t, increment, cam, ray, surface, normal);

      return 1;
   }

   while ( t < back && position[2] > dis.out[0]) { // (add test for top of BB here)
      old_pos[2] = dis.out[0];

      position[0] += increment*ray[0];
      position[1] += increment*ray[1];
      position[2] += increment*ray[2];
      t += increment;           // the all-important ray-creep increment

      increment *= acceleration;        // (1)

      copyarray2(dis.in, position);
      dis.pt[0] = t;
      displacement->query_data((void *)&dis);
   }

   if (position[2] <= dis.out[0]) {       // surface penetrated
      increment *= iacceleration;       // (1)
      t -= increment;

      position[0] -= increment*ray[0];
      position[1] -= increment*ray[1];

      copyarray2(old_pos, position);
      old_pos[3] = t;

      Intersect_Surface(t, increment, cam, ray, surface, normal);

      return 1;
   }

   copyarray3(old_pos, position);
   old_pos[3] = t;

   return -1;       // Exceeded far clip distance; update "prev_dist" appropriately  & exit.
}


/* **************************************************
************************************************** */
void sbfast::transform(eye *parm) {

//   isize = 3.0/sqrt(dotproduct3(rotate[0], rotate[0]) + dotproduct3(rotate[1], rotate[1]) + dotproduct3(rotate[2], rotate[2]));
   isize = (float)(3.0/(sqrt(rotate[0][0]*rotate[0][0] + rotate[1][0]*rotate[1][0] + rotate[2][0]*rotate[2][0]) +
		sqrt(rotate[0][1]*rotate[0][1] + rotate[1][1]*rotate[1][1] + rotate[2][1]*rotate[2][1]) +
		sqrt(rotate[0][2]*rotate[0][2] + rotate[1][2]*rotate[1][2] + rotate[2][2]*rotate[2][2])));

   back *= isize;

   matmatmulto(parm->transform, rotate, world);
   world[3][0] = world[3][1] = world[3][2] = 0;
   world[3][3] = 1;
   
   inversemx(world, iworld);
}


/* **************************************************
************************************************** */
void sbfast::beamrender(spotlight *lparm, engine *proc) {

   vector4f pt = {0,0,1,0};             // vertical column
   float one = (float)(1.0-CORRECT);
   vector4f pzero = {0,0,0,1};          // camera origin
   vector4f vnormal = {0,0,1,1};       // vpn
   vector4f vector;                     // vertical vector
   vector4f temp;
   float dx, dy;
   vector4f vertex[4];
   float t;
   
   if (mctype.model != PFLAT  && mctype.model != FLAT)
      return;

   matvecmultv(world, pt);            // up vector
   copyarray4(vector, pt);
   pt[2] /= (float)magnitude3(pt);
   normalize2(pt);

   vertex[0][0] = lparm->vrc[0];       // corners of viewplane "polygon"
   vertex[0][1] = lparm->vrc[2];
   vertex[0][2] = -1;
   vertex[0][3] = 1;

   vertex[1][0] = lparm->vrc[0];
   vertex[1][1] = lparm->vrc[3];
   vertex[1][2] = -1;
   vertex[1][3] = 1;

   vertex[2][0] = lparm->vrc[1];
   vertex[2][1] = lparm->vrc[3];
   vertex[2][2] = -1;
   vertex[2][3] = 1;

   vertex[3][0] = lparm->vrc[1];
   vertex[3][1] = lparm->vrc[2];
   vertex[3][2] = -1;
   vertex[3][3] = 1;

   if (line_cpoly_intersect(pzero, vector, vnormal, vertex, 4, temp, &t)) {

      lparm->map2screen(temp);

      // if here then we are in the "special case"
      if (fabs(pt[2]) > one || fabs(pt[1]) > one) // perpendicular to viewplane || vertical
         sbfastbm_verticald(lparm, (int)temp[1]);
      else if (fabs(pt[0]) > one)
         sbfastbm_horizontald(lparm, (int)temp[0]);
      else {       // if here then we can do diagonal :)
         dx = pt[0]/pt[1];
         dy = pt[1]/pt[0];

         vector[1] = pt[0];
         vector[0] = -pt[1];
         vector[2] = -(vector[0]*temp[0] + vector[1]*temp[1]);    // column

         pt[2] = -(pt[0]*temp[0] + pt[1]*temp[1]);        // perpendicular line

         if (dx > 0) {
            sbfastbm_posh(lparm, dy, vector, pt);
            sbfastbm_posv(lparm, dx, vector, pt);
         }

         else {
            sbfastbm_negh(lparm, dy, vector, pt);
            sbfastbm_negv(lparm, dx, vector, pt);
         }

      }

   }

   else if (fabs(pt[1]) > one)
      sbfastbm_vertical(lparm, pt[1] >= 0);
   else if (fabs(pt[0]) > one)
      sbfastbm_horizontal(lparm, pt[0] >= 0);
   else if (pt[0] > 0)       // if here then we can do diagonal :)
      if (pt[1] > 0) { // ll to ur
         sbfastbm_llurh(lparm, pt[1]/pt[0]);
         sbfastbm_llurv(lparm, pt[0]/pt[1]);
      }

      else { // ul to lr
         sbfastbm_ullrh(lparm, pt[1]/pt[0]);
         sbfastbm_ullrv(lparm, pt[0]/pt[1]);
      }

   else if (pt[1] > 0) { // lr to ul
      sbfastbm_lrulh(lparm, pt[1]/pt[0]);
      sbfastbm_lrulv(lparm, pt[0]/pt[1]);
   }

   else { // urll
      sbfastbm_urllh(lparm, pt[1]/pt[0]);
      sbfastbm_urllv(lparm, pt[0]/pt[1]);
   }

//   sbfastbm_postscan(lparm);
}


/* **************************************************
************************************************** */
void sbfast::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   vector4f pt = {0,0,1,0};             // vertical column
   float one = (float)(1.0-CORRECT);
   vector4f pzero = {0,0,0,1};          // camera origin
   vector4f vnormal = {0,0,1,1};       // vpn
   vector4f vector;                     // vertical vector
   vector4f temp;
   float dx, dy;
   vector4f vertex[4];
   zbuffer *zbuff = &proc->zbuff;
   float t;
   
   if (mctype.model != PFLAT  && mctype.model != FLAT)
      return;

   matvecmultv(world, pt);            // up vector
   copyarray4(vector, pt);
   pt[2] /= (float)magnitude3(pt);
   normalize2(pt);

   vertex[0][0] = cparm->vrc[0];       // corners of viewplane "polygon"
   vertex[0][1] = cparm->vrc[2];
   vertex[0][2] = -1;
   vertex[0][3] = 1;

   vertex[1][0] = cparm->vrc[0];
   vertex[1][1] = cparm->vrc[3];
   vertex[1][2] = -1;
   vertex[1][3] = 1;

   vertex[2][0] = cparm->vrc[1];
   vertex[2][1] = cparm->vrc[3];
   vertex[2][2] = -1;
   vertex[2][3] = 1;

   vertex[3][0] = cparm->vrc[1];
   vertex[3][1] = cparm->vrc[2];
   vertex[3][2] = -1;
   vertex[3][3] = 1;

   if (line_cpoly_intersect(pzero, vector, vnormal, vertex, 4, temp, &t)) {

      cparm->map2screen(temp);

      // if here then we are in the "special case"
      if (fabs(pt[2]) > one || fabs(pt[1]) > one) // perpendicular to viewplane || vertical
         sbfastpg_verticald(cparm, lmain, spot, zbuff, (int)temp[1]);
      else if (fabs(pt[0]) > one)
         sbfastpg_horizontald(cparm, lmain, spot, zbuff, (int)temp[0]);
      else {       // if here then we can do diagonal :)
         dx = pt[0]/pt[1];
         dy = pt[1]/pt[0];

         vector[1] = pt[0];
         vector[0] = -pt[1];
         vector[2] = -(vector[0]*temp[0] + vector[1]*temp[1]);    // column

         pt[2] = -(pt[0]*temp[0] + pt[1]*temp[1]);        // perpendicular line

         if (dx > 0) {
            sbfastpg_posh(cparm, lmain, spot, zbuff, dy, vector, pt);
            sbfastpg_posv(cparm, lmain, spot, zbuff, dx, vector, pt);
         }

         else {
            sbfastpg_negh(cparm, lmain, spot, zbuff, dy, vector, pt);
            sbfastpg_negv(cparm, lmain, spot, zbuff, dx, vector, pt);
         }

      }

   }

   else if (fabs(pt[1]) > one)
      sbfastpg_vertical(cparm, lmain, spot, zbuff, pt[1] >= 0);
   else if (fabs(pt[0]) > one)
      sbfastpg_horizontal(cparm, lmain, spot, zbuff, pt[0] >= 0);
   else if (pt[0] > 0)       // if here then we can do diagonal :)
      if (pt[1] > 0) { // ll to ur
         sbfastpg_llurh(cparm, lmain, spot, zbuff, pt[1]/pt[0]);
         sbfastpg_llurv(cparm, lmain, spot, zbuff, pt[0]/pt[1]);
      }

      else { // ul to lr
         sbfastpg_ullrh(cparm, lmain, spot, zbuff, pt[1]/pt[0]);
         sbfastpg_ullrv(cparm, lmain, spot, zbuff, pt[0]/pt[1]);
      }

   else if (pt[1] > 0) { // lr to ul
      sbfastpg_lrulh(cparm, lmain, spot, zbuff, pt[1]/pt[0]);
      sbfastpg_lrulv(cparm, lmain, spot, zbuff, pt[0]/pt[1]);
   }

   else { // urll
      sbfastpg_urllh(cparm, lmain, spot, zbuff, pt[1]/pt[0]);
      sbfastpg_urllv(cparm, lmain, spot, zbuff, pt[0]/pt[1]);
   }

//   sbfastpg_postscan(zbuff);

   if (ditherflag)
      dither(zbuff);
}


/* **************************************************
************************************************** */
void sbfast::prender(engine *proc) {

// asdf if ever bounding box on terrain .... put in draw for bbox
}


/* **************************************************
************************************************** */
int sbfast::scan(camera *cparm, light *lparm, engine *proc) {

   float deg;

   renderflag = 0;

   deg = (float)(1.0/sqrt(1 + cparm->vrc[1]*cparm->vrc[1]));
   deg = (float)ACOS(deg);    // fov wrt x axis
   deg += deg;
   deg = (float)(LOG2(tan(deg/proc->zbuff.maxx)) + 3.92);          // usually around ~ -5, relates Noise() to Nyquist limit
// LOG2(tan(HALFPI/ WINX)) + 3.5

   transform(cparm);

   sbbuffer->init_map(proc->zbuff.maxx, proc->zbuff.maxy);
   memset(sbbuffer->data, 0, proc->zbuff.maxx*proc->zbuff.maxy);

   dis.params.octaves = deg;
   dis.params.H = params.H;
   dis.params.lacunarity = params.lacunarity;
   dis.params.freq = params.freq;
   dis.frame = frame;
   dis.ob = this;

   renderflag = SBRENDER;
   return 1;
}


/* **************************************************
************************************************** */
int sbfast::beamscan(spotlight *lparm, engine *proc) {

   float deg;

   renderflag = 0;

   deg = (float)(1.0/sqrt(1 + lparm->vrc[1]*lparm->vrc[1]));
   deg = (float)ACOS(deg);    // fov wrt x axis
   deg += deg;
   deg = (float)(LOG2(tan(deg/proc->zbuff.maxx)) + 3.92);          // usually around ~ -5, relates Noise() to Nyquist limit
// LOG2(tan(HALFPI/ WINX)) + 3.5

   transform(lparm);

   sbbuffer->init_map(lparm->maxx, lparm->maxy);
   memset(sbbuffer->data, 0, lparm->maxx * lparm->maxy);

   dis.params.octaves = deg;
   dis.params.H = params.H;
   dis.params.lacunarity = params.lacunarity;
   dis.params.freq = params.freq;
   dis.frame = frame;
   dis.ob = this;

   renderflag = SBRENDER;
   return 1;
}


int sbfast::dump_frame(FILE *outfile) {

   char token[4][MAXSTRLEN];
   int i, j;
   unsigned int master;

   master = mcinfo.query_master();

   fprintf(outfile, "%s {\n", TOKEN_SBFAST_STR);

   sprintf(token[0], "\t%s ", TOKEN_SHADE_STR);
   sprintf(token[1], " %s\n", colorname.string);
   mctype.write_model(outfile, token[0], token[1]);

   if (master & CITEXTURE)
      fprintf(outfile, "\t%s %s\n", TOKEN_2D_TEXTURE_STR, texname2.string);
   if (master & CI3DTEX)
      fprintf(outfile, "\t%s %s\n", TOKEN_3D_TEXTURE_STR, texname3.string);

   if (master & CITRANSPARENT)
      fprintf(outfile, "\t%s\n", TOKEN_TRANSPARENT_STR);

   fprintf(outfile, "\t%s ", TOKEN_TR_MATRIX_STR);
   for (i=0; i<4; i++)
      for (j=0; j<4; j++) {
         float2char(rotate[i][j], token[0]);
         fprintf(outfile, "%s ", token);
      }

   fprintf(outfile, "\n");

   float2char(master_back, token[0]);
   fprintf(outfile, "\t%s %s\n", TOKEN_BACK_STR, token[0]);

   float2char(params.H, token[0]);
   fprintf(outfile, "\t%s %s\n", TOKEN_H_STR, token[0]);

   float2char(params.lacunarity, token[0]);
   fprintf(outfile, "\t%s %s\n", TOKEN_LACUNARITY_STR, token[0]);

   float2char(params.octaves, token[0]);
   fprintf(outfile, "\t%s %s\n", TOKEN_OCTAVES_STR, token[0]);

   fprintf(outfile, "\t%s %s\n", TOKEN_DISPLACEMENT_STR, shadername.string);

   if (ditherflag)
      fprintf(outfile, "\t%s\n", TOKEN_DITHER_STR);

   fprintf(outfile, "\tframe %d\n", frame);
   fprintf(outfile, "}\n");

   return 1;
}

