

#include <stdlib.h>
#include <string.h>

#include "pstring.h"
#include "radiant.h"
#include "sphere.h"


#define RADPOLY 1
#define RADSCAN 2


/* *************************************************************
************************************************************* */
int radiant::query_whatwasi(int type) {

    return (radiant::query_whatami() == type) ? 1 : pc::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
int radiant::parse(FILE *infile, char *token) {

   switch (token[0]) {

      case 'h':
         if (!strcmp(token, TOKEN_HOLLOW_STR)) {
            flagh = 1;
            return 1;
         }

         break;

      case 'i':
         if (!strcmp(token, TOKEN_INNER_RADIUS_STR)) {
            get_token(infile, token);
            inner_circle = (float)atof(token);

            return 1;
         }

         break;

      case 'o':
         if (!strcmp(token, TOKEN_OUTER_RADIUS_STR)) {
            get_token(infile, token);
            radius = (float)atof(token);

            return 1;
         }

         break;

      case 'l':
         if (!strcmp(token, TOKEN_LOCATION_STR)) {
            get_token(infile, token);
            center[0] = (float)atof(token);
            get_token(infile, token);
            center[1] = (float)atof(token);
            get_token(infile, token);
            center[2] = (float)atof(token);

            return 1;
         }

         break;

      default:
         break;
   }

   return pc::parse(infile, token);
}


void radiant::preprocess(void *data) {

   pc::preprocess(data);

   inner_circle *= size;
   radius *= size;

   wratio = (float)(1.0 - inner_circle/radius);
   sflag = 0;

   if (!((frame_manager *)global_resource_manager)->query_render())
      return;

   if (colorname.string[0])
      lob = (shadelist *)((frame_manager *)global_resource_manager)->read_ilm(colorname.string, 1);
}


void radiant::bound_sphere() {

   copyarray3(bcenter, center);
   bradius = radius;
   bvalid_flag = 1;
}


float radiant::radiance(float pt[]) {

   float i, k;
   float vector[2], sv[2];

   vector[0] = pt[0]-wcenter[0];
   vector[1] = pt[1]-wcenter[1];

   sv[0] = vector[0]*vector[0];
   sv[1] = vector[1]*vector[1];

   k = sv[0] + sv[1];
   i = (sqrwradius-k)*scale;                            // point outside perimeter

   if (i < 0)
      return -1.0;

   pt[2] = wcenter[2] + SQRT(i);

   if (pt[2] > front)
      return -1.0;

   if (k <= winner_circle)
      return !flagh;

   i = wratio*SQRT(k);          // calc intensity

   if (tradius < i)
      return -1.0;

   i = (float)((1.0-i/tradius)*HALFPI);
   return (float)(SIN(i) + 0.1);
}


int radiant::bound_box(eye *parm) {

   bbox[0][0] = wcenter[0] - wradius;
   bbox[0][1] = wcenter[1] - wradius;
   bbox[0][2] = wcenter[2] - wradius;

   bbox[1][0] = wcenter[0] + wradius;
   bbox[1][1] = wcenter[1] + wradius;
   bbox[1][2] = wcenter[2] + wradius;

   return 1;
}


int radiant::clip(eye *parm, int maxx, int maxy) {

   if (bbox[0][2] > front ||
       parm->zscale(bbox[0][0], bbox[0][2]) > parm->vrc[1] ||     // outside boundaries
       parm->zscale(bbox[1][0], bbox[0][2]) < parm->vrc[0] ||
       parm->zscale(bbox[0][1], bbox[0][2]) > parm->vrc[3] ||
       parm->zscale(bbox[1][1], bbox[0][2]) < parm->vrc[2])
      return 0;

   parm->map2screen(wcenter);                       // map to screen

   scale = parm->query_scale()/(-wcenter[2]);

   winner_circle *= scale;
   wradius       *= scale;
   tradius        = wradius - winner_circle;
   sqrwradius     = wradius*wradius;
   winner_circle *= winner_circle;
   scale = (float)(1.0/(scale*scale));

   row[0] = round(wcenter[1] - wradius);
   row[1] = round(wcenter[1] + wradius);
   col[0] = round(wcenter[0] - wradius);
   col[1] = round(wcenter[0] + wradius);

   if (col[0] < 0)
      col[0] = 0;

   if (col[1] > maxx-1)
      col[1] = maxx-1;

   if (row[0] < 0)
      row[0] = 0;

   if (row[1] > maxy-1)
      row[1] = maxy-1;

   return 1;
}


void radiant::transform(eye *parm) {

   matvecmulto(parm->transform, wcenter);
}


void radiant::datacopy() {

   mctype.datacopy();
   mcinfo.datacopy();

   copyarray3(wcenter, center);
   wcenter[3] = 1;
   wradius = radius;
   winner_circle = inner_circle;

   if (mctype.model > BW)
      base_color = &lob->base;
}


void radiant::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   int   i, j;
   float intens;
   vector4f pt;
   texcolortype texcolor;
   vector4f normal, ycenter;
   vector3f ca, cd;
   vector3f black = {0,0,0};
   int scanxy, index;
   flt2int_type a0, a1, a2, d0, d1, d2;
   zbuffer *zbuff = &proc->zbuff;
   int overwriteflag = (mcinfo.info & CIOVERWRITE) == CIOVERWRITE;

   if (r) {
      r->render(cparm, lmain, spot, proc);
      return;
   }

   pt[3] = 1;

   scanxy = row[0]*zbuff->maxx;

   switch (mctype.model) {
      case IRRADIANT:

         for (i=row[0], pt[1] = (float)i; i<=row[1]; i++, pt[1] += 1.0, scanxy+=zbuff->maxx) {

            for (j=col[0], index = scanxy + col[0], pt[0] = (float)j; j<=col[1]; j++, index++, pt[0] += 1.0) {
               intens = radiance(pt);

               if (intens <= 0)
                  continue;

               if (overwriteflag || pt[2] > zbuff->zdata[index]) {
                  ca[0] = base_color->lum[0]*intens;
                  ca[1] = base_color->lum[1]*intens;
                  ca[2] = base_color->lum[2]*intens;

                  set_datatr(zbuff, index, ca, black, a0, a1, a2, d0, d1, d2);
               }

            }

         }

         return;

      case RSOLID:              // pseudo 3D - needs work

         pt[3] = 1;
         copyarray4(ycenter, wcenter);
         cparm->screen2map(ycenter);

         texcolor.set(base_color);
	 
         if (lmain)
            lmain->set_ambient(texcolor.color.ka, texcolor.ambient, texcolor.color.lum);
         else
            copyarray3(texcolor.ambient, (float)texcolor.color.lum);

         for (i=row[0], pt[1] = (float)i; i<=row[1]; i++, pt[1] += 1.0, scanxy+=zbuff->maxx) {
            for (j=col[0], index = col[0] + scanxy, pt[0] = (float)j; j<=col[1]; j++, index++, pt[0] += 1.0) {
               intens = radiance(pt);

               if (intens <= 0)
                  continue;

               if (overwriteflag || pt[2]>zbuff->zdata[index]) {
                  copyarray3(black, pt);
                  cparm->screen2map(black);

                  subeqarray3(normal, black, ycenter);
                  normalize3(normal);

                  cd[0] = cd[1] = cd[2] = 0;
                  copyarray3(ca, texcolor.ambient);

                  if (lmain)
                     lmain->intensity(black, normal, cd, cparm, &texcolor.color, id);

                  smultarray3(ca, intens);
                  smultarray3(cd, intens);
                  set_datatr(zbuff, index, ca, cd, a0, a1, a2, d0, d1, d2);
               }

            }

         }

         return;

      default:
         return;
   }

}


int radiant::scan(camera *cparm, light *lmain, engine *proc) {

   sphere *s;

   renderflag = 0;

   if (mctype.model == WFBW) {		// set only if "-p" option...
      r = s = new sphere;
      s->frame = frame;
      s->id = id;

      s->sflag = 0;

      init_mx(s->rotate);
      s->rotate[0][3] = center[0];
      s->rotate[1][3] = center[1];
      s->rotate[2][3] = center[2];

      s->mctype.model = WFBW;
      s->mcinfo.info = CINULL;
      s->wscale[0] = s->wscale[1] = s->wscale[2] = radius;

      s->scan(cparm, lmain, proc);

      renderflag = RADPOLY;
      return 1;
   }

   transform(cparm);

   if (!bound_box((eye *)NULL) || !clip(cparm, proc->zbuff.maxx, proc->zbuff.maxy))
      return 0;

   renderflag = RADSCAN;
   return 1;
}


int radiant::beamscan(spotlight *spot, engine *proc) {

   renderflag = 0;

   return 0;
}


void radiant::beamrender(spotlight *spot, engine *proc) {

}


void radiant::prender(engine *proc) {

   r->prender(proc);
   delete r;
   r = NULL;
}


int radiant::dump_frame(FILE *outfile) {

   char token[4][MAXSTRLEN];

   fprintf(outfile, "%s {\n", TOKEN_RADIANT_STR);

   sprintf(token[0], "\t%s ", TOKEN_SHADE_STR);
   sprintf(token[1], " %s\n", colorname.string);
   mctype.write_model(outfile, token[0], token[1]);

   float2char(center[0], token[0]);
   float2char(center[1], token[1]);
   float2char(center[2], token[2]);
   fprintf(outfile, "\t%s %s %s %s\n", TOKEN_LOCATION_STR, token[0], token[1], token[2]);

   float2char(inner_circle, token[0]);
   fprintf(outfile, "\t%s %s\n", TOKEN_INNER_RADIUS_STR, token[0]);


   float2char(radius, token[0]);
   fprintf(outfile, "\t%s %s\n", TOKEN_OUTER_RADIUS_STR, token[0]);

   if (flagh)
      fprintf(outfile, "\t%s\n", TOKEN_HOLLOW_STR);

   fprintf(outfile, "\tframe %d\n", frame);
   fprintf(outfile, "}\n");

   return 1;
}

