

/* *************************************************************
   This function scans poligonal objects into a zbuffer
************************************************************* */

#include "polygon.h"


#define SHADECOMMON             		\
        texcolortype texcolor;  		\
        vector3f   rcolor, acolor, tcolor;	\
        flt2int_type a0, a1, a2, d0, d1, d2;  	\
                                		\
	unsigned int tempcolor;			\
	vector3f mtempt, mdeltat;		\
	float invinvz;				\
						\
	void *shade_fcn;			\
	color_calc_data colordata;		\
        shaderparamtype sparam; 		\
						\
	colordata.ob = this;			\
	colordata.surface = surface;		\
	colordata.spot = (bitflags[FLAG_TRANS] ? (light *)NULL : spot);	\
	colordata.parm = parm;			\
	colordata.texcolor = &texcolor;		\
	colordata.sparam = &sparam;		\
	colordata.tcolor = tcolor;		\
	colordata.rcolor = rcolor;		\
	colordata.acolor = acolor;		\
						\
	if (shaderlist)         		\
           sparam.setup(world, iworld, frame, parm, this, shaderlist->scale)


/* *************************************************************
             replace w/ bucket sorter - sorts by col
************************************************************* */
void polygon::sortbucket(edgetype **head, edgetype *node) {

   edgetype **btr;
   edgetype *ptr;

   for (btr = head, ptr = *head; ptr && node->start.point[0] > ptr->start.point[0]; btr = (edgetype **)&ptr->next, ptr = (edgetype *)ptr->next);

   node->next = (edgetype *)ptr;
   *btr = node;
}


/* *************************************************************
             replace w/ bucket sorter - sorts by col
************************************************************* */
void polygon::fixed_sortbucket(edgetype **head, edgetype *node) {

   edgetype **btr;
   edgetype *ptr;

   for (btr = head, ptr = *head; ptr; btr = (edgetype **)&ptr->next, ptr = (edgetype *)ptr->next) {
      if (node->start.fxpoint[0] < ptr->start.fxpoint[0])
         break;

      if (node->start.fxpoint[0] == ptr->start.fxpoint[0] && node->fxdx < ptr->fxdx)
         break;
   }
         
   node->next = (edgetype *)ptr;
   *btr = node;
}


/* *************************************************************
   this function calculates the constant coloring by interpolating
   a point from which to calculate the polygon's color
************************************************************* */
void polygon::constcolor(eye *parm, light *lmain) {

   vector3f surface;                    // surface point
   float div;
   face_type *start;
   int *sindex, *eindex;
   int i;
   
   if (!lmain)
      return;

   for (i=0, start=pot->flist; i < ob->countobject; i++, start++) {

      if (!start->polynum)
         continue;

      start->color[0] = start->color[1] = start->color[2] = 0;

      div = 1.0f/start->polynum;
      sindex = start->edgeptr;

      copyarray3(surface, pot->vlist[*sindex]);

      for (eindex=sindex+start->polynum, sindex++; sindex<eindex; sindex++)
         addarray3(surface, pot->vlist[*sindex]);

      smultarray3(surface, div);
      lmain->intensity(surface, start->normal, start->color, parm, sblock->facelist[i], id);
   }

}


/* *************************************************************
   This procedure calculates linear interpolation in object space
                T = (pn+d)/(vn)
                pt = (0,0,0)
                ray = (x, y, -1)
           FAR: pt = (x, y, 0)
                ray = (0, 0, -1)
************************************************************* */
float polygon::perspect(float *normal, float *middle, eye *parm, float *prenum, float *prediv) {

   if (parm->query_whatami() == OBJECT_FAR)
      if (fabs(normal[2]) > CORRECT) {
         *prenum = (parm->imscale*normal[0])/normal[2];
         return *prediv = ((middle[0]*parm->imscale + parm->vrc[0])*normal[0] +
                           (middle[1]*parm->imscale + parm->vrc[2])*normal[1] +
                           normal[3])/(-normal[2]);
      }

      else {
         *prenum = 0.0;
         return *prediv = back;
      }

   *prenum = parm->imscale*normal[0];
   *prediv = (middle[0]*parm->imscale + parm->vrc[0])*normal[0] +
             (middle[1]*parm->imscale + parm->vrc[2])*normal[1] - normal[2];
   return (fabs(*prediv) > CORRECT) ? normal[3]/(*prediv) : back;
}


/* **************************************************
************************************************** */
void polygon::polywfbw(light *spot, engine *proc) {

   int      j;
   int      top;
   COMMON_WFBW;

   winx = zbuff->maxx;

   // horizontal lines

   for (; et[ob->countobject]; control->push(MM_EDGE, ptr)) {
      ptr = et[ob->countobject];
      et[ob->countobject]=(edgetype *)et[ob->countobject]->next;

      scany = ptr->starty;
      scanxy = scany*winx;

      index = scanxy + round(ptr->start.point[0]);
      end   = scanxy + round(ptr->epoint[0]);

      ptr->start.point[2] -= ptr->dz;

      for (; index<end; index++) {
         ptr->start.point[2] += ptr->dz;

         if (bitflags[FLAG_OVERWRITE] || ptr->start.point[2]>zbuff->zdata[index]) {

            if (!bitflags[FLAG_GHOST])
               zbuff->zdata[index] = ptr->start.point[2];

            zbuff->data[index]  = 0xffffffff;
            zbuff->adata[index] = 0xffffffff;
         }

      }

   }

   // rest of lines

   for (i=0; i<ob->countobject; i++)
      for (; et[i]; control->push(MM_EDGE, ptr)) {
         ptr = et[i];
         et[i] = (edgetype *)et[i]->next;

         scany = ptr->starty;

         scanxy = scany*winx;
         top = ptr->endy;

         while (scany < (int)zbuff->maxy) {               // scan all the lines
            index = round(ptr->start.point[0]) + scanxy;

#include "polywfbw.c"

            scany++;
            scanxy += winx;

            if (scany >= top)
               break;

            ptr->start.point[0] += ptr->dx;
            ptr->start.point[2] += ptr->dz;
         }

      }

}


/* **************************************************
************************************************** */
void polygon::polybw(eye *parm, light *spot, engine *proc) {

   float     mtempz[2];
   int       mtemp[3];
   int       j;
   COMMON;

   winx = zbuff->maxx;
   winy = zbuff->maxy;

   // horizontal lines

   for (;et[ob->countobject]; control->push(MM_EDGE, ptr)) {
      ptr = et[ob->countobject];
      et[ob->countobject]=(edgetype *)et[ob->countobject]->next;

      scany = ptr->starty;

      scanxy = scany*winx;

      index = scanxy + round(ptr->start.point[0]);
      end   = scanxy + round(ptr->epoint[0]);

      if (bitflags[FLAG_RAYCAST]) {
         surface[0] = round(ptr->start.point[0]) - 1.0f;
         surface[1] = ptr->start.point[1];

         perspect(pot->flist[ptr->start.id].normal, surface, parm, &prenum, &prediv);
      }

      else
         mz -= (float)(ptr->dz - CORRECT);

      for (; index<end; index++) {

         if (bitflags[FLAG_RAYCAST]) {
            perspect_dx(pot->flist[ptr->start.id].normal, prenum, prediv, mz);
            mz += (float)CORRECT;
         }

         else
            mz += ptr->dz;

         if (bitflags[FLAG_OVERWRITE] || mz>zbuff->zdata[index]) {
            if (!bitflags[FLAG_GHOST])
               zbuff->zdata[index] = mz;

            zbuff->adata[index] = 0xffffffff;
            zbuff->data[index]  = 0xffffffff;
         }

      }

   }

#define POLYBW

   if (bitflags[FLAG_RAYCAST]) {
#include "polyplate.c"
   }

   else {
#define INTZ
#include "polyplate.c"
#undef INTZ
   }

#undef POLYBW
}


/* **************************************************
************************************************** */
void polygon::polylt(spotlight *parm, engine *proc) {

   COMMON_SPOT;

   winx = parm->maxx;
   winy = parm->maxy;

#define POLYLT

   if (bitflags[FLAG_RAYCAST]) {
#include "polyplate.c"
   }

   else {
#define INTZ
#include "polyplate.c"
#undef INTZ
   }

#undef POLYLT
}


/* **************************************************
************************************************** */
void polygon::polyct(eye *parm, light *spot, engine *proc) {

   float mtemp;
   vector4uc flatacolor, flatdcolor;
   COMMON;
   SHADECOMMON;

   if (bitflags[FLAG_3D])
      shade_fcn = (void *)calc_color3pc;
   else if (bitflags[FLAG_2D])
      shade_fcn = (void *)calc_color2pc;
   else
      shade_fcn = (void *)calc_colorpc;

   winx = zbuff->maxx;
   winy = zbuff->maxy;

#define POLYCT

   if (bitflags[FLAG_RAYCAST]) {
#include "polyplate.c"
   }

   else {
#define INTZ
#include "polyplate.c"
#undef INTZ
   }

#undef POLYCT
}


/* **************************************************
************************************************** */
void polygon::polygd(eye *parm, light *spot, engine *proc) {

   vector3f gcolor;
   float    mtemp;
   vector3f mdeltac;                    // delta color stuff
   COMMON;
   SHADECOMMON;

   if (bitflags[FLAG_3D])
      shade_fcn = (void *)calc_color3pc;
   else if (bitflags[FLAG_2D])
      shade_fcn = (void *)calc_color2pc;
   else
      shade_fcn = (void *)calc_colorpc;

   colordata.diffuse = gcolor;

   winx = zbuff->maxx;
   winy = zbuff->maxy;

#define POLYGD

   if (bitflags[FLAG_RAYCAST]) {
#include "polyplate.c"
   }

   else {
#define INTZ
#include "polyplate.c"
#undef INTZ

   }

#undef POLYGD
}


/* **************************************************
************************************************** */
void polygon::polyal(eye *parm, light *lmain, light *spot, engine *proc) {

   float     mtemp;
   COMMON;
   SHADECOMMON;

   if (bitflags[FLAG_3D])
      shade_fcn = (void *)calc_color3;
   else if (bitflags[FLAG_2D])
      shade_fcn = (void *)calc_color2;
   else
      shade_fcn = (void *)calc_color;

   colordata.lmain = lmain;

   winx = zbuff->maxx;
   winy = zbuff->maxy;

#define POLYAL
   if (bitflags[FLAG_RAYCAST]) {
#include "polyplate.c"
   }

   else {
#define INTZ
#include "polyplate.c"
#undef INTZ
   }

#undef POLYAL

}


/* **************************************************
************************************************** */
void polygon::polypg(eye *parm, light *lmain, light *spot, engine *proc) {

   float mtemp;
   vector3f normal, snormal, enormal;
   vector4f temp;
   COMMON;
   SHADECOMMON;

   if (bitflags[FLAG_3D])
      shade_fcn = (void *)calc_color3;
   else if (bitflags[FLAG_2D])
      shade_fcn = (void *)calc_color2;
   else
      shade_fcn = (void *)calc_color;

   colordata.lmain = lmain;
   colordata.normal = normal;

   colordata.i = 0;

   winx = zbuff->maxx;
   winy = zbuff->maxy;

#define POLYPG
   if (bitflags[FLAG_RAYCAST]) {
#include "polyplate.c"
   }

   else {
#define INTZ
#include "polyplate.c"
#undef INTZ
   }

#undef POLYPG
}


/* **************************************************
************************************************** */
void polygon::beamrender(spotlight *spot, engine *proc) {

   polylt(spot, proc);
}


/* **************************************************
************************************************** */
void polygon::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   switch (mctype.model) {

      case PHONG:
         polypg(cparm, lmain, spot, proc);
         return;

      case FLAT:
         polyal(cparm, lmain, spot, proc);
         return;

      case GOURAUD:
         polygd(cparm, spot, proc);
         return;

      case CONSTANT:
         polyct(cparm, spot, proc);
         return;

      case BW:
         polybw(cparm, spot, proc);
         return;

      default:
         polywfbw(spot, proc);
         return;
   }

}


/* **************************************************
   This function scans polygonal data and puts it in a zbuffer.
************************************************** */
void polygon::prender(engine *proc) {

   register int i;                           // loop counter
   edgetype  *ptr, *qtr;

   for (ptr=et[ob->countobject]; ptr; qtr=ptr, ptr=(edgetype *)ptr->next, proc->control->push(MM_EDGE, qtr))
      proc->wireframe.insert(frame, round(ptr->start.point[0]), ptr->starty, round(ptr->epoint[0]), ptr->starty);

   for (i=0; i<ob->countobject; i++)                    // scan all the lines
      for (ptr=et[i]; ptr; qtr=ptr, ptr=(edgetype *)ptr->next, proc->control->push(MM_EDGE, qtr))
         proc->wireframe.insert(frame, round(ptr->start.point[0]), ptr->starty,round(ptr->epoint[0]), round(ptr->epoint[1]));
}
