

/* *************************************************************
   This function scans poligonal objects into a zbuffer
************************************************************* */


#include <string.h>

#include "polygon.h"


/* *************************************************************
************************************************************* */
void make_poly::setup_transfer(int vcount, int pcount) {

   int i, j;

   i = pcount << 1;
   j = pcount << 3;

   if (pob)
      delete pob;

   pob = new polytype;

   pob->build(vcount, i, j);
   pob->maxpolynum = 4;

   pob->countvertex = 0;
   pob->countobject = 0;
   pob->countedge   = 0;

   if (mcinfo.info & CITEXTURE) {

      if (tpob)
         delete tpob;

      tpob = new texpolygon(i);
      tpob->countobject = 0;
   }

   plob = new shadelist(i);
}


/* *************************************************************
************************************************************* */
int polygon::bound_box(eye *parm) {

   vector4f center;
   
   matvecmulto(parm->transform, bcenter, center);
   center[3] = 1.0f;

   // ll_corner        
   bbox[0][2] = center[2] - bradius;  

   if (bbox[0][2] > front)
      return 0;
   
   bbox[0][0] = center[0] - bradius;  
   bbox[0][1] = center[1] - bradius;  

   // ur_corner        
   bbox[1][0] = center[0] + bradius;  
   bbox[1][1] = center[1] + bradius;  
   bbox[1][2] = center[2] + bradius;  

   return 1;
}


/* *************************************************************
************************************************************* */
void polygon::setup_texture(texpolygon *stob) {

   tob = stob;
   uvblock = (texface *)stob->query_data();
}


/* *************************************************************
************************************************************* */
void polygon::setup_texture3d(shaderlisttype *stob)  {

   shaderlist = stob;
}


/* *************************************************************
   This function converts surface patch data into polygonal data
************************************************************* */
void polygon::setup_patch(polytype *sob, shadelist *slob,
                          colortype sctype, unsigned scinfo,
                          int sid, int ssflag, float  ssplane[],
                          vector4f *sworld, vector4f *siworld, float  box[][4], shadetype *c) {

   copyarray4(bbox[0], box[0]);
   copyarray4(bbox[1], box[1]);

   dob = ob = sob;
   pot = (polygon_object_type *)ob->query_data();

   ob->calc_normal();
   ob->calc_area();

   if (sctype >=PDOT)
      sctype = (colortype)(sctype - PDOT + DOT);

   mctype.model = sctype;
   mcinfo.info  = scinfo;
   id     = sid;

   copymx4x4o(world, sworld);
   copymx4x4o(iworld, siworld);

   polyflag = POLYFLAG_BOUNDBOX | POLYFLAG_TRANSFORM;

   if (mctype.model > BW) {
      base_color = c;
      lob = slob;
      if (lob)
         sblock = (shade_block *)lob->query_data();
   }
   
   else if (mctype.model < BW)
      polyflag |= POLYFLAG_BACKFACE_CULL;

   sflag = (ssflag) ? 2 : 0;

   copyarray4(splane, ssplane);
}


/* *************************************************************
   This procedure takes the basic object data, and creates a composite
   structure to be worked on.
************************************************************* */
void polygon::datacopy() {

   face_type *flist, *fend, *dlist;
   int *olist;
   polygon_object_type *dot;

   mctype.datacopy();
   mcinfo.datacopy();

   ob->build(dob->countvertex, dob->countobject, dob->countedge);

   pot = (polygon_object_type *)ob->query_data();
   dot = (polygon_object_type *)dob->query_data();

   ob->maxpolynum = dob->maxpolynum;

   memcpy(pot->vlist, dot->vlist, ob->countvertex*sizeof(vector4f));

   if (mctype.model == GOURAUD || mctype.model == PHONG)
      memcpy(pot->nlist, dot->nlist, ob->countvertex*sizeof(vector3f));

   // asdf possible optimization - dont copy this
   memcpy(pot->vindex, dot->vindex, ob->countedge*sizeof(int));

   flist = pot->flist;
   fend = flist + ob->countobject;
   olist = pot->vindex;

   dlist = dot->flist;

   if (lob) {
      base_color = &lob->base;
      sblock = (shade_block *)lob->query_data();
   }

   for (; flist<fend; olist += flist->polynum, flist++, dlist++) {
      flist->edgeptr = olist;
      copyarray3(flist->normal, dlist->normal);
      flist->polynum = dlist->polynum;
      flist->iarea = dlist->iarea;
   }

   polyflag = 0;

   if (mctype.model < BW)
      polyflag |= POLYFLAG_BACKFACE_CULL;

   if (mcinfo.info & CITEXTURE)
      uvblock = (texface *)tob->query_data();
}


/* **************************************************
************************************************** */
void polygon::begin_scan() {

   ob = new polytype;
}


/* **************************************************
************************************************** */
void polygon::end_scan() {

   if (!ob)
      return;

   delete ob;
   ob = NULL;
}


/* **************************************************
   This function scans polygonal data and puts it in a zbuffer.
************************************************** */
int polygon::scan(camera *cparm, light *lmain, engine *proc) {

   shadow    *str;
   face_type *flist;
   int i;

   renderflag = 0;

   proc->countvertex += ob->countvertex;

   if (!(polyflag & POLYFLAG_TRANSFORM))
      transform(cparm);                  // transform objects

   if (sflag && lmain && !NOSHADOW && !(mcinfo.info & (CITRANSPARENT | CIBITMAP))) {
      str = new shadow;
      str->begin_scan();

      str->datacopy2(this, cparm, lmain);
      shadptr = str;
   }

   removeside(cparm);

   if (!(polyflag & POLYFLAG_BOUNDBOX) && !bound_box(cparm))
      return 0;

   if (mctype.model > BW) {
      if (lmain) {
         for (i=0, flist=pot->flist; i<ob->countobject; i++, flist++)
            if (flist->polynum)
               lmain->set_ambient(sblock->facelist[i]->ka, flist->ambient, sblock->facelist[i]->lum);
      }

      else
         for (i=0, flist=pot->flist; i<ob->countobject; i++, flist++)
            if (flist->polynum)
                copyarray3(flist->ambient, (float)sblock->facelist[i]->lum);
   }

   if (!polyclet(cparm, lmain, proc->zbuff.maxx, proc->zbuff.maxy, proc))
      return 0;

   return renderflag = 1;
}


/* **************************************************
   This function scans polygonal data and puts it in a zbuffer.
************************************************** */
int polygon::beamscan(spotlight *spot, engine *proc) {

   edgetype     *ptr;

   renderflag = 0;

   if (mctype.model < BW || (mcinfo.info & CIBITMAP))
      return 0;

   mctype.model = BW;
   mcinfo.info = CINULL;

   if (!(polyflag & POLYFLAG_TRANSFORM))
      transform(spot);                  // transform objects

   if (!(polyflag & POLYFLAG_BACKFACE_CULL))
      removeside(spot);

   if (!ob->countobject || (!(polyflag & POLYFLAG_BOUNDBOX) && !bound_box(spot)))
      return 0;

   if (!polyclet(spot, (light *)NULL, spot->maxx, spot->maxy, proc))
      return 0;

   for (;et[ob->countobject]; ptr = et[ob->countobject], et[ob->countobject] = (edgetype *)ptr->next,  proc->control->push(MM_EDGE, ptr));     // delete horizontal lines

   renderflag = 1;

   return 1;
}
