


/* ***************************************************************
   this file handles the routines to manipulate polygons
**************************************************************** */

#include "polygon.h"


/* *************************************************************
   this function removes back face surfaces
************************************************************* */
void polygon::removeside(eye *parm) {

   face_type *flist, *fend;
   float *v;
   int i;
   vector3f work, cam;
   float t1, t2;
   vector4f mx[4];
   
   if (!(polyflag & POLYFLAG_TRANSFORM)) {

      // calc camera position in object space
      cam[0] = iworld[0][3];
      cam[1] = iworld[1][3];
      cam[2] = iworld[2][3];

      fend = pot->flist + ob->countobject;

      // backface cull in object space
      if (!(polyflag & POLYFLAG_BACKFACE_CULL))
         for (flist=pot->flist; flist<fend; flist++) {               // rotate face normals
            subeqarray3(work, pot->vlist[flist->edgeptr[0]], cam);
            if (dotproduct3(work, flist->normal) > 0)
               flist->polynum = 0;
         } 

      // xform the verticies
      for (i=0, v=(float *)pot->vlist; i<ob->countvertex; i++, v+=4)
         matvecmulto(world, v);

      // check if skew scaling
      work[0] = dotproduct3(world[0], world[0]);
      work[1] = dotproduct3(world[1], world[1]);
      work[2] = dotproduct3(world[2], world[2]);
      t1 = work[0] - work[1];
      t2 = work[1] - work[2];

      // if we have a skew/shear matrix, then recalc normals
      if (t1*t1 > CORRECT || t2*t2 > CORRECT) {
         ob->calc_normal();

         if (mctype.model == PHONG || mctype.model == GOURAUD)
            ob->calc_vnormal();

         return;
      }

      copymx4x4o(mx, world);
      t1 = (float)(1.0/sqrt(work[0]));
      smultarray3(mx[0], t1);
      smultarray3(mx[1], t1);
      smultarray3(mx[2], t1);
      
      for (flist=pot->flist; flist<fend; flist++) {               // rotate face normals
         if (!flist->polynum)
            continue;

         matvecmultv(mx, flist->normal);
         flist->normal[3] = -dotproduct3(flist->normal, pot->vlist[flist->edgeptr[0]]);
      }

      // rotate vertex normals
      if (mctype.model == PHONG || mctype.model == GOURAUD)
         for (i=0, v=(float *)pot->nlist; i<ob->countvertex; i++, v+=3)
            matvecmultv(mx, v);

      return;
   }

   // backface cull in camera space
   if (!(polyflag & POLYFLAG_BACKFACE_CULL)) {
      fend = pot->flist + ob->countobject;

      for (flist=pot->flist; flist<fend; flist++)
         if (flist->normal[3]< 0) // precalc the dotprod in transform()
            flist->polynum = 0;
   }

}


/* *************************************************************
   This procedure puts the object in the edge table
************************************************************* */
void polygon::transform(eye *parm) {

   vector3f work;

   // if bitmap, remove rotation for bitmaps :)
   if (mcinfo.info & CIBITMAP) {
      copymx4x4o(world, rotate);

      work[0] = world[0][3];
      work[1] = world[1][3];
      work[2] = world[2][3];

      matvecmulto(parm->transform, work);

      world[0][3] = work[0];
      world[1][3] = work[1];
      world[2][3] = work[2];
   }

   else {
      world[3][0] = world[3][1] = world[3][2] = 0;
      world[3][3] = 1;
      matmatmulto(parm->transform, rotate, world);
   }
   
   // calc inverse
   inversemx(world, iworld);
}
