

#include <stdlib.h>
#include <string.h>

#include "pstring.h"
#include "polygon.h"


/* *************************************************************
************************************************************* */
int polygon::query_whatwasi(int type) {

   return (polygon::query_whatami() == type) ? 1 : pc::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
int polygon::parse(FILE *infile, char *token) {

   vector4uc temp;

   switch (token[0]) {

      case '2':
         if (!strcmp(token, TOKEN_2D_TEXTURE_STR)) {
            get_token(infile, token);
            texname2.stringcpy(token);
            mcinfo.mask_or(CITEXTURE);
            return 1;
         }

         break;

      case 'b':
         if (!strcmp(token, TOKEN_BIPLANE_STR)) {
            mcinfo.mask_or(CIBITMAP);
            return 1;
         }

         break;

      case 'f':
         if (!strcmp(token, TOKEN_FILE_STR)) {
            get_token(infile, token);
            filename.stringcpy(token);
            return 1;
         }

         break;

      case 'i':
         if (!strcmp(token, TOKEN_INVISO_STR)) {
            get_token(infile, token);
            temp[3] = atoi(token);
            get_token(infile, token);
            temp[2] = atoi(token);
            get_token(infile, token);
            temp[1] = atoi(token);
            temp[0] = 0;
            inviso = *(int *)temp;
            mcinfo.mask_or(CIINVISO);

            return 1;
         }

         break;

      default:
         break;
   }

   return pc::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void polygon::preprocess(void *data) {

   colortype ilm;
   file_loader *loader;
      
   pc::preprocess(data);

   smultarray3(rotate[0], size);
   smultarray3(rotate[1], size);
   smultarray3(rotate[2], size);

   rotate[0][3] += center[0];
   rotate[1][3] += center[1];
   rotate[2][3] += center[2];

   if (!((frame_manager *)global_resource_manager)->query_render())
      return;

   loader = (file_loader *)global_resource_manager->find_resource_object(RESOURCE_POLYGON_LOADER, filename.string, NULL);
   
   if (!loader || !loader->read_data()) {
      sprintf(perror_buffer, "ERROR: Could not load \"%s\"... Aborting...\n", filename.string);
      pprintf(perror_buffer);
      exit(0);
   }

   // extract object
   dob = (polytype *)loader->extract(FILETYPE_SPG, filename.string);
   
   if (!dob || !dob->countobject) {
      sprintf(perror_buffer, "ERROR: Invalid data file \"%s\"... Aborting...\n", filename.string);
      pprintf(perror_buffer);
      exit(0);
   }
   
   // extract material
   if (colorname.string[0])
      lob = (shadelist *)loader->extract(FILETYPE_ILM, colorname.string);
   
   ilm = mctype.query_master();

   if ((ilm > BW && ilm <= PHONG) || ilm > PBW) {

      // extract texture
      if (mcinfo.query_master() & CITEXTURE) {
         tob = (texpolygon *)loader->extract(FILETYPE_TEX, texname2.string);

         if (!tob)
            mcinfo.mask_and(~CITEXTURE);
      }
            
      else if (mcinfo.query_master() & CI3DTEX)
         read_3dtex(texname3.string, filename.string);
   }

   loader->cleanup();
}


/* *************************************************************
************************************************************* */
void polygon::bound_sphere() {

   float mag, temp;

   matvecmulto(rotate, dob->bs_center, bcenter);
   
   mag = rotate[0][0]*rotate[0][0] + rotate[1][0]*rotate[1][0] + rotate[2][0]*rotate[2][0];

   temp = rotate[0][1]*rotate[0][1] + rotate[1][1]*rotate[1][1] + rotate[2][1]*rotate[2][1];
   if (temp > mag)
      mag = temp;

   temp = rotate[0][2]*rotate[0][2] + rotate[1][2]*rotate[1][2] + rotate[2][2]*rotate[2][2];
   if (temp > mag)
      mag = temp;

   bradius = (float)(dob->bs_radius * sqrt(mag));

   bvalid_flag = 1;
}


/* *************************************************************
************************************************************* */
int polygon::read_3dtex(char *filename, char *dfilename) {

   shaderlist = (shaderlisttype *)((frame_manager *)global_resource_manager)->read_tex3d(filename, dfilename, dob->countobject);

   if (!shaderlist) {
      mcinfo.mask_and(~CI3DTEX);
      return 0;
   }

   return 1;
}


/* *************************************************************
************************************************************* */
int polygon::dump_frame(FILE *outfile) {

   char token[4][MAXSTRLEN];
   int  i, j;
   unsigned int master;

   master = mcinfo.query_master();

   fprintf(outfile, "%s {\n", TOKEN_POLYGON_STR);

   sprintf(token[0], "\t%s ", TOKEN_SHADE_STR);
   sprintf(token[1], " %s\n", colorname.string);
   mctype.write_model(outfile, token[0], token[1]);

   if (master & CITEXTURE)
      fprintf(outfile, "\t%s %s\n", TOKEN_2D_TEXTURE_STR, texname2.string);
   if (master & CI3DTEX)
      fprintf(outfile, "\t%s %s\n", TOKEN_3D_TEXTURE_STR, texname3.string);

   fprintf(outfile, "\t%s %s\n", TOKEN_FILE_STR, filename.string);

   if (master & CIINVISO)
      fprintf(outfile, "\t%s %d %d %d\n", TOKEN_INVISO_STR, ((char *)&inviso)[3], ((char *)&inviso)[2], ((char *)&inviso)[1]);

   if (master & CIBITMAP)
      fprintf(outfile, "\t%s\n", TOKEN_BIPLANE_STR);

   if (master & CIRAYCAST)
      fprintf(outfile, "\t%s\n", TOKEN_RAYCAST_STR);

   if (master & CITRANSPARENT)
      fprintf(outfile, "\t%s\n", TOKEN_TRANSPARENT_STR);
   else if (sflag && !NOSHADOW) {
      float2char(splane[0], token[0]);
      float2char(splane[1], token[1]);
      float2char(splane[2], token[2]);
      float2char(splane[3], token[3]);
      fprintf(outfile, "\t%s %s %s %s %s\n", TOKEN_SHADOW_STR, token[0], token[1], token[2], token[3]);
   }

   fprintf(outfile, "\t%s ", TOKEN_TR_MATRIX_STR);
   for (i=0; i<4; i++)
      for (j=0; j<4; j++) {
         float2char(rotate[i][j], token[0]);
         fprintf(outfile, "%s ", token);
      }

   fprintf(outfile, "\n");

   fprintf(outfile, "\tframe %d\n", frame);
   fprintf(outfile, "}\n");

   return 1;
}

