

/* *************************************************************
   This file creates the edge table
************************************************************* */


#include <string.h>

#include "polygon.h"

#define X          0
#define Y          1
#define Z          2


/* *************************************************************
************************************************************* */
int polygon::clip(eye *parm, int maxx, int maxy) { return 0; }     // use polyclet instead


/* *************************************************************
        // can precalc length of edge...
************************************************************* */
pointlisttype *polygon::split_edge(pointtype *start, pointtype *end, int i, float plane, float *normal, eye *parm, memman *control, int texture_flag) {

   float factor;
   float temp1, temp2;
   pointlisttype *ptr;
   vector4f d;

   ptr = (pointlisttype *)control->pop(MM_POINTLIST);

   subeqarray3(d, end->point, start->point);

   factor = (plane-start->point[i])/d[i];

   ptr->pt.point[0] = start->point[0] + factor*d[0];
   ptr->pt.point[1] = start->point[1] + factor*d[1];
   ptr->pt.point[2] = (i==Z) ? plane : perspect(normal, ptr->pt.point, parm, &temp1, &temp2);

   switch (mctype.model) {
      case PHONG:
                                              // normal interp
         vector_interp_setup(start->gnormal, end->gnormal, 3, 1.0, d, &temp1);

         temp1 = factor * d[3];
         d[0] -= temp1;
         d[1] += temp1;

         vector_interp_eval(start->gnormal, end->gnormal, 3, d, ptr->pt.gnormal);
         break;

      case GOURAUD:
         ptr->pt.color[0] = start->color[0] + factor*(end->color[0] - start->color[0]);
         ptr->pt.color[1] = start->color[1] + factor*(end->color[1] - start->color[1]);
         ptr->pt.color[2] = start->color[2] + factor*(end->color[2] - start->color[2]);
         break;

      default:
         break;
   }

   // texture interp
   if (texture_flag) {
      ptr->pt.uvz[0] = start->uvz[0] + factor*(end->uvz[0]-start->uvz[0]);
      ptr->pt.uvz[1] = start->uvz[1] + factor*(end->uvz[1]-start->uvz[1]);
      ptr->pt.uvz[2] = start->uvz[2] + factor*(end->uvz[2]-start->uvz[2]);
   }
   
   return ptr;
}


/* *************************************************************
        // based on quakes line clipper
************************************************************* */
void polygon::clip_greater(pointlisttype **ptr, int i, float plane, float *normal, eye *parm, memman *control, int texture_flag) {

   pointlisttype *head, *qtr;
   pointtype start;
   int flag1, flag2;
   float bound;

   head = *ptr;
   *ptr = NULL;

   if (!head || !head->next || !head->next->next) {
      while (head) {
         qtr = head;
         head = (pointlisttype *)head->next;
         control->push(MM_POINTLIST, qtr);
      }

      return;
   }

   copyarray3(start.point, head->pt.point);
   copyarray3(start.uvz, head->pt.uvz);
   copyarray3(start.gnormal, head->pt.gnormal);

   bound = (float)(plane + CORRECT);

   qtr = (pointlisttype *)head->next;
   flag1 = head->pt.point[i] > bound;

   while (qtr) {

      flag2 = qtr->pt.point[i] > bound;

      if (!flag1) {
         *ptr = head;
         ptr = (pointlisttype **)&head->next;
      }

      if (flag1 + flag2 == 1) {
         *ptr = split_edge(&head->pt, &qtr->pt, i, plane, normal, parm, control, texture_flag);
         ptr = (pointlisttype **)&(*ptr)->next;
      }

      if (flag1)
         control->push(MM_POINTLIST, head);

      head = qtr;
      flag1 = flag2;
      qtr = (pointlisttype *)qtr->next;
   }

   flag2 = start.point[i] > bound;

   if (!flag1) {
      *ptr = head;
      ptr = (pointlisttype **)&head->next;
   }

   if (flag1 + flag2 == 1) {
      *ptr = split_edge(&head->pt, &start, i, plane, normal, parm, control, texture_flag);
      (*ptr)->next = NULL;
   }

   else
      *ptr = NULL;

   if (flag1)
      control->push(MM_POINTLIST, head);
}


/* *************************************************************
        // based on quakes line clipper
************************************************************* */
void polygon::clip_lesser(pointlisttype **ptr, int i, float plane, float *normal, eye *parm, memman *control, int texture_flag) {

   pointlisttype *head, *qtr;
   pointtype start;
   int flag1, flag2;
   float bound;

   head = *ptr;
   *ptr = NULL;

   if (!head || !head->next || !head->next->next) {
      while (head) {
         qtr = head;
         head = (pointlisttype *)head->next;
         control->push(MM_POINTLIST, qtr);
      }

      return;
   }

   copyarray3(start.point, head->pt.point);
   copyarray3(start.uvz, head->pt.uvz);
   copyarray3(start.gnormal, head->pt.gnormal);

   bound = (float)(plane - CORRECT);

   qtr = (pointlisttype *)head->next;
   flag1 = head->pt.point[i] < bound;

   while (qtr) {

      flag2 = qtr->pt.point[i] < bound;

      if (!flag1) {
         *ptr = head;
         ptr = (pointlisttype **)&head->next;
      }

      if (flag1 + flag2 == 1) {
         *ptr = split_edge(&head->pt, &qtr->pt, i, plane, normal, parm, control, texture_flag);
         ptr = (pointlisttype **)&(*ptr)->next;
      }

      if (flag1)
         control->push(MM_POINTLIST, head);

      head = qtr;
      flag1 = flag2;
      qtr = (pointlisttype *)qtr->next;
   }

   flag2 = start.point[i] < bound;

   if (!flag1) {
      *ptr = head;
      ptr = (pointlisttype **)&head->next;
   }

   if (flag1 + flag2 == 1) {
      *ptr = split_edge(&head->pt, &start, i, plane, normal, parm, control, texture_flag);
      (*ptr)->next = NULL;
   }

   else
      *ptr = NULL;

   if (flag1)
      control->push(MM_POINTLIST, head);
}


/* *************************************************************
   this function initiates an edge in the edge table
************************************************************* */
void polygon::prepare_edge(engine *proc, int face, pointtype *start, pointtype *end, int starty, int endy, int texture_flag) {

   float    deltay;
   float    work;
   edgetype **btr;
   edgetype *ptr, *qtr;

   deltay = 1.0f/(end->point[1] - start->point[1]);

   proc->countedge++;

   ptr = (edgetype *)proc->control->pop(MM_EDGE);

   ptr->starty = starty;
   ptr->endy = endy;

   ptr->start.point[0] = start->point[0];
   ptr->start.point[1] = (float)starty;
   ptr->start.point[2] = start->point[2];
   copyarray3(ptr->start.uvz, start->uvz);

   if (mctype.model > BW) {
      copyarray3(ptr->start.gnormal, start->gnormal);
   }

   else {
      copyarray3(ptr->epoint, end->point);
   }

   ptr->dx  = (end->point[0] - start->point[0]) * deltay;
   ptr->dz  = (end->point[2] - start->point[2]) * deltay;

   for (btr=&et[face], qtr=et[face]; qtr && starty > qtr->starty; btr=(edgetype **)&qtr->next, qtr=(edgetype *)qtr->next);

   ptr->next = qtr;
   *btr = ptr;

   switch (mctype.model) {
      case PHONG:                                       // phong
         vector_interp_setup(start->gnormal, end->gnormal, 3, deltay, ptr->dnormal, &work);
         copyarray3(ptr->enormal, end->gnormal);
         break;

      case GOURAUD:
         ptr->dcolor[0] = (end->color[0] - start->color[0]) * deltay;
         ptr->dcolor[1] = (end->color[1] - start->color[1]) * deltay;
         ptr->dcolor[2] = (end->color[2] - start->color[2]) * deltay;
         break;

      default:
         break;
   }

   if (texture_flag) {
       ptr->duvz[0] = (end->uvz[0] - start->uvz[0]) * deltay;
       ptr->duvz[1] = (end->uvz[1] - start->uvz[1]) * deltay;
       ptr->duvz[2] = (end->uvz[2] - start->uvz[2]) * deltay;
   }

}


/* *************************************************************
************************************************************* */
void polygon::prepare_hedge(engine *proc, int face, pointtype *start, pointtype *end, int starty) {

   int b, t;
   edgetype *ptr;

   b = round(start->point[0]);
   t = round(end->point[0]);

   if (b == t)
      return;

   proc->countedge++;

   ptr = (edgetype *)proc->control->pop(MM_EDGE);
   ptr->starty = starty;
   ptr->start.id = face;
   ptr->next = et[ob->countobject];
   et[ob->countobject] = ptr;

   copyarray3(ptr->start.point, start->point);
   copyarray2(ptr->epoint, end->point);

   ptr->dz = (start->point[2] - end->point[2]) / (start->point[0] - end->point[0]);
}


/* *************************************************************
   gouraud calculated here cause each face has different color
************************************************************* */
pointlisttype *polygon::edgelist(eye *parm, light *lmain, int i, int texture_flag, memman *control) {

   pointlisttype *ptr, *head;
   int j, k;
   float temp;
   int *sindex;
   int index;
   face_type *flist;
   
   flist = &pot->flist[i];
   
   k = flist->polynum;
   head = NULL;

   for (j=0, sindex=flist->edgeptr; j<k; j++) {
      index = sindex[j];
      
      ptr = (pointlisttype *)control->pop(MM_POINTLIST);

      copyarray3(ptr->pt.point, pot->vlist[index]);

      if (texture_flag) {
         tob->query_uvmap(i, j, ptr->pt.uvz);

         temp = 1.0f/ptr->pt.point[2];
         ptr->pt.uvz[0] *= temp;
         ptr->pt.uvz[1] *= temp;
         ptr->pt.uvz[2] = temp;
      }

      if (mctype.model == GOURAUD) {
         copyarray3(ptr->pt.color, flist->ambient);
         if (lmain)
            lmain->intensity(ptr->pt.point, pot->nlist[index], ptr->pt.color, parm, sblock->facelist[i], id);
      }

      else if (mctype.model == PHONG)
         copyarray3(ptr->pt.gnormal, pot->nlist[index]);

      ptr->next = head;
      head = ptr;
   }

   return head;
}


/* *************************************************************
   this procedure creates the main edge table
************************************************************* */
void polygon::add_edge_table_bw(engine *proc, eye *parm) {

   pointlisttype *qtr, *ptr, *head;
   int       *roundy;
   int       i;
   int       oldy, newy;
   face_type *flist;
   memman    *control = proc->control;
   float     *v;
   int       *sindex, *eindex;
    
   if (ob->maxpolynum < 3)
      return;

   roundy = (int *)control->pop(MM_BUFFER, ob->countvertex<<2);

   for (i=0, v=(float *)pot->vlist; i<ob->countvertex; i++, v+=4) {
      parm->map2screen(v);
      roundy[i] = round(v[1]);
   }

   flist = pot->flist;

   for (i=0; i<ob->countobject; i++, flist++) {

      if (flist->polynum<3)
         continue;

      proc->countface++;

      head = NULL;

      for (sindex=flist->edgeptr, eindex=flist->edgeptr+flist->polynum; sindex<eindex; sindex++) {
         ptr = (pointlisttype *)control->pop(MM_POINTLIST);
         copyarray3(ptr->pt.point, pot->vlist[*sindex]);
	 ptr->index = *sindex;
         ptr->next = head;
         head = ptr;
      }

      // trick - get pointer to last element, this will get pushed first
      //         last wont be pushed cause its already pushed :)
      for(ptr=head; ptr->next; ptr=(pointlisttype *)ptr->next);

      oldy = roundy[ptr->index];
      qtr = ptr;

      do {
         newy = roundy[head->index];

         if (oldy != newy) {
            if (oldy < newy)
               prepare_edge(proc, i, &ptr->pt, &head->pt, oldy, newy, 0);
            else
               prepare_edge(proc, i, &head->pt, &ptr->pt, newy, oldy, 0);
         }

         else if (mctype.model > SHADOW) {  // handles horizontal lines
            if (ptr->pt.point[0] < head->pt.point[0])
               prepare_hedge(proc, i, &ptr->pt, &head->pt, oldy);
            else
               prepare_hedge(proc, i, &head->pt, &ptr->pt, oldy);
         }

         oldy = newy;
         control->push(MM_POINTLIST, ptr);
         ptr = head;
         head=(pointlisttype *)head->next;
      } while (ptr != qtr);

   }

}


/* *************************************************************
   this procedure creates the main edge table
************************************************************* */
void polygon::add_edge_table_all(engine *proc, eye *parm, light *lmain) {

   pointlisttype *qtr, *ptr, *head;
   int i;
   int texture_flag = mcinfo.info & CITEXTURE;
   int face_texture_flag;
   int oldy, newy;
   face_type   *flist;
   float texscale  = parm->imscale/size;
   memman *control = proc->control;
   
   if (ob->maxpolynum < 3)
      return;

   flist = pot->flist;

   for (i=0; i<ob->countobject; i++, flist++) {

      if (flist->polynum<3)
         continue;

      proc->countface++;

      // build "edge" list
      face_texture_flag = texture_flag && tob->query_tflag(i);
      if (face_texture_flag) {
         flist->iarea *= uvblock[i].area * texscale;
         head = edgelist(parm, lmain, i, 1, control);
      }

      else
         head = edgelist(parm, lmain, i, 0, control);

      // trick - get pointer to last element, this will get pushed first
      //         last wont be pushed cause its already pushed :)
      for(ptr=head; ptr->next; ptr=(pointlisttype *)ptr->next)
         parm->map2screen(ptr->pt.point);

      parm->map2screen(ptr->pt.point);
      oldy = round(ptr->pt.point[1]);
      qtr = ptr;

      do {
         newy = round(head->pt.point[1]);

         if (oldy != newy) {
            if (oldy < newy)
               prepare_edge(proc, i, &ptr->pt, &head->pt, oldy, newy, face_texture_flag);
            else
               prepare_edge(proc, i, &head->pt, &ptr->pt, newy, oldy, face_texture_flag);
         }

         oldy = newy;
         control->push(MM_POINTLIST, ptr);
         ptr = head;
         head=(pointlisttype *)head->next;
      } while (ptr != qtr);

   }

}


/* *************************************************************
   this function is the main clipping routine
************************************************************* */
int polygon::polyclet(eye *parm, light *lmain, int maxx, int maxy, engine *proc) {

   float         extreme[2][4];
   int           i, k;
   pointlisttype *head, *ptr, *qtr;
   int           clipcode;
   int           texture_flag = mcinfo.info & CITEXTURE;
   int           face_texture_flag;
   int           hlineflag = mctype.model > SHADOW && mctype.model < CONSTANT;
   face_type     *flist;
   float         fmaxx, fmaxy;
   float         texscale  = parm->imscale/size;
   memman        *control = proc->control;
   int           oldy, newy;
   int           *sindex, *eindex;
   
   if (bbox[0][2] > front ||
       parm->zscale(bbox[0][0], bbox[0][2]) > parm->vrc[1] ||     // outside boundaries
       parm->zscale(bbox[1][0], bbox[0][2]) < parm->vrc[0] ||
       parm->zscale(bbox[0][1], bbox[0][2]) > parm->vrc[3] ||
       parm->zscale(bbox[1][1], bbox[0][2]) < parm->vrc[2])    {

      ob->countobject = 0;
      return 0;
   }

   i = (ob->countobject+1)<<2;
   et = (edgetype **)control->pop(MM_ET, i);

   memset(et, 0, i);

   if (mctype.model == CONSTANT)
      constcolor(parm, lmain);

   if (bbox[1][2] < front &&
       parm->zscale(bbox[0][0], bbox[1][2]) > parm->vrc[0] &&      // outside boundaries
       parm->zscale(bbox[1][0], bbox[1][2]) < parm->vrc[1] &&
       parm->zscale(bbox[0][1], bbox[1][2]) > parm->vrc[2] &&
       parm->zscale(bbox[1][1], bbox[1][2]) < parm->vrc[3]) {

      if (mctype.model > BW)
         add_edge_table_all(proc, parm, lmain);
      else
         add_edge_table_bw(proc, parm);

      return 1;
   }

   flist = pot->flist;
   fmaxx = maxx-1.0f;
   fmaxy = maxy-1.0f;

   for (i=0; i<ob->countobject; i++, flist++) {
      if (flist->polynum < 3)
          continue;

      proc->countface++;

      sindex=flist->edgeptr;
      eindex=flist->edgeptr+flist->polynum;
      
      // bound polygon box
      copyarray3(extreme[0], pot->vlist[*sindex]);
      copyarray3(extreme[1], extreme[0]);

      for (sindex++; sindex<eindex; sindex++)
         for (k=0; k<3; k++)
            if (extreme[0][k] > pot->vlist[*sindex][k])
               extreme[0][k] = pot->vlist[*sindex][k];
            else if (extreme[1][k] < pot->vlist[*sindex][k])
               extreme[1][k] = pot->vlist[*sindex][k];

      if (extreme[0][2] > front ||            // outside boundaries
          parm->zscale(extreme[0][0], extreme[0][2]) > parm->vrc[1] ||
          parm->zscale(extreme[1][0], extreme[0][2]) < parm->vrc[0] ||
          parm->zscale(extreme[0][1], extreme[0][2]) > parm->vrc[3] ||
          parm->zscale(extreme[1][1], extreme[0][2]) < parm->vrc[2])
         continue;

      face_texture_flag = texture_flag && tob->query_tflag(i);
      
      if (face_texture_flag) {
         flist->iarea *= uvblock[i].area * texscale;
         head = edgelist(parm, lmain, i, 1, control);
      }

      else
         head = edgelist(parm, lmain, i, 0, control);

      if (extreme[1][2] > front)
         clip_greater(&head, Z, front, flist->normal, parm, control, face_texture_flag);

      clipcode = 0;

      for (ptr=head; ptr; ptr=(pointlisttype *)ptr->next) { // map to screen

         parm->map2screen(ptr->pt.point);

         if (ptr->pt.point[0] < 0.0)
            clipcode |= 0x02;
         else if (ptr->pt.point[0] > fmaxx)
            clipcode |= 0x01;

         if (ptr->pt.point[1] < 0.0)
            clipcode |= 0x04;
         else if (ptr->pt.point[1] > fmaxy)
            clipcode |= 0x08;
      }

      if (clipcode & 0x02)
         clip_lesser(&head, X, 0.0, flist->normal, parm, control, face_texture_flag);

      if (clipcode & 0x01)
         clip_greater(&head, X, fmaxx, flist->normal, parm, control, face_texture_flag);

      if (clipcode & 0x04)
         clip_lesser(&head, Y, 0.0, flist->normal, parm, control, face_texture_flag);

      if (clipcode & 0x08)
         clip_greater(&head, Y, fmaxy, flist->normal, parm, control, face_texture_flag);

      if (!head)
         continue;

      for (ptr=head; ptr->next; ptr = (pointlisttype *)ptr->next);

      oldy = round(ptr->pt.point[1]);
      qtr = ptr;

      do {
         newy = round(head->pt.point[1]);

         if (oldy != newy) {
            if (oldy < newy)
               prepare_edge(proc, i, &ptr->pt, &head->pt, oldy, newy, face_texture_flag);
            else
               prepare_edge(proc, i, &head->pt, &ptr->pt, newy, oldy, face_texture_flag);
         }

         else if (hlineflag)   // handles horizontal lines
            if (ptr->pt.point[0] < head->pt.point[0])
               prepare_hedge(proc, i, &ptr->pt, &head->pt, oldy);
            else
               prepare_hedge(proc, i, &head->pt, &ptr->pt, oldy);

         oldy = newy;
         control->push(MM_POINTLIST, ptr);
         ptr = head;
         head=(pointlisttype *)head->next;
      } while (ptr != qtr);

   }

   return 1;
}
