

#include <stdlib.h>
#include <string.h>

#include "pstring.h"
#include "particle.h"


/* *************************************************************
************************************************************* */
particle::particle() {

   color[0] = color[1] = color[2] = 255.0;
   bradius = 0;
}


/* *************************************************************
************************************************************* */
int particle::query_whatwasi(int type) {

   return (particle::query_whatami() == type) ? 1 : pc::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
int particle::parse(FILE *infile, char *token) {

   switch (token[0]) {

      case 'l':
         if (!strcmp(token, TOKEN_LOCATION_STR)) {
            get_token(infile, token);
            center[0] = (float)atof(token);
            get_token(infile, token);
            center[1] = (float)atof(token);
            get_token(infile, token);
            center[2] = (float)atof(token);

            return 1;
         }

         break;

      case 's':         // before base
         if (!strcmp(token, TOKEN_SHADE_STR)) {
            get_token(infile, token);
            lower_case(token);

            switch (token[0]) {

               case 'w':
                  if (!strcmp(token, SHADE_WFBW_STR)) {
                     mctype.set_master(WFBW);
                     return 1;
                  }

                  return 0;

               case 'g':
                  if (!strcmp(token, SHADE_GOURAUD_STR)) {
                     mctype.set_master(GOURAUD);

                     get_token(infile, token);
                     color[0] = (float)(atof(token)*255);
                     get_token(infile, token);
                     color[1] = (float)(atof(token)*255);
                     get_token(infile, token);
                     color[2] = (float)(atof(token)*255);
                     return 1;
                  }

                  return 0;

               default:
                  return 0;
            }

         }

         break;

      default:
         break;
   }

   return pc::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void particle::preprocess(void *data) {

   pc::preprocess(data);
}


/* *************************************************************
************************************************************* */
void particle::bound_sphere() {

   bvalid_flag = 1;
   copyarray3(bcenter, center);
}


/* *************************************************************
************************************************************* */
int particle::bound_box(eye *parm) {

   copyarray3(bbox[0], wwai);
   copyarray3(bbox[1], wwai);

   return 1;
}


/* *************************************************************
   this is the basic particle clipper
************************************************************* */
int particle::clip(eye *parm, int maxx, int maxy) {

   if (wwai[2] >= front)
      return 0;

   parm->map2screen(wwai);

   iwai[0] = round(wwai[0]);
   iwai[1] = round(wwai[1]);

   return (iwai[0] >= 0 && iwai[0] < maxx && iwai[1] >= 0 && iwai[1] < maxy);
}


/* *************************************************************
   This procedure puts the object in the edge table
************************************************************* */
void particle::transform(eye *parm) {

   matvecmulto(parm->transform, wwai);
}


/* *************************************************************
************************************************************* */
void particle::datacopy() {

   mctype.datacopy();
   mcinfo.datacopy();

   copyarray3(wwai, center);
   wwai[3] = 1;

   copyarray3(wcolor, color);
}


/* **************************************************
************************************************** */
void particle::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   vector3f black = {0,0,0};
   int index;
   flt2int_type a0, a1, a2, d0, d1, d2;
   float *color = wcolor;
   zbuffer *zbuff = &proc->zbuff;

   index = iwai[1];

   index = index*zbuff->maxx + iwai[0];

   if ((mcinfo.info & CIOVERWRITE) || wwai[2] > zbuff->zdata[index])
      if (mctype.model == GOURAUD)
         if (mcinfo.info & CITRANSPARENT) {
            set_datatr(zbuff, index, color, black, a0, a1, a2, d0, d1, d2);
         }

         else if (mcinfo.info & CIGHOST) {
            set_nzbuff(zbuff, index, color, black, a0, a1, a2, d0, d1, d2);
         }

         else {
            set_zdata(zbuff, index, wwai[2], color, black, a0, a1, a2, d0, d1, d2);
         }

      else {
         if (!(mcinfo.info & CIGHOST))
            zbuff->zdata[index] = wwai[2];

         zbuff->data[index]  = 0xffffffff;
         zbuff->adata[index] = 0xffffffff;
      }

}


/* **************************************************
************************************************** */
int particle::scan(camera *cparm, light *lmain, engine *proc) {

   shadowpt *str;

   renderflag = 0;

   if (sflag && lmain && !NOSHADOW && !(mcinfo.info & CITRANSPARENT)) {
      str = new shadowpt;
      str->begin_scan();
      if (str->datacopy2(this, lmain))
         shadptr = str;
      else {
         str->end_scan();
         delete str;
      }

   }

   transform(cparm);         // transform objects

   if (!bound_box(cparm) || !clip(cparm, proc->zbuff.maxx, proc->zbuff.maxy))
      return 0;

   renderflag = 1;
   return 1;
}


/* **************************************************
************************************************** */
void particle::prender(engine *proc) {

   proc->wireframe.insert(frame, iwai[0], iwai[1], iwai[0], iwai[1]);
}


/* **************************************************
************************************************** */
int particle::beamscan(spotlight *lparm, engine *proc) {

   renderflag = 0;

   transform(lparm);         // transform objects

   if (!bound_box(lparm) || !clip(lparm, lparm->maxx, lparm->maxy))
      return 0;

   renderflag = 1;
   return 1;
}


/* **************************************************
************************************************** */
void particle::beamrender(spotlight *lparm, engine *proc) {

   int   i, j;

   j = iwai[0];
   i = iwai[1];

   if (wwai[2] > lparm->lbuff->lbuff.pdata[i][j].zdata) {
      lparm->lbuff->lbuff.pdata[i][j].zdata = wwai[2];
      lparm->lbuff->lbuff.pdata[i][j].idbuff = id;
   }

}


/* **************************************************
************************************************** */
int particle::dump_frame(FILE *outfile) {

   char token[4][MAXSTRLEN];

   fprintf(outfile, "%s {\n", TOKEN_PARTICLE_STR);

   if (mctype.model == GOURAUD) {
      float2char(color[0], token[0]);
      float2char(color[1], token[1]);
      float2char(color[2], token[2]);
      fprintf(outfile, "\t%s %s %s %s\n", SHADE_GOURAUD_STR, token[0], token[1], token[2]);
   }

   else
      fprintf(outfile, "\t%s\n", SHADE_WFBW_STR);

   if (mcinfo.info & CITRANSPARENT)
      fprintf(outfile, "\t%s\n", TOKEN_TRANSPARENT_STR);
   else if (sflag && !NOSHADOW) {
      float2char(splane[0], token[0]);
      float2char(splane[1], token[1]);
      float2char(splane[2], token[2]);
      float2char(splane[3], token[2]);
      fprintf(outfile, "\t%s %s %s %s %s\n", TOKEN_SHADOW_STR, token[0], token[1], token[2], token[3]);
   }

   float2char(center[0], token[0]);
   float2char(center[1], token[1]);
   float2char(center[2], token[2]);
   fprintf(outfile, "\t%s %s %s %s\n", TOKEN_LOCATION_STR, token[0], token[1], token[2]);

   fprintf(outfile, "\tframe %d\n", frame);
   fprintf(outfile, "}\n");

   return 1;
}
