

#include <stdio.h>
#include "memman.h"


/* ************************************************************
************************************************************ */
memman::memman(int maxlists, int maxbuffers) {

   listmem     = new dbl_llist_manager[maxlists];
   buffermem   = new buffertype[maxbuffers];
   listcount   = maxlists;
   buffercount = maxbuffers;
}


/* ************************************************************
************************************************************ */
memman::~memman() {

   if (listmem)
      delete [] listmem;

   if (buffermem)
      delete [] buffermem;
}


/* ************************************************************
************************************************************ */
void *memman::pop(int item, int size) {

   dbl_llist *ptr;

   if (size) {
      buffertype *ptr = buffermem + item;

      if (ptr->buffer) {
         if (ptr->size >= size)
            return ptr->buffer;

         delete [] ptr->buffer;
      }

      ptr->size = (size+3) & 0xfffffffc;
      return ptr->buffer = new char[ptr->size];
   }

   if (listmem[item].head) {
      ptr = listmem[item].head;
      listmem[item].remove(ptr);
      return ptr;
   }

   switch (item) {

      case MM_EDGE:
         return new edgetype;

      case MM_POINTLIST:
         return new pointlisttype;

      default:          // MM_LIGHTBUFF
         return new lightbufftype;
   }

}


/* ************************************************************
************************************************************ */
void memman::push(int item, dbl_llist *mem) {

   listmem[item].insert(mem, NULL);
}

