

#include <string.h>
#include "mctype.h"


/* *************************************************************
   This function prints out data for shading
************************************************************* */
void shading_model::write_model(FILE *outfile, char *prestring, char *poststring) {

    char *ptr;

    switch (master_model) {

        case DOT:
            ptr = SHADE_DOT_STR;
            break;

        case WFBW:
            ptr = SHADE_WFBW_STR;
            break;

        case BW:
            ptr = SHADE_BW_STR;
            break;

        case CONSTANT:
            ptr = SHADE_CONSTANT_STR;
            break;

        case GOURAUD:
            ptr = SHADE_GOURAUD_STR;
            break;

        case FLAT:
            ptr = SHADE_FLAT_STR;
            break;

        case PHONG:
            ptr = SHADE_PHONG_STR;
            break;

        case PDOT:
            ptr = SHADE_PDOT_STR;
            break;

        case PWFBW:
            ptr = SHADE_PWFBW_STR;
            break;

        case PBW:
            ptr = SHADE_PBW_STR;
            break;

        case PCONSTANT:
            ptr = SHADE_PCONSTANT_STR;
            break;

        case PGOURAUD:
            ptr = SHADE_PGOURAUD_STR;
            break;

        case PFLAT:
            ptr = SHADE_PFLAT_STR;
            break;

        case PPHONG:
            ptr = SHADE_PPHONG_STR;
            break;

        case IRRADIANT:
            ptr = SHADE_IRRADIANT_STR;
            break;

        case RSOLID:
            ptr = SHADE_RSOLID_STR;
            break;

        default:                    // should never get here ...
            ptr = SHADE_WFBW_STR;

    }

    fprintf(outfile, "%s%s%s", prestring, ptr, poststring);
}


int shading_model::parse(char *token) {

   switch (token[0]) {
      case 'a':
         if (!strcmp(token, SHADE_FALLAETX_STR)) {
            master_model = FLAT;
            return 1;
         }

         return 0;

      case 'b':
         if (!strcmp(token, SHADE_BW_STR)) {
            master_model = BW;
            return 1;
         }

         return 0;

      case 'c':
         if (!strcmp(token, SHADE_CONSTANT_STR)) {
            master_model = CONSTANT;
            return 1;
         }

         return 0;

      case 'd':
         if (!strcmp(token, SHADE_DOT_STR)) {
            master_model = DOT;
            return 1;
         }

         return 0;

      case 'f':
         if (!strcmp(token, SHADE_FLAT_STR)) {
            master_model = FLAT;
            return 1;
         }

         return 0;

      case 'g':                        // line/particle called before this
         if (!strcmp(token, SHADE_GOURAUD_STR)) {
            master_model = GOURAUD;
            return 1;
         }

         return 0;

      case 'i':
         if (!strcmp(token, SHADE_IRRADIANT_STR)) {
            master_model = IRRADIANT;
            return 1;
         }

         return 0;

      case 'p':
         if (!strcmp(token, SHADE_PHONG_STR)) {
            master_model = PHONG;
            return 1;
         }

         if (strlen(token) < 2)
            return 0;

         switch (token[1]) {

            case 'a':
               if (!strcmp(token, SHADE_PFALLAETX_STR)) {
                  master_model = PFLAT;
                  return 1;
               }

               return 0;

            case 'b':
               if (!strcmp(token, SHADE_PBW_STR)) {
                  master_model = PBW;
                  return 1;
               }

               return 0;

            case 'c':
               if (!strcmp(token, SHADE_PCONSTANT_STR)) {
                  master_model = PCONSTANT;
                  return 1;
               }

               return 0;

            case 'd':
               if (!strcmp(token, SHADE_PDOT_STR)) {
                  master_model = PDOT;
                  return 1;
               }

               return 0;

            case 'f':
               if (!strcmp(token, SHADE_PFLAT_STR)) {
                  master_model = PFLAT;
                  return 1;
               }

               return 0;

            case 'g':
               if (!strcmp(token, SHADE_PGOURAUD_STR)) {
                  master_model = PGOURAUD;
                  return 1;
               }

               return 0;

            case 'p':
               if (!strcmp(token, SHADE_PPHONG_STR)) {
                  master_model = PPHONG;
                  return 1;
               }

               return 0;

            case 'w':
               if (!strcmp(token, SHADE_PWFBW_STR)) {
                  master_model = PWFBW;
                  return 1;
               }

               return 0;

            default:
               return 0;
         }

      case 'r':
         if (!strcmp(token, SHADE_RSOLID_STR)) {
            master_model = RSOLID;
            return 1;
         }

         return 0;

      case 'w':
         if (!strcmp(token, SHADE_WFBW_STR)) {
            master_model = WFBW;
            return 1;
         }

         return 0;

      default:
         return 0;
   }

}


char SHADE_DOT_STR[]        = "dot";
char SHADE_WFBW_STR[]       = "wfbw";
char SHADE_BW_STR[]         = "bw";
char SHADE_CONSTANT_STR[]   = "constant";
char SHADE_GOURAUD_STR[]    = "gouraud";
char SHADE_FLAT_STR[]       = "flat";
char SHADE_FALLAETX_STR[]   = "alex";
char SHADE_PHONG_STR[]      = "phong";
char SHADE_PDOT_STR[]       = "pdot";
char SHADE_PWFBW_STR[]      = "pwfbw";
char SHADE_PBW_STR[]        = "pbw";
char SHADE_PCONSTANT_STR[]  = "pconstant";
char SHADE_PGOURAUD_STR[]   = "pgouraud";
char SHADE_PFLAT_STR[]      = "pflat";
char SHADE_PFALLAETX_STR[]  = "palex";
char SHADE_PPHONG_STR[]     = "pphong";
char SHADE_RSOLID_STR[]     = "rsolid";
char SHADE_IRRADIANT_STR[]  = "irradiant";
