

#include <stdlib.h>
#include <string.h>

#include "pstring.h"
#include "line.h"


/* *************************************************************
************************************************************* */
int line::query_whatwasi(int type) {

   return (line::query_whatami() == type) ? 1 : pc::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
int line::parse(FILE *infile, char *token) {

   switch (token[0]) {

      case 'p':
         if (!strcmp(token, TOKEN_POINT_STR)) {
            get_token(infile, token);
            center[0] = (float)atof(token);
            get_token(infile, token);
            center[1] = (float)atof(token);
            get_token(infile, token);
            center[2] = (float)atof(token);

            get_token(infile, token);
            wwi[0] = (float)atof(token);
            get_token(infile, token);
            wwi[1] = (float)atof(token);
            get_token(infile, token);
            wwi[2] = (float)atof(token);

            return 1;
         }

         break;

      case 's':         // before base
         if (!strcmp(token, TOKEN_SHADE_STR)) {
            get_token(infile, token);
            lower_case(token);

            switch (token[0]) {

               case 'w':
                  if (!strcmp(token, SHADE_WFBW_STR)) {
                     mctype.set_master(WFBW);
                     return 1;
                  }

                  return 0;

               case 'g':
                  if (!strcmp(token, SHADE_GOURAUD_STR)) {
                     mctype.set_master(GOURAUD);

                     get_token(infile, token);
                     color[0][0] = (float)(atof(token)*255.0);
                     get_token(infile, token);
                     color[0][1] = (float)(atof(token)*255.0);
                     get_token(infile, token);
                     color[0][2] = (float)(atof(token)*255.0);

                     get_token(infile, token);
                     color[1][0] = (float)(atof(token)*255.0);
                     get_token(infile, token);
                     color[1][1] = (float)(atof(token)*255.0);
                     get_token(infile, token);
                     color[1][2] = (float)(atof(token)*255.0);

                     return 1;
                  }

                  return 0;

               default:
                  break;
            }

            return 0;
         }

         break;

      default:
         break;
   }

   return pc::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void line::preprocess(void *data) {

   pc::preprocess(data);
}


/* *************************************************************
************************************************************* */
void line::bound_sphere() {

   vector3f v;

   bcenter[0] = (float)(0.5 * (center[0] + wwi[0]));
   bcenter[1] = (float)(0.5 * (center[1] + wwi[1]));
   bcenter[2] = (float)(0.5 * (center[2] + wwi[2]));

   subeqarray3(v, bcenter, wwi);
   bradius = (float)magnitude3(v);

   bvalid_flag = 1;
}


/* *************************************************************
************************************************************* */
int line::bound_box(eye *parm) {

   int i;

   copyarray3(bbox[0], wwai[0]);
   copyarray3(bbox[1], wwai[0]);

   for (i=0; i<3; i++)
      if (bbox[0][i] > wwai[1][i])
         bbox[0][i] = wwai[1][i];
      else if (bbox[1][i] < wwai[1][i])
         bbox[1][i] = wwai[1][i];

   return 1;
}


/* *************************************************************
************************************************************* */
int line::clip(eye *parm, int maxx, int maxy) {

   int      i, k;                            // loop variables
   float    d;

   if (bbox[1][2] < front &&                    // w/in boundaries
       parm->zscale(bbox[0][0], bbox[1][2]) > parm->vrc[0] &&      // outside boundaries
       parm->zscale(bbox[1][0], bbox[1][2]) < parm->vrc[1] &&
       parm->zscale(bbox[0][1], bbox[1][2]) > parm->vrc[2] &&
       parm->zscale(bbox[1][1], bbox[1][2]) < parm->vrc[3]) {

      parm->map2screen(wwai[0]);
      parm->map2screen(wwai[1]);

      return 1;
   }

   if (bbox[0][2] > front ||
       parm->zscale(bbox[0][0], bbox[0][2]) > parm->vrc[1] ||     // outside boundaries
       parm->zscale(bbox[1][0], bbox[0][2]) < parm->vrc[0] ||
       parm->zscale(bbox[0][1], bbox[0][2]) > parm->vrc[3] ||
       parm->zscale(bbox[1][1], bbox[0][2]) < parm->vrc[2])
      return 0;

   for (i=0; i<2; i++) {                // clip Z
      k = (!i);

      if (wwai[i][2] > front) {
         d = wwai[k][2] - wwai[i][2];

         if (fabs(d) < CORRECT)
            return 0;

         d = (front-wwai[i][2]) / d;

         if (d < 0 || d > 1)
            return 0;

         wwai[i][0] += d * (wwai[k][0] - wwai[i][0]);
         wwai[i][1] += d * (wwai[k][1] - wwai[i][1]);
         wwai[i][2] = front;

         if (mctype.model == GOURAUD) {
            wcolor[k][0] += d * (wcolor[k][0] - wcolor[i][0]);
            wcolor[k][1] += d * (wcolor[k][1] - wcolor[i][1]);
            wcolor[k][2] += d * (wcolor[k][2] - wcolor[i][2]);
         }

         break;
      }

   }

   parm->map2screen(wwai[0]);
   parm->map2screen(wwai[1]);

   for (i=0; i<2; i++) {                // clip x
      k = (!i);

      if (wwai[i][0] < 0) {
         d = wwai[k][0] - wwai[i][0];

         if (fabs(d) < 0.5)
            return 0;

         d = -wwai[i][0] / d;

         if (d < 0 || d > 1)
            return 0;

         wwai[i][0] = 0;
         wwai[i][1] += d * (wwai[k][1] - wwai[i][1]);
         wwai[i][2] += d * (wwai[k][2] - wwai[i][2]);

         if (mctype.model == GOURAUD) {
            wcolor[i][0] += d * (wcolor[k][0] - wcolor[i][0]);
            wcolor[i][1] += d * (wcolor[k][1] - wcolor[i][1]);
            wcolor[i][2] += d * (wcolor[k][2] - wcolor[i][2]);
         }

      }

      else if (wwai[i][0] > maxx) {
         d = wwai[k][0] - wwai[i][0];

         if (fabs(d) < 0.5)
            return 0;

         d = (maxx-wwai[i][0]) / d;

         if (d < 0 || d > 1)
            return 0;

         wwai[i][0] = (float)maxx;
         wwai[i][1] += d * (wwai[k][1] - wwai[i][1]);
         wwai[i][2] += d * (wwai[k][2] - wwai[i][2]);

         if (mctype.model == GOURAUD) {
            wcolor[i][0] += d * (wcolor[k][0] - wcolor[i][0]);
            wcolor[i][1] += d * (wcolor[k][1] - wcolor[i][1]);
            wcolor[i][2] += d * (wcolor[k][2] - wcolor[i][2]);
         }

      }

   }

   for (i=0; i<2; i++) {                // clip y
      k = (!i);

      if (wwai[i][1] < 0) {
         d = wwai[k][1] - wwai[i][1];

         if (fabs(d) < 0.5)
            return 0;

         d = -wwai[i][1] / d;

         if (d < 0 || d > 1)
            return 0;

         wwai[i][0] += d * (wwai[k][0] - wwai[i][0]);
         wwai[i][1] = 0;
         wwai[i][2] += d * (wwai[k][2] - wwai[i][2]);

         if (mctype.model == GOURAUD) {
            wcolor[i][0] += d * (wcolor[k][0] - wcolor[i][0]);
            wcolor[i][1] += d * (wcolor[k][1] - wcolor[i][1]);
            wcolor[i][2] += d * (wcolor[k][2] - wcolor[i][2]);
         }

      }

      else if (wwai[i][1] > maxy) {

         d = wwai[k][1] - wwai[i][1];

         if (fabs(d) < 0.5)
            return 0;

         d = (maxy-wwai[i][1]) / d;

         if (d < 0 || d > 1)
            return 0;

         wwai[i][0] += d * (wwai[k][0] - wwai[i][0]);
         wwai[i][1] = (float)maxy;
         wwai[i][2] += d * (wwai[k][2] - wwai[i][2]);

         if (mctype.model == GOURAUD) {
            wcolor[i][0] += d * (wcolor[k][0] - wcolor[i][0]);
            wcolor[i][1] += d * (wcolor[k][1] - wcolor[i][1]);
            wcolor[i][2] += d * (wcolor[k][2] - wcolor[i][2]);
         }

      }

   }

   return 1;
}


/* *************************************************************
   This procedure puts the object in the edge table
************************************************************* */
void line::transform(eye *parm) {

   matvecmulto(parm->transform, wwai[0]);
   matvecmulto(parm->transform, wwai[1]);
}


/* *************************************************************
************************************************************* */
void line::datacopy() {

   mctype.datacopy();
   mcinfo.datacopy();

   copyarray3(wwai[0], center);
   wwai[0][3] = 1;

   copyarray3(wwai[1], wwi);
   wwai[1][3] = 1;

   if (mctype.model == GOURAUD) {
      copyarray3(wcolor[0], color[0]);
      copyarray3(wcolor[1], color[1]);
   }

}


/* **************************************************
************************************************** */
void line::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   int    h, i, j, k, l;
   int    scany;
   float  delta[2][3];
   float  pt[3];
   float  m;
   vector3f c, dc, hc;
   int flagtr = (mcinfo.info & CITRANSPARENT) == CITRANSPARENT;
   int ghostflag = (mcinfo.info & CIGHOST) == CIGHOST;
   int overwriteflag = (mcinfo.info & CIOVERWRITE) == CIOVERWRITE;
   int scanxy, index;
   flt2int_type a0, a1, a2, d0, d1, d2;
   vector3f black = { 0, 0, 0 };
   zbuffer *zbuff = &proc->zbuff;

   j = (wwai[0][1] <= wwai[1][1]);
   i = (!j);                            // i is the smaller y

   h = (int)wwai[j][1];
   scany = (int)wwai[i][1];

   if (scany == h)
      h++;

   m = (float)(1.0/(h-scany));

   scanxy = scany * zbuff->maxx;

   delta[0][0] = (wwai[j][0] - wwai[i][0])*m;
   delta[0][1] = (wwai[j][2] - wwai[i][2])*m;

   switch (mctype.model) {

      case GOURAUD:

         dc[0] = (wcolor[j][0] - wcolor[i][0])*m;
         dc[1] = (wcolor[j][1] - wcolor[i][1])*m;
         dc[2] = (wcolor[j][2] - wcolor[i][2])*m;

         m = (float)(1.0/fabs(delta[0][0]));
         delta[1][2] = delta[0][1]*m;
         hc[0] = dc[0]*m;
         hc[1] = dc[1]*m;
         hc[2] = dc[2]*m;

         do {
            if (delta[0][0] > 0) {
               pt[0] = wwai[i][0];
               pt[1] = pt[0] + delta[0][0];
               pt[2] = wwai[i][2];

               copyarray3(c, wcolor[i]);
            }

            else {
               pt[1] = wwai[i][0];
               pt[0] = pt[1] + delta[0][0];
               pt[2] = wwai[i][2] + delta[0][1];

               c[0] = wcolor[i][0] + dc[0];
               c[1] = wcolor[i][1] + dc[1];
               c[2] = wcolor[i][2] + dc[2];
            }

            l = (int)pt[0];
            k = (int)pt[1];
            index = scanxy + l;

            do {
               if (overwriteflag || pt[2] > zbuff->zdata[index])
                  if (flagtr) {
                     set_datatr(zbuff, index, c, black, a0, a1, a2, d0, d1, d2);
                  }

                  else if (ghostflag) {
                     set_nzbuff(zbuff, index, c, black, a0, a1, a2, d0, d1, d2);
                  }

                  else {
                     set_zdata(zbuff, index, pt[2], c, black, a0, a1, a2, d0, d1, d2);
                  }

               pt[2] += delta[1][2];
               addarray3(c, hc);
               l++; index++;
            } while (l<k);

            wwai[i][0] += delta[0][0];
            wwai[i][2] += delta[0][1];
            addarray3(wcolor[i], dc);

            scany++;

            scanxy+=zbuff->maxx;

         }  while (scany < h);

         break;

      default:  //case WFBW:

         delta[1][2] = (float)(delta[0][1]/fabs(delta[0][0]));

         do {

            if (delta[0][0] > 0) {
               pt[0] = wwai[i][0];
               pt[1] = pt[0] + delta[0][0];
               pt[2] = wwai[i][2];
            }

            else {
               pt[1] = wwai[i][0];
               pt[0] = pt[1] + delta[0][0];
               pt[2] = wwai[i][2] + delta[0][1];
            }

            l = (int)pt[0];
            k = (int)pt[1];
            index = l + scanxy;

            do {
               if (overwriteflag || pt[2] > zbuff->zdata[index]) {
                  if (!ghostflag)
                     zbuff->zdata[index] = pt[2];

                  zbuff->data[index] = zbuff->adata[index] = 0xffffffff;
               }

               pt[2] += delta[1][2];
               l++, index++;
            } while (l<k);

            wwai[i][0] += delta[0][0];
            wwai[i][2] += delta[0][1];

            scany++;
            scanxy+=zbuff->maxx;

         }  while (scany < h);

         break;
   }

}


/* **************************************************
************************************************** */
int line::scan(camera *cparm, light *lmain, engine *proc) {

   shadline *str;

   renderflag = 0;

   if (sflag && lmain && !NOSHADOW && !(mcinfo.info & CITRANSPARENT)) {
      str = new shadline;
      str->begin_scan();
      if (str->datacopy2(this, lmain))
         shadptr = str;
      else {
         str->end_scan();
         delete str;
      }

   }

   transform(cparm);         // transform objects

   if (!bound_box(cparm) || !clip(cparm, proc->zbuff.maxx-1, proc->zbuff.maxy-1))
      return 0;

   renderflag = 1;
   return 1;
}


/* **************************************************
************************************************** */
void line::prender(engine *proc) {

   proc->wireframe.insert(frame, round(wwai[0][0]), round(wwai[0][1]), round(wwai[1][0]), round(wwai[1][1]));
}


/* **************************************************
************************************************** */
int line::beamscan(spotlight *spot, engine *proc) {

   renderflag = 0;

   mctype.model = WFBW;
   mcinfo.info = CINULL;

   transform(spot);         // transform objects

   if (!bound_box(spot) || !clip(spot, spot->maxx-1, spot->maxy-1))
      return 0;

   renderflag = 1;
   return 1;
}


/* **************************************************
************************************************** */
void line::beamrender(spotlight *spot, engine *proc) {

   int    h, i, j, k, l;
   int    scany;
   float  delta[2][6];
   float  pt[6];
   float  m;

   j = (wwai[0][1] <= wwai[1][1]);
   i = (!j);

   h = (int)wwai[j][1];
   scany = (int)wwai[i][1];

   if (scany == h)
      h++;

   m = (float)(1.0/(h-scany));
   delta[0][0] = (wwai[j][0] - wwai[i][0])*m;
   delta[0][1] = (wwai[j][2] - wwai[i][2])*m;

   delta[1][2] = (float)(delta[0][1]/fabs(delta[0][0]));

   do {

      if (delta[0][0] > 0) {
         pt[0] = wwai[i][0];
         pt[1] = pt[0] + delta[0][0];
         pt[2] = wwai[i][2];
      }

      else {
         pt[1] = wwai[i][0];
         pt[0] = pt[1] + delta[0][0];
         pt[2] = wwai[i][2] + delta[0][1];
      }

      l = (int)pt[0];
      k = (int)pt[1];

      do {
         if (pt[2] > spot->lbuff->lbuff.pdata[scany][l].zdata) {
            spot->lbuff->lbuff.pdata[scany][l].zdata  = pt[2];
            spot->lbuff->lbuff.pdata[scany][l].idbuff = id;
         }

         pt[2] += delta[1][2];
         l++;
      } while (l<k);

      wwai[i][0] += delta[0][0];
      wwai[i][2] += delta[0][1];
      scany++;
   }  while (scany < h);

}


/* **************************************************
************************************************** */
int line::dump_frame(FILE *outfile) {

   char token[4][MAXSTRLEN];

   fprintf(outfile, "%s {\n", TOKEN_LINE_STR);

   if (mctype.model == GOURAUD) {
      float2char(color[0][0], token[0]);
      float2char(color[0][1], token[1]);
      float2char(color[0][2], token[2]);
      fprintf(outfile, "\t%s %s %s %s ", SHADE_GOURAUD_STR, token[0], token[1], token[2]);
      float2char(color[1][0], token[0]);
      float2char(color[1][1], token[1]);
      float2char(color[1][2], token[2]);
      fprintf(outfile, "%s %s %s\n", token[0], token[1], token[2]);
   }

   else
      fprintf(outfile, "\t%s\n", SHADE_WFBW_STR);

   if (mcinfo.info & CITRANSPARENT)
      fprintf(outfile, "\t%s\n", TOKEN_TRANSPARENT_STR);
   else if (sflag && !NOSHADOW) {
      float2char(splane[0], token[0]);
      float2char(splane[1], token[1]);
      float2char(splane[2], token[2]);
      float2char(splane[3], token[2]);
      fprintf(outfile, "\t%s %s %s %s %s\n", TOKEN_SHADOW_STR, token[0], token[1], token[2], token[3]);
   }

   float2char(center[0], token[0]);
   float2char(center[1], token[1]);
   float2char(center[2], token[2]);
   fprintf(outfile, "\t%s %s %s %s ", TOKEN_LOCATION_STR, token[0], token[1], token[2]);
   float2char(wwi[0], token[0]);
   float2char(wwi[1], token[1]);
   float2char(wwi[2], token[2]);
   fprintf(outfile, "%s %s %s\n", token[0], token[1], token[2]);

   fprintf(outfile, "\tframe %d\n", frame);
   fprintf(outfile, "}\n");
   return 1;
}
