

#include <string.h>

#include "geo.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
int geo::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_2D_TEXTURE_STR)) {
      get_token(infile, token);
      texname2.stringcpy(token);
      mcinfo.mask_or(CITEXTURE);
      return 1;
   }

   return make_poly::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void geo::preprocess(void *data) {

   colortype ilm;

   make_poly::preprocess(data);

   ilm = mctype.query_master();

   if (!((frame_manager *)global_resource_manager)->query_render())
      return;

   if (colorname.string[0])
      lob = (shadelist *)((frame_manager *)global_resource_manager)->read_ilm(colorname.string, 1);
   
   if ((ilm > BW && ilm <= PHONG) || ilm > PBW) {

      if (mcinfo.query_master() & CITEXTURE)
         read_tex(texname2.string);
      else if (mcinfo.query_master() & CI3DTEX)
         read_3dtex(texname3.string);
   }

}


/* *************************************************************
************************************************************* */
int geo::read_tex(char *filename) {

   tob = (texbase *)((frame_manager *)global_resource_manager)->read_tex(filename);

   if (!tob) {
      mcinfo.mask_and(~CITEXTURE);
      return 0;
   }

   texcoord[1][0] = texcoord[0][0] = texcoord[3][1] = texcoord[0][1] = 0.0;
   texcoord[2][1] = texcoord[1][1] = (float)(tob->maxy-1);
   texcoord[3][0] = texcoord[2][0] = (float)(tob->maxx-1);

   return 1;
}


/* *************************************************************
************************************************************* */
int geo::read_3dtex(char *filename) {

   shaderlist = (shaderlisttype *)((frame_manager *)global_resource_manager)->read_tex3d(filename, "__GEO__", 1);

   if (!shaderlist) {
      mcinfo.mask_and(~CI3DTEX);
      return 0;
   }

   return 1;
}


/* *************************************************************
************************************************************* */
int geo::bound_box(eye *parm) {

   return bbox[0][2] <= front;
}


/* *************************************************************
        bbox is made by children
************************************************************* */
unsigned int geo::query_texel(float tx, float ty, float *c, float d) {

   float a, b;

   a = (tx - (int)tx)*texcoord[2][0];
   b = (ty - (int)ty)*texcoord[2][1];

   return tob->query_texel(a, b, c, frame, d);
}

/* *************************************************************
        bbox is made by children
************************************************************* */
int geo::clip(eye *parm, int maxx, int maxy) {

   vector3f corner;

   if (bbox[0][2] > front ||
       parm->zscale(bbox[0][0], bbox[0][2]) > parm->vrc[1] ||     // outside boundaries
       parm->zscale(bbox[1][0], bbox[0][2]) < parm->vrc[0] ||
       parm->zscale(bbox[0][1], bbox[0][2]) > parm->vrc[3] ||
       parm->zscale(bbox[1][1], bbox[0][2]) < parm->vrc[2])
      return 0;

   copyarray3(corner, bbox[0]);

   parm->map2screen(corner);

   row[0] = round(corner[1]);
   col[0] = round(corner[0]);

   corner[0] = bbox[1][0];
   corner[1] = bbox[1][1];
   corner[2] = bbox[0][2];

   parm->map2screen(corner);

   row[1] = round(corner[1]);
   col[1] = round(corner[0]);

   corner[0] = bbox[0][0];
   corner[1] = bbox[0][1];
   corner[2] = bbox[1][2];

   parm->map2screen(corner);

   if (row[0] > corner[1])
      row[0] = round(corner[1]);
   if (col[0] > corner[0])
      col[0] = round(corner[0]);

   copyarray3(corner, bbox[1]);

   parm->map2screen(corner);

   if (row[1] < corner[1])
      row[1] = round(corner[1]);
   if (col[1] < corner[0])
      col[1] = round(corner[0]);

   if (col[0] < 0)
      col[0] = 0;

   if (col[1] >= maxx)
      col[1] = maxx-1;

   if (row[0] < 0)
      row[0] = 0;

   if (row[1] >= maxy)
      row[1] = maxy-1;

   return 1;
}


/* **************************************************
************************************************** */
int geo::beamscan(spotlight *lparm, engine *proc) {

   int i;

   renderflag = 0;

   if (mctype.model < BW)
      return 0;

   mcinfo.info = CINULL;
   mctype.model =  (mctype.model > PWFBW) ? PBW : BW;

   transform(lparm);

   if (!(i=bound_box(lparm)))
      return 0;

   if (i==2) {
      polyob.setup_patch(pob, plob, BW, CINULL, id, 0, splane, world, iworld, bbox, base_color);

      renderflag = SCANPOLY;

      return polyob.beamscan(lparm, proc);
   }

   if (!clip(lparm, lparm->maxx, lparm->maxy))
      return 0;

   if (mctype.model == BW) {
      geo2poly((texpolygon **)NULL, (shaderlisttype *)NULL);
      polyob.setup_patch(pob, plob, BW, CINULL, id, 0, splane, bbox, world, iworld, base_color);

      renderflag = SCANPOLY;

      return polyob.beamscan(lparm, proc);
   }

   renderflag = SCANCAST;
   return 1;
}


/* **************************************************
************************************************** */
void geo::beamrender(spotlight *lparm, engine *proc) {

   switch (renderflag) {

      case SCANPOLY:
         polyob.beamrender(lparm, proc);
         return;

      case SCANCAST:
         lt(lparm);
         return;
   }

}


/* **************************************************
************************************************** */
int geo::scan(camera *cparm, light *lmain, engine *proc) {

   int i;
   shadow *str;

   renderflag = 0;

   transform(cparm);

   if (!(i=bound_box(cparm)))
      return 0;

   if (i == 2) {
      polyob.setup_patch(pob, plob, mctype.model, mcinfo.info, id, sflag, splane, world, iworld, bbox, base_color);
      i = polyob.scan(cparm, lmain, proc);
      shadptr = polyob.shadptr;

      if (!i)
         return 0;
	 
      renderflag = SCANPOLY;
      return i;
   }

   if (!clip(cparm, proc->zbuff.maxx, proc->zbuff.maxy))
      return 0;

   if (mctype.model < PFLAT) {
      geo2poly(&tpob, &slist);
      polyob.setup_patch(pob, plob, mctype.model, mcinfo.info, id, sflag, splane, world, iworld, bbox, base_color);

      if ((mcinfo.info & CITEXTURE))
         polyob.setup_texture(tpob);

      if ((mcinfo.info & CI3DTEX))
         polyob.setup_texture3d(&slist);

      i = polyob.scan(cparm, lmain, proc);
      shadptr = polyob.shadptr;

      if (!i)
         return 0;
	 
      renderflag = SCANPOLY;
      return i;
   }

   if (sflag && lmain && !NOSHADOW && !(mcinfo.info & CITRANSPARENT)) {
      geo2poly((texpolygon **)NULL, (shaderlisttype *)NULL);
      polyob.setup_patch(pob, plob, FLAT, 0, id, 1, splane, world, iworld, bbox, base_color);

      str = new shadow;
      str->begin_scan();

      if (str->datacopy2(&polyob, cparm, lmain))
         shadptr = str;
      else {
         str->end_scan();
         delete str;
      }

      polyob.end_scan();
   }

   renderflag = SCANCAST;
   return 1;
}


/* **************************************************
************************************************** */
void geo::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   switch (renderflag) {

      case SCANPOLY:
         polyob.render(cparm, lmain, spot, proc);
         return;

      case SCANCAST:
         pg(cparm, lmain, spot, &proc->zbuff);
         return;
   }

}


/* **************************************************
************************************************** */
void geo::prender(engine *proc) {

   polyob.prender(proc);
}


/* **************************************************
************************************************** */
void geo::begin_scan() {

   tpob = (texpolygon *)NULL;
}


/* **************************************************
************************************************** */
void geo::end_scan() {

   int i;

   if (tpob)
      delete [] tpob;

   if (slist.shade) {
      for (i=0; i<slist.scount; i++) {
         slist.shade[i].s = NULL;
         slist.shade[i].stype = NULL;
      }

      delete [] slist.shade;
      slist.shade = NULL;
   }

   if (plob) {
      delete plob;
      plob = NULL;
   }
   
   if (renderflag == SCANPOLY)
      polyob.end_scan();
}

