

#include "base.h"


/* *************************************************************
************************************************************* */
void engine::cullnsort(eye *parm, pc *list, pc **start_list, pc **final_list, int direction) {

   pc *ptr, *head, *last, *boundless, *culled, *culled_last;
   pc **qtr;
   float dist;

   head = list;
   last = list = boundless = culled = culled_last = NULL;

   while (head) {
      ptr = head;
      head = (pc *)head->next;

      if (!ptr->bvalid_flag) {
         ptr->next = boundless;
         boundless = ptr;
         continue;
      }

      if (parm->query_frustum_clip(ptr->bradius, ptr->bcenter, &dist)) {

         if (!culled_last)
            culled_last = ptr;

         ptr->next = culled;
         culled = ptr;
         continue;
      }

      ptr->bwork = dist + ptr->bradius;

      if (!last) {
         list = last = ptr;
         ptr->next = NULL;
         continue;
      }

      // sort based on farthest distance
      if (ptr->groundflag == MIDGROUND) {

         if (direction == SORT_ASCENDING) {
            for (qtr=(pc **)&list; *qtr; qtr=(pc **)&(*qtr)->next)
               if (ptr->bwork <= (*qtr)->bwork) {
                  ptr->next = *qtr;
                  *qtr = ptr;
                  break;
               }

         }

         else { // SORT_DECENDING
            for (qtr=(pc **)&list; *qtr; qtr=(pc **)&(*qtr)->next)
               if (ptr->bwork >= (*qtr)->bwork) {
                  ptr->next = *qtr;
                  *qtr = ptr;
                  break;
               }

         }

      }

      else {
         for (qtr=(pc **)&list; *qtr; qtr=(pc **)&(*qtr)->next)
            if (ptr->renderpriority <= (*qtr)->renderpriority) {
               ptr->next = *qtr;
               *qtr = ptr;
               break;
            }

      }

      if (*qtr)
         continue;

      ptr->next = NULL;
      last->next = ptr;
      last = ptr;
   }

   if (boundless)
      if (!list)
         list = boundless;
      else
         last->next = boundless;

   if (culled)
      culled_last->next = list;
   else
      culled = list;

   *start_list = list;
   *final_list = culled;
}


/* *************************************************************
************************************************************* */
void engine::cull(eye *parm, pc *list, pc **start_list, pc **final_list) {

   pc *ptr, *head, *last, *boundless, *culled, *culled_last;
   float dist;

   head = list;
   last = list = boundless = culled = culled_last = NULL;

   while (head) {
      ptr = head;
      head = (pc *)head->next;

      if (!ptr->bvalid_flag) {
         ptr->next = boundless;
         boundless = ptr;
         continue;
      }

      if (parm->query_frustum_clip(ptr->bradius, ptr->bcenter, &dist)) {

         if (!culled_last)
            culled_last = ptr;

         ptr->next = culled;
         culled = ptr;
         continue;
      }

      if (!last)
         last = ptr;

      ptr->next = list;
      list = ptr;
   }

   if (boundless)
      if (!list)
         list = boundless;
      else
         last->next = boundless;

   if (culled)
      culled_last->next = list;
   else
      culled = list;

   *start_list = list;
   *final_list = culled;
}


/* *************************************************************
************************************************************* */
void engine::engine_init() {

   frame.init();
   countedge = countvertex = countface = 0;
}


/* *************************************************************
************************************************************* */
void engine::engine_submit(frameclass *ob) {

   light **lit;
   pc    **obj;

   switch (ob->query_category()) {

      case CLASS_LIGHT:
         lit = (((light *)ob)->query_class() == GLOBAL_LIGHT) ? &frame.lightdtr : &frame.beamdtr;
         ob->next = *lit;
         *lit = (light *)ob;
         return;

      case CLASS_CAMERA:
         ob->next = frame.camdtr;
         frame.camdtr = (camera *)ob;
         return;

      case CLASS_OBJECT:

         if (((pc *)ob)->mcinfo.query_master() & CITRANSPARENT)
            obj = &frame.transtr[((pc *)ob)->groundflag];
         else if (((pc *)ob)->mcinfo.query_master() & CIINVISO)
            obj = &frame.invisotr[((pc *)ob)->groundflag];
         else
            obj = &frame.solidtr[((pc *)ob)->groundflag];

         ob->next = *obj;
         *obj = (pc *)ob;
         (*obj)->bound_sphere();
         return;

      default:
         return;
   }

}

