

#include <stdlib.h>
#include <string.h>

#include "cylinder.h"
#include "pstring.h"


#define COUNTVERTEX   20
                // COUNTVERTEX/2
#define COUNTSIDE     10
                // countside + 2
#define COUNTOBJECT   12
                // 1.0/countside
#define ICOUNTSIDE    0.1
                // countside*4
#define COUNTSIDEEDGE 40
                // countsideedge + 2*countside
#define COUNTEDGE     60


/* *************************************************************
************************************************************* */
int cylinder::query_whatwasi(int type) {

   return (cylinder::query_whatami() == type) ? 1 : pc::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
int cylinder::parse(FILE *infile, char *token) {

   switch (token[0]) {

      case 'l':
         if (!strcmp(token, TOKEN_LENGTH_STR)) {
            get_token(infile, token);
            master_length = (float)atof(token);
            master_hlength = (float)(master_length * 0.5);

            return 1;
         }

         break;

      case 'r':
         if (!strcmp(token, TOKEN_RADIUS_STR)) {
            get_token(infile, token);
            master_radius = (float)atof(token);

            return 1;
         }

         break;

      default:
         break;
   }

   return geo::parse(infile, token);
}


/* **************************************************
************************************************** */
void cylinder::preprocess(void *data) {

   geo::preprocess(data);

   master_length *= size;
   master_hlength *= size;
   master_radius *= size;

   rotate[0][3] += center[0];
   rotate[1][3] += center[1];
   rotate[2][3] += center[2];
}


/* **************************************************
************************************************** */
void cylinder::bound_sphere() {

   float mag, temp;
   vector4f r[4];

   bcenter[0] = rotate[0][3];
   bcenter[1] = rotate[1][3];
   bcenter[2] = rotate[2][3];

   transpose(r, rotate);

   mag = dotproduct3(r[0], r[0]);

   temp = dotproduct3(r[1], r[1]);
   if (temp > mag)
      mag = temp;

   temp = dotproduct3(r[2], r[2]);
   if (temp > mag)
      mag = temp;

   bradius = (float)sqrt(mag *(master_radius*master_radius + master_hlength*master_hlength));

   bvalid_flag = 1;
}


/* **************************************************
************************************************** */
void cylinder::datacopy() {

   mcinfo.datacopy();
   mctype.datacopy();

   if (lob)
      base_color = &lob->base;

   length = master_length;
   radius = master_radius;
   hlength = master_hlength;

   pob = NULL;
   plob = NULL;
}


/* *************************************************************
************************************************************* */
float cylinder::calc_area() {

   return cylinder_area(radius, length);
}


/* *************************************************************
************************************************************* */
void cylinder::pg(eye *parm, light *lmain, light *spot, zbuffer *zbuff) {

   int  i, j;
   float surface[4], pzero[4];
   float temp[2];
   vector4f normal;
   float pt[4];
   float t;
   int   side;
   int   flag;
   vector3f rcolor, acolor, tcolor;
   char  flag2t = (mcinfo.info & CITEXTURE) == CITEXTURE;
   char  flag3t = (mcinfo.info & CI3DTEX) == CI3DTEX;
   char  flagtr = (mcinfo.info & CITRANSPARENT) == CITRANSPARENT;
   int  ghostflag = (mcinfo.info & CIGHOST) == CIGHOST;
   int  overwriteflag = (mcinfo.info & CIOVERWRITE) == CIOVERWRITE;
   int   inflag;
   int scanxy, index;
   flt2int_type a0, a1, a2, d0, d1, d2;

   texcolortype texcolor;
   shaderparamtype sparam;
   color_calc_data colordata;
   void *shade_fcn;

   float piinverse = (float)(1.0/PI);
   float ratio;
   float tx, ty;
   float di, dj, wi, wj, wt;

   float area;

   colordata.ob = this;
   colordata.surface = surface;
   colordata.normal = normal;
   colordata.spot = (flagtr ? (light *)NULL : spot);
   colordata.parm = parm;
   colordata.texcolor = &texcolor;
   colordata.tcolor = tcolor;
   colordata.sparam = &sparam;
   colordata.i = 0;
   colordata.rcolor = rcolor;
   colordata.acolor = acolor;
   colordata.lmain = lmain;

   if (flag3t) {
      shade_fcn = (void *)calc_color3;
      sparam.setup(world, iworld, frame, parm, this, shaderlist->scale);
   }

   else if (flag2t) {
      shade_fcn = (void *)calc_color2;
      area = parm->query_scale();
      area = (float)sqrt((tob->maxx*tob->maxy)/(calc_area()*area*area));
   }

   else
      shade_fcn = (void *)calc_color;

   ratio = (float)(1.0/length);

   normal[3] = 0;

   texcolor.set(base_color);

   if (lmain)
      lmain->set_ambient(texcolor.color.ka, texcolor.ambient, texcolor.color.lum);
   else
      copyarray3(texcolor.ambient, (float)texcolor.color.lum);

   pzero[0] = iworld[0][3];
   pzero[1] = iworld[1][3];
   pzero[2] = iworld[2][3];
   pzero[3] = 1;

   surface[0] = (float)col[0];
   surface[1] = (float)row[0];
   surface[2] = -1;
   surface[3] = 1;
   parm->screen2map(surface);

   di = dj = (float)(1.0/parm->query_scale());

   wt = surface[0];
   wi = surface[1];

   scanxy = row[0] * zbuff->maxx;
   for (i=row[0]; i<=row[1]; i++, wi+=di, scanxy += zbuff->maxx) {

      for (j=col[0], index = scanxy + col[0], wj=wt, inflag = 0; j<=col[1]; j++, wj+=dj, index++) {
         surface[0] = wj;
         surface[1] = wi;
         surface[2] = -1;

         matvecmultv(iworld, surface, pt);

         flag = line_cylinder_intersect(pzero, pt, hlength, radius, &t, &side);

         if (!flag) {
            if (inflag)
               break;

            continue;
         }

         inflag = 1;

         if (overwriteflag || -t>zbuff->zdata[index]) {
            surface[0] *= t;
            surface[1] *= t;
            surface[2] = -t;

            switch (side) {

               case CYL_TOP:
                  normal[0] = normal[2] = 0;
                  normal[1] = 1;
                  break;

               case CYL_BOTTOM:
                  normal[0] = normal[2] = 0;
                  normal[1] = -1;
                  break;

               default:                      // CYL_SIDE
                  normal[0] = pzero[0] + t*pt[0];
                  normal[2] = pzero[2] + t*pt[2];
                  normal[1] = 0;
                  break;
            }

            matvecmultv(world, normal);
            normalize3(normal);

            if (flag2t) {
               smultarray3(pt, t);
               addarray3(pt, pzero);

               switch(side) {

                  case CYL_TOP:
                     ty = 1;
                     break;

                  case CYL_BOTTOM:
                     ty = 0;
                     break;

                  default:
                     ty = (pt[1] + hlength)*ratio;
                     break;
               }

               normalize3(pt);

               temp[0] = pt[0];
               temp[1] = pt[2];
               normalize2(temp);
               tx = (float)(0.5 * ((temp[0] >= 0.0) ? (ACOS(temp[1])*piinverse) : (2-ACOS(temp[1])*piinverse)));

               query_texel(tx, ty, tcolor, area*(-surface[2]));
            }

            ((void (*)(color_calc_data *))shade_fcn)(&colordata);

            if (flagtr) {
               set_datatr(zbuff, index, acolor, rcolor, a0, a1, a2, d0, d1, d2);
            }

            else if (ghostflag) {
               set_nzbuff(zbuff, index, acolor, rcolor, a0, a1, a2, d0, d1, d2);
            }

            else {
               set_zdata(zbuff, index, surface[2], acolor, rcolor, a0, a1, a2, d0, d1, d2);
            }

         }

      }

   }

}


/* *************************************************************
************************************************************* */
void cylinder::lt(spotlight *spot) {

   int i, j;
   float surface[4], pzero[4];
   float t;
   int   side;
   int   flag;
   float wi, wj, wt, di, dj;
   int   inflag;

   surface[0] = (float)col[0];
   surface[1] = (float)row[0];
   surface[2] = -1;
   surface[3] = 1;
   copyarray3(pzero, surface);

   spot->screen2map(surface);

   pzero[0] += 1;
   pzero[1] += 1;
   pzero[3] = 0;
   spot->screen2map(pzero);

   dj = pzero[0] - surface[0];
   di = pzero[1] - surface[1];
   wt = surface[0];
   wi = surface[1];

   if (spot->query_whatami() == OBJECT_POINT) {
      pzero[0] = iworld[0][3];
      pzero[1] = iworld[1][3];
      pzero[2] = iworld[2][3];
      pzero[3] = 1;

      surface[3] = 0;
   }

   else {
      pzero[0] = -iworld[0][2];
      pzero[1] = -iworld[1][2];
      pzero[2] = -iworld[2][2];
      pzero[3] = 0;

      surface[3] = 1;
   }

   for (i=row[0]; i<=row[1]; i++, wi+=di)
      for (j=col[0], wj=wt, inflag = 0; j<=col[1]; j++, wj+=dj) {

         surface[0] = wj;
         surface[1] = wi;

         if (spot->query_whatami() == OBJECT_POINT) {
            surface[2] = -1;
            matvecmultv(iworld, surface);
            flag = line_cylinder_intersect(pzero, surface, hlength, radius, &t, &side);
         }

         else {
            surface[2] = 0;
            matvecmulto(iworld, surface);
            flag = line_cylinder_intersect(surface, pzero, hlength, radius, &t, &side);
         }

         if (!flag) {
            if (inflag)
               break;
         }

         else {
            inflag = 1;

            if (-t>spot->lbuff->lbuff.pdata[i][j].zdata) {
               spot->lbuff->lbuff.pdata[i][j].zdata = -t;
               spot->lbuff->lbuff.pdata[i][j].idbuff = id;
            }

         }

      }

}


/* *************************************************************
************************************************************* */
void cylinder::transform(eye *parm) {

   int i, j;
   vector4f box[8];

   matmatmulto(parm->transform, rotate, world);
   world[3][0] = world[3][1] = world[3][2] = 0;
   world[3][3] = 1;

   wcenter[0] = world[0][3];
   wcenter[1] = world[1][3];
   wcenter[2] = world[2][3];
   wcenter[3] = 1;

   inversemx(world, iworld);

   bbox[0][0] = -radius;
   bbox[0][1] = -hlength;
   bbox[0][2] = -radius;
   bbox[0][3] = 1;

   bbox[1][0] = radius;
   bbox[1][1] = hlength;
   bbox[1][2] = radius;
   bbox[1][3] = 1;

   make_box(bbox, box);

   matvecmulto(world, box[0], bbox[0]);
   copyarray3(bbox[1], bbox[0]);

   for (i=1; i<8; i++) {
      matvecmulto(world, box[i]);

      for (j=0; j<3; j++)
         if (box[i][j] < bbox[0][j])
            bbox[0][j] = box[i][j];
         else if (box[i][j] > bbox[1][j])
            bbox[1][j] = box[i][j];
   }

}


/* *************************************************************
************************************************************* */
void cylinder::geo2poly(texpolygon **ptob, shaderlisttype *slist) {

   int i, j, k, l;
   float fi, fd;
   float x, z;
   float tx, td, tx2;
   vector2f uv[4];
   int      textureflag = (mcinfo.info & CITEXTURE) && ptob;
   polygon_object_type *ptr;
   shade_block *sblock;
   
   pob = new polytype;

   pob->build(COUNTVERTEX, COUNTOBJECT, COUNTEDGE);
   pob->maxpolynum = COUNTSIDE;

   ptr = (polygon_object_type *)pob->query_data();
   
   if (ptob) {
      if (textureflag) {
         *ptob = new texpolygon;
         (*ptob)->setup(COUNTOBJECT);
      }

      if (mctype.model > BW)
         plob = new shadelist(COUNTOBJECT);
   
      if (mcinfo.info & CI3DTEX) {
         slist->scount = COUNTOBJECT;
         slist->shade = new shadertype[COUNTOBJECT];
      }
   }
   
   for (i=0, j=COUNTSIDE, fi=-HALFPI, fd = TWOPI*ICOUNTSIDE; i < COUNTSIDE; i++, j++, fi += fd) {
      x = COS(fi);              // could precalc cos/sin in a table (only 10 entries each)
      z = -SIN(fi);

      ptr->vlist[j][0] =   ptr->vlist[i][0] = x*radius;
      ptr->vlist[j][1] = -(ptr->vlist[i][1] = hlength);
      ptr->vlist[j][2] =   ptr->vlist[i][2] = z*radius;
      ptr->vlist[j][3] =   ptr->vlist[i][3] = 1;

      ptr->nlist[i][0] = x;
      ptr->nlist[i][1] = 0;
      ptr->nlist[i][2] = z;

      matvecmulto(world, ptr->vlist[i]);
      matvecmulto(world, ptr->vlist[j]);
      matvecmultv(world, ptr->nlist[i]);
      normalize3(ptr->nlist[i]);
      copyarray3(ptr->nlist[j], ptr->nlist[i]);
   }

   for (i=j=0, tx=0, tx2=td=(float)(texcoord[2][0]*ICOUNTSIDE), k=COUNTSIDE-1, l=COUNTSIDE; i<k; i++, l++, tx=tx2, tx2+=td) {
      ptr->flist[i].polynum = 4;
      ptr->flist[i].edgeptr = &ptr->vindex[j];

      ptr->vindex[j] = l+1;
      j++;
      ptr->vindex[j] = l;
      j++;
      ptr->vindex[j] = i;
      j++;
      ptr->vindex[j] = i+1;
      j++;

      if (textureflag) {
         uv[0][0] = tx2;
         uv[0][1] = 0;
         uv[1][0] = tx;
         uv[1][1] = 0;
         uv[2][0] = tx;
         uv[2][1] = texcoord[2][1];
         uv[3][0] = tx2;
         uv[3][1] = texcoord[2][1];
         (*ptob)->direct2Dmap(i, uv, tob, 4, 1);
      }

   }

   ptr->flist[k].polynum = 4;
   ptr->flist[k].edgeptr = &ptr->vindex[COUNTSIDEEDGE-4];
   l = COUNTSIDE-1;

   ptr->vindex[COUNTSIDEEDGE-4] = COUNTSIDE;
   ptr->vindex[COUNTSIDEEDGE-3] = COUNTVERTEX-1;
   ptr->vindex[COUNTSIDEEDGE-2] = k;
   ptr->vindex[COUNTSIDEEDGE-1] = 0;

   if (textureflag) {
      uv[0][0] = tx2;
      uv[0][1] = 0;
      uv[1][0] = tx;
      uv[1][1] = 0;
      uv[2][0] = tx;
      uv[2][1] = texcoord[2][1];
      uv[3][0] = tx2;
      uv[3][1] = texcoord[2][1];
      (*ptob)->direct2Dmap(l, uv, tob, 4, 1);
   }

   ptr->flist[COUNTSIDE].polynum = COUNTSIDE;
   ptr->flist[COUNTSIDE].edgeptr = &ptr->vindex[COUNTSIDEEDGE];
   ptr->flist[COUNTSIDE+1].polynum = COUNTSIDE;
   ptr->flist[COUNTSIDE+1].edgeptr = &ptr->vindex[COUNTSIDEEDGE+COUNTSIDE];

   for (i=COUNTSIDE-1, l=COUNTSIDEEDGE; i>-1; i--, l++)
      ptr->vindex[l] = i;

   for (i=COUNTSIDE, j=COUNTSIDE<<1; i<j; i++, l++)
      ptr->vindex[l] = i;

   if (ptob) {   // NULL signifies NO coloring
      if (mctype.model > BW) {
         sblock = (shade_block *)plob->query_data();
         for (i=0; i<COUNTOBJECT; i++)
            sblock->facelist[i] = base_color;
      }
      
      if (mcinfo.info & CI3DTEX) {
         for (i=0; i<COUNTOBJECT; i++) {
            slist->shade[i].scount = shaderlist->shade[0].scount;
            slist->shade[i].s = shaderlist->shade[0].s;
            slist->shade[i].stype = shaderlist->shade[0].stype;
         }

         slist->scale = shaderlist->scale;
      }

   }

}


/* *************************************************************
************************************************************* */
int cylinder::dump_frame(FILE *outfile) {

   char token[4][MAXSTRLEN];
   int i, j;
   unsigned int master;

   master = mcinfo.query_master();

   fprintf(outfile, "%s {\n", TOKEN_GEOCYLINDER_STR);

   sprintf(token[0], "\t%s ", TOKEN_SHADE_STR);
   sprintf(token[1], " %s\n", colorname.string);
   mctype.write_model(outfile, token[0], token[1]);

   float2char(master_length, token[0]);
   fprintf(outfile, "\t%s %s\n", TOKEN_LENGTH_STR, token[0]);
   float2char(master_radius, token[0]);
   fprintf(outfile, "\t%s %s\n", TOKEN_RADIUS_STR, token[0]);

   if (master & CITEXTURE)
      fprintf(outfile, "\t%s %s\n", TOKEN_2D_TEXTURE_STR, texname2.string);
   else if (master & CI3DTEX)
      fprintf(outfile, "\t%s %s\n", TOKEN_3D_TEXTURE_STR, texname3.string);

   if (master & CIRAYCAST)
      fprintf(outfile, "\t%s\n", TOKEN_RAYCAST_STR);

   if (master & CITRANSPARENT)
      fprintf(outfile, "\t%s\n", TOKEN_TRANSPARENT_STR);
   else if (sflag && !NOSHADOW) {
      float2char(splane[0], token[0]);
      float2char(splane[1], token[1]);
      float2char(splane[2], token[2]);
      float2char(splane[3], token[3]);
      fprintf(outfile, "\t%s %s %s %s %s\n", TOKEN_SHADOW_STR, token[0], token[1], token[2], token[3]);
   }

   fprintf(outfile, "\t%s ", TOKEN_TR_MATRIX_STR);
   for (i=0; i<4; i++)
      for (j=0; j<4; j++) {
         float2char(rotate[i][j], token[0]);
         fprintf(outfile, "%s ", token);
      }

   fprintf(outfile, "\n");

   fprintf(outfile, "\tframe %d\n", frame);
   fprintf(outfile, "}\n");

   return 1;
}
