

#include <stdlib.h>
#include <string.h>

#include "base.h"
#include "pstring.h"


#define pre_calc_shade(sparam, shaderlist, i, k, surface, norm, sout, nout)       \
   sparam->set_point(surface, norm);                            \
   sparam->out[0] = sparam->out[1] = sparam->out[2] = 1;        \
   sparam->add[0] = sparam->add[1] = sparam->add[2] = 0;        \
   for (k=0; k<shaderlist->shade[i].scount; k++)                \
      if (shaderlist->shade[i].s[k] != (shader *)NULL && shaderlist->shade[i].stype[k] == SURFACE)      \
         shaderlist->shade[i].s[k]->query_data((void *)sparam); \
   copyarray3(sout, sparam->pt);                                \
   copyarray3(nout, sparam->normal);

#define post_calc_shade(sparam, shaderlist, i, k, acolor, rcolor)           \
   sparam->out[0] = sparam->out[1] = sparam->out[2] = 1;        \
   sparam->add[0] = sparam->add[1] = sparam->add[2] = 0;        \
   for (k=0; k<shaderlist->shade[i].scount; k++)                \
      if (shaderlist->shade[i].s[k] && shaderlist->shade[i].stype[k] == ATMOSPHERE)     \
         shaderlist->shade[i].s[k]->query_data((void *)sparam); \
   multarray3(rcolor, sparam->out);                             \
   acolor[0] = acolor[0]*sparam->out[0] + sparam->add[0]*255.0f; \
   acolor[1] = acolor[1]*sparam->out[1] + sparam->add[1]*255.0f; \
   acolor[2] = acolor[2]*sparam->out[2] + sparam->add[2]*255.0f



shadetype gshade;


/* *************************************************************
************************************************************* */
void frame_data::init() {

   camdtr = NULL;
   lightdtr = NULL;
   beamdtr = NULL;
   solidtr[FOREGROUND] = solidtr[MIDGROUND] = solidtr[BACKGROUND] = NULL;
   transtr[FOREGROUND] = transtr[MIDGROUND] = transtr[BACKGROUND] = NULL;
   invisotr[FOREGROUND] = invisotr[MIDGROUND] = invisotr[BACKGROUND] = NULL;
}


/* *************************************************************
************************************************************* */
frame_data::~frame_data() {

   union {
      camera *ctr;
      light *lctr;
      pc *ptr;
   };

   int i;

   for (i=0; i<MAXGROUND; i++) {
      for (; solidtr[i]; ptr=solidtr[i], solidtr[i]=(pc *)solidtr[i]->next, delete ptr);
      for (; invisotr[i]; ptr=invisotr[i], invisotr[i]=(pc *)invisotr[i]->next, delete ptr);
      for (; transtr[i]; ptr=transtr[i], transtr[i]=(pc *)transtr[i]->next, delete ptr);
   }

   for (; camdtr; ctr=camdtr, camdtr=(camera *)camdtr->next, delete ctr);
   for (; lightdtr; lctr=lightdtr, lightdtr=(light *)lightdtr->next, delete lctr);
         
   for (; beamdtr; lctr=beamdtr, beamdtr=(light *)beamdtr->next, delete lctr);
}


/* *************************************************************
************************************************************* */
int pc::query_whatwasi(int type) {

   return (pc::query_whatami() == type) ? 1 : superclass::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
pc::pc() {

   groundflag = MIDGROUND;
   renderpriority = 0;

   base_color = &gshade;
   shaderlist = NULL;
   mcinfo.mask_replace(CINULL);
   center[0] = center[1] = center[2] = 0;
   center[3] = 1;
   size = 1;
   rotate = rotate_buffer;
   init_mx(rotate);
   sflag = 0;
   lob = NULL;
   renderflag = 0;
   shadptr = NULL;
}


/* *************************************************************
************************************************************* */
int pc::parse(FILE *infile, char *token) {

   vector4f tmx[4];

   switch (token[0]) {

      case '3':
         if (!strcmp(token, TOKEN_3D_TEXTURE_STR)) {
            get_token(infile, token);
            texname3.stringcpy(token);
            mcinfo.mask_or(CI3DTEX);
            return 1;
         }

         break;

      case 'b':
         if (!strcmp(token, TOKEN_BACKGROUND_STR)) {
            groundflag = BACKGROUND;
            get_token(infile, token);
            renderpriority = atoi(token);
            mcinfo.mask_or(CIOVERWRITE | CIGHOST);
            return 1;
         }

         break;

      case 'f':
         if (!strcmp(token, TOKEN_FOREGROUND_STR)) {
            groundflag = FOREGROUND;
            get_token(infile, token);
            renderpriority = atoi(token);
            mcinfo.mask_or(CIOVERWRITE | CIGHOST);
            return 1;
         }

         break;

      case 'g':
         if (!strcmp(token, TOKEN_GHOST_STR)) {
            mcinfo.mask_or(CIGHOST);
            return 1;
         }

         break;

      case 'l':
         if (!strcmp(token, TOKEN_LUMINATE_STR)) {              // obsolete
            return 1;
         }

         break;

      case 'm':
         if (!strcmp(token, TOKEN_MIDGROUND_STR)) {
            groundflag = MIDGROUND;
            return 1;
         }

         break;

      case 'o':
         if (!strcmp(token, TOKEN_OVERWRITE_STR)) {
            mcinfo.mask_or(CIOVERWRITE);
            return 1;
         }

         break;

      case 'r':

         if (!strcmp(token, TOKEN_RAYCAST_STR)) {
            mcinfo.mask_or(CIRAYCAST);
            return 1;
         }

         if (strlen(token) < 8)
            break;

         switch(token[7]) {

            case 'x':
               if (!strcmp(token, TOKEN_ROTATE_X_STR)) {
                  get_token(infile, token);
                  rotate_mx_x(rotate, (float)deg2rad(atof(token)));
                  return 1;
               }

               break;

            case 'y':
               if (!strcmp(token, TOKEN_ROTATE_Y_STR)) {
                  get_token(infile, token);
                  rotate_mx_y(rotate, (float)deg2rad(atof(token)));
                  return 1;
               }

               break;

            case 'z':
               if (!strcmp(token, TOKEN_ROTATE_Z_STR)) {
                  get_token(infile, token);
                  rotate_mx_z(rotate, (float)deg2rad(atof(token)));
                  return 1;
               }

               break;

            default:
               break;
         }

         break;

      case 's':
         if (!strcmp(token, TOKEN_SCALE_STR)) {
            get_token(infile, token);
            size = (float)atof(token);
            return 1;
         }

         if (!strcmp(token, TOKEN_SHADOW_STR)) {
            sflag = 1;
            get_token(infile, token);
            splane[0] = (float)atof(token);
            get_token(infile, token);
            splane[1] = (float)atof(token);
            get_token(infile, token);
            splane[2] = (float)atof(token);
            get_token(infile, token);
            splane[3] = (float)atof(token);

            mcinfo.mask_and(~CITRANSPARENT);
            return 1;
         }

         if (!strcmp(token, TOKEN_SHADE_STR)) {
            get_token(infile, token);
            lower_case(token);

            if (!mctype.parse(token))
                return 0;

            switch (mctype.query_master()) {
               case BW:
               case WFBW:
               case DOT:
               case PBW:
               case PWFBW:
               case PDOT:
                  colorname.stringcpy("");
                  break;

               default:
                  get_token(infile, token);
                  colorname.stringcpy(token);
                  break;
            }

            return 1;
         }

         break;

      case 't':
         if (strlen(token) < 6)
            break;

         switch (token[5]) {

            case 't':
               if (!strcmp(token, TOKEN_TR_MATRIX_STR)) {
                  get_token(infile, token);
                  tmx[0][0] = (float)atof(token);
                  get_token(infile, token);
                  tmx[0][1] = (float)atof(token);
                  get_token(infile, token);
                  tmx[0][2] = (float)atof(token);
                  get_token(infile, token);
                  tmx[0][3] = (float)atof(token);

                  get_token(infile, token);
                  tmx[1][0] = (float)atof(token);
                  get_token(infile, token);
                  tmx[1][1] = (float)atof(token);
                  get_token(infile, token);
                  tmx[1][2] = (float)atof(token);
                  get_token(infile, token);
                  tmx[1][3] = (float)atof(token);

                  get_token(infile, token);
                  tmx[2][0] = (float)atof(token);
                  get_token(infile, token);
                  tmx[2][1] = (float)atof(token);
                  get_token(infile, token);
                  tmx[2][2] = (float)atof(token);
                  get_token(infile, token);
                  tmx[2][3] = (float)atof(token);

                  get_token(infile, token);
                  tmx[3][0] = (float)atof(token);
                  get_token(infile, token);
                  tmx[3][1] = (float)atof(token);
                  get_token(infile, token);
                  tmx[3][2] = (float)atof(token);
                  get_token(infile, token);
                  tmx[3][3] = (float)atof(token);

                  matmatmulto(tmx, rotate);

                  return 1;
               }

               break;

            case 'l':
               if (!strcmp(token, TOKEN_TRANSLATE_STR)) {
                  get_token(infile, token);
                  rotate[0][3] += (float)atof(token);
                  get_token(infile, token);
                  rotate[1][3] += (float)atof(token);
                  get_token(infile, token);
                  rotate[2][3] += (float)atof(token);

                  return 1;
               }

               break;

            case 'p':
               if (!strcmp(token, TOKEN_TRANSPARENT_STR)) {
                  mcinfo.mask_or(CITRANSPARENT);
                  sflag = 0;

                  return 1;
               }

               break;

            default:
               break;
         }

         break;

      default:
         break;
   }

   return frameclass::parse(infile, token);
}


/* *************************************************************
************************************************************** */
void pc::preprocess(void *data) {

   frameclass::preprocess(data);

   bvalid_flag = 0;

   if (PENCILTEST) {
      mctype.set_master((mctype.query_master() < PDOT || mctype.query_master() > PPHONG) ? WFBW : PWFBW);
      mcinfo.mask_replace(CINULL);
      colorname.stringcpy("");
      return;
   }

}


int  basenull::bound_box(eye *parm) { return 0; }
void basenull::transform(eye *parm) {}
int  basenull::clip(eye *parm, int maxx, int maxy) { return 0; }
int  basenull::beamscan(spotlight *spot, engine *proc) { return 0; }
int  basenull::scan(camera *cparm, light *lmain, engine *proc) { return 0; }
void basenull::beamrender(spotlight *spot, engine *proc) {}
void basenull::render(camera *cparm, light *lmain, light *spot, engine *proc) {}
void basenull::prender(engine *proc) {}


/* *************************************************************
************************************************************* */
int basenull::query_whatwasi(int type) {

   if (basenull::query_whatami() == type)
      return 1;

   return pc::query_whatwasi(type);
}



/* *************************************************************
                // plain shading
************************************************************* */
void calc_color(color_calc_data *shdmdl) {

   light *ltr;

   shdmdl->rcolor[0] = shdmdl->rcolor[1] = shdmdl->rcolor[2] = 0.0;
   copyarray3(shdmdl->acolor, shdmdl->texcolor->ambient);

   if (shdmdl->lmain)
      shdmdl->lmain->intensity(shdmdl->surface, shdmdl->normal, shdmdl->rcolor, shdmdl->parm, &shdmdl->texcolor->color, shdmdl->ob->id);

   for (ltr=shdmdl->spot; ltr; ltr=(light *)ltr->next)
      ltr->intensity(shdmdl->surface, shdmdl->normal, shdmdl->acolor, shdmdl->parm, &shdmdl->texcolor->color, shdmdl->ob->id);
}


/* *************************************************************
************************************************************* */
void calc_colorpc(color_calc_data *shdmdl) {

   light *ltr;

   copyarray3(shdmdl->rcolor, shdmdl->diffuse);
   copyarray3(shdmdl->acolor, shdmdl->texcolor->ambient);

   for (ltr=shdmdl->spot; ltr; ltr=(light *)ltr->next)
      ltr->intensity(shdmdl->surface, shdmdl->normal, shdmdl->acolor, shdmdl->parm, &shdmdl->texcolor->color, shdmdl->ob->id);
}


/* *************************************************************
        // 2d texture
************************************************************* */
void calc_color2(color_calc_data *shdmdl) {

   shdmdl->rcolor[0] = shdmdl->rcolor[1] = shdmdl->rcolor[2] = 0.0;
   copyarray3(shdmdl->acolor, shdmdl->texcolor->ambient);

   if (shdmdl->lmain)
      shdmdl->lmain->intensity(shdmdl->surface, shdmdl->normal, shdmdl->rcolor, shdmdl->parm, &shdmdl->texcolor->color, shdmdl->ob->id);

   multarray3(shdmdl->rcolor, shdmdl->tcolor);
   multarray3(shdmdl->acolor, shdmdl->tcolor);
}


/* *************************************************************
************************************************************* */
void calc_color2pc(color_calc_data *shdmdl) {

   light *ltr;

   shdmdl->rcolor[0] = shdmdl->diffuse[0] * shdmdl->tcolor[0];
   shdmdl->rcolor[1] = shdmdl->diffuse[1] * shdmdl->tcolor[1];
   shdmdl->rcolor[2] = shdmdl->diffuse[2] * shdmdl->tcolor[2];

   copyarray3(shdmdl->acolor, shdmdl->texcolor->ambient);

   for (ltr=shdmdl->spot; ltr; ltr=(light *)ltr->next)
      ltr->intensity(shdmdl->surface, shdmdl->normal, shdmdl->acolor, shdmdl->parm, &shdmdl->texcolor->color, shdmdl->ob->id);

   multarray3(shdmdl->acolor, shdmdl->tcolor);
}


/* *************************************************************
        3d texture
************************************************************* */
void calc_color3(color_calc_data *shdmdl) {

   light *ltr;
   vector4f s, n;
   int k;

   pre_calc_shade(shdmdl->sparam, shdmdl->ob->shaderlist, shdmdl->i, k, shdmdl->surface, shdmdl->normal, s, n);

   shdmdl->rcolor[0] = shdmdl->rcolor[1] = shdmdl->rcolor[2] = 0.0;
   copyarray3(shdmdl->acolor, shdmdl->texcolor->ambient);

   if (shdmdl->lmain)
      shdmdl->lmain->intensity(s, n, shdmdl->rcolor, shdmdl->parm, &shdmdl->texcolor->color, shdmdl->ob->id);

   for (ltr=shdmdl->spot; ltr; ltr=(light *)ltr->next)
      ltr->intensity(s, n, shdmdl->acolor, shdmdl->parm, &shdmdl->texcolor->color, shdmdl->ob->id);

   multarray3(shdmdl->rcolor, shdmdl->sparam->out);
   shdmdl->acolor[0] = shdmdl->acolor[0]*shdmdl->sparam->out[0] + shdmdl->sparam->add[0]*255.0f;
   shdmdl->acolor[1] = shdmdl->acolor[1]*shdmdl->sparam->out[1] + shdmdl->sparam->add[1]*255.0f;
   shdmdl->acolor[2] = shdmdl->acolor[2]*shdmdl->sparam->out[2] + shdmdl->sparam->add[2]*255.0f;

   post_calc_shade(shdmdl->sparam, shdmdl->ob->shaderlist, shdmdl->i, k, shdmdl->acolor, shdmdl->rcolor);
}


/* *************************************************************
************************************************************* */
void calc_color3pc(color_calc_data *shdmdl) {

   light *ltr;
   vector4f s, n;
   int k;

   pre_calc_shade(shdmdl->sparam, shdmdl->ob->shaderlist, shdmdl->i, k, shdmdl->surface, shdmdl->normal, s, n);

   copyarray3(shdmdl->acolor, shdmdl->texcolor->ambient);

   for (ltr=shdmdl->spot; ltr!=(light *)NULL; ltr=(light *)ltr->next)
      ltr->intensity(s, n, shdmdl->acolor, shdmdl->parm, &shdmdl->texcolor->color, shdmdl->ob->id);

   shdmdl->rcolor[0] = shdmdl->diffuse[0]*shdmdl->sparam->out[0];
   shdmdl->rcolor[1] = shdmdl->diffuse[1]*shdmdl->sparam->out[1];
   shdmdl->rcolor[2] = shdmdl->diffuse[2]*shdmdl->sparam->out[2];

   shdmdl->acolor[0] = shdmdl->acolor[0]*shdmdl->sparam->out[0] + shdmdl->sparam->add[0]*255.0f;
   shdmdl->acolor[1] = shdmdl->acolor[1]*shdmdl->sparam->out[1] + shdmdl->sparam->add[1]*255.0f;
   shdmdl->acolor[2] = shdmdl->acolor[2]*shdmdl->sparam->out[2] + shdmdl->sparam->add[2]*255.0f;

   post_calc_shade(shdmdl->sparam, shdmdl->ob->shaderlist, shdmdl->i, k, shdmdl->acolor, shdmdl->rcolor);
}


