

#include <stdlib.h>
#include <string.h>

#include "font.h"
#include "linetype.h"
#include "global.h"
#include "pstring.h"


/* ***********************************************************************
*********************************************************************** */
int vectorflist::read_data(FILE *infile, char *token) {

   int i;

   get_token(infile, token);

   count = atoi(token);

   if (pt)
      delete [] pt;

   pt = new vector2f[count];

   i = 0;

   while (i < count && get_token(infile, token)) {

      lower_case(token);

      if (strcmp(token, "point"))
         continue;

      get_token(infile, token);
      pt[i][0] = (float)atof(token);

      get_token(infile, token);
      pt[i][1] = (float)atof(token);

      i++;
   }

   return 1;
}


/* ***********************************************************************
*********************************************************************** */
void vectorilist::set(vectorflist *flist, float scale) {

   int i;

   if (pt)
      delete [] pt;

   count = flist->count;

   if (!count) {
      pt = NULL;
      return;
   }

   pt = new vector2i[count];

   for (i=0; i<count; i++) {
      pt[i][0] = (int)(flist->pt[i][0] * scale);
      pt[i][1] = (int)(flist->pt[i][1] * scale);
   }

}


/* ***********************************************************************
*********************************************************************** */
void vectorilist::print(int x, int y, unsigned int rgb, mapul *mapbuffer) {

   int start[2], end[2];
   vector2i *v0, *v1;

   end[0] = x + pt[0][0];
   end[1] = y + pt[0][1];

   for (v0 = pt+1, v1=pt+count; v0<v1; v0++) {
      copyarray2(start, end);
      end[0] = x + (*v0)[0];
      end[1] = y + (*v0)[1];
      lineblt(start, end, rgb, mapbuffer->data, mapbuffer->maxx, mapbuffer->maxy);
   }

}


/* ***********************************************************************
*********************************************************************** */
void vectorchar::init(int i) {

   count = i;

   if (master)
      delete [] master;

   if (v)
      delete [] v;

   master = new vectorflist[count];
   v = new vectorilist[count];
}


/* ***********************************************************************
*********************************************************************** */
int vectorchar::read_data(FILE *infile, char *token) {

   int i;

   while (get_token(infile, token)) {

      lower_case(token);

      if (!strcmp(token, "sizey")) {
         get_token(infile, token);
         fsizey = (float)atof(token);
         continue;
      }

      if (!strcmp(token, "sizex")) {
         get_token(infile, token);
         fsizex = (float)atof(token);
         continue;
      }

      if (!strcmp(token, "facecount")) {

         get_token(infile, token);

         init(atoi(token));

         i = 0;

         while (i < count && get_token(infile, token)) {

            lower_case(token);

            if (strcmp(token, "vertexcount"))
               continue;

            if (!master[i].read_data(infile, token))
               return 0;

            i++;
         }

         return 1;              // assumes facecount last thing in character
      }

   }

   return 1;
}


/* ***********************************************************************
*********************************************************************** */
int vectorchar::print(int *x, int y, unsigned int rgb, mapul *mapbuffer) {

   int i;

   if (*x+isizex < 0 || y+isizey < 0) {
      *x += isizex;
      return 1;
   }

   if (*x >= (int)mapbuffer->maxx)
      return 0;

   for (i=0; i<count; i++)
      v[i].print(*x, y, rgb, mapbuffer);

   *x += isizex;
   return 1;
}


/* ***********************************************************************
*********************************************************************** */
void vectorchar::set_scale(float scale) {

   int i;

   isizex = (int)(fsizex * scale + 1.0f);
   isizey = (int)(fsizey * scale);

   for (i=0; i<count; i++)
      v[i].set(master+i, scale);
}


/* ***********************************************************************
*********************************************************************** */
int vectorfont::read_data(char *filename) {

   FILE *infile;
   char token[MAXSTRLEN];
   int i;
   float maxsize;

   if (!find_file(filename, "r", FONT_PATH.string, (char)PLATFORM_SLASH, NULL, &infile))
      return 0;

   init();

   for (i=0; i<256; i++) {
      vfont[i].count = 0;
      vfont[i].fsizex = 0;
   }

   while (get_token(infile, token)) {

      lower_case(token);

      if (!strcmp(token, "flightfont")) {
         get_token(infile, token);
         continue;
      }

      if (!strcmp(token, "charheight")) {
         get_token(infile, token);
         fsizey = (float)atof(token);
         continue;
      }

      if (!strcmp(token, "fonttype")) {
         get_token(infile, token);
         lower_case(token);

         if (strcmp(token, "line")) {
            fclose(infile);
            return 0;
         }

         continue;
      }

      if (!strcmp(token, "italicfactor")) {
         get_token(infile, token);
         continue;
      }

      if (!strcmp(token, "underlineheight")) {
         get_token(infile, token);
         continue;
      }

      if (!strcmp(token, "char")) {
         get_token(infile, token);

         if (!vfont[((unsigned char *)token)[0]].read_data(infile, token)) {
            fclose(infile);
            return 0;
         }

         continue;
      }


   }

   fclose(infile);

   fontname.stringcpy(filename);
   
   // calc size of "blanked" or missing character fonts

   for (maxsize = vfont[0].fsizex, i=1; i<256; i++)
      if (maxsize < vfont[i].fsizex)
         maxsize = vfont[i].fsizex;

   for (i=0; i<256; i++)
      if (!vfont[i].count)
         vfont[i].fsizex = maxsize;

   // init integer fonts
   font_scale = 0.0;
   set_scale(1.0f);

   return 1;
}


/* ***********************************************************************
*********************************************************************** */
void vectorfont::print(int x, int y, unsigned char *str, mapul *mapbuffer)  {

   if (y >= (int)mapbuffer->maxy)
      return;

   for (; *str; str++)
      if (!vfont[*str].print(&x, y, rgb, mapbuffer))
         return;
}


/* ***********************************************************************
*********************************************************************** */
void vectorfont::set_color(char r, char g, char b) {

   if (r == ccolor[0] && g == ccolor[1] && b == ccolor[2])
      return;

   ccolor[0] = r;
   ccolor[1] = g;
   ccolor[2] = b;
             
   ((unsigned char *)&rgb)[0] = r;
   ((unsigned char *)&rgb)[1] = g;
   ((unsigned char *)&rgb)[2] = b;
}


/* ***********************************************************************
*********************************************************************** */
void vectorfont::set_scale(float x) {

   int i;

   if (font_scale == x)
      return;

   font_scale = x;

   x /= fsizey;

   for (i=0; i<256; i++)
      vfont[i].set_scale(x);
}


/* ***********************************************************************
*********************************************************************** */
vectorfont::vectorfont() {

   rgb = 0;
   fsizey = 1.0f;
   vfont = NULL;
}


/* ***********************************************************************
*********************************************************************** */
vectorfont::~vectorfont() {

   if (vfont)
      delete [] vfont;
}


/* ***********************************************************************
*********************************************************************** */
void vectorfont::init() {

   if (vfont)
      delete [] vfont;

   vfont = new vectorchar[256];
}


/* ***********************************************************************
*********************************************************************** */
int vectorfont::pixel_length(unsigned char *str) {

   int length = 0;

   for (; *str; str++)
      length += vfont[*str].isizex;

   return length;
}


