

#include <string.h>

#include "WIN_VIRTUAL.h"

#include "gamegine.h"
#include "pcloud.h"
#include "flat.h"
#include "polygame.h"
#include "pntgame.h"
#include "linegame.h"
#include "box.h"
#include "texture.h"


/* *************************************************************
************************************************************* */
void sw_gfx::init_state() {

   begin_flag = -1;
   pointsize = 1;
   pointoffset = 0;
   mode = GFX_NODRAW;
   canvas = NULL;
   first_pt[0] = first_pt[1] = 0;
   last_pt[0] = last_pt[1] = 0;
   tc_color = 0;
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxInit() {

   if (!global_resource_manager)
      return;

   base_gfx::gfxInit();
   init_state();
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxDest() {

   proc.zbuff.data = NULL;
   proc.zbuff.pdata = NULL;
   proc.zbuff.zdata = NULL;

   base_gfx::gfxDest();
}


/* *************************************************************
************************************************************* */
font_type *sw_gfx::gfxAllocFontObject(int type) {

   switch (type) {
      case FONT_VECTOR:
         return new vectorfont;

      case FONT_RASTER:
         return new rasterfont;

      default:
         break;
   }

   return NULL;
}


/* *************************************************************
************************************************************* */
pc *sw_gfx::gfxAllocRenderObject(int type) {

   switch (type) {
      case OBJECT_POLYGON:
         return new polygame;

      case OBJECT_LINE:
         return new linegame;

      case OBJECT_PARTICLE:
         return new pointgame;

      case OBJECT_FLAT:
      case OBJECT_GLFLAT:
         return new flat;

      case OBJECT_PARTICLE_CLOUD:
         return new pcloud;

      case OBJECT_FXPOLYGON:
         return new fxpolygame;

      case OBJECT_FXFLAT:
         return new fxflat;

      default:
         break;
   }

   return NULL;
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxPointSize(float x) {

   pointsize = (int)x;
   pointoffset = (int)(x*0.5);
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxBegin(unsigned int md, mapul *cvs) {

   begin_flag = 0;
   mode = md;
   canvas = cvs;
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxEnd() {

   int flag;

   if (begin_flag < 0)
      return;

   flag = begin_flag < 1 || mode != GFX_LINE_LOOP;

   mode = GFX_NODRAW;
   begin_flag = -1;

   if (flag)
      return;

   lineblt(last_pt, first_pt, tc_color, canvas->data, canvas->maxx, canvas->maxy);
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxEnable(unsigned int cap) {

   if (gfx_state & cap)
      return;

   switch (cap) {
      case GFX_CLEAR_COLOR_BUFFER:
         gfx_state |= GFX_CLEAR_COLOR_BUFFER;
         return;

      case GFX_CLEAR_DEPTH_BUFFER:
         gfx_state |= GFX_CLEAR_DEPTH_BUFFER;
         return;

      default:
         return;
   }

}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxDisable(unsigned int cap) {

   if (!(gfx_state & cap))
      return;

   switch (cap) {
      case GFX_CLEAR_COLOR_BUFFER:
         gfx_state &= ~GFX_CLEAR_COLOR_BUFFER;
         return;

      case GFX_CLEAR_DEPTH_BUFFER:
         gfx_state &= ~GFX_CLEAR_DEPTH_BUFFER;
         return;

      default:
         return;
   }

}


/* *************************************************************
   asdf this ignores gfx_state clear bits
************************************************************* */
void sw_gfx::gfxClear(mapul *mapbuffer, mapf *zdata) {

   proc.initbuff(mapbuffer->data, mapbuffer->pdata, zdata->data, mapbuffer->maxx, mapbuffer->maxy, 1.0f/back);
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxSetColor(unsigned char *src, unsigned char *rgb) {

   rgb[REDINDEX]   = src[0];
   rgb[GREENINDEX] = src[1];
   rgb[BLUEINDEX]  = src[2];
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfx2DMode(int winx, int winy) {

}


/* *************************************************************
************************************************************* */
void sw_gfx::gfx3DModeBegin(camera *cparm, light *lmain, int winx, int winy) {

   if (lmain)
      lmain->xform(cparm);
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfx3DModeEnd() {

}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxBitblt(BLTwindow *win, mapul *mapbuffer) {

   win->BLTbitmap(mapbuffer);

#ifndef WIN32
   memset(mapbuffer->data, 0, mapbuffer->maxy*mapbuffer->maxx<<2);
#endif

}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxFlatIncrementTime(pc *ob, float inc) {

   ((flat *)ob)->last_frame += inc;

   if (((flat *)ob)->last_frame > 256)
      ((flat *)ob)->last_frame -= 256;

   ((flat *)ob)->update_texture();
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxPolygonIncrementTime(pc *ob, float inc) {

   ((polygame *)ob)->last_frame += inc;

   if (((polygame *)ob)->last_frame > 256)
      ((polygame *)ob)->last_frame -= 256;
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxFxflatInit(pc *ob, texbase *tob) {

   ((fxflat *)ob)->set_ob_data(tob);
   ((fxflat *)ob)->last_frame = 0;
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxPolygonInit(pc *ob) {

   ((polygame *)ob)->last_frame = 0;
}



/* *************************************************************
************************************************************* */
void sw_gfx::gfxColor3ubv(unsigned char *color) {

   tc_color = lut_red[color[0]] | lut_green[color[1]] | lut_blue[color[2]];
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxVertex2iv(int *v) {

   vector2i ll, ur;

   if (begin_flag < 0)
      return;

   if (mode == GFX_POINTS) {

      if (pointsize == 1)
         pointblt(v, tc_color, canvas->data, canvas->maxx, canvas->maxy);
      else {
         ll[0] = v[0] - pointoffset;
         ll[1] = v[1] - pointoffset;
         ur[0] = v[0] + pointsize;
         ur[1] = v[1] + pointsize;

         boxfill(ll, ur, tc_color, canvas->data, canvas->maxx, canvas->maxy);
      }

      return;
   }

   if (begin_flag < 1) {
      begin_flag = 2;
      first_pt[0] = last_pt[0] = v[0];
      first_pt[1] = last_pt[1] = v[1];
      return;
   }

   if (begin_flag == 1) {
      begin_flag = 2;
      copyarray2(last_pt, v);
      return;
   }

   lineblt(last_pt, v, tc_color, canvas->data, canvas->maxx, canvas->maxy);

   if (mode == GFX_LINES)
      begin_flag = 1;
   else
      copyarray2(last_pt, v);
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxRectiv(mapul *mapbuffer, int *ll, int *ur) {

   boxfill(ll, ur, tc_color, mapbuffer->data, mapbuffer->maxx, mapbuffer->maxy);
}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxSnapshot(char *filename, mapul *mapbuffer, image_coder *coder) {

   coder->write_data(filename, mapbuffer, CBYTE_ORDER_RGBA);
}


/* *************************************************************
   shade[0] = r
   shade[1] = g
   shade[2] = b
************************************************************* */
void sw_gfx::gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int *ll, int *ur, float *lluv, float *uruv, int transflag) {

   vector2i cll, cur;
   fixed_pt tll[2];
   fixed_pt inc[2];
   float finc[2];
   vector2f mlluv, muruv;
   
   unsigned int mpalette[256];
   union { unsigned char *ctr; unsigned int *ictr; };
   unsigned int idtr;
   union { unsigned char *dtr; unsigned int *intdtr; };
   unsigned char *rlut, *glut, *blut;
   texture256 *tob256;
   int row, index;
   int i;
   fixed_pt tcol;
   unsigned char *data;
   float temp;
   union { basic_texture_block *tblock; texture_block256 *tblock256; };

   tob256 = (texture256 *)tob;

   mlluv[0] = tob->maxx*lluv[0];
   mlluv[1] = tob->maxy*lluv[1];
   
   muruv[0] = tob->maxx*uruv[0];
   muruv[1] = tob->maxy*uruv[1];
   
   cur[0] = ur[0] + 1;
   cur[1] = ur[1] + 1;

   finc[0] = (muruv[0] - mlluv[0])/(cur[0] - ll[0]);
   finc[1] = (muruv[1] - mlluv[1])/(cur[1] - ll[1]);

   inc[0] = FLOAT_TO_FIXED(finc[0]);
   inc[1] = FLOAT_TO_FIXED(finc[1]);

   // clip
   if (ll[0] < 0) {
      temp = mlluv[0] + finc[0]*(-ll[0]);
      tll[0] = FLOAT_TO_FIXED(temp);
      cll[0]  = 0;
   }

   else {
      tll[0] = FLOAT_TO_FIXED(mlluv[0]);
      cll[0] = ll[0];
   }

   if (ll[1] < 0) {
      temp = mlluv[1] + finc[1]*(-ll[1]);
      tll[1] = FLOAT_TO_FIXED(temp);
      cll[1]  = 0;
   }

   else {
      tll[1] = FLOAT_TO_FIXED(mlluv[1]);
      cll[1] = ll[1];
   }

   cur[0] = min((int)mapbuffer->maxx, cur[0]);
   cur[1] = min((int)mapbuffer->maxy, cur[1]);

   if (shade) {
      rlut = &byte_mult[shade[0]<<8];
      glut = &byte_mult[shade[1]<<8];
      blut = &byte_mult[shade[2]<<8];
   }
   
   tblock256 = (texture_block256 *)tob256->query_data();
   dtr = tblock256->cpalette;

   ctr = (unsigned char *)mpalette;

   // multiply palette by shade

   if (shade)
      for (index=0; index<1024; index+=4) {
         ctr[index+REDINDEX]   = rlut[dtr[index+3]];
         ctr[index+GREENINDEX] = glut[dtr[index+2]];
         ctr[index+BLUEINDEX]  = blut[dtr[index+1]];
      }

   else
      for (index=0; index<1024; index+=4) {
         ctr[index+REDINDEX]   = dtr[index+3];
         ctr[index+GREENINDEX] = dtr[index+2];
         ctr[index+BLUEINDEX]  = dtr[index+1];
      }

   switch(transflag) {
      case GFX_TRANSPARENT:
         for (row = cll[1]; row < cur[1]; row++, tll[1] += inc[1]) {
            data = tblock256->tob.data + FIXED_TO_INT(tll[1])*tob->maxx;
            tcol = tll[0];
            ictr = mapbuffer->pdata[row];
            for (index = cll[0]; index < cur[0]; index++, tcol += inc[0]) {
               idtr = mpalette[data[FIXED_TO_INT(tcol)]];
               set_trans(ictr[index], (unsigned char *)&idtr);
            }

         }

         return;

      case GFX_INVISO:
         for (row = cll[1]; row < cur[1]; row++, tll[1] += inc[1]) {
            data = tblock256->tob.data + FIXED_TO_INT(tll[1])*tob->maxx;
            tcol = tll[0];
            ictr = mapbuffer->pdata[row];
            for (index = cll[0]; index < cur[0]; index++, tcol += inc[0]) {
               i = data[FIXED_TO_INT(tcol)];
               if (intdtr[i])
                  ictr[index] = mpalette[i];
            }

         }

         return;

      default:
         for (row = cll[1]; row < cur[1]; row++, tll[1] += inc[1]) {
            data = tblock256->tob.data + FIXED_TO_INT(tll[1])*tob->maxx;
            tcol = tll[0];
            ictr = mapbuffer->pdata[row];
            for (index = cll[0]; index < cur[0]; index++, tcol += inc[0])
               ictr[index] = mpalette[data[FIXED_TO_INT(tcol)]];
         }

         return;
   }

}


/* *************************************************************
   shade[0] = r
   shade[1] = g
   shade[2] = b
************************************************************* */
void sw_gfx::gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int left, int bottom, int right, int top, int transflag) {

   vector2i ll, ur;
   fixed_pt tll[2];
   fixed_pt inc[2];
   unsigned int mpalette[256];
   union { unsigned char *ctr; unsigned int *ictr; };
   unsigned int idtr;
   union { unsigned char *dtr; unsigned int *intdtr; };
   unsigned char *rlut, *glut, *blut;
   texture256 *tob256;
   int row, index;
   int i;
   fixed_pt tcol;
   unsigned char *data;
   union { basic_texture_block *tblock; texture_block256 *tblock256; };

   tob256 = (texture256 *)tob;

   right++;
   top++;

   inc[0] = FLOAT_TO_FIXED(tob->maxx/((float)(right-left)));
   inc[1] = FLOAT_TO_FIXED(tob->maxy/((float)(top-bottom)));

   tll[0] = 0;
   tll[1] = 0;
   ll[0] = left;
   ll[1] = bottom;

   if (ll[0] < 0) {
      tll[0] = inc[0]*(-ll[0]);
      ll[0]  = 0;
   }

   if (ll[1] < 0) {
      tll[1] = inc[1]*(-ll[1]);
      ll[1]  = 0;
   }

   ur[0] = min((int)mapbuffer->maxx, right);
   ur[1] = min((int)mapbuffer->maxy, top);

   if (shade) {
      rlut = &byte_mult[shade[0]<<8];
      glut = &byte_mult[shade[1]<<8];
      blut = &byte_mult[shade[2]<<8];
   }
   
   tblock256 = (texture_block256 *)tob256->query_data();
   dtr = tblock256->cpalette;

   ctr = (unsigned char *)mpalette;

   // multiply palette by shade
   if (shade)
      for (index=0; index<1024; index+=4) {
         ctr[index+REDINDEX]   = rlut[dtr[index+3]];
         ctr[index+GREENINDEX] = glut[dtr[index+2]];
         ctr[index+BLUEINDEX]  = blut[dtr[index+1]];
      }

   else
      for (index=0; index<1024; index+=4) {
         ctr[index+REDINDEX]   = dtr[index+3];
         ctr[index+GREENINDEX] = dtr[index+2];
         ctr[index+BLUEINDEX]  = dtr[index+1];
      }

   switch(transflag) {
      case GFX_TRANSPARENT:
         for (row = ll[1]; row < ur[1]; row++, tll[1] += inc[1]) {
            data = tblock256->tob.data + FIXED_TO_INT(tll[1])*tob->maxx;
            tcol = tll[0];
            ictr = mapbuffer->pdata[row];
            for (index = ll[0]; index < ur[0]; index++, tcol += inc[0]) {
               idtr = mpalette[data[FIXED_TO_INT(tcol)]];
               set_trans(ictr[index], (unsigned char *)&idtr);
            }

         }

         return;

      case GFX_INVISO:
         for (row = ll[1]; row < ur[1]; row++, tll[1] += inc[1]) {
            data = tblock256->tob.data + FIXED_TO_INT(tll[1])*tob->maxx;
            tcol = tll[0];
            ictr = mapbuffer->pdata[row];
            for (index = ll[0]; index < ur[0]; index++, tcol += inc[0]) {
               i = data[FIXED_TO_INT(tcol)];
               if (intdtr[i])
                  ictr[index] = mpalette[i];
            }

         }

         return;

      default:
         for (row = ll[1]; row < ur[1]; row++, tll[1] += inc[1]) {
            data = tblock256->tob.data + FIXED_TO_INT(tll[1])*tob->maxx;
            tcol = tll[0];
            ictr = mapbuffer->pdata[row];
            for (index = ll[0]; index < ur[0]; index++, tcol += inc[0])
               ictr[index] = mpalette[data[FIXED_TO_INT(tcol)]];
         }

         return;
   }

}


/* *************************************************************
************************************************************* */
void sw_gfx::gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int x, int y, int placeflag, int transflag) {

   vector2i ll, ur;
   unsigned char *map, *data;
   unsigned char *rlut, *glut, *blut;
   int row, index;
   unsigned int mpalette[256];
   union { unsigned char *ctr; unsigned int *ictr; };
   unsigned int idtr;
   union { unsigned char *dtr; unsigned int *intdtr; };
   union { texture_block256 *tblock256; basic_texture_block *tblock; };

   switch(placeflag) {
      case GFX_PLACEMENT_LOWER_LEFT:
         ll[0] = x;
         ll[1] = y;
         ur[0] = x + tob->maxx;
         ur[1] = y + tob->maxy;
         break;

      case GFX_PLACEMENT_UPPER_LEFT:
         ll[0] = x;
         ll[1] = y - tob->maxy+1;
         ur[0] = x + tob->maxx;
         ur[1] = y + 1;
         break;

      case GFX_PLACEMENT_UPPER_RIGHT:
         ll[0] = x - tob->maxx+1;
         ll[1] = y - tob->maxy+1;
         ur[0] = x + 1;
         ur[1] = y + 1;
         break;

      case GFX_PLACEMENT_LOWER_RIGHT:
         ll[0] = x - tob->maxx+1;
         ll[1] = y;
         ur[0] = x + 1;
         ur[1] = y + tob->maxy;
         break;

      default:	// center
         ll[0] = x - (tob->maxx>>1);
         ll[1] = y - (tob->maxy>>1);
         ur[0] = ll[0] + tob->maxx;
         ur[1] = ll[1] + tob->maxy;
         break;
   }

   tblock256 = (texture_block256 *)tob->query_data();
   dtr = tblock256->cpalette;
   map = (unsigned char *)tblock256->tob.data;

   if (ll[0] < 0) {
      map -= ll[0];
      ll[0]  = 0;
   }

   if (ll[1] < 0) {
      map -= tob->maxx*ll[1];
      ll[1]  = 0;
   }

   if (ur[0] > (int)mapbuffer->maxx)
      ur[0] = mapbuffer->maxx;

   if (ur[1] > (int)mapbuffer->maxy)
      ur[1] = mapbuffer->maxy;

   if (shade) {
      rlut = &byte_mult[shade[0]<<8];
      glut = &byte_mult[shade[1]<<8];
      blut = &byte_mult[shade[2]<<8];
   }
   
   ctr = (unsigned char *)mpalette;

   // multiply palette by shade
   if (shade)
      for (index=0; index<1024; index+=4) {
         ctr[index+REDINDEX]   = rlut[dtr[index+3]];
         ctr[index+GREENINDEX] = glut[dtr[index+2]];
         ctr[index+BLUEINDEX]  = blut[dtr[index+1]];
      }

   else
      for (index=0; index<1024; index+=4) {
         ctr[index+REDINDEX]   = dtr[index+3];
         ctr[index+GREENINDEX] = dtr[index+2];
         ctr[index+BLUEINDEX]  = dtr[index+1];
      }

   switch(transflag) {
      case GFX_TRANSPARENT:
         for (row = ll[1]; row < ur[1]; row++, map += tob->maxx) {
            data = map;
            ictr = mapbuffer->pdata[row];
            for (index = ll[0]; index < ur[0]; index++, data++) {
               idtr = mpalette[*data];
               set_trans(ictr[index], (unsigned char *)&idtr);
            }

         }

         return;

      case GFX_INVISO:
         for (row = ll[1]; row < ur[1]; row++, map += tob->maxx) {
            data = map;
            ictr = mapbuffer->pdata[row];
            for (index = ll[0]; index < ur[0]; index++, data++)
               if (intdtr[*data])
                  ictr[index] = mpalette[*data];
         }

         return;

      default:
         for (row = ll[1]; row < ur[1]; row++, map += tob->maxx) {
            data = map;
            ictr = mapbuffer->pdata[row];
            for (index = ll[0]; index < ur[0]; index++, data++)
               ictr[index] = mpalette[*data];
         }

         return;
   }

}


/* *************************************************************
************************************************************* */
font_type *sw_gfx::gfxReadFont(char *filename, int type) {

   font_type *ftr;

   ftr = gfxAllocFontObject(type);

   if (ftr->read_data(filename))
      return ftr;

   delete ftr;
   return NULL;
}

