

#include <string.h>

#include "spb_load.h"
#include "gamegine.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
class keylist : public dbl_llist {

   public:
      virtual ~keylist() {}

      void *key;
};


/* *************************************************************
************************************************************* */
void *spg2_loader::extract(unsigned int type, char *altname, int level) {

   spheretype *colsphere;

   switch (type) {

      case FILETYPE_SPHERE:
         colsphere = (spheretype *)global_resource_manager->find_resource_object(RESOURCE_SPHERE, ((polytype *)ob)->dataname.string, altname);
         if (colsphere) {
            if (!(colsphere->statusflag & STATUSFLAG_LOADED)) {
               colsphere->read_data(altname);
               colsphere->dataname.stringcpy(&((polytype *)ob)->dataname);
            }

            return colsphere;
         }

         colsphere = new spheretype;

         if (!colsphere->read_data(altname)) {
            delete colsphere;
            return NULL;
         }

         if (colsphere) {
            colsphere->dataname.stringcpy(&((polytype *)ob)->dataname);
            global_resource_manager->register_resource_object(RESOURCE_SPHERE, colsphere);
         }

         return colsphere;

      default:
         return spg_loader::extract(type, altname, level);
   }

}


/* *******************************************************************
******************************************************************* */
int spg2_loader::write_data(char *dname, polytype *dob, char *lname, shadelist *lob, char *tname, texpolygon *tob, char *wname, shaderlisttype *wob, char *sname, spheretype *sob) {

   if (!dob)
      return 0;

   if (!dob->write_data(dname)) {
      sprintf(perror_buffer, "Could not open %s for output\n", dname);
      pprintf(perror_buffer);
   }
   
   if (lob)
      lob->write_data(lname);

   if (tob)
      tob->write_basis(tname);

   if (wob) {
// asdf to be finished at a later date
   }

   if (sob && !sob->write_data(sname)) {
      sprintf(perror_buffer, "Could not open %s for output\n", sname);
      pprintf(perror_buffer);
   }

   return 1;
}


/* *******************************************************************
******************************************************************* */
void spb_loader::cleanup() {

   file_loader::cleanup();

   ob = NULL;
   current = NULL;
}


/* *******************************************************************
******************************************************************* */
void spb_loader::extract_object() {

   generic_block_header header;
   polygon_object_type *pot;
   int i, j, l;
   int countvertex, countobject, countedge;

   if (mblock.header.tag != MASTER_BLOCK_TAG || !mblock.object_byte_offset) {
      ob = NULL;
      return;
   }

   sinfile->sseek(mblock.object_byte_offset);

   header.tag = sinfile->scan_uint();
   header.length = sinfile->scan_uint();
   countvertex = sinfile->scan_uint();
   countobject = sinfile->scan_uint();
   countedge = sinfile->scan_uint();

   if (header.tag != OBJECT_BLOCK_TAG || !countvertex || !countobject || !countedge) {
      ob = NULL;
      return;
   }

   if (!ob) {
      ob = new polytype;
      ob->dataname.stringcpy(&sinfile->filename);
   }

   ob->statusflag = STATUSFLAG_VOID;
   ob->build(countvertex, countobject, countedge);
   pot = (polygon_object_type *)ob->query_data();

   for (i=0; i<countvertex; i++) {
      pot->vlist[i][0] = sinfile->scan_float();
      pot->vlist[i][1] = sinfile->scan_float();
      pot->vlist[i][2] = sinfile->scan_float();
      pot->vlist[i][3] = 1.0f;
   }

   ob->countedge = 0;

   for (i=0; i<countobject; i++) {
      pot->flist[i].polynum = sinfile->scan_int();
      pot->flist[i].edgeptr = &pot->vindex[ob->countedge];

      ob->countedge += (l = pot->flist[i].polynum);

      for (j=0; j<l; j++)
         pot->flist[i].edgeptr[j] = sinfile->scan_int();
   }

   ob->preprocess();
   ob->statusflag = STATUSFLAG_LOADABLE | STATUSFLAG_LOADED;
}


/* *************************************************************
************************************************************* */
void spb_loader::extract_shade(shadetype *ilm) {

   ilm->ka[0] = sinfile->scan_int();
   ilm->ka[1] = sinfile->scan_int();
   ilm->ka[2] = sinfile->scan_int();

   ilm->kp[0] = sinfile->scan_int();
   ilm->kp[1] = sinfile->scan_int();
   ilm->kp[2] = sinfile->scan_int();

   ilm->ks[0] = sinfile->scan_int();
   ilm->ks[1] = sinfile->scan_int();
   ilm->ks[2] = sinfile->scan_int();

   ilm->specn = sinfile->scan_float();

   ilm->lum[0] = sinfile->scan_int();
   ilm->lum[1] = sinfile->scan_int();
   ilm->lum[2] = sinfile->scan_int();

   ilm->update_float();
}


/* *******************************************************************
******************************************************************* */
void spb_loader:: extract_material1() {

   shade_block *sblock;
   int *itr;
   shadetype *str;
   int i, j;
   int max;

   if (!current) {
      current = new shadelist;
      current->dataname.stringcpy(&sinfile->filename);
      current->altname.stringcpy(&sinfile->filename);
   }

   current->replace_data(sblock = new shade_block);

   extract_shade(&((shadelist *)current)->base);

   j = sinfile->scan_int();

   sblock->shade_palette = new shadetype[sblock->shade_count = j+1];

   memcpy(&sblock->shade_palette[0], &((shadelist *)current)->base, sizeof(shadetype));
   max = 1;

   if (j) {
      itr = new int[j];
      str = new shadetype[j];

      for (i = 0; i<j; i++) {
         itr[i] = sinfile->scan_int();
         extract_shade(&str[i]);
         if (itr[i] > max)
            max = itr[i];
      }

      max++;
   }

   sblock->index_count = ob->countobject > max ? ob->countobject : max;
   sblock->index_palette = new int[sblock->index_count];
   memset(sblock->index_palette, 0, sblock->index_count*sizeof(int));

   if (j) {
      memcpy(&sblock->shade_palette[1], str, j*sizeof(shadetype));

      for (i=0; i<j; i++)
         sblock->index_palette[itr[i]] = i+1;

      delete [] itr;
      delete [] str;
   }

   ((shadelist *)current)->postprocess(ob->countobject);
   current->statusflag = STATUSFLAG_LOADABLE | STATUSFLAG_LOADED;
}


/* *******************************************************************
******************************************************************* */
void spb_loader:: extract_material2() {

   shade_block *sblock;
   int i;

   if (!current) {
      current = new shadelist;
      current->dataname.stringcpy(&sinfile->filename);
      current->altname.stringcpy(&sinfile->filename);
   }

   current->replace_data(sblock = new shade_block);

   sblock->shade_palette = new shadetype[sblock->shade_count = sinfile->scan_int()];

   for (i=0; i<sblock->shade_count; i++)
      extract_shade(&sblock->shade_palette[i]);

   sblock->index_palette = new int[sblock->index_count = sinfile->scan_int()];

   for (i=0; i<sblock->index_count; i++)
      sblock->index_palette[i] = sinfile->scan_int();
   
   ((shadelist *)current)->postprocess(ob->countobject);
   current->statusflag = STATUSFLAG_LOADABLE | STATUSFLAG_LOADED;
}


/* *******************************************************************
******************************************************************* */
void spb_loader::extract_material() {

   generic_block_header header;
   
   if (mblock.header.tag != MASTER_BLOCK_TAG || !mblock.material_byte_offset) {
      current = NULL;
      return;
   }
   
   sinfile->sseek(mblock.material_byte_offset);

   header.tag = sinfile->scan_uint();
   header.length = sinfile->scan_uint();

   switch (header.tag) {

      case MATERIAL_BLOCK_TAG:
         extract_material1();
         return;

      case MATERIAL2_BLOCK_TAG:
         extract_material2();
         return;

      default:
         current = NULL;
         return;
   }

}


/* *******************************************************************
******************************************************************* */
void spb_loader::extract_uv() {

   generic_block_header header;
   int i, j, k;
   vector2f uv[3];
   char buffer[MAXSTRLEN];
   int count;
   texbase **tob;
    
   if (mblock.header.tag != MASTER_BLOCK_TAG || !mblock.uv_byte_offset) {
      current = NULL;
      return;
   }

   sinfile->sseek(mblock.uv_byte_offset);

   header.tag = sinfile->scan_uint();
   header.length = sinfile->scan_uint();
    
   if (header.tag != UV_BLOCK_TAG) {
      current = NULL;
      return;
   }

   count = sinfile->scan_int();

   if (!count) {
      current = NULL;
      return;
   }

   if (!current) {
      current = new texpolygon;
      current->dataname.stringcpy(&sinfile->filename);
      current->altname.stringcpy(&sinfile->filename);
   }

   ((texpolygon *)current)->setup(ob->countobject);

   tob = new ptexbase[count];

   for (i=0; i<count; i++) {
      k = 0;
      do {
         buffer[k]   = sinfile->scan_char();
         buffer[k+1] = sinfile->scan_char();
         buffer[k+2] = sinfile->scan_char();
         buffer[k+3] = sinfile->scan_char();
         k += 4;
      } while (buffer[k-1] && buffer[k-2] && buffer[k-3] && buffer[k-4]);
      
      tob[i] = (texbase *)((frame_manager *)global_resource_manager)->read_tex(buffer);

      if (!tob[i]) {
         sprintf(perror_buffer, "Warning: Unable to access \"%s\"...\n", buffer);
         pprintf(perror_buffer);
      }

   }

   count = sinfile->scan_int();
   
   for (i = 0; i < count; i++) {
      j = sinfile->scan_int();
      uv[0][0] = sinfile->scan_float();
      uv[0][1] = sinfile->scan_float();
      uv[1][0] = sinfile->scan_float();
      uv[1][1] = sinfile->scan_float();
      uv[2][0] = sinfile->scan_float();
      uv[2][1] = sinfile->scan_float();
      
      k = sinfile->scan_int();
      if (tob[k])
         ((texpolygon *)current)->affinemap(j, uv, tob[k], ob, 0);
   }
   
   current->statusflag = STATUSFLAG_LOADABLE | STATUSFLAG_LOADED;

   delete [] tob;
}


/* *******************************************************************
******************************************************************* */
void spb_loader::extract_uvw() {

   generic_block_header header;
    
   if (mblock.header.tag != MASTER_BLOCK_TAG || !mblock.uvw_byte_offset) {
      current = NULL;
      return;
   }

   sinfile->sseek(mblock.uvw_byte_offset);

   header.tag = sinfile->scan_uint();
   header.length = sinfile->scan_uint();
    
   if (header.tag != UVW_BLOCK_TAG) {
      current = NULL;
      return;
   }

// asdf to be finished at a later date
   current = NULL;
}


/* *******************************************************************
******************************************************************* */
void spb_loader::extract_colsphere() {

   generic_block_header header;
   sphere_block *sblock;
   int i, j;
      
   if (mblock.header.tag != MASTER_BLOCK_TAG || !mblock.collision_byte_offset) {
      current = NULL;
      return;
   }

   sinfile->sseek(mblock.collision_byte_offset);

   header.tag = sinfile->scan_uint();
   header.length = sinfile->scan_uint();
    
   if (header.tag != SPHERE_BLOCK_TAG) {
      current = NULL;
      return;
   }

   if (!current) {
      current = new spheretype;
      current->dataname.stringcpy(&sinfile->filename);
      current->altname.stringcpy(&sinfile->filename);
   }

   current->replace_data(sblock = new sphere_block);

   sblock->countsphere = sinfile->scan_int();

   if (sblock->countsphere) {
      sblock->slist = new colsphere[sblock->countsphere];

      for (i=0; i<sblock->countsphere; i++) {
         sblock->slist[i].center[0] = sinfile->scan_float();
         sblock->slist[i].center[1] = sinfile->scan_float();
         sblock->slist[i].center[2] = sinfile->scan_float();

         sblock->slist[i].radius = sinfile->scan_float();

         sblock->slist[i].level = sinfile->scan_int();
         sblock->slist[i].count = sinfile->scan_int();

         if (sblock->slist[i].index)
            delete [] sblock->slist[i].index;

         sblock->slist[i].index = new int[sblock->slist[i].count];

         for (j=0; j<sblock->slist[i].count; j++)
            sblock->slist[i].index[j] = sinfile->scan_int();
      }
      
   }

   current->statusflag = STATUSFLAG_LOADABLE | STATUSFLAG_LOADED;
}


/* *******************************************************************
******************************************************************* */
basic_loader *spb_loader::find_loader(sfile *data) {

   data->sseek(0);

   if (data->scan_uint() == MASTER_BLOCK_TAG) {
      sinfile = data;
      return this;
   }

   return next ? ((basic_loader *)next)->find_loader(data) : NULL;
}


/* *******************************************************************
******************************************************************* */
int spb_loader::read_data() {

   if (!sinfile)
      return 0;

   ob = (polytype *)global_resource_manager->find_resource_object(RESOURCE_OBJECT, sinfile->filename.string, NULL);

   sinfile->sseek(0);
   
   mblock.header.tag = sinfile->scan_uint();
   mblock.header.length = sinfile->scan_uint();
   mblock.object_byte_offset = sinfile->scan_uint();
   mblock.material_byte_offset = sinfile->scan_uint();
   mblock.uv_byte_offset = sinfile->scan_uint();
   mblock.uvw_byte_offset = sinfile->scan_uint();
   mblock.collision_byte_offset = sinfile->scan_uint();
   // account for old format
   mblock.extention_byte_offset = (mblock.header.length > 28) ? sinfile->scan_uint() : 0;

   extract(FILETYPE_SPG, sinfile->filename.string);
   return 1;
}


/* *******************************************************************
******************************************************************* */
void *spb_loader::extract(unsigned int type, char *altname, int level) {

   switch (type) {

      case FILETYPE_SPG:

         if (ob) {
            if (!(ob->statusflag & STATUSFLAG_LOADED))
               extract_object();

            return ob;
         }

         extract_object();

         if (ob)
            global_resource_manager->register_resource_object(RESOURCE_OBJECT, ob);

         return ob;

      case FILETYPE_ILM:
         current = (resource_type *)global_resource_manager->find_resource_object(RESOURCE_MATERIAL, sinfile->filename.string, sinfile->filename.string);

         if (current) {
            if (!(current->statusflag & STATUSFLAG_LOADED))
               extract_material();

            return current;
         }

         extract_material();

         if (current) {
            global_resource_manager->register_resource_object(RESOURCE_MATERIAL, current);
            return current;
         }

         // try processing .ilm file
         current = (resource_type *)((frame_manager *)global_resource_manager)->read_ilm(altname, ob->countobject);

         if (current)
            current->dataname.stringcpy(&ob->dataname);

         return current;

      case FILETYPE_TEX:
         current = (resource_type *)global_resource_manager->find_resource_object(RESOURCE_UVCOORD, sinfile->filename.string, sinfile->filename.string);

         if (current) {
            if (!(current->statusflag & STATUSFLAG_LOADED))
               extract_uv();

            return current;
         }

         extract_uv();

         if (current)
            global_resource_manager->register_resource_object(RESOURCE_UVCOORD, current);

         return current;

      case FILETYPE_TEX3D:
         current = (resource_type *)global_resource_manager->find_resource_object(RESOURCE_UVWCOORD, sinfile->filename.string, sinfile->filename.string);

         if (current) {
            if (!(current->statusflag & STATUSFLAG_LOADED))
               extract_uvw();

            return current;
         }

         extract_uvw();

         if (current)
            global_resource_manager->register_resource_object(RESOURCE_UVWCOORD, current);

         return current;

      case FILETYPE_SPHERE:
         current = (resource_type *)global_resource_manager->find_resource_object(RESOURCE_SPHERE, sinfile->filename.string, sinfile->filename.string);

         if (current) {
            if (!(current->statusflag & STATUSFLAG_LOADED))
               extract_colsphere();

            return current;
         }

         extract_colsphere();

         if (current)
            global_resource_manager->register_resource_object(RESOURCE_SPHERE, current);

         return current;

      default:
         return NULL;
   }

}


/* *******************************************************************
******************************************************************* */
int spb_loader::calc_size(polytype *data) {

   return 8 + 12 + 12*data->countvertex + 4*(data->countobject + data->countedge);
}


/* *******************************************************************
******************************************************************* */
int spb_loader::calc_size(shadelist *data) {

   shade_block *shblock = (shade_block *)data->query_data();

   return 8 + 4 + (shblock ? 52 * shblock->shade_count : 0) + 4 + (shblock ? 4 * shblock->index_count : 0);
}


/* *******************************************************************
******************************************************************* */
int spb_loader::calc_size(texpolygon *data) {

   int size;
   texface *tblock = (texface *)data->query_data();
   int i;
   dbl_llist_manager head;
   keylist *ptr;

   size = 8 + 4 + 4;

   for (i=0; i<data->countobject; i++)
      if (data->query_tflag(i)) {
         size += 4 + 24 + 4;

         for (ptr = (keylist *)head.head; ptr && ptr->key != (void *)tblock[i].ob; ptr = (keylist *)ptr->next);

         if (ptr)
            continue;

         head.insert(ptr = new keylist, NULL);
         ptr->key = tblock[i].ob;

         size += (tblock[i].ob->dataname.stringlen()+4) & 0xfffffffc;
      }

   if (!head.head)
      return 0;

   return size;	 
}


/* *******************************************************************
******************************************************************* */
int spb_loader::calc_size(shaderlisttype *data) {

// asdf to be finished at a later date
   return 0;
}


/* *******************************************************************
******************************************************************* */
int spb_loader::calc_size(spheretype *data) {

   int size;
   int i;
   sphere_block *spblock = (sphere_block *)data->query_data();

   size = 8 + 4;
   
   for (i=0; i<spblock->countsphere; i++)
      size += 24 + spblock->slist[i].count*4;

   return size;
}


/* *******************************************************************
******************************************************************* */
void spb_loader::write_data(polytype *data, int size) {

   polygon_object_type *pot;
   int i, j;
      
   sinfile->sput_uint(OBJECT_BLOCK_TAG);
   sinfile->sput_uint(size);
   sinfile->sput_uint(data->countvertex);
   sinfile->sput_uint(data->countobject);
   sinfile->sput_uint(data->countedge);

   pot = (polygon_object_type *)data->query_data();

   for (i=0; i<data->countvertex; i++) {
      sinfile->sput_float(pot->vlist[i][0]);
      sinfile->sput_float(pot->vlist[i][1]);
      sinfile->sput_float(pot->vlist[i][2]);
   }

   for (i=0; i<data->countobject; i++) {
      sinfile->sput_int(pot->flist[i].polynum);

      for (j = 0; j < pot->flist[i].polynum; j++)
         sinfile->sput_int(pot->flist[i].edgeptr[j]);
   }

}


/* *************************************************************
************************************************************* */
void spb_loader::write_data(shadetype *ilm) {

   sinfile->sput_int(ilm->ka[0]);
   sinfile->sput_int(ilm->ka[1]);
   sinfile->sput_int(ilm->ka[2]);

   sinfile->sput_int(ilm->kp[0]);
   sinfile->sput_int(ilm->kp[1]);
   sinfile->sput_int(ilm->kp[2]);

   sinfile->sput_int(ilm->ks[0]);
   sinfile->sput_int(ilm->ks[1]);
   sinfile->sput_int(ilm->ks[2]);

   sinfile->sput_float(ilm->specn);

   sinfile->sput_int(ilm->lum[0]);
   sinfile->sput_int(ilm->lum[1]);
   sinfile->sput_int(ilm->lum[2]);
}


/* *******************************************************************
******************************************************************* */
void spb_loader::write_data(shadelist *data, int size) {

   shade_block *sblock;
   int i;
   
   sinfile->sput_uint(MATERIAL2_BLOCK_TAG);
   sinfile->sput_uint(size);

   sblock = (shade_block *)data->query_data();

   sinfile->sput_int(sblock->shade_count);

   for (i=0; i<sblock->shade_count; i++)
      write_data(&sblock->shade_palette[i]);

   sinfile->sput_int(sblock->index_count);

   for (i=0; i<sblock->index_count; i++)
      sinfile->sput_int(sblock->index_palette[i]);
}

      
/* *******************************************************************
******************************************************************* */
void spb_loader::write_data(texpolygon *data, int size) {

   texface *tblock = (texface *)data->query_data();
   int i, j;
   dbl_llist_manager head;
   keylist *ptr;

   sinfile->sput_uint(UV_BLOCK_TAG);
   sinfile->sput_uint(size);

   for (i=j=0; i<data->countobject; i++)
      if (data->query_tflag(i)) {
         for (ptr = (keylist *)head.head; ptr && ptr->key != (void *)tblock[i].ob; ptr = (keylist *)ptr->next);
         if (ptr)
            continue;

         head.insert(ptr = new keylist, NULL);
         ptr->key = tblock[i].ob;

         j++;
      }

   sinfile->sput_int(j);
   for (ptr = (keylist *)head.head; ptr; ptr = (keylist *)ptr->next)
       sinfile->swrite(((texbase *)ptr->key)->dataname.string, (((texbase *)ptr->key)->dataname.stringlen()+4) & 0xfffffffc);

   for (i=j=0; i<data->countobject; i++)
      if (data->query_tflag(i))
         j++;

   sinfile->sput_int(j);

   for (i=0; i<data->countobject; i++)
      if (data->query_tflag(i)) {
         sinfile->sput_int(i);
         sinfile->sput_float(tblock[i].uv[0][0]);
         sinfile->sput_float(tblock[i].uv[0][1]);
         sinfile->sput_float(tblock[i].uv[1][0]);
         sinfile->sput_float(tblock[i].uv[1][1]);
         sinfile->sput_float(tblock[i].uv[2][0]);
         sinfile->sput_float(tblock[i].uv[2][1]);

         for (ptr=(keylist *)head.head, j=0; ptr; ptr=(keylist *)ptr->next, j++)
            if (ptr->key == (void *)tblock[i].ob) {
	       sinfile->sput_int(j);
               break;
            }
      }

}

      
/* *******************************************************************
******************************************************************* */
void spb_loader::write_data(shaderlisttype *data, int size) {

// asdf to be finished at a later date
}

      
/* *******************************************************************
******************************************************************* */
void spb_loader::write_data(spheretype *data, int size) {

   sphere_block *sblock;
   int i, j;
   
   sinfile->sput_uint(SPHERE_BLOCK_TAG);
   sinfile->sput_uint(size);

   sblock = (sphere_block *)data->query_data();

   sinfile->sput_int(sblock->countsphere);

   for (i=0; i<sblock->countsphere; i++) {
      sinfile->sput_float(sblock->slist[i].center[0]);
      sinfile->sput_float(sblock->slist[i].center[1]);
      sinfile->sput_float(sblock->slist[i].center[2]);

      sinfile->sput_float(sblock->slist[i].radius);
      
      sinfile->sput_int(sblock->slist[i].level);
      sinfile->sput_int(sblock->slist[i].count);

      for (j=0; j<sblock->slist[i].count; j++)
         sinfile->sput_int(sblock->slist[i].index[j]);
   }

}


/* *******************************************************************
******************************************************************* */
int spb_loader::write_data(polytype *geom, shadelist *material, texpolygon *uv, shaderlisttype *uvw, spheretype *spheredata, int extension_flag) {

   unsigned int filesize;
   int object_offset, material_offset, uv_offset, uvw_offset, sphere_offset, extention_offset;
   int master_size, object_size, material_size, uv_size, uvw_size, sphere_size;

   filesize = sinfile->vsize;

   master_size = sizeof(master_data_block);
   filesize += master_size;

   object_offset = filesize;
   filesize += (object_size = calc_size(geom));
   
   if (material) {
      material_offset = filesize;
      filesize += (material_size = calc_size(material));
   }
   
   else
      material_offset = 0;

   if (uv) {
      uv_size = calc_size(uv);
      if (uv_size) {
         uv_offset = filesize;
         filesize += uv_size;
      }

      else
         uv_offset = 0;
   }
   
   else
      uv_offset = 0;

   if (uvw) {
      uvw_offset = filesize;
      filesize += (uvw_size = calc_size(uvw));
   }
   
   else
      uvw_offset = 0;
      
   if (spheredata) {
      sphere_offset = filesize;
      filesize += (sphere_size = calc_size(spheredata));
   }
   
   else
      sphere_offset = 0;

   extention_offset = extension_flag ? filesize : 0;
      
   sinfile->sput_uint(MASTER_BLOCK_TAG);
   sinfile->sput_uint(master_size);
   sinfile->sput_uint(object_offset);
   sinfile->sput_uint(material_offset);
   sinfile->sput_uint(uv_offset);
   sinfile->sput_uint(uvw_offset);
   sinfile->sput_uint(sphere_offset);
   sinfile->sput_uint(extention_offset);

   write_data(geom, object_size);

   if (material_offset)
      write_data(material, material_size);
      
   if (uv_offset)
      write_data(uv, uv_size);

   if (uvw_offset)
      write_data(uvw, uvw_size);

   if (sphere_offset)
      write_data(spheredata, sphere_size);

   if (filesize != sinfile->vsize) {
      sprintf(perror_buffer, "%s -> bad size calculation - %d : %d\n", sinfile->filename.string, filesize, sinfile->vsize);
      pprintf(perror_buffer);
   }
   
   return 1;
}


/* *******************************************************************
******************************************************************* */
int spb_loader::write_data(char *filename, polytype *geom, shadelist *material, texpolygon *uv, shaderlisttype *uvw, spheretype *spheredata) {

   sfile data;
   int i;

   if (!geom)
      return 0;

   sinfile = &data;
   sinfile->filename.stringcpy(filename);

   write_data(geom, material, uv, uvw, spheredata, 0);

   i = sinfile->dump_data(filename);
   sinfile->dest();
   return i;
}


/* *******************************************************************
******************************************************************* */
int spb_loader::write_data(char *filename, polytype **geom, shadelist **material, texpolygon **uv, shaderlisttype **uvw, spheretype **spheredata) {

   sfile data;
   int i;

   if (!geom)
      return 0;

   sinfile = &data;
   sinfile->filename.stringcpy(filename);

   for (i=0; geom[i]; i++)
      write_data(geom[i], material[i], uv[i], uvw[i], spheredata[i], (int)geom[i+1]);
   
   i = sinfile->dump_data(filename);
   sinfile->dest();
   return i;
}
