

#include <stdlib.h>
#include <string.h>

#include "simman.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
int sim_infobyte_type::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_ID_STR)) {
      get_token(infile, token);
      id = atoi(token);
      return 1;
   }
   
   if (!strcmp(token, TOKEN_PRIORITY_STR)) {
      get_token(infile, token);
      priority = atoi(token);
      return 1;
   }
   
   sprintf(perror_buffer, "WARNING - SIM:infobyte : Unknown token '%s'\n", token);
   pprintf(perror_buffer);
   return 0;
}


/* *************************************************************
************************************************************* */
void sim_infobyte_type::preprocess(void *data) {

   owner = ((sim_preprocess_type *)data)->parent;
}


/* *************************************************************
************************************************************* */
void sim_task_type::preprocess(void *data) {
   
   sim_infobyte_type::preprocess(data);

   if (owner && owner->owner)
      owner->owner->htree->set_specific_data(DATAFLAG_AI_NEW_TASK, this);
}


/* *************************************************************
************************************************************* */
int sim_object::query_whatwasi(int type) {

   return type == sim_object::query_whatami();
}


/* *************************************************************
************************************************************* */
int sim_object::parse(FILE *infile, char *token) {

   sim_infobyte_type *itr;

   if (!strcmp(token, TOKEN_INFO_STR)) {
      get_token(infile, token);
      itr = process_info(infile, token);
      if (itr) {
         script_manager[SIM_MANAGER_INFO].append(itr, NULL);
         return 1;
      }

      return 0;
   }

   if (!strcmp(token, TOKEN_TASK_STR)) {
      get_token(infile, token);
      itr = process_task(infile, token);
      if (itr) {
         script_manager[SIM_MANAGER_TASK].append(itr, NULL);
         return 1;
      }

      return 0;
   }

   if (!strcmp(token, TOKEN_EVENT_STR)) {
      get_token(infile, token);
      itr = process_event(infile, token);
      if (itr) {
         script_manager[SIM_MANAGER_EVENT].append(itr, NULL);
         return 1;
      }

      return 0;
   }

   sprintf(perror_buffer, "WARNING - SIM:sim_object - Unknown token '%s'\n", token);
   pprintf(perror_buffer);
   return 0;
}


/* *************************************************************
************************************************************* */
void sim_object::preprocess(void *data) {

   int i;
   sim_infobyte_type *ptr, *qtr;
   sim_preprocess_type pdata;
   
   parent = ((sim_preprocess_type *)data)->parent;
   
   pdata.head = ((sim_preprocess_type *)data)->head;
   pdata.parent = this;
   
   for (i=0; i<SIM_MANAGER_MAX; i++) {
      ptr = (sim_infobyte_type *)script_manager[i].head;
      while (ptr) {
         qtr = ptr;
         ptr = (sim_infobyte_type *)ptr->next;
         qtr->preprocess(&pdata);
         if (qtr->flags & SIM_INFOBYTE_FLAG_REDUNDANT) {
            script_manager[i].remove(qtr);
            delete qtr;
         }

      }
      
   }

}


/* *************************************************************
************************************************************* */
void sim_object::process_ai() {

   sim_infobyte_type *etr, *ftr;
   int i, flag;
   unsigned int mask = SIM_INFOBYTE_FLAG_SUCCESS | SIM_INFOBYTE_FLAG_FAILURE;
   
   for (i=0; i<SIM_MANAGER_MAX; i++) {
      flag = owner && i == SIM_MANAGER_TASK;

      etr = (sim_infobyte_type *)script_manager[i].head;
      while (etr) {
         ftr = etr;
         etr = (sim_infobyte_type *)etr->next;
         ftr->update();
         if (ftr->flags & mask) {
            script_manager[i].remove(ftr);
            success_manager.append(ftr, NULL);

            if (flag)
               owner->htree->set_specific_data(DATAFLAG_AI_REMOVE_TASK, ftr);
         }

      }
      
   }
      
}


/* *************************************************************
************************************************************* */
void sim_object::clear_dynamic_tasks(sim_object *source) {

   sim_infobyte_type *sittr, *ptr;
   sim_object *sotr;

   sittr = (sim_infobyte_type *)success_manager.head;
   while (sittr) {
      ptr = sittr;
      sittr = (sim_infobyte_type *)sittr->next;

      if (ptr->query_specific_data(SIM_INFOFLAG_SOURCE, &sotr) && sotr == source) {
         if (owner)
            owner->htree->set_specific_data(DATAFLAG_AI_REMOVE_TASK, ptr);
         success_manager.remove(ptr);
         delete ptr;
      }

   }

   sittr = (sim_infobyte_type *)script_manager[SIM_MANAGER_TASK].head;
   while (sittr) {
      ptr = sittr;
      sittr = (sim_infobyte_type *)sittr->next;

      if (ptr->query_specific_data(SIM_INFOFLAG_SOURCE, &sotr) && sotr == source) {
         if (owner)
            owner->htree->set_specific_data(DATAFLAG_AI_REMOVE_TASK, ptr);
         script_manager[SIM_MANAGER_TASK].remove(ptr);
         delete ptr;
      }

   }

}


/* *************************************************************
************************************************************* */
int sim_object::set_specific_data(int type, void *data) {

   sim_object *source;
   
   switch (type) {

      case SIM_INFOFLAG_DYNAMIC_TASK:
         if (!((sim_infobyte_type *)data)->query_specific_data(SIM_INFOFLAG_SOURCE, &source))
	    return 0;
	    
         clear_dynamic_tasks(source);
         script_manager[SIM_MANAGER_TASK].append((dbl_llist *)data, NULL);
         return 1;

      case SIM_INFOFLAG_RESCIND_DYNAMIC_TASKS:
         clear_dynamic_tasks((sim_object *)data);
         return 1;

      default:
         break;
   }

   return 0;
}

 
/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_object::find_infobyte(int type, int fid) {

   sim_infobyte_type *ptr, *qtr;
   int i;

   for (ptr = (sim_infobyte_type *)script_manager[type].head; ptr; ptr = (sim_infobyte_type *)ptr->next)
      if (ptr->id == fid)
         return ptr;

   for (i=0; i<SIM_MANAGER_MAX; i++)
      for (ptr = (sim_infobyte_type *)script_manager[i].head; ptr; ptr = (sim_infobyte_type *)ptr->next) {
         qtr = ptr->find_subinfobyte(type, fid);
         if (qtr)
            return qtr;
      }

   return NULL;
}


/* *************************************************************
************************************************************* */
void sim_object::render2d(mapul *mapbuffer) {

   int i;
   sim_infobyte_type *ptr;

   for (i=0; i<SIM_MANAGER_MAX; i++)
      for (ptr = (sim_infobyte_type *)script_manager[i].head; ptr; ptr = (sim_infobyte_type *)ptr->next)
         ptr->render2d(mapbuffer);
}

